/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.IImageManipulator;
import fr.esrf.tangoatk.widget.image.IImagePanel;
import fr.esrf.tangoatk.widget.image.IImageViewer;
import fr.esrf.tangoatk.widget.util.IApplicable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ConvolveFilter
extends JPanel
implements IImageManipulator,
IImagePanel,
IApplicable {
    IImageViewer viewer;
    boolean customFilter = false;
    int i = 0;
    final float ninth = 0.11111111f;
    float[] edge = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    float[] sharpen = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    float[] blur = new float[]{0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f};
    Kernel kernel;
    ConvolveOp cop;
    ButtonGroup group = new ButtonGroup();
    JRadioButton edgeButton = new JRadioButton("Edge");
    JRadioButton blurButton = new JRadioButton("Blur");
    JRadioButton sharpButton = new JRadioButton("Sharpen");
    JRadioButton resetButton = new JRadioButton("No filter");
    float[] myFilter = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    float[] currentFilter = this.myFilter;
    JRadioButton setButton = new JRadioButton("Custom");
    boolean newFilter = false;
    boolean filter = false;
    MyTableModel tableModel = new MyTableModel();
    JTable table = new JTable(this.tableModel);

    public ConvolveFilter() {
        this.group.add(this.edgeButton);
        this.group.add(this.blurButton);
        this.group.add(this.sharpButton);
        this.group.add(this.setButton);
        this.group.add(this.resetButton);
        this.resetButton.setSelected(true);
        this.resetAction();
        GridBagConstraints constraints = new GridBagConstraints();
        this.kernel = new Kernel(3, 3, this.sharpen);
        this.cop = new ConvolveOp(this.kernel);
        this.setLayout(new GridBagLayout());
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.anchor = 13;
        constraints.fill = 1;
        this.add((Component)this.edgeButton, constraints);
        constraints.gridy = 2;
        this.add((Component)this.blurButton, constraints);
        constraints.gridy = 3;
        this.add((Component)this.sharpButton, constraints);
        constraints.gridy = 4;
        this.add((Component)this.setButton, constraints);
        constraints.gridx = 2;
        constraints.gridy = 5;
        this.add((Component)this.resetButton, constraints);
        constraints = new GridBagConstraints();
        constraints.gridy = 1;
        constraints.gridx = 1;
        this.add((Component)this.table, constraints);
        this.edgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvolveFilter.this.edgeAction();
            }
        });
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvolveFilter.this.setAction();
            }
        });
        this.blurButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvolveFilter.this.blurAction();
            }
        });
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvolveFilter.this.resetAction();
            }
        });
        this.sharpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvolveFilter.this.sharpAction();
            }
        });
    }

    protected void edgeAction() {
        this.currentFilter = this.edge;
        this.tableModel.filterChanged();
        this.filter = true;
        this.newFilter = true;
    }

    protected void setAction() {
        this.currentFilter = this.myFilter;
        this.tableModel.filterChanged();
        this.filter = true;
        this.newFilter = true;
    }

    protected void blurAction() {
        this.currentFilter = this.blur;
        this.tableModel.filterChanged();
        this.filter = true;
        this.newFilter = true;
    }

    protected void resetAction() {
        this.table.setBackground(this.getBackground());
        this.filter = false;
    }

    protected void sharpAction() {
        this.currentFilter = this.sharpen;
        this.tableModel.filterChanged();
        this.filter = true;
        this.newFilter = true;
    }

    @Override
    public String getName() {
        return "ConvolveOps";
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public BufferedImage filter(BufferedImage image) {
        if (this.filter) {
            System.out.println("filtering...");
            this.newFilter = false;
            return this.cop.filter(image, null);
        }
        return image;
    }

    @Override
    public void setModel(IImageViewer viewer) {
        this.setImageViewer(viewer);
    }

    @Override
    public void setImageViewer(IImageViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void roiChanged(int startx, int endx, int starty, int endy) {
    }

    @Override
    public void ok() {
        this.apply();
        this.cancel();
    }

    @Override
    public void cancel() {
        this.getRootPane().getParent().setVisible(false);
    }

    @Override
    public void apply() {
        this.kernel = new Kernel(3, 3, this.currentFilter);
        this.cop = new ConvolveOp(this.kernel);
        this.viewer.repaint();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.getContentPane().add(new ConvolveFilter());
        f.pack();
        f.setVisible(true);
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return 3;
        }

        public void filterChanged() {
            ConvolveFilter.this.table.setBackground(Color.white);
            this.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return new Float(ConvolveFilter.this.currentFilter[row * this.getColumnCount() + column]);
        }

        @Override
        public void setValueAt(Object val, int row, int column) {
            ConvolveFilter.this.currentFilter[row * this.getColumnCount() + column] = ((Float)val).floatValue();
        }

        public Class getColumnClass(int i) {
            return Float.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return ConvolveFilter.this.setButton.isSelected();
        }
    }
}

