/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.BWRaster;
import fr.esrf.tangoatk.widget.image.IImageManipulator;
import fr.esrf.tangoatk.widget.image.IImagePanel;
import fr.esrf.tangoatk.widget.image.IImageViewer;
import fr.esrf.tangoatk.widget.image.IRasterConverter;
import fr.esrf.tangoatk.widget.image.ImageController;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ImageViewer
extends JPanel
implements IImageViewer {
    IImageManipulator[] listenerList = new IImageManipulator[0];
    double[][] raster;
    BufferedImage image;
    JDialog controlFrame = new JDialog();
    int startx;
    int starty;
    int endx;
    int endy;
    JPanel canvas;
    JFrame frame;
    boolean rasterChanged = true;
    ImageController controller = new ImageController();
    IRasterConverter rasterConverter;

    public ImageViewer() {
        this.controller.setModel(this);
        this.controlFrame.getContentPane().add(this.controller);
        this.setRasterConverter(new BWRaster());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    ImageViewer.this.startRoi(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int i = e.getButton();
                switch (i) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        ImageViewer.this.setControllerVisible(true);
                        break;
                    }
                    case 3: {
                        ImageViewer.this.setControllerVisible(true);
                        break;
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                ImageViewer.this.dragRoi(e.getX(), e.getY());
            }
        });
    }

    @Override
    public void setRasterConverter(IRasterConverter v) {
        this.rasterConverter = v;
        this.rasterConverter.setImageViewer(this);
    }

    @Override
    public IRasterConverter getRasterConverter() {
        return this.rasterConverter;
    }

    @Override
    public void setSize(Dimension size) {
        this.setPreferredSize(size);
        this.setMaximumSize(size);
    }

    @Override
    public Dimension getSize() {
        return this.getPreferredSize();
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    protected void startRoi(int x, int y) {
        this.startx = x;
        this.starty = y;
        this.endx = x;
        this.endy = y;
    }

    protected void dragRoi(int x, int y) {
        for (int i = 0; i < this.listenerList.length; ++i) {
            this.listenerList[i].roiChanged(this.startx, x, this.starty, y);
        }
    }

    public ImageController getController() {
        return this.controller;
    }

    public void setController(ImageController v) {
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public void setImage(BufferedImage v) {
        this.image = v;
    }

    public boolean isControllerVisible() {
        return this.controlFrame.isVisible();
    }

    public void setControllerVisible(boolean v) {
        this.controlFrame.pack();
        this.controlFrame.setVisible(v);
    }

    @Override
    public double[][] getRaster() {
        return this.raster;
    }

    @Override
    public void setRaster(double[][] v) {
        this.raster = v;
        this.rasterChanged = true;
        this.image = this.rasterConverter.convertRaster(this.raster);
        this.setSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.internalPaint(g);
    }

    public void addImageListener(IImageManipulator l) {
    }

    @Override
    public void addImagePanel(IImagePanel panel) {
        this.getController().addToPanel(panel);
    }

    @Override
    public void addImageManipulator(IImageManipulator l) {
        int i = this.listenerList.length;
        IImageManipulator[] tmp = new IImageManipulator[i + 1];
        System.arraycopy(this.listenerList, 0, tmp, 0, i);
        tmp[i] = l;
        this.listenerList = tmp;
        l.setImageViewer(this);
        if (l instanceof IImagePanel) {
            this.addImagePanel((IImagePanel)((Object)l));
            l.setImageViewer(this);
        }
    }

    public void removeImageListener(IImageManipulator l) {
    }

    @Override
    public void removeImageManipulator(IImageManipulator l) {
        boolean found = false;
        int length = this.listenerList.length;
        for (int i = 0; i < length; ++i) {
            if (this.listenerList[i] != l) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        this.listenerList[i] = this.listenerList[length - 1];
        IImageManipulator[] tmp = new IImageManipulator[length - 1];
        System.arraycopy(this.listenerList, 0, tmp, 0, length - 1);
        this.listenerList = tmp;
    }

    void internalPaint(Graphics g) {
        if (this.image == null) {
            return;
        }
        BufferedImage tmpImg = this.image;
        for (int i = 0; i < this.listenerList.length; ++i) {
            tmpImg = this.listenerList[i].filter(tmpImg);
        }
        g.drawImage(tmpImg, 0, 0, this);
        this.rasterChanged = false;
    }

    @Override
    public boolean isRasterChanged() {
        return this.rasterChanged;
    }

    @Override
    public JPanel getTopLayer() {
        return this;
    }

    public static void main(String[] args) {
        ImageViewer iv = new ImageViewer();
        JFrame f = new JFrame();
        f.getContentPane().add(iv);
        f.pack();
        f.setVisible(true);
    }
}

