/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.swing.JOptionPane;

public class JpegDecoder
extends ImageInputStreamImpl {
    public static final int RGB24 = 1;
    public static final int GRAY8 = 2;
    private byte[] cache;
    private int type;
    ImageReader imgReader;

    public JpegDecoder() {
        Iterator<ImageReader> imgIt = ImageIO.getImageReadersByFormatName("jpeg");
        if (!imgIt.hasNext()) {
            JOptionPane.showMessageDialog(null, "Jpeg decoder not found", "Error", 0);
            this.imgReader = null;
        } else {
            this.imgReader = imgIt.next();
        }
    }

    public void setBuffer(byte[] jpgBuffer) {
        this.cache = jpgBuffer;
        this.streamPos = 0L;
        this.bitOffset = 0;
        this.type = 0;
    }

    public int GetType() {
        return this.type;
    }

    public byte[][] decode() throws IOException {
        if (this.imgReader == null) {
            throw new IOException("No native JPEG decoder available");
        }
        byte[][] img = null;
        this.streamPos = 0L;
        this.imgReader.setInput(this, true, true);
        ImageReadParam param = this.imgReader.getDefaultReadParam();
        Raster r = this.imgReader.readRaster(0, param);
        int width = r.getWidth();
        int height = r.getHeight();
        int colors = this.imgReader.getRawImageType(0).getColorModel().getNumColorComponents();
        int startLine = 0;
        switch (colors) {
            case 1: {
                this.type = 2;
                DataBufferByte data = (DataBufferByte)r.getDataBuffer();
                img = new byte[height][width];
                for (int i = 0; i < height; ++i) {
                    System.arraycopy(data.getData(), startLine, img[i], 0, width);
                    startLine += width;
                }
                break;
            }
            case 3: {
                this.type = 1;
                DataBufferByte data = (DataBufferByte)r.getDataBuffer();
                img = new byte[height][width * 3];
                for (int i = 0; i < height; ++i) {
                    System.arraycopy(data.getData(), startLine, img[i], 0, width * 3);
                    startLine += width * 3;
                }
                break;
            }
            default: {
                throw new IOException("Unexpected JPEG color format");
            }
        }
        return img;
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        if (this.streamPos >= (long)this.cache.length) {
            return -1;
        }
        int i = this.cache[(int)this.streamPos];
        ++this.streamPos;
        return i &= 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int byteToCopy;
        this.bitOffset = 0;
        int remainingByte = (int)((long)this.cache.length - this.streamPos);
        int n = byteToCopy = len <= remainingByte ? len : remainingByte;
        if (byteToCopy > 0) {
            System.arraycopy(this.cache, (int)this.streamPos, b, off, byteToCopy);
            this.streamPos += (long)byteToCopy;
            return byteToCopy;
        }
        return -1;
    }
}

