/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.IImageFormat;
import java.io.IOException;

public class Mono8ImageFormat
extends IImageFormat {
    @Override
    public void setData(byte[] rawData) throws IOException {
        int wh = rawData[0] & 0xFF;
        int wl = rawData[1] & 0xFF;
        int width = (wh <<= 8) | wl;
        int hh = rawData[2] & 0xFF;
        int hl = rawData[3] & 0xFF;
        int height = (hh <<= 8) | hl;
        int idx = 4;
        this.data = new byte[height][width];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                this.data[j][i] = rawData[idx++];
            }
        }
    }

    @Override
    public int getWidth() {
        if (this.getHeight() == 0) {
            return 0;
        }
        return this.data[0].length;
    }

    @Override
    public String getName() {
        return "MONO8";
    }

    @Override
    public boolean isColorFormat() {
        return false;
    }

    @Override
    public int getHistogramWidth() {
        return 256;
    }

    @Override
    public double getValue(int x, int y) {
        int v = this.data[y][x] & 0xFF;
        return v;
    }

    @Override
    public String getValueStr(int x, int y) {
        return Double.toString(this.getValue(x, y));
    }

    @Override
    public void computeFitting() {
        if (!this.bestFit) {
            if (this.tool.isVisible()) {
                this.tool.getAxis().setMinimum(-this.bfA0);
                this.tool.getAxis().setMaximum(-this.bfA0 + 1.0 / this.bfA1 * 65536.0);
            }
        } else {
            double autoBfMin = 65536.0;
            double autoBfMax = 0.0;
            for (int j = 0; j < this.data.length; ++j) {
                for (int i = 0; i < this.data[j].length; ++i) {
                    int uc = this.data[j][i] & 0xFF;
                    double v = uc;
                    if (v > autoBfMax) {
                        autoBfMax = v;
                    }
                    if (!(v < autoBfMin)) continue;
                    autoBfMin = v;
                }
            }
            this.bfA0 = -autoBfMin;
            if (autoBfMax == autoBfMin) {
                this.bfA1 = 0.0;
                if (this.tool.isVisible()) {
                    this.tool.getAxis().setMinimum(autoBfMin);
                    this.tool.getAxis().setMaximum(autoBfMax + 1.0);
                }
            } else {
                this.bfA1 = 65536.0 / (autoBfMax - autoBfMin);
                if (this.tool.isVisible()) {
                    this.tool.getAxis().setMinimum(autoBfMin);
                    this.tool.getAxis().setMaximum(autoBfMax);
                }
            }
        }
    }

    @Override
    public int getRGB(boolean negative, int[] colormap16, int x, int y) {
        double v = this.data[y][x] & 0xFF;
        int nv = (int)((this.bfA0 + v) * this.bfA1);
        if (nv < 0) {
            nv = 0;
        }
        if (nv > 65535) {
            nv = 65535;
        }
        if (negative) {
            return colormap16[~nv & 0xFFFF];
        }
        return colormap16[nv];
    }
}

