/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.jdraw;

import fr.esrf.tangoatk.widget.jdraw.TangoSynopticHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.util.MissingResourceException;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DeviceSynopticViewer
extends JPanel {
    private static final String defaultJdrawDir = "/users/poncet/ATK_OLD/jloox_files";
    private String jdrawDir = null;
    private String devName = null;
    private TangoSynopticHandler tsh = null;

    public DeviceSynopticViewer() {
        this.initComponents();
    }

    public DeviceSynopticViewer(String dev) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        this.setDevName(dev);
    }

    public DeviceSynopticViewer(String jdrd, String dev) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        this.setJdrawDir(jdrd);
        this.setDevName(dev);
    }

    public String getJdrawDir() {
        return this.jdrawDir;
    }

    public void setJdrawDir(String newDir) {
        if (newDir == null) {
            return;
        }
        if (newDir.length() <= 0) {
            return;
        }
        this.jdrawDir = new String(newDir);
    }

    public String getDevName() {
        return this.devName;
    }

    public void setDevName(String dev) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this.devName = dev;
        String fullFileName = this.jdrawDir == null ? "/users/poncet/ATK_OLD/jloox_files/" + this.getFileNameFromDev(this.devName) + ".jdw" : this.jdrawDir + "/" + this.getFileNameFromDev(this.devName) + ".jdw";
        this.tsh = new TangoSynopticHandler(fullFileName);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.tsh, gbc);
    }

    public String getFileNameFromDev(String dev) {
        if (dev == null) {
            return dev;
        }
        String devFile = dev.replace('/', '_');
        return devFile;
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(22, 22));
        this.setLayout(new GridBagLayout());
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        try {
            DeviceSynopticViewer dsv = new DeviceSynopticViewer(defaultJdrawDir, "id14/eh3_mono/diamond");
            jf.setContentPane(dsv);
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Prog Aborted.");
            System.exit(-1);
        }
        jf.pack();
        jf.setVisible(true);
    }
}

