/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.jdraw;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.jdraw.SynopticProgressListener;
import fr.esrf.tangoatk.widget.jdraw.TangoSynopticHandler;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.SettingsManagerProxy;
import fr.esrf.tangoatk.widget.util.Splash;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.MissingResourceException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class SimpleSynopticAppli
extends JFrame
implements SynopticProgressListener {
    private final Splash splash = new Splash();
    private ErrorHistory errorHistory = new ErrorHistory();
    private boolean standAlone = false;
    private boolean fileLoaded = false;
    private String settingManagerName = null;
    private SettingsManagerProxy smProxy = null;
    private AttributePolledList numberAndStateScalarAttList;
    private JFrame trendFrame;
    private JPanel mainPanel;
    private Trend globalTrend = null;
    private JMenuItem trendMenuItem;
    private JMenuItem errHistMenuItem;
    private JMenuItem diagtMenuItem;
    private JMenu fileJMenu;
    private JMenuBar jMenuBar1;
    private JMenuItem quitJMenuItem;
    private JMenuItem fileLoadMenuItem;
    private JMenuItem fileSaveMenuItem;
    private JMenuItem filePreviewMenuItem;
    private TangoSynopticHandler tangoSynopHandler;
    private JMenu viewMenu;

    public SimpleSynopticAppli() {
        this.splash.setTitle("SimpleSynopticAppli  ");
        this.splash.setCopyright("(c) ESRF 2003-2017");
        this.splash.setMessage("Loading synoptic ...");
        this.splash.initProgress();
        this.splash.setMaxProgress(100);
        this.splash.setVisible(true);
        this.numberAndStateScalarAttList = new AttributePolledList();
        this.numberAndStateScalarAttList.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                return entity instanceof INumberScalar || entity instanceof IDevStateScalar;
            }
        });
        this.trendFrame = new JFrame();
        JPanel trendPanel = new JPanel();
        trendPanel.setLayout(new BorderLayout());
        trendPanel.setPreferredSize(new Dimension(600, 300));
        this.globalTrend = new Trend(this.trendFrame);
        trendPanel.add((Component)this.globalTrend, "Center");
        this.trendFrame.setContentPane(trendPanel);
        this.trendFrame.pack();
        this.initComponents();
    }

    public SimpleSynopticAppli(String jdrawFullFileName) {
        this();
        this.loadSynoptic(jdrawFullFileName);
        this.pack();
        this.setVisible(true);
    }

    public SimpleSynopticAppli(String jdrawFullFileName, boolean stand) {
        this();
        this.loadSynoptic(jdrawFullFileName);
        this.standAlone = stand;
    }

    public SimpleSynopticAppli(String jdrawFullFileName, String settingManagerName, boolean stand) {
        this(jdrawFullFileName, stand);
        this.settingManagerName = settingManagerName;
        this.addSettingsManagerSupport();
    }

    private void addSettingsManagerSupport() {
        if (this.settingManagerName == null) {
            return;
        }
        this.smProxy = new SettingsManagerProxy(this.settingManagerName);
        this.smProxy.setErrorHistoryWindow(this.errorHistory);
        String username = System.getProperty("user.name");
        String author = this.settingManagerName.substring(this.settingManagerName.lastIndexOf("/") + 1) + " Synoptic (" + username + ")";
        this.smProxy.setFileAuthor(author);
        this.fileLoadMenuItem = new JMenuItem("Load...");
        this.fileLoadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleSynopticAppli.this.smProxy.loadSettingsFile();
            }
        });
        this.filePreviewMenuItem = new JMenuItem("Preview...");
        this.filePreviewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleSynopticAppli.this.smProxy.previewSettingsFile();
            }
        });
        this.fileSaveMenuItem = new JMenuItem("Save...");
        this.fileSaveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleSynopticAppli.this.smProxy.saveSettingsFile();
            }
        });
        this.fileJMenu.add((Component)new JSeparator(), 0);
        this.fileJMenu.add((Component)this.fileSaveMenuItem, 0);
        this.fileJMenu.add((Component)this.filePreviewMenuItem, 0);
        this.fileJMenu.add((Component)this.fileLoadMenuItem, 0);
        if (this.smProxy.getSettingsPanel() != null) {
            this.mainPanel.add((Component)this.smProxy.getSettingsPanel(), "South");
        }
    }

    private void loadSynoptic(String jdrawFullFileName) {
        try {
            this.tangoSynopHandler.setProgressListener(this);
            this.tangoSynopHandler.setSynopticFileName(jdrawFullFileName);
            this.splash.setMessage("Synoptic file loaded ...");
            this.tangoSynopHandler.setToolTipMode(3);
            if (this.tangoSynopHandler.isAutoZoomAsked()) {
                this.tangoSynopHandler.setAutoZoom(true);
            }
        }
        catch (FileNotFoundException fnfEx) {
            this.splash.setVisible(false);
            JOptionPane.showMessageDialog(null, "Cannot find the synoptic file : " + jdrawFullFileName + ".\nCheck the file name you entered; Application will abort ...\n" + fnfEx, "No such file", 0);
            this.splash.setVisible(false);
            return;
        }
        catch (IllegalArgumentException illEx) {
            this.splash.setVisible(false);
            JOptionPane.showMessageDialog(null, "Cannot parse the synoptic file : " + jdrawFullFileName + ".\nCheck if the file is a Jdraw file. Application will abort ...\n" + illEx, "Cannot parse the file", 0);
            this.splash.setVisible(false);
            return;
        }
        catch (MissingResourceException mrEx) {
            this.splash.setVisible(false);
            JOptionPane.showMessageDialog(null, "Cannot parse the synoptic file : " + jdrawFullFileName + ".\n Application will abort ...\n" + mrEx, "Cannot parse the file", 0);
            this.splash.setVisible(false);
            return;
        }
        this.setTrendAttributeList();
        this.splash.setVisible(false);
        this.fileLoaded = true;
        this.setTitle(jdrawFullFileName);
    }

    private void setTrendAttributeList() {
        AttributeList attl = this.tangoSynopHandler.getAttributeList();
        for (int i = 0; i < attl.getSize(); ++i) {
            IEntity ie = (IEntity)attl.get(i);
            try {
                this.numberAndStateScalarAttList.add(ie.getName());
                continue;
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
        }
        this.globalTrend.setModel(this.numberAndStateScalarAttList);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.tangoSynopHandler = new TangoSynopticHandler();
        this.jMenuBar1 = new JMenuBar();
        this.fileJMenu = new JMenu();
        this.quitJMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.trendMenuItem = new JMenuItem();
        this.errHistMenuItem = new JMenuItem();
        this.diagtMenuItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SimpleSynopticAppli.this.exitForm(evt);
            }
        });
        if (this.errorHistory != null) {
            try {
                this.tangoSynopHandler.setErrorHistoryWindow(this.errorHistory);
            }
            catch (Exception setErrwExcept) {
                System.out.println("Cannot set Error History Window");
            }
        }
        this.mainPanel.add((Component)this.tangoSynopHandler, "Center");
        this.setContentPane(this.mainPanel);
        this.fileJMenu.setText("File");
        this.quitJMenuItem.setText("Quit");
        this.quitJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleSynopticAppli.this.quitJMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.quitJMenuItem);
        this.jMenuBar1.add(this.fileJMenu);
        this.viewMenu.setText("View");
        this.trendMenuItem.setText("Numeric & State Trend ");
        this.trendMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleSynopticAppli.this.viewTrendActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.trendMenuItem);
        this.viewMenu.add(this.errHistMenuItem);
        this.errHistMenuItem.setText("Error History ...");
        this.errHistMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleSynopticAppli.this.errHistMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.errHistMenuItem);
        this.diagtMenuItem.setText("Diagnostic ...");
        this.diagtMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        this.viewMenu.add(this.diagtMenuItem);
        this.jMenuBar1.add(this.viewMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void viewTrendActionPerformed(ActionEvent evt) {
        ATKGraphicsUtils.centerFrame(this.getRootPane(), this.trendFrame);
        this.trendFrame.setVisible(true);
    }

    private void errHistMenuItemActionPerformed(ActionEvent evt) {
        this.errorHistory.setVisible(true);
    }

    private void quitJMenuItemActionPerformed(ActionEvent evt) {
        this.stopSimpleSynopticAppli();
    }

    private void exitForm(WindowEvent evt) {
        this.stopSimpleSynopticAppli();
    }

    public void stopSimpleSynopticAppli() {
        if (this.standAlone) {
            System.exit(0);
        } else {
            this.tangoSynopHandler.getAttributeList().stopRefresher();
            if (this.globalTrend != null) {
                this.globalTrend.clearModel();
            }
            if (this.smProxy != null) {
                this.smProxy.clearModels();
            }
            this.dispose();
        }
    }

    @Override
    public void progress(double p) {
        this.splash.progress((int)(p * 100.0));
    }

    private static void printUsage() {
        System.out.println("Usage: synopticAppli [-s settingsmanager] [jdwfile]");
        System.exit(0);
    }

    public static void main(String[] args) {
        String fullFileName = null;
        String settingManagerName = null;
        int argc = 0;
        while (argc < args.length) {
            if (args[argc].equals("-s")) {
                if (++argc < args.length) {
                    settingManagerName = args[argc];
                } else {
                    SimpleSynopticAppli.printUsage();
                }
                ++argc;
                continue;
            }
            if (fullFileName == null) {
                fullFileName = args[argc];
            } else {
                SimpleSynopticAppli.printUsage();
            }
            ++argc;
        }
        if (fullFileName == null) {
            JFileChooser chooser = new JFileChooser(".");
            chooser.setDialogTitle("[SimpleSynopticAppli] Open a synoptic file");
            JDFileFilter jdwFilter = new JDFileFilter("JDraw synoptic", new String[]{"jdw"});
            chooser.addChoosableFileFilter(jdwFilter);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                fullFileName = f.getAbsolutePath();
            } else {
                System.exit(0);
            }
        }
        SimpleSynopticAppli syApp = new SimpleSynopticAppli(fullFileName, settingManagerName, true);
        if (!syApp.fileLoaded) {
            System.exit(-1);
        }
        ATKGraphicsUtils.centerFrameOnScreen(syApp);
        syApp.setVisible(true);
    }
}

