/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.jdraw;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.DevStateSpectrumEvent;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.EnumScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IEnumScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.IStatusListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.core.StatusEvent;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.AttributeFactory;
import fr.esrf.tangoatk.core.attribute.BooleanScalar;
import fr.esrf.tangoatk.core.command.CommandFactory;
import fr.esrf.tangoatk.core.command.InvalidCommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.widget.attribute.BooleanScalarCheckBoxViewer;
import fr.esrf.tangoatk.widget.attribute.DigitalNumberScalarViewer;
import fr.esrf.tangoatk.widget.attribute.EnumScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.MultiNumberSpectrumViewer;
import fr.esrf.tangoatk.widget.attribute.NumberImageViewer;
import fr.esrf.tangoatk.widget.attribute.NumberScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumViewer;
import fr.esrf.tangoatk.widget.attribute.SimpleEnumScalarViewer;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.attribute.StatusViewer;
import fr.esrf.tangoatk.widget.attribute.StringScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.StringScalarEditor;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.command.AnyCommandViewer;
import fr.esrf.tangoatk.widget.command.VoidVoidCommandViewer;
import fr.esrf.tangoatk.widget.jdraw.PanelItem;
import fr.esrf.tangoatk.widget.jdraw.SynopticProgressListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.JDWAttribute;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDMouseAdapter;
import fr.esrf.tangoatk.widget.util.jdraw.JDMouseEvent;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDSlider;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueListener;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TangoSynopticHandler
extends JDrawEditor
implements IStateListener,
IStatusListener,
INumberScalarListener,
IEnumScalarListener,
IDevStateScalarListener,
IBooleanScalarListener,
IDevStateSpectrumListener,
WindowListener {
    public static final int TOOL_TIP_NONE = 0;
    public static final int TOOL_TIP_STATE = 1;
    public static final int TOOL_TIP_STATUS = 2;
    public static final int TOOL_TIP_NAME = 3;
    private static final int STATE_INDEX = 0;
    private static final int STATUS_INDEX = 1;
    private static final String STATE_NONE = "no status";
    private static Map<String, Integer> dynoState = new HashMap<String, Integer>();
    private int toolTipMode = 3;
    protected String jdrawFileFullName = null;
    private AttributeFactory aFac = null;
    private CommandFactory cFac = null;
    private DeviceFactory dFac = null;
    protected AttributeList allAttributes = null;
    protected Map<String, List<JDObject>> jdHash;
    protected Map<String, List<String>> stateCashHash;
    protected Vector<String> metaNames;
    private AnyCommandViewer acv = null;
    private JFrame argFrame = null;
    private ErrorHistory errorHistWind = null;
    private ErrorPopup errPopup = null;
    private Vector<PanelItem> panelList = new Vector();
    private SynopticProgressListener progressListener = null;
    private int itemNumber = 0;
    private int loadedItem;

    public TangoSynopticHandler() {
        super(3);
        this.aFac = AttributeFactory.getInstance();
        this.cFac = CommandFactory.getInstance();
        this.dFac = DeviceFactory.getInstance();
        this.errPopup = ErrorPopup.getInstance();
        this.allAttributes = new AttributeList();
        this.metaNames = new Vector();
    }

    public TangoSynopticHandler(String jdFileName) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        this.setSynopticFileName(jdFileName);
    }

    public TangoSynopticHandler(String jdFileName, ErrorHistory errh) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        if (errh != null) {
            this.errorHistWind = errh;
        }
        this.setSynopticFileName(jdFileName);
    }

    public TangoSynopticHandler(String jdFileName, int ttMode) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        if (ttMode == 0 || ttMode == 1 || ttMode == 2 || ttMode == 3) {
            this.toolTipMode = ttMode;
        }
        this.setSynopticFileName(jdFileName);
    }

    public void setProgressListener(SynopticProgressListener p) {
        this.progressListener = p;
    }

    public int getToolTipMode() {
        return this.toolTipMode;
    }

    public void setToolTipMode(int ttMode) {
        if ((ttMode == 0 || ttMode == 1 || ttMode == 2 || ttMode == 3) && this.toolTipMode != ttMode) {
            this.toolTipMode = ttMode;
        }
    }

    public ErrorHistory getErrorHistoryWindow() {
        return this.errorHistWind;
    }

    public void setErrorHistoryWindow(ErrorHistory errh) {
        if (errh == null) {
            return;
        }
        if (this.jdrawFileFullName != null) {
            return;
        }
        this.errorHistWind = errh;
    }

    public String getSynopticFileName() {
        return this.jdrawFileFullName;
    }

    public void addMetaName(String metaName, String realName) {
        this.metaNames.add(metaName);
        this.metaNames.add(realName);
    }

    public AttributeList getAttributeList() {
        return this.allAttributes;
    }

    public void loadSynopticFromStream(InputStreamReader inp) throws IOException, MissingResourceException {
        this.jdHash = new HashMap<String, List<JDObject>>();
        this.stateCashHash = new HashMap<String, List<String>>();
        this.loadFromStream(inp);
        this.jdrawFileFullName = "InputStreamReader";
        if (this.getObjectNumber() == 0) {
            throw new MissingResourceException("The Jdraw file has no component inside. First draw a Jdraw File.", "JDrawEditor", null);
        }
        this.parseJdrawComponents();
        this.computePreferredSize();
        if (this.allAttributes.size() > 0) {
            for (int i = 0; i < this.allAttributes.size(); ++i) {
                ((AAttribute)this.allAttributes.elementAt(i)).refresh();
            }
            this.allAttributes.startRefresher();
        }
    }

    public void setSynopticFileName(String jdFileName) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        if (this.jdrawFileFullName != null) {
            this.clearSynopticFileModel();
        }
        this.jdHash = new HashMap<String, List<JDObject>>();
        this.stateCashHash = new HashMap<String, List<String>>();
        try {
            this.loadFile(jdFileName);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (this.getObjectNumber() == 0) {
            throw new MissingResourceException("The Jdraw file has no component inside. First draw a Jdraw File.", "JDrawEditor", null);
        }
        this.jdrawFileFullName = jdFileName;
        this.parseJdrawComponents();
        this.computePreferredSize();
        if (this.allAttributes.size() > 0) {
            for (int i = 0; i < this.allAttributes.size(); ++i) {
                ((AAttribute)this.allAttributes.elementAt(i)).refresh();
            }
            this.allAttributes.startRefresher();
        }
    }

    public void clearAllPanels() {
        for (PanelItem pi : this.panelList) {
            this.removePanel(pi);
        }
        this.panelList.clear();
        this.panelList = new Vector();
    }

    private void removeAllListeners() {
        if (this.allAttributes == null) {
            return;
        }
        if (this.allAttributes.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.allAttributes.size(); ++i) {
            IDevStateScalar idss;
            Object obj = this.allAttributes.get(i);
            if (obj instanceof IDevStateScalar) {
                idss = (IDevStateScalar)obj;
                idss.removeDevStateScalarListener((IDevStateScalarListener)this);
                continue;
            }
            if (obj instanceof INumberScalar) {
                INumberScalar ins = (INumberScalar)obj;
                ins.removeNumberScalarListener((INumberScalarListener)this);
                continue;
            }
            if (obj instanceof IBooleanScalar) {
                IBooleanScalar ibs = (IBooleanScalar)obj;
                ibs.removeBooleanScalarListener((IBooleanScalarListener)this);
                continue;
            }
            if (!(obj instanceof IDevStateSpectrum)) continue;
            idss = (IDevStateSpectrum)obj;
            idss.removeDevStateSpectrumListener((IDevStateSpectrumListener)this);
        }
    }

    public void clearSynopticFileModel() {
        this.removeAllListeners();
        this.clearAllPanels();
        if (this.allAttributes != null) {
            this.allAttributes.stopRefresher();
            if (this.allAttributes.size() > 0) {
                this.allAttributes.clear();
            }
            this.allAttributes = new AttributeList();
        }
        if (this.jdHash != null) {
            if (!this.jdHash.isEmpty()) {
                this.jdHash.clear();
            }
            this.jdHash = null;
        }
        if (this.stateCashHash != null) {
            if (!this.stateCashHash.isEmpty()) {
                this.stateCashHash.clear();
            }
            this.stateCashHash = null;
        }
        this.jdrawFileFullName = null;
    }

    private void updateName(JDObject obj) {
        int nbName = this.metaNames.size() / 2;
        if (nbName > 0) {
            boolean found = false;
            for (int i = 0; !found && i < nbName; ++i) {
                String objName = obj.getName();
                found = objName.contains(this.metaNames.get(2 * i));
                if (!found) continue;
                objName = objName.replace(this.metaNames.get(2 * i), this.metaNames.get(2 * i + 1));
                obj.setName(objName);
            }
        }
    }

    protected void parseJdrawComponents() {
        if (this.progressListener != null) {
            this.countJdrawComponents();
        }
        this.loadedItem = 0;
        for (int i = 0; i < this.getObjectNumber(); ++i) {
            JDObject jdObj = this.getObjectAt(i);
            this.updateName(jdObj);
            String s = jdObj.getName();
            if (jdObj instanceof JDSwingObject && ((JDSwingObject)jdObj).getComponent() instanceof MultiNumberSpectrumViewer) {
                MultiNumberSpectrumViewer v = (MultiNumberSpectrumViewer)((JDSwingObject)jdObj).getComponent();
                for (int j = 0; j < v.getJDWAttributeNumber(); ++j) {
                    JDWAttribute jdwAtt = v.getJDWAttribute(j);
                    if (!this.isAttribute(jdwAtt.attName)) continue;
                    try {
                        IAttribute att = this.aFac.getAttribute(jdwAtt.attName);
                        if (att == null || !(att instanceof INumberSpectrum)) continue;
                        INumberSpectrum model = (INumberSpectrum)att;
                        v.addNumberSpectrumModel(model, jdwAtt);
                        this.allAttributes.add((IEntity)model);
                        if (this.errorHistWind == null) continue;
                        model.addErrorListener((IErrorListener)this.errorHistWind);
                        continue;
                    }
                    catch (ConnectionException connectionexception) {
                        System.out.println("Error: " + s + " " + connectionexception);
                        continue;
                    }
                    catch (DevFailed ex) {
                        System.out.println("Error: " + s + " " + ex.errors[0].desc);
                    }
                }
                continue;
            }
            if (jdObj instanceof JDSwingObject && ((JDSwingObject)jdObj).getComponent() instanceof Trend) {
                String err;
                Trend t = (Trend)((JDSwingObject)jdObj).getComponent();
                Object config = jdObj.getExtendedParam("trendSettings");
                if (!((String)config).endsWith("\n")) {
                    config = (String)config + "\n";
                }
                if ((err = t.setSetting((String)config)).length() <= 0) continue;
                System.out.println("Trend Error: " + err);
                continue;
            }
            if (this.isDevice(s)) {
                this.addDevice(jdObj, s);
                this.itemLoaded();
                continue;
            }
            if (this.isAttribute(s)) {
                this.addAttribute(jdObj, s);
                this.itemLoaded();
                continue;
            }
            if (this.isSpectrumAttElement(s)) {
                this.addSpectrumAttElement(jdObj, s);
                this.itemLoaded();
                continue;
            }
            if (this.isCommand(s)) {
                this.addCommand(jdObj, s);
                this.itemLoaded();
                continue;
            }
            if (!jdObj.isInteractive() || !jdObj.hasExtendedParam("shellCommand")) continue;
            this.addShellCmdButton(jdObj);
        }
    }

    private void itemLoaded() {
        if (this.progressListener != null) {
            ++this.loadedItem;
            double p = (double)this.loadedItem / (double)this.itemNumber;
            this.progressListener.progress(p);
        }
    }

    private void countJdrawComponents() {
        this.itemNumber = 0;
        for (int i = 0; i < this.getObjectNumber(); ++i) {
            JDObject jdObj = this.getObjectAt(i);
            String s = jdObj.getName();
            if (this.isDeviceSyntax(s)) {
                ++this.itemNumber;
                continue;
            }
            if (this.isAttributeSyntax(s)) {
                ++this.itemNumber;
                continue;
            }
            if (this.isSpectrumAttElementSyntax(s)) {
                ++this.itemNumber;
                continue;
            }
            if (!this.isCommandSyntax(s)) continue;
            ++this.itemNumber;
        }
    }

    private void addShellCmdButton(JDObject jdo) {
        String shellCmd = jdo.getExtendedParam("shellCommand");
        if (shellCmd == null) {
            return;
        }
        if (shellCmd.length() == 0) {
            return;
        }
        jdo.addValueListener(new JDValueListener(){

            @Override
            public void valueChanged(JDObject src) {
            }

            @Override
            public void valueExceedBounds(JDObject src) {
                String compName = src.getName();
                String command = src.getExtendedParam("shellCommand");
                System.out.println("Interactive Object " + compName + " value Exceed Bounds");
                if (JOptionPane.showConfirmDialog(null, "This Shell Command is going to be executed, Are you sure?\n>" + command, compName + ": Shell Command", 0) == 0) {
                    try {
                        System.out.println("The osName is " + System.getProperty("os.name"));
                        if (command.endsWith("&")) {
                            command = command.substring(0, command.length() - 1);
                        }
                        System.out.println("ExecutionAccepted:" + command);
                        Runtime rt = Runtime.getRuntime();
                        rt.exec(command);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage());
                    }
                } else {
                    System.out.println("ExecutionRejected");
                }
            }
        });
    }

    protected boolean isAttribute(String s) {
        int lastSlash = s.lastIndexOf("/");
        if (lastSlash <= 0 || lastSlash >= s.length()) {
            return false;
        }
        try {
            String attDevName = s.substring(0, lastSlash);
            boolean isdev = this.isDevice(attDevName);
            if (!isdev) {
                if (s.toLowerCase().endsWith("/state")) {
                    return this.aFac.isConnectionLessAttribute(s);
                }
                return false;
            }
            String attName = s.substring(lastSlash, s.length());
            boolean attPattern = Pattern.matches("/[a-zA-Z_0-9[-]]+", attName);
            if (!attPattern) {
                return false;
            }
            return this.aFac.isAttribute(s);
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
    }

    private boolean isAttributeSyntax(String s) {
        int lastSlash = s.lastIndexOf("/");
        if (lastSlash <= 0 || lastSlash >= s.length()) {
            return false;
        }
        try {
            String attDevName = s.substring(0, lastSlash);
            boolean isdev = this.isDeviceSyntax(attDevName);
            if (!isdev) {
                return false;
            }
            String attName = s.substring(lastSlash, s.length());
            if (Pattern.matches("/[a-zA-Z_0-9[-]]+", attName)) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
        return false;
    }

    protected boolean isSpectrumAttElement(String s) {
        int lastSlash = s.lastIndexOf("/");
        if (lastSlash <= 0 || lastSlash >= s.length()) {
            return false;
        }
        try {
            int leftBracket;
            String attDevName = s.substring(0, lastSlash);
            boolean isdev = this.isDevice(attDevName);
            if (!isdev) {
                return false;
            }
            String attName = s.substring(lastSlash, s.length());
            boolean attPattern = Pattern.matches("/[a-zA-Z_0-9[-]]+\\[[0-9]+\\]", attName);
            if (attPattern && ((leftBracket = s.lastIndexOf("[")) > 0 || leftBracket < s.length())) {
                String spectrumAttName = s.substring(0, leftBracket);
                return this.aFac.isAttribute(spectrumAttName);
            }
            return false;
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
    }

    private boolean isSpectrumAttElementSyntax(String s) {
        int lastSlash = s.lastIndexOf("/");
        if (lastSlash <= 0 || lastSlash >= s.length()) {
            return false;
        }
        try {
            int leftBracket;
            String attDevName = s.substring(0, lastSlash);
            boolean isdev = this.isDevice(attDevName);
            if (!isdev) {
                return false;
            }
            String attName = s.substring(lastSlash, s.length());
            boolean attPattern = Pattern.matches("/[a-zA-Z_0-9[-]]+\\[[0-9]+\\]", attName);
            return attPattern && ((leftBracket = s.lastIndexOf("[")) > 0 || leftBracket < s.length());
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
    }

    protected boolean isCommand(String s) {
        int lastSlash = s.lastIndexOf("/");
        if (lastSlash <= 0 || lastSlash >= s.length()) {
            return false;
        }
        try {
            String cmdDevName = s.substring(0, lastSlash);
            boolean isdev = this.isDevice(cmdDevName);
            if (!isdev) {
                return false;
            }
            String cmdName = s.substring(lastSlash, s.length());
            boolean cmdPattern = Pattern.matches("/[a-zA-Z_0-9[-]]+", cmdName);
            if (!cmdPattern) {
                return false;
            }
            return this.cFac.isCommand(s);
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
    }

    private boolean isCommandSyntax(String s) {
        int lastSlash = s.lastIndexOf("/");
        if (lastSlash <= 0 || lastSlash >= s.length()) {
            return false;
        }
        try {
            String cmdDevName = s.substring(0, lastSlash);
            boolean isdev = this.isDevice(cmdDevName);
            if (!isdev) {
                return false;
            }
            String cmdName = s.substring(lastSlash, s.length());
            if (Pattern.matches("/[a-zA-Z_0-9[-]]+", cmdName)) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
        return false;
    }

    protected boolean isDevice(String devName) {
        if (!this.isDeviceName(devName)) {
            return false;
        }
        return this.dFac.isDevice(devName);
    }

    private boolean isDeviceSyntax(String devName) {
        return this.isDeviceName(devName);
    }

    private boolean isDeviceName(String devName) {
        boolean devNamePattern;
        String s = new String(devName);
        String devicePattern = "[a-zA-Z_0-9[-][\\.]]+/[a-zA-Z_0-9[-][\\.]]+/[a-zA-Z_0-9[-][\\.]]+";
        if (s.startsWith("tango:")) {
            s = s.substring(6);
        }
        if (!(devNamePattern = Pattern.matches("//[a-zA-Z_0-9]+:[0-9]+/" + devicePattern, s))) {
            devNamePattern = Pattern.matches(devicePattern, s);
        }
        if (!devNamePattern) {
            devNamePattern = Pattern.matches("taco:" + devicePattern, s);
        }
        if (!devNamePattern) {
            devNamePattern = Pattern.matches("taco://" + devicePattern, s);
        }
        if (!devNamePattern) {
            devNamePattern = Pattern.matches("//[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+:[0-9]+/" + devicePattern, s);
        }
        return devNamePattern;
    }

    private void addDevice(JDObject jdObj, String s) {
        try {
            Device dev = this.dFac.getDevice(s);
            if (dev == null) {
                return;
            }
            if (!dev.areDevPropertiesLoaded()) {
                dev.loadDevProperties();
            }
            this.addDeviceListener(dev);
            this.mouseifyDevice(jdObj);
            this.stashComponent(s, jdObj);
            this.addDevToStateCashHashMap(s);
            this.refreshStateJDObj(jdObj, dev);
        }
        catch (ConnectionException connectionexception) {
            System.out.println("Couldn't load device " + s + " " + connectionexception);
        }
    }

    private void refreshStateJDObj(JDObject jdo, Device dev) {
        List<String> stateStatusCash = null;
        String stateCash = null;
        stateStatusCash = this.stateCashHash.get(dev.getName().toLowerCase());
        if (stateStatusCash != null) {
            try {
                stateCash = stateStatusCash.get(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (stateCash == null || stateCash.equalsIgnoreCase(STATE_NONE)) {
            return;
        }
        if (jdo.isProgrammed()) {
            jdo.setValue(this.getDynoState(stateCash));
            jdo.refresh();
        } else {
            this.changeJDobjColor(jdo, ATKConstant.getColor4State(stateCash, dev.getInvertedOpenClose(), dev.getInvertedInsertExtract()));
        }
    }

    private void addDeviceListener(Device device) {
        System.out.println("connecting to a device : " + device);
        device.addStateListener((IStateListener)this);
        device.addStatusListener((IStatusListener)this);
        if (this.errorHistWind != null) {
            device.addErrorListener((IErrorListener)this.errorHistWind);
        }
    }

    private void mouseifyDevice(JDObject jdObj) {
        jdObj.addMouseListener(new JDMouseAdapter(){

            @Override
            public void mousePressed(JDMouseEvent e) {
                TangoSynopticHandler.this.deviceClicked(e);
            }

            @Override
            public void mouseEntered(JDMouseEvent e) {
                TangoSynopticHandler.this.devDisplayToolTip(e);
            }

            @Override
            public void mouseExited(JDMouseEvent e) {
                TangoSynopticHandler.this.devRemoveToolTip();
            }
        });
    }

    private void mouseifyAttribute(JDObject jdObj) {
        jdObj.addMouseListener(new JDMouseAdapter(){

            @Override
            public void mousePressed(JDMouseEvent e) {
                TangoSynopticHandler.this.attributeClicked(e);
            }

            @Override
            public void mouseEntered(JDMouseEvent e) {
                TangoSynopticHandler.this.attDisplayToolTip(e);
            }

            @Override
            public void mouseExited(JDMouseEvent e) {
                TangoSynopticHandler.this.attRemoveToolTip();
            }
        });
    }

    private void mouseifyStateAttribute(JDObject jdObj) {
        jdObj.addMouseListener(new JDMouseAdapter(){

            @Override
            public void mousePressed(JDMouseEvent e) {
                TangoSynopticHandler.this.stateAttributeClicked(e);
            }

            @Override
            public void mouseEntered(JDMouseEvent e) {
                TangoSynopticHandler.this.devDisplayToolTip(e);
            }

            @Override
            public void mouseExited(JDMouseEvent e) {
                TangoSynopticHandler.this.devRemoveToolTip();
            }
        });
    }

    private void mouseifyStateSpectrumElement(JDObject jdObj, IDevStateSpectrum stateSpecAtt) {
        final IDevStateSpectrum att = stateSpecAtt;
        final int elemIndex = this.getIndexFromName(jdObj.getName());
        jdObj.addMouseListener(new JDMouseAdapter(){

            @Override
            public void mousePressed(JDMouseEvent e) {
                TangoSynopticHandler.this.stateSpectrumElementClicked(e);
            }

            @Override
            public void mouseEntered(JDMouseEvent e) {
                TangoSynopticHandler.this.stateSpectrumElementDisplayToolTip(e, att, elemIndex);
            }

            @Override
            public void mouseExited(JDMouseEvent e) {
                TangoSynopticHandler.this.stateSpectrumElementRemoveToolTip();
            }
        });
    }

    private void deviceClicked(JDMouseEvent evt) {
        JDObject comp = (JDObject)evt.getSource();
        String devName = comp.getName();
        this.launchPanel(comp, devName, true);
    }

    private void attributeClicked(JDMouseEvent evt) {
        JDObject comp = (JDObject)evt.getSource();
        String attName = comp.getName();
        this.launchPanel(comp, attName, false);
    }

    private void stateAttributeClicked(JDMouseEvent evt) {
        if (evt.getButton() != 1) {
            return;
        }
        JDObject comp = (JDObject)evt.getSource();
        String attName = comp.getName();
        int i = attName.lastIndexOf(47);
        if (i > 0) {
            String devName = attName.substring(0, i);
            this.launchPanel(comp, devName, true);
        }
    }

    private boolean isNoPanel(String panelName) {
        if (panelName.equalsIgnoreCase("noPanel")) {
            return true;
        }
        return panelName.equalsIgnoreCase("no panel");
    }

    private void launchPanel(JDObject comp, String compName, boolean isAdevice) {
        Constructor<?> panelClNew;
        String pname;
        if (comp.isDisabled()) {
            return;
        }
        if (comp.hasExtendedParam("className") && this.isNoPanel(pname = comp.getExtendedParam("className"))) {
            return;
        }
        if (!comp.hasExtendedParam("className")) {
            if (isAdevice) {
                Window w = this.getPanel("atkpanel.MainPanel", compName);
                if (w == null) {
                    this.showDefaultPanel(compName);
                } else {
                    this.showPanelWindow(w);
                }
            }
            return;
        }
        String clName = comp.getExtendedParam("className");
        String constParam = comp.getExtendedParam("classParam");
        if (constParam.length() == 0) {
            constParam = null;
        }
        System.out.println("clName = " + clName + "  constParam = " + constParam + " compName = " + compName);
        Class[] paramCls = new Class[1];
        Object[] params = new Object[]{constParam == null ? compName : constParam};
        System.out.println("params[0]= " + params[0]);
        Window w = this.getPanel(clName, (String)params[0]);
        if (w != null) {
            this.showPanelWindow(w);
            return;
        }
        try {
            Class<?> panelCl = Class.forName(clName);
            paramCls[0] = compName.getClass();
            panelClNew = panelCl.getConstructor(paramCls);
        }
        catch (ClassNotFoundException clex) {
            this.showErrorMsg("The panel class : " + clName + " not found; ignored.\n");
            return;
        }
        catch (Exception e) {
            this.showErrorMsg("Failed to load the constructor " + clName + "( String ) for the panel class.\n");
            return;
        }
        try {
            Object obj = panelClNew.newInstance(params);
            PanelItem newPanel = this.addNewPanel(obj, clName, (String)params[0]);
            if (newPanel != null) {
                this.showPanelWindow(newPanel.parent);
            }
        }
        catch (InstantiationException instex) {
            this.showErrorMsg("Failed to instantiate 1 the panel class : " + clName + ".\n");
            instex.printStackTrace();
        }
        catch (IllegalAccessException accesex) {
            this.showErrorMsg("Failed to instantiate 2 the panel class : " + clName + ".\n");
            accesex.printStackTrace();
        }
        catch (IllegalArgumentException argex) {
            this.showErrorMsg("Failed to instantiate 3 the panel class : " + clName + ".\n");
            argex.printStackTrace();
        }
        catch (InvocationTargetException invoqex) {
            this.showErrorMsg("Failed to instantiate 4 the panel class : " + clName + ".\n");
            System.out.println(invoqex);
            System.out.println(invoqex.getMessage());
            invoqex.printStackTrace();
        }
        catch (Exception e) {
            this.showErrorMsg("Got an exception when instantiate the panel class : " + clName + ".\n");
            e.printStackTrace();
        }
    }

    private void showErrorMsg(String msg) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(null, msg);
    }

    private void showPanelWindow(Window pw) {
        if (pw == null) {
            return;
        }
        if (pw instanceof JFrame) {
            ATKGraphicsUtils.centerFrame(this, (JFrame)pw);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (pw.isVisible()) {
            pw.toFront();
        }
    }

    private Window getPanel(String className, String param) {
        boolean found = false;
        int i = 0;
        PanelItem panel = null;
        while (i < this.panelList.size() && !found) {
            panel = this.panelList.get(i);
            found = panel.className.equals(className) && panel.param.equals(param);
            if (found) continue;
            ++i;
        }
        if (found) {
            return panel.parent;
        }
        return null;
    }

    private PanelItem addNewPanel(Object obj, String className, String param) {
        PanelItem panel = new PanelItem(obj, className, param);
        if (panel.parent != null) {
            this.panelList.add(panel);
            panel.parent.addWindowListener(this);
            return panel;
        }
        return null;
    }

    private void removePanel(PanelItem pi) {
        Window pw = pi.parent;
        if (pw != null) {
            pw.removeWindowListener(this);
            if (pw instanceof JFrame) {
                JFrame jf = (JFrame)pw;
                pw.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(pw, 201));
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        boolean found = false;
        int i = 0;
        PanelItem panel = null;
        while (i < this.panelList.size() && !found) {
            panel = this.panelList.get(i);
            found = panel.parent == e.getSource();
            if (found) continue;
            ++i;
        }
        if (found) {
            this.panelList.remove(i);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private void showDefaultPanel(String devName) {
        Constructor<?> atkpanelClNew;
        Class<?> atkpanelCl;
        Class[] atkpanelParamCls = new Class[5];
        Object[] params = new Object[5];
        System.out.println("showDefaultPanel called");
        try {
            atkpanelCl = Class.forName("atkpanel.MainPanel");
        }
        catch (ClassNotFoundException clex) {
            this.showErrorMsg("showDefaultPanel : atkpanel.MainPanel not found; ignored.\n");
            return;
        }
        try {
            atkpanelParamCls[0] = devName.getClass();
            atkpanelParamCls[1] = Class.forName("java.lang.Boolean");
            atkpanelParamCls[2] = atkpanelParamCls[1];
            atkpanelParamCls[3] = atkpanelParamCls[1];
            atkpanelParamCls[4] = atkpanelParamCls[1];
            atkpanelClNew = atkpanelCl.getConstructor(atkpanelParamCls);
        }
        catch (ClassNotFoundException clex) {
            this.showErrorMsg("showDefaultPanel :java.lang.Boolean not found; ignored.\n");
            return;
        }
        catch (Exception e) {
            this.showErrorMsg("showDefaultPanel : Failed to load the constructor (five arguments) for atkpanel read-only.\n");
            return;
        }
        params[0] = devName;
        params[1] = Boolean.FALSE;
        params[2] = Boolean.TRUE;
        params[3] = Boolean.FALSE;
        params[4] = Boolean.TRUE;
        try {
            Object obj = atkpanelClNew.newInstance(params);
            PanelItem newPanel = this.addNewPanel(obj, "atkpanel.MainPanel", devName);
            if (newPanel != null) {
                this.showPanelWindow(newPanel.parent);
            }
        }
        catch (InstantiationException instex) {
            this.showErrorMsg("Failed to instantiate 1 the atkpanel read-only.\n");
        }
        catch (IllegalAccessException accesex) {
            this.showErrorMsg("Failed to instantiate 2 the atkpanel read-only.\n");
        }
        catch (IllegalArgumentException argex) {
            this.showErrorMsg("Failed to instantiate 3 the atkpanel read-only.\n");
        }
        catch (InvocationTargetException invoqex) {
            this.showErrorMsg("Failed to instantiate 4 the atkpanel read-only.\n");
            System.out.println(invoqex);
            System.out.println(invoqex.getMessage());
            invoqex.printStackTrace();
        }
        catch (Exception e) {
            this.showErrorMsg("Got an exception when instantiate the default panel : atkpanel readonly.\n");
        }
    }

    private void stashComponent(String s, JDObject jdObj) {
        List<JDObject> list = this.jdHash.get(s);
        if (list == null) {
            list = new Vector<JDObject>();
        }
        list.add(jdObj);
        this.jdHash.put(s, list);
    }

    private void addDevToStateCashHashMap(String s) {
        List<String> list = this.stateCashHash.get(s.toLowerCase());
        if (list != null) {
            return;
        }
        list = new Vector<String>();
        String str = new String(STATE_NONE);
        list.add(0, str);
        list.add(1, str);
        this.stateCashHash.put(s.toLowerCase(), list);
    }

    private void addCommand(JDObject jdObj, String s) {
        ICommand cmd = null;
        try {
            cmd = this.cFac.getCommand(s);
            if (cmd != null) {
                if (jdObj instanceof JDSwingObject) {
                    JComponent swingComp = ((JDSwingObject)jdObj).getComponent();
                    if (swingComp instanceof VoidVoidCommandViewer) {
                        ((VoidVoidCommandViewer)swingComp).setModel(cmd);
                    }
                } else if (jdObj.isInteractive()) {
                    this.mouseifyCommand(jdObj, cmd);
                }
                cmd.addErrorListener((IErrorListener)this);
            }
        }
        catch (ConnectionException connectionexception) {
            System.out.println("Couldn't load device for command" + s + " " + connectionexception);
        }
        catch (DevFailed dfEx) {
            System.out.println("Couldn't find the command" + s + " " + dfEx);
        }
    }

    private void mouseifyCommand(JDObject jdpb, ICommand devCmd) {
        final ICommand cmd = devCmd;
        jdpb.addValueListener(new JDValueListener(){

            @Override
            public void valueChanged(JDObject jdObject) {
            }

            @Override
            public void valueExceedBounds(JDObject jdObject) {
                System.out.println("Acommand is " + cmd);
                TangoSynopticHandler.this.commandClicked(cmd);
            }
        });
    }

    private void commandClicked(ICommand ic) {
        if (ic instanceof InvalidCommand) {
            JOptionPane.showMessageDialog(this, ic.getName() + " is not supported. ", "Error", 1);
            return;
        }
        if (ic instanceof VoidVoidCommand) {
            ic.execute();
            return;
        }
        if (this.acv == null) {
            this.argFrame = new JFrame();
            this.acv = new AnyCommandViewer();
            this.argFrame.getContentPane().add(this.acv);
        }
        this.acv.initialize(ic);
        this.acv.setBorder(null);
        this.acv.setInputVisible(true);
        this.acv.setDeviceButtonVisible(true);
        this.acv.setDescriptionVisible(true);
        this.acv.setInfoButtonVisible(true);
        if (!ic.takesInput()) {
            ic.execute();
        }
        this.argFrame.setTitle(ic.getName());
        this.argFrame.pack();
        this.argFrame.setVisible(true);
    }

    private void addStateScalarAttribute(JDObject jdObj, IDevStateScalar model) {
        String attName = model.getName();
        System.out.println("Connecting to a StateScalar attribute : " + attName);
        this.mouseifyStateAttribute(jdObj);
        this.stashComponent(attName, jdObj);
        this.addDevToStateCashHashMap(attName);
        if (!model.areAttPropertiesLoaded()) {
            model.loadAttProperties();
        }
        model.addDevStateScalarListener((IDevStateScalarListener)this);
        this.allAttributes.add((IEntity)model);
        if (this.errorHistWind != null) {
            model.addErrorListener((IErrorListener)this.errorHistWind);
        }
        this.refreshStateJDObj(jdObj, model);
    }

    private void refreshStateJDObj(JDObject jdo, IDevStateScalar stateAtt) {
        List<String> stateStatusCash = null;
        String stateCash = null;
        stateStatusCash = this.stateCashHash.get(stateAtt.getName().toLowerCase());
        if (stateStatusCash != null) {
            try {
                stateCash = stateStatusCash.get(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (stateCash == null || stateCash.equalsIgnoreCase(STATE_NONE)) {
            return;
        }
        if (jdo.isProgrammed()) {
            jdo.setValue(this.getDynoState(stateCash));
            jdo.refresh();
        } else {
            this.changeJDobjColor(jdo, ATKConstant.getColor4State(stateCash, stateAtt.getInvertedOpenClose(), stateAtt.getInvertedInsertExtract()));
        }
    }

    private void addBooleanScalarAttribute(JDObject jdObj, IBooleanScalar model) {
        this.mouseifyAttribute(jdObj);
        if (jdObj instanceof JDSwingObject) {
            JComponent atkObj = ((JDSwingObject)jdObj).getComponent();
            if (atkObj instanceof BooleanScalarCheckBoxViewer) {
                ((BooleanScalarCheckBoxViewer)atkObj).setAttModel(model);
                this.allAttributes.add((IEntity)model);
                model.addSetErrorListener((ISetErrorListener)this.errPopup);
                if (this.errorHistWind != null) {
                    model.addErrorListener((IErrorListener)this.errorHistWind);
                }
            } else {
                System.out.println(atkObj.getClass().getName() + " does not accept IBooleanScalar model");
            }
        } else {
            String attName = model.getName();
            System.out.println("connecting to a BooleanScalar attribute : " + attName);
            this.allAttributes.add((IEntity)model);
            model.addBooleanScalarListener((IBooleanScalarListener)this);
            this.stashComponent(model.getName(), jdObj);
        }
    }

    private void addNumberScalarAttribute(JDObject jdObj, INumberScalar model) {
        this.mouseifyAttribute(jdObj);
        if (jdObj instanceof JDSwingObject) {
            JComponent atkObj = ((JDSwingObject)jdObj).getComponent();
            if (atkObj instanceof SimpleScalarViewer) {
                ((SimpleScalarViewer)atkObj).setModel(model);
                ((SimpleScalarViewer)atkObj).setHasToolTip(true);
                this.allAttributes.add((IEntity)model);
            } else if (atkObj instanceof DigitalNumberScalarViewer) {
                ((DigitalNumberScalarViewer)atkObj).setModel(model);
                ((DigitalNumberScalarViewer)atkObj).setHasToolTip(true);
                this.allAttributes.add((IEntity)model);
            } else if (atkObj instanceof NumberScalarWheelEditor) {
                ((NumberScalarWheelEditor)atkObj).setModel(model);
                this.allAttributes.add((IEntity)model);
                model.addSetErrorListener((ISetErrorListener)this.errPopup);
            } else if (atkObj instanceof NumberScalarComboEditor) {
                double[] possVals;
                String valList = jdObj.getExtendedParam("valueList");
                if (valList != null && valList.length() != 0 && (possVals = this.parsePossNumberValues(valList)) != null && possVals.length != 0) {
                    model.setPossibleValues(possVals);
                }
                ((NumberScalarComboEditor)atkObj).setNumberModel(model);
                this.allAttributes.add((IEntity)model);
                model.addSetErrorListener((ISetErrorListener)this.errPopup);
            } else {
                System.out.println(atkObj.getClass().getName() + " does not accept INumberScalar model");
            }
        } else {
            String attName = model.getName();
            System.out.println("connecting to a NumberScalar attribute : " + attName);
            this.allAttributes.add((IEntity)model);
            model.addNumberScalarListener((INumberScalarListener)this);
            this.stashComponent(model.getName(), jdObj);
        }
        if (this.errorHistWind != null) {
            model.addErrorListener((IErrorListener)this.errorHistWind);
        }
    }

    private void addStateSpectrumAttributeElement(JDObject jdObj, IDevStateSpectrum model) {
        System.out.println("Connecting to a DevStateSpectrum element : " + jdObj.getName());
        if (!model.areAttPropertiesLoaded()) {
            model.loadAttProperties();
        }
        this.mouseifyStateSpectrumElement(jdObj, model);
        this.stashComponent(jdObj.getName().toLowerCase(), jdObj);
        model.addDevStateSpectrumListener((IDevStateSpectrumListener)this);
        this.allAttributes.add((IEntity)model);
        if (this.errorHistWind != null) {
            model.addErrorListener((IErrorListener)this.errorHistWind);
        }
        model.refresh();
    }

    private double[] parsePossNumberValues(String vals) {
        String[] c = vals.split(",");
        if (c.length == 0) {
            return null;
        }
        if (c.length < 0) {
            return null;
        }
        double[] dvals = new double[c.length];
        int j = 0;
        for (int i = 0; i < c.length; ++i) {
            try {
                double dval;
                dvals[j] = dval = Double.parseDouble(c[i]);
                ++j;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (j <= 0) {
            return null;
        }
        if (j != c.length) {
            double[] retVals = new double[j];
            for (int i = 0; i < j; ++i) {
                retVals[i] = dvals[i];
            }
            return retVals;
        }
        return dvals;
    }

    private void addNumberSpectrumAttribute(JDObject jdObj, INumberSpectrum model) {
        if (jdObj instanceof JDSwingObject) {
            JComponent atkObj = ((JDSwingObject)jdObj).getComponent();
            if (atkObj instanceof NumberSpectrumViewer) {
                NumberSpectrumViewer nsv = (NumberSpectrumViewer)atkObj;
                nsv.setModel(model);
                this.allAttributes.add((IEntity)model);
                if (this.errorHistWind != null) {
                    model.addErrorListener((IErrorListener)this.errorHistWind);
                }
                if (nsv.getManageXaxis() && model.hasMinxMaxxAttributes()) {
                    this.addSpectMinxMaxxAttributes(nsv, model);
                }
            } else {
                System.out.println(atkObj.getClass().getName() + " does not accept INumberSpectrum model");
            }
        }
    }

    private void addSpectMinxMaxxAttributes(NumberSpectrumViewer nsv, INumberSpectrum ins) {
        String attFullName;
        IAttribute iatt = null;
        INumberScalar minAtt = null;
        INumberScalar maxAtt = null;
        if (nsv == null || ins == null) {
            return;
        }
        if (ins.getMinxAttName() == null || ins.getMaxxAttName() == null) {
            return;
        }
        try {
            attFullName = ins.getDevice() + "/" + ins.getMinxAttName();
            iatt = null;
            iatt = this.aFac.getAttribute(attFullName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iatt != null && iatt instanceof INumberScalar) {
            minAtt = (INumberScalar)iatt;
        }
        if (minAtt == null) {
            return;
        }
        try {
            attFullName = ins.getDevice() + "/" + ins.getMaxxAttName();
            iatt = null;
            iatt = this.aFac.getAttribute(attFullName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iatt != null && iatt instanceof INumberScalar) {
            maxAtt = (INumberScalar)iatt;
        }
        if (maxAtt == null) {
            return;
        }
        if (minAtt == maxAtt) {
            return;
        }
        this.allAttributes.add((IEntity)minAtt);
        this.allAttributes.add((IEntity)maxAtt);
        nsv.setXaxisModels(minAtt, maxAtt);
    }

    private void addNumberImageAttribute(JDObject jdObj, INumberImage model) {
        if (jdObj instanceof JDSwingObject) {
            JComponent atkObj = ((JDSwingObject)jdObj).getComponent();
            if (atkObj instanceof NumberImageViewer) {
                ((NumberImageViewer)atkObj).setModel(model);
                this.allAttributes.add((IEntity)model);
                if (this.errorHistWind != null) {
                    model.addErrorListener((IErrorListener)this.errorHistWind);
                }
            } else {
                System.out.println(atkObj.getClass().getName() + " does not accept INumberImage model");
            }
        }
    }

    private void addStringScalarAttribute(JDObject jdObj, IStringScalar model) {
        if (jdObj instanceof JDSwingObject) {
            JComponent atkObj = ((JDSwingObject)jdObj).getComponent();
            if (atkObj instanceof SimpleScalarViewer) {
                ((SimpleScalarViewer)atkObj).setModel(model);
                this.allAttributes.add((IEntity)model);
                if (this.errorHistWind != null) {
                    model.addErrorListener((IErrorListener)this.errorHistWind);
                }
            } else if (atkObj instanceof StringScalarEditor) {
                ((StringScalarEditor)atkObj).setModel(model);
                this.allAttributes.add((IEntity)model);
                if (this.errorHistWind != null) {
                    model.addErrorListener((IErrorListener)this.errorHistWind);
                }
            } else if (atkObj instanceof StatusViewer) {
                ((StatusViewer)atkObj).setModel(model);
                this.allAttributes.add((IEntity)model);
                if (this.errorHistWind != null) {
                    model.addErrorListener((IErrorListener)this.errorHistWind);
                }
            } else if (atkObj instanceof StringScalarComboEditor) {
                String[] possStrVals;
                String valList = jdObj.getExtendedParam("valueList");
                if (valList != null && valList.length() != 0 && (possStrVals = this.parsePossStringValues(valList)) != null && possStrVals.length != 0) {
                    model.setPossibleValues(possStrVals);
                }
                ((StringScalarComboEditor)atkObj).setStringModel(model);
                this.allAttributes.add((IEntity)model);
                model.addSetErrorListener((ISetErrorListener)this.errPopup);
            } else {
                System.out.println(atkObj.getClass().getName() + " does not accept IStringScalar model");
            }
        }
    }

    private void addEnumScalarAttribute(JDObject jdObj, IEnumScalar model) {
        if (jdObj instanceof JDSwingObject) {
            JComponent atkObj = ((JDSwingObject)jdObj).getComponent();
            if (atkObj instanceof SimpleEnumScalarViewer) {
                ((SimpleEnumScalarViewer)atkObj).setModel(model);
                this.allAttributes.add((IEntity)model);
                if (this.errorHistWind != null) {
                    model.addErrorListener((IErrorListener)this.errorHistWind);
                }
            } else if (atkObj instanceof EnumScalarComboEditor) {
                ((EnumScalarComboEditor)atkObj).setEnumModel(model);
                this.allAttributes.add((IEntity)model);
                model.addSetErrorListener((ISetErrorListener)this.errPopup);
            } else {
                System.out.println(atkObj.getClass().getName() + " does not accept IStringScalar model");
            }
        } else {
            this.mouseifyAttribute(jdObj);
            String attName = model.getName();
            System.out.println("connecting to a EnumScalar attribute : " + attName);
            this.allAttributes.add((IEntity)model);
            model.addEnumScalarListener((IEnumScalarListener)this);
            this.stashComponent(model.getName(), jdObj);
        }
    }

    private String[] parsePossStringValues(String vals) {
        String[] c;
        try {
            c = vals.split(",");
        }
        catch (Exception ex) {
            c = null;
        }
        return c;
    }

    protected void addAttribute(JDObject jddg, String s) {
        IAttribute att = null;
        try {
            att = this.aFac.getAttribute(s);
            if (att != null) {
                if (att instanceof IDevStateScalar) {
                    this.addStateScalarAttribute(jddg, (IDevStateScalar)att);
                    return;
                }
                if (att instanceof BooleanScalar) {
                    this.addBooleanScalarAttribute(jddg, (IBooleanScalar)att);
                    return;
                }
                if (att instanceof INumberScalar) {
                    this.addNumberScalarAttribute(jddg, (INumberScalar)att);
                    return;
                }
                if (att instanceof IStringScalar) {
                    this.addStringScalarAttribute(jddg, (IStringScalar)att);
                    return;
                }
                if (att instanceof IEnumScalar) {
                    this.addEnumScalarAttribute(jddg, (IEnumScalar)att);
                    return;
                }
                if (att instanceof INumberSpectrum) {
                    this.addNumberSpectrumAttribute(jddg, (INumberSpectrum)att);
                    return;
                }
                if (att instanceof INumberImage) {
                    this.addNumberImageAttribute(jddg, (INumberImage)att);
                    return;
                }
            }
        }
        catch (ConnectionException connectionexception) {
            System.out.println("Couldn't load device for attribute" + s + " " + connectionexception);
        }
        catch (DevFailed dfEx) {
            System.out.println("Couldn't find the attribute" + s + " " + dfEx);
        }
    }

    private void addSpectrumAttElement(JDObject jdo, String s) {
        String spectrumAttName = null;
        IAttribute att = null;
        int leftBracket = s.lastIndexOf("[");
        if (leftBracket <= 0 || leftBracket >= s.length()) {
            return;
        }
        spectrumAttName = s.substring(0, leftBracket);
        try {
            att = this.aFac.getAttribute(spectrumAttName);
            if (att == null) {
                return;
            }
            if (att instanceof IDevStateSpectrum) {
                this.addStateSpectrumAttributeElement(jdo, (IDevStateSpectrum)att);
                return;
            }
        }
        catch (ConnectionException connectionexception) {
            System.out.println("Couldn't load device for attribute" + spectrumAttName + " " + connectionexception);
        }
        catch (DevFailed dfEx) {
            System.out.println("Couldn't find the attribute" + spectrumAttName + " " + dfEx);
        }
    }

    public void numberScalarChange(NumberScalarEvent evt) {
        double value = evt.getValue();
        INumberScalar ins = null;
        ins = evt.getNumberSource();
        String s = ins.getName();
        if (ins != null) {
            List<JDObject> list = this.jdHash.get(s);
            if (list == null) {
                return;
            }
            int nbJdObjs = list.size();
            for (int i = 0; i < nbJdObjs; ++i) {
                JDSlider slider;
                JDObject jdObj = null;
                jdObj = list.get(i);
                if (jdObj == null) continue;
                if (jdObj.isProgrammed()) {
                    int jdValue = 0;
                    if (!Double.isNaN(value)) {
                        jdValue = (int)Math.rint(value);
                    }
                    if (jdObj.getValue() != jdValue) {
                        jdObj.preRefresh();
                        jdObj.setValue(jdValue);
                        jdObj.refresh();
                    }
                }
                if (jdObj instanceof JDBar) {
                    JDBar bar = (JDBar)jdObj;
                    if (bar.getBarValue() == value) continue;
                    bar.setBarValue(value);
                    jdObj.refresh();
                    continue;
                }
                if (!(jdObj instanceof JDSlider) || (slider = (JDSlider)jdObj).getSliderValue() == value) continue;
                jdObj.preRefresh();
                ((JDSlider)jdObj).setSliderValue(value);
                jdObj.refresh();
            }
        }
    }

    public void enumScalarChange(EnumScalarEvent evt) {
        IEnumScalar ies = (IEnumScalar)evt.getSource();
        String s = ies.getName();
        List<JDObject> list = this.jdHash.get(s);
        if (list == null) {
            return;
        }
        short enumVal = ies.getShortValueFromEnumScalar(evt.getValue());
        int nbJdObjs = list.size();
        for (int i = 0; i < nbJdObjs; ++i) {
            JDObject jdObj = null;
            jdObj = list.get(i);
            if (jdObj == null || !jdObj.isProgrammed()) continue;
            jdObj.preRefresh();
            jdObj.setValue(enumVal);
            jdObj.refresh();
        }
    }

    public void booleanScalarChange(BooleanScalarEvent evt) {
        IBooleanScalar boolAtt = (IBooleanScalar)evt.getSource();
        boolean newValue = evt.getValue();
        String attName = boolAtt.getName();
        List<JDObject> jdobjList = this.jdHash.get(attName);
        if (jdobjList == null) {
            return;
        }
        if (jdobjList.isEmpty()) {
            return;
        }
        for (JDObject jdobj : jdobjList) {
            if (!jdobj.isProgrammed()) continue;
            if (newValue) {
                jdobj.setValue(1);
            } else {
                jdobj.setValue(0);
            }
            jdobj.refresh();
        }
    }

    public void devStateSpectrumChange(DevStateSpectrumEvent evt) {
        String[] newStates = evt.getValue();
        IDevStateSpectrum att = (IDevStateSpectrum)evt.getSource();
        if (newStates == null) {
            this.setAllStateElements(att, "UNKNOWN");
        } else if (newStates.length == 0) {
            this.setAllStateElements(att, "UNKNOWN");
        } else {
            this.updateAllStateElements(att, newStates);
        }
    }

    private void setAllStateElements(IDevStateSpectrum att, String newState) {
        Set<String> synopticKeySet = this.jdHash.keySet();
        if (synopticKeySet.isEmpty()) {
            return;
        }
        String attName = att.getName().toLowerCase();
        for (String synopticKey : synopticKeySet) {
            if (!synopticKey.startsWith(attName)) continue;
            List<JDObject> jdobjList = this.jdHash.get(synopticKey);
            int elemIndex = this.getIndexFromName(synopticKey);
            for (JDObject jdobj : jdobjList) {
                this.manageStateSpectrumElementChange(jdobj, elemIndex, att, newState);
            }
        }
    }

    private void updateAllStateElements(IDevStateSpectrum att, String[] newStates) {
        Set<String> synopticKeySet = this.jdHash.keySet();
        if (synopticKeySet.isEmpty()) {
            return;
        }
        String attName = att.getName().toLowerCase();
        for (String synopticKey : synopticKeySet) {
            if (!synopticKey.startsWith(attName)) continue;
            int elemIndex = this.getIndexFromName(synopticKey);
            String newElemState = elemIndex < 0 || elemIndex >= newStates.length ? "UNKNOWN" : newStates[elemIndex];
            List<JDObject> jdobjList = this.jdHash.get(synopticKey);
            for (JDObject jdobj : jdobjList) {
                this.manageStateSpectrumElementChange(jdobj, elemIndex, att, newElemState);
            }
        }
    }

    private void manageStateSpectrumElementChange(JDObject jdo, int elemIndex, IDevStateSpectrum att, String newState) {
        if (jdo.isProgrammed()) {
            jdo.setValue(this.getDynoState(newState));
            jdo.refresh();
        } else {
            this.changeJDobjColor(jdo, ATKConstant.getColor4State(newState, att.getInvertedOpenCloseForElement(elemIndex), att.getInvertedInsertExtractForElement(elemIndex)));
        }
    }

    public void stateChange(AttributeStateEvent evt) {
        String quality = evt.getState();
        IAttribute iatt = null;
        iatt = (IAttribute)evt.getSource();
        String s = iatt.getName();
        if (iatt != null) {
            List<JDObject> list = this.jdHash.get(s);
            if (list == null) {
                return;
            }
            int nbJdObjs = list.size();
            for (int i = 0; i < nbJdObjs; ++i) {
                String qfString;
                JDObject jdObj = null;
                jdObj = list.get(i);
                if (jdObj instanceof JDBar || jdObj instanceof JDSlider || jdObj.hasBackgroundMapper() || jdObj.hasForegroundMapper() || !jdObj.hasExtendedParam("qualityFactor") || !Boolean.valueOf(qfString = jdObj.getExtendedParam("qualityFactor")).booleanValue()) continue;
                this.changeJDobjColourForQuality(jdObj, quality);
                return;
            }
        }
    }

    public void errorChange(ErrorEvent event) {
        ICommand src;
        Object source = event.getSource();
        if (source instanceof IDevStateScalar) {
            IDevStateScalar src2 = (IDevStateScalar)event.getSource();
            String state = "UNKNOWN";
            this.manageStateChange(src2.getName(), state, source);
            return;
        }
        if (source instanceof INumberScalar) {
            NumberScalarEvent e = new NumberScalarEvent((INumberScalar)source, Double.NaN, event.getTimeStamp());
            this.numberScalarChange(e);
            return;
        }
        if (source instanceof IEnumScalar) {
            EnumScalarEvent e = new EnumScalarEvent((IEnumScalar)source, "UNKNOWN", event.getTimeStamp());
            this.enumScalarChange(e);
            return;
        }
        if (source instanceof ICommand) {
            src = (ICommand)source;
            ErrorPane.showErrorMessage((Component)this, src.getName(), (ATKException)event.getError());
        }
        if (source instanceof IBooleanScalar) {
            src = (IBooleanScalar)event.getSource();
            String attName = src.getName();
            List<JDObject> jdobjList = this.jdHash.get(attName);
            if (jdobjList == null) {
                return;
            }
            if (jdobjList.isEmpty()) {
                return;
            }
            for (JDObject jdobj : jdobjList) {
                if (!jdobj.isProgrammed()) continue;
                jdobj.setValue(-1);
                jdobj.refresh();
            }
            return;
        }
        if (source instanceof IDevStateSpectrum) {
            src = (IDevStateSpectrum)event.getSource();
            this.setAllStateElements((IDevStateSpectrum)src, "UNKNOWN");
            return;
        }
    }

    public void refreshDisabled(Color disabledColor) {
        for (int i = 0; i < this.getObjectNumber(); ++i) {
            JDObject jdObj = this.getObjectAt(i);
            if (!jdObj.isDisabled()) {
                String objName = jdObj.getName();
                List<String> stateStatusCash = this.stateCashHash.get(objName.toLowerCase());
                if (stateStatusCash == null) continue;
                try {
                    String stateCash = stateStatusCash.get(0);
                    if (stateCash == null) continue;
                    this.changeJDobjColor(jdObj, ATKConstant.getColor4State(stateCash));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                continue;
            }
            this.changeJDobjColor(jdObj, disabledColor);
        }
    }

    private void manageStateChange(String entityName, String state, Object sourceEntity) {
        List<JDObject> list;
        List<String> stateStatusCash = null;
        stateStatusCash = this.stateCashHash.get(entityName.toLowerCase());
        if (stateStatusCash != null) {
            String stateCash = null;
            try {
                stateCash = stateStatusCash.get(0);
                if (stateCash != null && stateCash.equals(state)) {
                    return;
                }
                stateCash = new String(state);
                stateStatusCash.set(0, stateCash);
                this.stateCashHash.put(entityName.toLowerCase(), stateStatusCash);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if ((list = this.jdHash.get(entityName)) == null) {
            return;
        }
        int nbJdObjs = list.size();
        for (int i = 0; i < nbJdObjs; ++i) {
            JDObject jdObj = list.get(i);
            if (jdObj.isDisabled()) continue;
            if (jdObj.isProgrammed()) {
                jdObj.setValue(this.getDynoState(state));
                jdObj.refresh();
                continue;
            }
            if (sourceEntity instanceof IDevice) {
                IDevice dev = (IDevice)sourceEntity;
                this.changeJDobjColor(jdObj, ATKConstant.getColor4State(state, dev.getInvertedOpenClose(), dev.getInvertedInsertExtract()));
                continue;
            }
            if (sourceEntity instanceof IDevStateScalar) {
                IDevStateScalar stateAtt = (IDevStateScalar)sourceEntity;
                this.changeJDobjColor(jdObj, ATKConstant.getColor4State(state, stateAtt.getInvertedOpenClose(), stateAtt.getInvertedInsertExtract()));
                continue;
            }
            this.changeJDobjColor(jdObj, ATKConstant.getColor4State(state));
        }
    }

    public void devStateScalarChange(DevStateScalarEvent event) {
        IDevStateScalar src = (IDevStateScalar)event.getSource();
        String state = event.getValue();
        this.manageStateChange(src.getName(), state, src);
    }

    public void stateChange(StateEvent event) {
        Device device = (Device)event.getSource();
        String state = event.getState();
        this.manageStateChange(device.getName(), state, device);
    }

    private void changeJDobjColor(JDObject jdo, Color stateColor) {
        if (jdo instanceof JDGroup) {
            this.changeJDgroupColor(jdo, stateColor);
            return;
        }
        if (jdo.getFillStyle() == 0) {
            jdo.setForeground(stateColor);
        } else {
            jdo.setBackground(stateColor);
        }
        jdo.refresh();
    }

    private void changeJDgroupColor(JDObject jdo, Color stateColor) {
        JDGroup jdg = null;
        int nbChild = 0;
        JDObject currChild = null;
        if (!(jdo instanceof JDGroup)) {
            return;
        }
        if (jdo.getName().equalsIgnoreCase("IgnoreRepaint")) {
            return;
        }
        jdg = (JDGroup)jdo;
        nbChild = jdg.getChildrenNumber();
        for (int idx = 0; idx < nbChild; ++idx) {
            currChild = jdg.getChildAt(idx);
            if (currChild == null || currChild.getName().equalsIgnoreCase("IgnoreRepaint")) continue;
            if (currChild instanceof JDGroup) {
                this.changeJDgroupColor(currChild, stateColor);
                continue;
            }
            if (currChild.getFillStyle() == 0) {
                currChild.setForeground(stateColor);
            } else {
                currChild.setBackground(stateColor);
            }
            currChild.refresh();
        }
    }

    private void changeJDobjColourForQuality(JDObject jdo, String quality) {
        if (jdo instanceof JDGroup) {
            this.changeJDgroupForQuality(jdo, quality);
            return;
        }
        if (jdo.getFillStyle() == 0) {
            jdo.setForeground(ATKConstant.getColor4Quality(quality));
        } else {
            jdo.setBackground(ATKConstant.getColor4Quality(quality));
        }
        jdo.refresh();
    }

    private void changeJDgroupForQuality(JDObject jdo, String quality) {
        JDGroup jdg = null;
        int nbChild = 0;
        JDObject currChild = null;
        if (!(jdo instanceof JDGroup)) {
            return;
        }
        if (jdo.getName().equalsIgnoreCase("IgnoreRepaint")) {
            return;
        }
        jdg = (JDGroup)jdo;
        nbChild = jdg.getChildrenNumber();
        for (int idx = 0; idx < nbChild; ++idx) {
            currChild = jdg.getChildAt(idx);
            if (currChild == null || currChild.getName().equalsIgnoreCase("IgnoreRepaint")) continue;
            if (currChild instanceof JDGroup) {
                this.changeJDgroupForQuality(currChild, quality);
                continue;
            }
            if (currChild.getFillStyle() == 0) {
                currChild.setForeground(ATKConstant.getColor4Quality(quality));
            } else {
                currChild.setBackground(ATKConstant.getColor4Quality(quality));
            }
            currChild.refresh();
        }
    }

    public void statusChange(StatusEvent event) {
        Device device = (Device)event.getSource();
        String s = device.getName();
        List<String> stateStatusCash = null;
        stateStatusCash = this.stateCashHash.get(s.toLowerCase());
        if (stateStatusCash != null) {
            String statusCash = null;
            try {
                statusCash = stateStatusCash.get(1);
                if (statusCash != null && statusCash.equals(event.getStatus())) {
                    return;
                }
                statusCash = new String(event.getStatus());
                stateStatusCash.set(1, statusCash);
                this.stateCashHash.put(s.toLowerCase(), stateStatusCash);
            }
            catch (IndexOutOfBoundsException iob) {
                return;
            }
        }
    }

    private int getDynoState(String deviceState) {
        Integer intObj = dynoState.get(deviceState);
        return intObj;
    }

    private void devDisplayToolTip(JDMouseEvent e) {
        List<String> stateStatusCash = null;
        String stateCash = null;
        if (this.toolTipMode == 0) {
            this.setToolTipText(null);
            return;
        }
        if (this.toolTipMode == 3) {
            JDObject jdObj = (JDObject)e.getSource();
            String devName = jdObj.getName();
            this.setToolTipText(devName);
            return;
        }
        if (this.toolTipMode == 1) {
            JDObject jdObj = (JDObject)e.getSource();
            String devName = jdObj.getName();
            stateStatusCash = this.stateCashHash.get(devName.toLowerCase());
            if (stateStatusCash == null) {
                this.setToolTipText(null);
                return;
            }
            try {
                stateCash = stateStatusCash.get(0);
                if (stateCash == null) {
                    this.setToolTipText(null);
                    return;
                }
                this.setToolTipText(stateCash);
                return;
            }
            catch (IndexOutOfBoundsException iob) {
                this.setToolTipText(null);
                return;
            }
        }
        this.setToolTipText(null);
    }

    private void devRemoveToolTip() {
        this.setToolTipText(null);
    }

    private void attDisplayToolTip(JDMouseEvent e) {
        if (this.toolTipMode != 3) {
            this.setToolTipText(null);
            return;
        }
        JDObject jdObj = (JDObject)e.getSource();
        String attName = jdObj.getName();
        this.setToolTipText(attName);
    }

    private void attRemoveToolTip() {
        this.setToolTipText(null);
    }

    private void stateSpectrumElementClicked(JDMouseEvent evt) {
        JDObject comp = (JDObject)evt.getSource();
        String attElemName = comp.getName().toLowerCase();
        this.launchPanel(comp, attElemName, false);
    }

    private void stateSpectrumElementDisplayToolTip(JDMouseEvent e, IDevStateSpectrum att, int elemIndex) {
        String[] stateLabels = null;
        if (this.toolTipMode != 3) {
            this.setToolTipText(null);
            return;
        }
        JDObject jdObj = (JDObject)e.getSource();
        if (elemIndex < 0) {
            this.setToolTipText(jdObj.getName());
            return;
        }
        stateLabels = att.getStateLabels();
        if (stateLabels == null || elemIndex >= stateLabels.length) {
            this.setToolTipText(jdObj.getName());
            return;
        }
        this.setToolTipText(stateLabels[elemIndex]);
    }

    private void stateSpectrumElementRemoveToolTip() {
        this.setToolTipText(null);
    }

    private int getIndexFromName(String elemName) {
        int index = -1;
        int leftBracket = elemName.lastIndexOf("[");
        int rightBracket = elemName.lastIndexOf("]");
        if (leftBracket < 0 || leftBracket >= elemName.length()) {
            return -1;
        }
        if (rightBracket < 0 || rightBracket >= elemName.length()) {
            return -1;
        }
        if (leftBracket >= rightBracket) {
            return -1;
        }
        String indexNumber = elemName.substring(leftBracket + 1, rightBracket);
        try {
            index = Integer.parseInt(indexNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return index;
    }

    public static void main(String[] args) {
        TangoSynopticHandler tsh = null;
        try {
            tsh = new TangoSynopticHandler("/users/poncet/JDRAW_FILES/sy_klyst.jdw", 3);
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Prog Aborted.");
            System.exit(-1);
        }
        JFrame jf = new JFrame();
        jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        jf.setContentPane(tsh);
        jf.pack();
        jf.setVisible(true);
    }

    static {
        dynoState.put("ON", new Integer(0));
        dynoState.put("OFF", new Integer(1));
        dynoState.put("CLOSE", new Integer(2));
        dynoState.put("OPEN", new Integer(3));
        dynoState.put("INSERT", new Integer(4));
        dynoState.put("EXTRACT", new Integer(5));
        dynoState.put("MOVING", new Integer(6));
        dynoState.put("STANDBY", new Integer(7));
        dynoState.put("FAULT", new Integer(8));
        dynoState.put("INIT", new Integer(9));
        dynoState.put("RUNNING", new Integer(10));
        dynoState.put("ALARM", new Integer(11));
        dynoState.put("DISABLE", new Integer(12));
        dynoState.put("UNKNOWN", new Integer(13));
    }
}

