/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.properties;

import fr.esrf.tangoatk.core.DeviceProperty;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

class DevicePropertyListTableModel
extends DefaultTableModel {
    private DeviceProperty[] rows;
    private String[] columnsNames = new String[this.getColumnCount()];
    private static final int NO_SORT = 0;
    private static final int SORT_UP = 1;
    private static final int SORT_DOWN = 2;
    private int idSort = 0;

    public DeviceProperty getContextAtRow(int rowIndex) {
        if (this.rows != null) {
            return this.rows[rowIndex];
        }
        return null;
    }

    public DevicePropertyListTableModel(String title1, String title2) {
        this.columnsNames[0] = title1;
        this.columnsNames[1] = title2;
        this.rows = new DeviceProperty[0];
    }

    public void apply() {
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i].store();
        }
    }

    public void reset() {
        int firstRemoved = 0;
        int lastRemoved = this.rows.length - 1;
        this.rows = null;
        this.fireTableRowsDeleted(firstRemoved, lastRemoved);
    }

    public void removeRows(int[] indexesToRemove) {
        int i;
        int numberOfLinesToRemove = indexesToRemove.length;
        DeviceProperty[] newRows = new DeviceProperty[this.rows.length - numberOfLinesToRemove];
        Vector<Integer> idsToRemoveList = new Vector<Integer>(numberOfLinesToRemove);
        for (int i2 = 0; i2 < numberOfLinesToRemove; ++i2) {
            int idOfLineToRemove = indexesToRemove[i2];
            idsToRemoveList.add(new Integer(idOfLineToRemove));
        }
        int j = 0;
        for (i = 0; i < this.rows.length; ++i) {
            Integer idOfCurrentLine = new Integer(i);
            if (idsToRemoveList.contains(idOfCurrentLine)) continue;
            newRows[j] = this.rows[i];
            ++j;
        }
        this.rows = newRows;
        for (i = 0; i < numberOfLinesToRemove; ++i) {
            this.fireTableRowsDeleted(indexesToRemove[i], indexesToRemove[i]);
        }
    }

    public void setRows(DeviceProperty[] _rows) {
        this.rows = _rows;
        this.fireTableRowsInserted(0, _rows.length - 1);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String value = null;
        switch (columnIndex) {
            case 0: {
                value = this.rows[rowIndex].getName();
                break;
            }
            case 1: {
                value = this.rows[rowIndex].getStringValue();
                break;
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        switch (column) {
            case 0: {
                return;
            }
            case 1: {
                this.rows[row].setValue((String)aValue);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnsNames[columnIndex];
    }

    public void setColumnName(int columnIndex, String columnName) {
        if (columnIndex < this.getColumnCount()) {
            this.columnsNames[columnIndex] = columnName;
        }
    }
}

