/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.properties;

import fr.esrf.tangoatk.core.Property;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.Caret;

class PropertyListAdapter
implements PropertyChangeListener {
    JPanel valuePanel;
    JPanel namePanel;
    Map properties;
    Map valueMap;
    Map fieldMap;
    List keys;
    protected GridBagConstraints constraints = new GridBagConstraints();
    boolean editable;

    PropertyListAdapter() {
    }

    protected void gbAdd(JPanel parent, JComponent c, int x, int y) {
        this.constraints.anchor = 18;
        this.constraints.gridx = x;
        this.constraints.gridy = y;
        this.constraints.fill = 2;
        this.constraints.weightx = 0.1;
        parent.add((Component)c, this.constraints);
        this.constraints.gridy = y + 1;
        parent.add((Component)new JSeparator(), this.constraints);
    }

    public void setModel(Map model, JPanel valuePanel, JPanel namePanel) {
        this.valuePanel = valuePanel;
        this.namePanel = namePanel;
        valuePanel.removeAll();
        namePanel.removeAll();
        this.valueMap = new HashMap();
        this.fieldMap = new HashMap();
        this.properties = model;
        this.keys = new Vector();
        this.keys.addAll(model.keySet());
        Iterator it = this.keys.iterator();
        int i = 0;
        while (it.hasNext()) {
            String s = (String)it.next();
            JLabel name = new JLabel(s);
            name.setFont(namePanel.getFont());
            Property property = (Property)model.get(s);
            property.addPresentationListener((PropertyChangeListener)this);
            JTextField value = new JTextField(property.getPresentation());
            this.valueMap.put(value, property);
            this.fieldMap.put(property, value);
            value.setBorder(BorderFactory.createEmptyBorder());
            value.setBackground(valuePanel.getBackground());
            value.setDisabledTextColor(valuePanel.getForeground());
            if (property.isEditable() && this.isEditable()) {
                value.setEnabled(false);
                value.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        JTextField source = (JTextField)evt.getSource();
                        source.setEnabled(true);
                        Caret c = source.getCaret();
                        c.setDot(source.getText().length());
                        source.setCaret(c);
                        source.setBackground(Color.white);
                    }
                });
                value.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        PropertyListAdapter.this.inputKeyPressed(evt);
                    }
                });
            } else {
                value.setEditable(false);
            }
            this.gbAdd(namePanel, name, 0, i);
            this.gbAdd(valuePanel, value, 0, i);
            i += 2;
        }
    }

    void store() {
        for (Property p : this.fieldMap.keySet()) {
            if (!p.isEditable()) continue;
            JTextField field = (JTextField)this.fieldMap.get(p);
            this.done(field);
            p.setValue((Object)field.getText());
            p.store();
        }
    }

    void cancel() {
        for (Property p : this.fieldMap.keySet()) {
            if (!p.isEditable()) continue;
            JTextField field = (JTextField)this.fieldMap.get(p);
            field.setText(p.getPresentation());
            this.done(field);
        }
    }

    public void inputKeyPressed(KeyEvent evt) {
        JTextField src = (JTextField)evt.getComponent();
        if (evt.getKeyCode() == 27) {
            Property model = (Property)this.valueMap.get(src);
            src.setText(model.getPresentation());
            this.done(src);
            return;
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean v) {
        this.editable = v;
    }

    public void done(JTextField textField) {
        Caret c = textField.getCaret();
        c.setVisible(false);
        textField.setCaret(c);
        textField.setEnabled(false);
        textField.setBackground(this.valuePanel.getBackground());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Property src = (Property)evt.getSource();
        JTextField field = (JTextField)this.fieldMap.get(src);
        if (field == null) {
            return;
        }
        field.setText(evt.getNewValue().toString());
    }
}

