/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.util.ATKField;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.XORCaret;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.PlainDocument;

public class ATKNumberField
extends ATKField {
    protected boolean wheelSwitchEnabled = true;
    protected INumberScalar model;
    protected Color bg;
    protected boolean insertOK = false;

    public void setText(Number d) {
        if (this.userFormat != null) {
            this.insertOK = true;
            super.setText(this.userFormat.format(d));
            this.insertOK = false;
            return;
        }
        if (this.format.indexOf(37) == -1) {
            super.setText(AttrManip.format((String)this.format, (double)d.doubleValue()));
            return;
        }
        super.setText(ATKFormat.format(this.format, d.doubleValue()));
    }

    public void setValue(Number d) {
        if (this.isEditable() && this.receivedEvent) {
            return;
        }
        this.receivedEvent = true;
        int dot = this.getCaret().getDot();
        this.setText(d);
        this.getCaret().setDot(dot);
    }

    public Number getValue() {
        return new Double(this.getText());
    }

    public void setModel(INumberScalar m) {
        this.model = m;
        this.receivedEvent = false;
        this.modelEditable = this.model.isWritable();
        super.setEditable(this.editable && this.modelEditable);
        Number number = this.model.getNumber();
        if (number == null) {
            return;
        }
        this.init();
        this.setValue(number);
    }

    private void init() {
        this.setText(this.error);
        this.bg = this.getBackground();
        this.setHorizontalAlignment(4);
        if (!this.isEditable()) {
            return;
        }
        this.setCaret(new XORCaret());
        Keymap parent = this.getKeymap();
        Keymap map = ATKNumberField.addKeymap("wheelmap", parent);
        KeyStroke up = KeyStroke.getKeyStroke(38, 0, false);
        KeyStroke down = KeyStroke.getKeyStroke(40, 0, false);
        KeyStroke left = KeyStroke.getKeyStroke(37, 0, false);
        KeyStroke right = KeyStroke.getKeyStroke(39, 0, false);
        KeyStroke toggleWheelSwitch = KeyStroke.getKeyStroke(87, 2, false);
        map.addActionForKeyStroke(up, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ATKNumberField.this.upStroke(e);
            }
        });
        map.addActionForKeyStroke(down, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ATKNumberField.this.downStroke(e);
            }
        });
        map.addActionForKeyStroke(left, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ATKNumberField.this.leftStroke(e);
            }
        });
        map.addActionForKeyStroke(right, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ATKNumberField.this.rightStroke(e);
            }
        });
        map.addActionForKeyStroke(toggleWheelSwitch, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ATKNumberField.this.setWheelSwitchEnabled(!ATKNumberField.this.isWheelSwitchEnabled());
            }
        });
        this.setKeymap(map);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ATKNumberField.this.getCaret().paint(ATKNumberField.this.getGraphics());
            }
        });
    }

    @Override
    protected void enter(ActionEvent e) {
        this.inserting = false;
        this.newValue(this.getValue());
    }

    protected void newValue(Number d) {
        try {
            this.model.setNumber(d);
        }
        catch (IllegalArgumentException ex) {
            this.setText(this.model.getNumber());
        }
    }

    public void setWheelSwitchEnabled(boolean b) {
        this.wheelSwitchEnabled = b;
        if (b) {
            this.setToolTipText("Wheel switch enabled, use arrow up or arrow down to adjust the values");
        } else {
            this.setToolTipText("Wheel switch disabled, press C-w to enable");
        }
    }

    public boolean isWheelSwitchEnabled() {
        return this.wheelSwitchEnabled;
    }

    protected double getFactor() {
        int i = this.getCaret().getDot();
        int comma = this.getText().indexOf(46);
        if (comma == i) {
            return 0.0;
        }
        int sign = this.getText().indexOf(45);
        if (sign == i) {
            return 0.0;
        }
        sign = this.getText().indexOf(43);
        if (sign == i) {
            return 0.0;
        }
        i = comma == -1 ? this.getText().length() - i : comma - i;
        if (i > 0) {
            --i;
        }
        return Math.pow(10.0, i);
    }

    protected void downStroke(ActionEvent e) {
        if (!this.isWheelSwitchEnabled()) {
            return;
        }
        this.changeValue(-1);
    }

    protected void upStroke(ActionEvent e) {
        if (!this.isWheelSwitchEnabled()) {
            return;
        }
        this.changeValue(1);
    }

    protected void leftStroke(ActionEvent e) {
        this.moveLeft();
    }

    protected void rightStroke(ActionEvent e) {
        this.moveRight();
    }

    protected void moveRight() {
        int dot = this.getCaret().getDot();
        int comma = this.getText().indexOf(46);
        if (comma == ++dot) {
            ++dot;
        }
        if (dot >= this.getText().length()) {
            return;
        }
        this.getCaret().setDot(dot);
    }

    protected void moveLeft() {
        int dot = this.getCaret().getDot();
        int comma = this.getText().indexOf(46);
        if (comma == --dot) {
            --dot;
        }
        if (dot < 0) {
            return;
        }
        this.getCaret().setDot(dot);
    }

    protected void changeValue(int sign) {
        double i = this.getFactor() * (double)sign;
        int dot = this.getCaret().getDot();
        int oldComma = this.getText().indexOf(46);
        this.setText(new Double(Double.parseDouble(this.getText()) + i).toString());
        int newComma = this.getText().indexOf(46);
        dot = dot + newComma - oldComma;
        this.getCaret().setDot(dot);
        this.newValue(this.getValue());
    }

    @Override
    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        ATKNumberField field = new ATKNumberField();
        field.setFont(new Font("Times", 1, 60));
        f.setContentPane(field);
        f.pack();
        f.setVisible(true);
    }

    class NumberDocument
    extends PlainDocument {
        NumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            try {
                if (ATKNumberField.this.insertOK) {
                    super.insertString(0, str, a);
                    return;
                }
                if (str.equals(ATKNumberField.this.error)) {
                    super.insertString(0, str, a);
                    return;
                }
                if (str.equals("-") || str.equals("+")) {
                    this.remove(0, this.getLength());
                    super.insertString(0, str, a);
                    ATKNumberField.this.inserting = true;
                    return;
                }
                if (str.equals(".")) {
                    int comma = ATKNumberField.this.getText().indexOf(".");
                    if (comma != -1) {
                        this.remove(comma, 1);
                        if (comma < offs) {
                            --offs;
                        }
                    }
                    super.insertString(offs, str, a);
                    return;
                }
                Double.parseDouble(str);
                if (ATKNumberField.this.inserting) {
                    super.insertString(offs, str, a);
                } else {
                    ATKNumberField.this.inserting = true;
                    this.remove(0, this.getLength());
                    super.insertString(0, str, a);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

