/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.HelpWindow;
import fr.esrf.tangoatk.widget.util.IApplicable;
import fr.esrf.tangoatk.widget.util.IControlee;
import fr.esrf.tangoatk.widget.util.IHelpful;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ButtonBar
extends JPanel {
    IControlee controlee;
    URL helpUrl;
    private JButton help;
    private JButton ok;
    private JButton cancel;
    private JLabel jLabel1;
    private JButton apply;

    public ButtonBar() {
        this.initComponents();
        this.cancel.setMnemonic(67);
        this.apply.setMnemonic(65);
        this.help.setMnemonic(72);
        this.ok.setMnemonic(79);
    }

    private void initComponents() {
        this.help = new JButton();
        this.ok = new JButton();
        this.cancel = new JButton();
        this.jLabel1 = new JLabel();
        this.apply = new JButton();
        this.setLayout(new GridBagLayout());
        this.help.setText("Help");
        this.help.setEnabled(false);
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonBar.this.helpActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 10, 10, 10);
        gridBagConstraints1.anchor = 16;
        this.add((Component)this.help, gridBagConstraints1);
        this.ok.setText("OK");
        this.ok.setSelected(true);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonBar.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 4;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 2, 10, 10);
        gridBagConstraints1.anchor = 14;
        this.add((Component)this.ok, gridBagConstraints1);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonBar.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(5, 2, 10, 2);
        gridBagConstraints1.anchor = 15;
        this.add((Component)this.cancel, gridBagConstraints1);
        this.jLabel1.setMinimumSize(new Dimension(0, 10));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints1.weightx = 0.1;
        this.add((Component)this.jLabel1, gridBagConstraints1);
        this.apply.setText("Apply");
        this.apply.setEnabled(false);
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonBar.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(5, 2, 10, 2);
        this.add((Component)this.apply, gridBagConstraints1);
    }

    private void applyActionPerformed(ActionEvent evt) {
        ((IApplicable)this.controlee).apply();
    }

    private void helpActionPerformed(ActionEvent evt) {
        if (this.helpUrl != null) {
            HelpWindow.getInstance().showUrl(this.helpUrl);
        }
    }

    private void okActionPerformed(ActionEvent evt) {
        this.controlee.ok();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        ((IApplicable)this.controlee).cancel();
    }

    public void setHelpUrl(URL url) {
        this.helpUrl = url;
        this.help.setEnabled(true);
    }

    public void setControlee(IControlee controlee) {
        this.controlee = controlee;
        this.help.setEnabled(false);
        this.help.setToolTipText("Brings up the helpwindow");
        this.apply.setEnabled(false);
        this.apply.setToolTipText("Sets the values");
        this.cancel.setEnabled(false);
        this.cancel.setToolTipText("Closes this window without setting values");
        if (controlee instanceof IHelpful) {
            this.setHelpUrl(((IHelpful)controlee).getHelpUrl());
        }
        if (controlee instanceof IApplicable) {
            this.apply.setEnabled(true);
            this.cancel.setEnabled(true);
            this.ok.setToolTipText("Sets the values and closes this window");
            this.ok.setText("OK");
            return;
        }
        this.ok.setToolTipText("Closes this window");
        this.ok.setText("Close");
    }

    public JButton getOKButton() {
        return this.ok;
    }

    public JButton getHelpButton() {
        return this.help;
    }

    public JButton getCancelButton() {
        return this.cancel;
    }

    public JButton getApplyButton() {
        return this.apply;
    }
}

