/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class DigitalNumberViewer
extends JComponent {
    private String format = "%5.2f";
    private double value = 0.0;
    private int fontSize = 30;
    private int hOffset = 3;
    private int vOffset = 3;
    private int[] cX = new int[6];
    private int[] cY = new int[6];

    public DigitalNumberViewer() {
        this.setOpaque(true);
        this.setLayout(null);
        this.setBorder(null);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
    }

    public void setFormat(String format) {
        this.format = format;
        this.repaint();
    }

    public String getFormat() {
        return this.format;
    }

    public void setValue(double value) {
        this.value = value;
        this.repaint();
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        this.repaint();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setVerticalOffset(int offset) {
        this.vOffset = offset;
    }

    public void setHorizontalOffset(int offset) {
        this.hOffset = offset;
    }

    @Override
    public Dimension getPreferredSize() {
        String v = this.getFormattedValue();
        int lgth = v.length();
        int pointWidth = 0;
        if (v.indexOf(46) != -1) {
            --lgth;
            pointWidth = 5;
        }
        Insets h = this.getInsets();
        return new Dimension((this.fontSize + 5) * lgth + pointWidth + 2 * this.hOffset + h.left + h.right, this.fontSize * 2 + 2 * this.vOffset + h.top + h.bottom);
    }

    private void drawASegment(Graphics g, int xPos, int yPos) {
        int w = this.fontSize / 6;
        this.cX[0] = xPos + 1;
        this.cX[1] = xPos + this.fontSize - 1;
        this.cX[2] = xPos + this.fontSize - 1 - w;
        this.cX[3] = xPos + w + 1;
        this.cY[0] = yPos;
        this.cY[1] = yPos;
        this.cY[2] = yPos + w;
        this.cY[3] = yPos + w;
        g.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawBSegment(Graphics g, int xPos, int yPos) {
        int w = this.fontSize / 6;
        this.cX[0] = xPos + this.fontSize;
        this.cX[1] = xPos + this.fontSize;
        this.cX[2] = xPos + this.fontSize - w;
        this.cX[3] = xPos + this.fontSize - w;
        this.cY[0] = yPos + 2;
        this.cY[1] = yPos + this.fontSize - 2;
        this.cY[2] = yPos + this.fontSize - 2 - w;
        this.cY[3] = yPos + w + 2;
        g.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawCSegment(Graphics g, int xPos, int yPos) {
        int w = this.fontSize / 6;
        this.cX[0] = xPos + this.fontSize;
        this.cX[1] = xPos + this.fontSize;
        this.cX[2] = xPos + this.fontSize - w;
        this.cX[3] = xPos + this.fontSize - w;
        this.cY[0] = yPos + 2 + this.fontSize;
        this.cY[1] = yPos + 2 * this.fontSize - 2;
        this.cY[2] = yPos + 2 * this.fontSize - 2 - w;
        this.cY[3] = yPos + this.fontSize + w + 2;
        g.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawDSegment(Graphics g, int xPos, int yPos) {
        int w = this.fontSize / 6;
        this.cX[0] = xPos + 1;
        this.cX[1] = xPos + this.fontSize - 1;
        this.cX[2] = xPos + this.fontSize - 1 - w;
        this.cX[3] = xPos + w + 1;
        this.cY[0] = yPos + 2 * this.fontSize;
        this.cY[1] = yPos + 2 * this.fontSize;
        this.cY[2] = yPos + 2 * this.fontSize - w;
        this.cY[3] = yPos + 2 * this.fontSize - w;
        g.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawESegment(Graphics g, int xPos, int yPos) {
        int w = this.fontSize / 6;
        this.cX[0] = xPos;
        this.cX[1] = xPos;
        this.cX[2] = xPos + w;
        this.cX[3] = xPos + w;
        this.cY[0] = yPos + 2 + this.fontSize;
        this.cY[1] = yPos + 2 * this.fontSize - 2;
        this.cY[2] = yPos + 2 * this.fontSize - 2 - w;
        this.cY[3] = yPos + this.fontSize + w + 2;
        g.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawFSegment(Graphics g, int xPos, int yPos) {
        int w = this.fontSize / 6;
        this.cX[0] = xPos;
        this.cX[1] = xPos;
        this.cX[2] = xPos + w;
        this.cX[3] = xPos + w;
        this.cY[0] = yPos + 2;
        this.cY[1] = yPos + this.fontSize - 2;
        this.cY[2] = yPos + this.fontSize - 2 - w;
        this.cY[3] = yPos + w + 2;
        g.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawGSegment(Graphics g, int xPos, int yPos) {
        int w = this.fontSize / 6;
        int o = w / 2;
        this.cX[0] = xPos + o;
        this.cX[1] = xPos + w;
        this.cX[2] = xPos + this.fontSize - w;
        this.cX[3] = xPos + this.fontSize - o;
        this.cX[4] = xPos + this.fontSize - w;
        this.cX[5] = xPos + w;
        this.cY[0] = yPos + this.fontSize;
        this.cY[1] = yPos + this.fontSize - w / 2;
        this.cY[2] = yPos + this.fontSize - w / 2;
        this.cY[3] = yPos + this.fontSize;
        this.cY[4] = yPos + this.fontSize + w / 2 + 1;
        this.cY[5] = yPos + this.fontSize + w / 2 + 1;
        g.fillPolygon(this.cX, this.cY, 6);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
        }
        g.setColor(this.getForeground());
        String v = this.getFormattedValue();
        Insets h = this.getInsets();
        int xPos = h.left + this.hOffset;
        int yPos = h.top + this.vOffset;
        block15: for (int i = 0; i < v.length(); ++i) {
            switch (v.charAt(i)) {
                case '0': {
                    this.drawASegment(g, xPos, yPos);
                    this.drawBSegment(g, xPos, yPos);
                    this.drawCSegment(g, xPos, yPos);
                    this.drawDSegment(g, xPos, yPos);
                    this.drawESegment(g, xPos, yPos);
                    this.drawFSegment(g, xPos, yPos);
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case '1': {
                    this.drawBSegment(g, xPos, yPos);
                    this.drawCSegment(g, xPos, yPos);
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case '2': {
                    this.drawASegment(g, xPos, yPos);
                    this.drawBSegment(g, xPos, yPos);
                    this.drawGSegment(g, xPos, yPos);
                    this.drawESegment(g, xPos, yPos);
                    this.drawDSegment(g, xPos, yPos);
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case '3': {
                    this.drawASegment(g, xPos, yPos);
                    this.drawBSegment(g, xPos, yPos);
                    this.drawGSegment(g, xPos, yPos);
                    this.drawCSegment(g, xPos, yPos);
                    this.drawDSegment(g, xPos, yPos);
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case '4': {
                    this.drawFSegment(g, xPos, yPos);
                    this.drawGSegment(g, xPos, yPos);
                    this.drawBSegment(g, xPos, yPos);
                    this.drawCSegment(g, xPos, yPos);
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case '5': {
                    this.drawASegment(g, xPos, yPos);
                    this.drawFSegment(g, xPos, yPos);
                    this.drawGSegment(g, xPos, yPos);
                    this.drawCSegment(g, xPos, yPos);
                    this.drawDSegment(g, xPos, yPos);
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case '6': {
                    this.drawASegment(g, xPos, yPos);
                    this.drawFSegment(g, xPos, yPos);
                    this.drawGSegment(g, xPos, yPos);
                    this.drawCSegment(g, xPos, yPos);
                    this.drawDSegment(g, xPos, yPos);
                    this.drawESegment(g, xPos, yPos);
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case '7': {
                    this.drawASegment(g, xPos, yPos);
                    this.drawBSegment(g, xPos, yPos);
                    this.drawCSegment(g, xPos, yPos);
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case '8': {
                    this.drawASegment(g, xPos, yPos);
                    this.drawBSegment(g, xPos, yPos);
                    this.drawCSegment(g, xPos, yPos);
                    this.drawDSegment(g, xPos, yPos);
                    this.drawESegment(g, xPos, yPos);
                    this.drawFSegment(g, xPos, yPos);
                    this.drawGSegment(g, xPos, yPos);
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case '9': {
                    this.drawASegment(g, xPos, yPos);
                    this.drawBSegment(g, xPos, yPos);
                    this.drawCSegment(g, xPos, yPos);
                    this.drawDSegment(g, xPos, yPos);
                    this.drawFSegment(g, xPos, yPos);
                    this.drawGSegment(g, xPos, yPos);
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case '-': {
                    this.drawGSegment(g, xPos, yPos);
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case ' ': {
                    xPos += this.fontSize + 5;
                    continue block15;
                }
                case '.': {
                    g.fillRect(xPos, yPos + 2 * this.fontSize - 5, 5, 5);
                    xPos += 8;
                }
            }
        }
    }

    private String getFormattedValue() {
        if (Double.isNaN(this.value)) {
            return "-----";
        }
        return ATKFormat.format(this.format, this.value);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        DigitalNumberViewer d = new DigitalNumberViewer();
        d.setBorder(BorderFactory.createLoweredBevelBorder());
        d.setValue(-Math.PI);
        d.setFormat("%.6f");
        f.setContentPane(d);
        ATKGraphicsUtils.centerFrameOnScreen(f);
        f.setVisible(true);
    }
}

