/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.widget.util.EntityJTableAdapter;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class DropTable
extends JTable {
    private DropTarget dropTarget;
    private DropTargetListener dtListener;
    private int acceptableActions = 1;

    public DropTable() {
        this.dtListener = new DTListener();
        this.dropTarget = new DropTarget(this, this.acceptableActions, this.dtListener, true);
    }

    public DropTable(TableModel tablemodel) {
        super(tablemodel);
        this.dtListener = new DTListener();
        this.dropTarget = new DropTarget(this, this.acceptableActions, this.dtListener, true);
    }

    public DropTable(int i) {
        if (i != 0 && i != 1 && i != 2 && i != 3 && i != 0x40000000) {
            throw new IllegalArgumentException("action" + i);
        }
        this.acceptableActions = i;
        this.dtListener = new DTListener();
        this.dropTarget = new DropTarget(this, this.acceptableActions, this.dtListener, true);
    }

    class DTListener
    implements DropTargetListener {
        private boolean isDragFlavorSupported(DropTargetDragEvent droptargetdragevent) {
            return true;
        }

        private DataFlavor chooseDropFlavor(DropTargetDropEvent droptargetdropevent) {
            DataFlavor dataflavor = DataFlavor.stringFlavor;
            return dataflavor;
        }

        private boolean isDragOk(DropTargetDragEvent droptargetdragevent) {
            if (!this.isDragFlavorSupported(droptargetdragevent)) {
                System.out.println("isDragOk:no flavors chosen");
                return false;
            }
            int i = droptargetdragevent.getDropAction();
            System.out.print("dt drop action " + i);
            System.out.println(" my acceptable actions " + DropTable.this.acceptableActions);
            return (i & DropTable.this.acceptableActions) != 0;
        }

        @Override
        public void dragEnter(DropTargetDragEvent droptargetdragevent) {
            System.out.println("dtlistener dragEnter");
            if (!this.isDragOk(droptargetdragevent)) {
                System.out.println("enter not ok");
                droptargetdragevent.rejectDrag();
                return;
            }
            System.out.println("dt enter: accepting " + droptargetdragevent.getDropAction());
            droptargetdragevent.acceptDrag(droptargetdragevent.getDropAction());
        }

        @Override
        public void dragOver(DropTargetDragEvent droptargetdragevent) {
            if (!this.isDragOk(droptargetdragevent)) {
                System.out.println("dtlistener dragOver not ok");
                droptargetdragevent.rejectDrag();
                return;
            }
            System.out.println("dt over: accepting");
            droptargetdragevent.acceptDrag(droptargetdragevent.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent droptargetdragevent) {
            if (!this.isDragOk(droptargetdragevent)) {
                System.out.println("dtlistener changed not ok");
                droptargetdragevent.rejectDrag();
                return;
            }
            System.out.println("dt changed: accepting" + droptargetdragevent.getDropAction());
            droptargetdragevent.acceptDrag(droptargetdragevent.getDropAction());
        }

        @Override
        public void dragExit(DropTargetEvent droptargetevent) {
            System.out.println("dtlistener dragExit");
        }

        @Override
        public void drop(DropTargetDropEvent droptargetdropevent) {
            System.out.println("dtlistener drop");
            DataFlavor dataflavor = this.chooseDropFlavor(droptargetdropevent);
            if (dataflavor == null) {
                System.err.println("No flavor match found");
                droptargetdropevent.rejectDrop();
                return;
            }
            System.err.println("Chosen data flavor is " + dataflavor.getMimeType());
            int i = droptargetdropevent.getDropAction();
            int j = droptargetdropevent.getSourceActions();
            System.out.println("drop: sourceActions: " + j);
            System.out.println("drop: dropAction: " + i);
            if ((j & DropTable.this.acceptableActions) == 0) {
                System.err.println("No action match found");
                droptargetdropevent.rejectDrop();
                return;
            }
            Object obj = null;
            try {
                droptargetdropevent.acceptDrop(DropTable.this.acceptableActions);
                obj = droptargetdropevent.getTransferable().getTransferData(dataflavor);
                if (obj == null) {
                    throw new NullPointerException();
                }
            }
            catch (Throwable throwable) {
                System.err.println("Couldn't get transfer data: " + throwable.getMessage());
                throwable.printStackTrace();
                droptargetdropevent.dropComplete(false);
                return;
            }
            System.out.println("Got data: " + obj.getClass().getName());
            if (!(obj instanceof IEntity)) {
                System.out.println("drop: rejecting");
                droptargetdropevent.dropComplete(false);
                return;
            }
            IEntity ientity = (IEntity)obj;
            ((EntityJTableAdapter)DropTable.this.getModel()).addEntity(ientity);
            System.out.println("got " + ientity);
            droptargetdropevent.dropComplete(true);
        }

        DTListener() {
        }
    }
}

