/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.TableRowModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JOptionPane;

public class EditableTableRowModel
extends TableRowModel {
    public EditableTableRowModel() {
        this.editable = true;
        this.data = new Object[0][0];
        this.colName = new String[2];
        this.colName[0] = "Index";
    }

    @Override
    public void setEditable(boolean b) {
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.editable || this.data == null) {
            return;
        }
        if (columnIndex < 1) {
            return;
        }
        this.data[rowIndex][columnIndex] = aValue;
        if (rowIndex == this.data.length - 1) {
            Object[][] tmp = new Object[this.data.length + 1][2];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            double lastIndex = this.data.length;
            tmp[this.data.length][0] = Double.toString(lastIndex);
            tmp[this.data.length][1] = null;
            this.data = tmp;
            this.fireTableRowsInserted(tmp.length - 1, tmp.length - 1);
        }
    }

    public void setAttributeColumnName(String attName) {
        this.colName[1] = attName;
    }

    void loadDataFile(File dataFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(dataFile));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "IO Error. Failed to load file: " + dataFile.getAbsolutePath(), "Error", 0);
            return;
        }
        this.readTabbedDataLines(dataFile.getAbsolutePath(), reader);
    }

    private void readTabbedDataLines(String fileName, BufferedReader dataReader) {
        String line = null;
        try {
            line = dataReader.readLine();
            if (line == null) {
                throw new Exception();
            }
            if ("".equals(line.trim())) {
                throw new Exception();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Failed to load file: " + fileName + "\nNo title line.", "Error", 0);
            return;
        }
        String[] parsedTitleLine = line.split("\t");
        if (parsedTitleLine == null || parsedTitleLine.length != this.getColumnCount()) {
            JOptionPane.showMessageDialog(null, "Failed to load file: " + fileName + "\nColumn count error.", "Error", 0);
            return;
        }
        Vector<String[]> tableDataVector = new Vector<String[]>();
        while (true) {
            int i;
            String[] lineData;
            String[] parsedLine;
            try {
                line = dataReader.readLine();
            }
            catch (IOException ex) {
                break;
            }
            if (line == null) break;
            if ("".equals(line.trim()) || (parsedLine = line.split("\t")).length != (lineData = new String[parsedTitleLine.length]).length) continue;
            try {
                double index = Double.parseDouble(parsedLine[0].trim());
                lineData[0] = parsedLine[0].trim();
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            for (i = 1; i < parsedLine.length; ++i) {
                try {
                    double cellData = Double.parseDouble(parsedLine[i].trim());
                    lineData[i] = parsedLine[i].trim();
                }
                catch (NumberFormatException nfe) {
                    if (parsedLine[i].trim().equalsIgnoreCase("null")) {
                        lineData[i] = "NaN";
                        continue;
                    }
                    if (!parsedLine[i].trim().equalsIgnoreCase("NaN")) break;
                    lineData[i] = "NaN";
                }
            }
            if (i < parsedLine.length) continue;
            tableDataVector.add(lineData);
        }
        if (tableDataVector.isEmpty()) {
            JOptionPane.showMessageDialog(null, "Failed to load file: " + fileName + "\nRead error occured on one of the lines.", "Error", 0);
            return;
        }
        Object[][] temp_data = new Object[tableDataVector.size()][parsedTitleLine.length];
        for (int i = 0; i < tableDataVector.size(); ++i) {
            String[] lineValue = (String[])tableDataVector.get(i);
            for (int j = 0; j < lineValue.length; ++j) {
                temp_data[i][j] = lineValue[j];
            }
        }
        this.data = temp_data;
        this.fireTableRowsInserted(0, this.data.length - 1);
    }

    public double[] parseNumberSpectrumData() {
        if (this.getColumnCount() != 2) {
            return null;
        }
        if (this.data == null) {
            return null;
        }
        if (this.data.length == 0) {
            return null;
        }
        if (this.data[0].length != this.getColumnCount()) {
            return null;
        }
        Vector<Double> numberSpectrumDataVector = new Vector<Double>();
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].length < 2) continue;
            if (this.data[i][1] == null) {
                if (i >= this.data.length - 1) continue;
                numberSpectrumDataVector.add(new Double(Double.NaN));
                continue;
            }
            if (!(this.data[i][1] instanceof String)) continue;
            String cellStr = (String)this.data[i][1];
            try {
                double cellData = Double.parseDouble(cellStr.trim());
                numberSpectrumDataVector.add(new Double(cellStr.trim()));
                continue;
            }
            catch (NumberFormatException nfe) {
                if (!cellStr.trim().equalsIgnoreCase("null") && !cellStr.trim().equalsIgnoreCase("NaN")) continue;
                numberSpectrumDataVector.add(new Double(Double.NaN));
            }
        }
        if (numberSpectrumDataVector.isEmpty()) {
            return null;
        }
        double[] result = new double[numberSpectrumDataVector.size()];
        for (int i = 0; i < numberSpectrumDataVector.size(); ++i) {
            result[i] = (Double)numberSpectrumDataVector.get(i);
        }
        return result;
    }

    void removeOneRow(int rowIndex) {
        Object[][] temp_data = new Object[this.data.length - 1][2];
        if (rowIndex == 0) {
            System.arraycopy(this.data, 1, temp_data, 0, this.data.length - 1);
        } else if (rowIndex == this.data.length - 1) {
            System.arraycopy(this.data, 0, temp_data, 0, this.data.length - 1);
        } else {
            System.arraycopy(this.data, 0, temp_data, 0, rowIndex);
            System.arraycopy(this.data, rowIndex + 1, temp_data, rowIndex, this.data.length - rowIndex - 1);
        }
        this.data = temp_data;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][0] = Double.toString(i);
        }
    }
}

