/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.ErrorTree;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

class ErrorDialog
extends JDialog {
    JScrollPane simpleErrorView;
    JTextArea simpleError;
    JPanel simpleErrorPanel;
    JPanel buttonPanel;
    JButton okButton;
    JButton moreButton;
    JLabel iconLabel;
    ATKException theError;
    JTabbedPane tabPanel;
    ErrorTree stackPanel;
    JScrollPane stackView;
    JTextArea stackTraceText;
    JScrollPane stackTraceView;
    String deviceName;
    boolean showDetails = false;

    ErrorDialog(Frame parent, ATKException e, String title, String devName) {
        super(parent, title, true);
        this.theError = e;
        this.deviceName = devName;
        this.initComponents();
    }

    ErrorDialog(Dialog parent, ATKException e, String title, String devName) {
        super(parent, title, true);
        this.theError = e;
        this.deviceName = devName;
        this.initComponents();
    }

    private void fillInStackTrace() {
        StackTraceElement[] st = this.theError.getStackTrace();
        StringBuffer str = new StringBuffer();
        str.append(this.theError.getSourceName() + "\n at\n");
        for (int i = 0; i < st.length; ++i) {
            str.append(st[i]);
            str.append('\n');
        }
        this.stackTraceText.setText(str.toString());
    }

    private void maxSizeComponent(JComponent comp, int maxWidth, int maxHeight) {
        Dimension d = comp.getSize();
        boolean dChange = false;
        if (d.width > maxWidth) {
            d.width = maxWidth;
            dChange = true;
        }
        if (d.height > maxHeight) {
            d.height = maxHeight;
            dChange = true;
        }
        if (dChange) {
            comp.setPreferredSize(d);
        }
    }

    private void showDetails() {
        this.moreButton.setText("Hide...");
        this.showDetails = true;
        this.tabPanel.setVisible(true);
        this.pack();
        this.maxSizeComponent(this.simpleErrorView, 800, 600);
        this.maxSizeComponent(this.stackTraceView, 800, 400);
        if (this.theError.getStackLength() > 0) {
            this.maxSizeComponent(this.stackView, 800, 400);
        }
        ATKGraphicsUtils.centerDialog(this);
    }

    private void hideDetails() {
        this.moreButton.setText("Details...");
        this.showDetails = false;
        this.tabPanel.setVisible(false);
        this.pack();
        this.maxSizeComponent(this.simpleErrorView, 800, 600);
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        this.okButton = new JButton("Ok");
        this.moreButton = new JButton("Details...");
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ErrorDialog.this.showDetails) {
                    ErrorDialog.this.showDetails();
                } else {
                    ErrorDialog.this.hideDetails();
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.dispose();
                ErrorDialog.this.setVisible(false);
            }
        });
        this.simpleError = new JTextArea();
        this.simpleError.setEditable(false);
        this.simpleError.setBackground(contentPane.getBackground());
        this.simpleError.setFont(this.okButton.getFont());
        this.simpleErrorView = new JScrollPane(this.simpleError);
        this.simpleErrorView.setBorder(null);
        if (this.deviceName != null && this.deviceName.length() > 0) {
            this.simpleError.setText(this.deviceName + " :\n" + this.theError.getDescription());
        } else {
            this.simpleError.setText(this.theError.getDescription());
        }
        this.simpleErrorPanel = new JPanel();
        this.simpleErrorPanel.setLayout(new GridBagLayout());
        this.iconLabel = new JLabel(new ImageIcon(ErrorPane.errorImage));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.top = 12;
        gbc.insets.bottom = 12;
        gbc.insets.left = 10;
        gbc.insets.right = 10;
        this.simpleErrorPanel.add((Component)this.iconLabel, gbc);
        gbc.fill = 1;
        gbc.insets.top = 2;
        gbc.insets.bottom = 2;
        gbc.insets.left = 2;
        gbc.insets.right = 10;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 10;
        this.simpleErrorPanel.add((Component)this.simpleErrorView, gbc);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.setPreferredSize(new Dimension(260, 40));
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.moreButton);
        if (this.theError.getStackLength() > 0) {
            this.stackPanel = new ErrorTree();
            this.stackPanel.addErrors(this.theError.getErrors());
            this.stackView = new JScrollPane(this.stackPanel);
            this.stackView.setBorder(BorderFactory.createEtchedBorder());
        }
        this.stackTraceText = new JTextArea();
        this.stackTraceText.setEditable(false);
        this.stackTraceView = new JScrollPane(this.stackTraceText);
        this.stackTraceView.setBorder(BorderFactory.createEtchedBorder());
        this.tabPanel = new JTabbedPane();
        if (this.theError.getStackLength() > 0) {
            this.tabPanel.add("Error", this.stackView);
        }
        this.tabPanel.add("Trace", this.stackTraceView);
        gbc.fill = 1;
        gbc.insets.top = 0;
        gbc.insets.bottom = 0;
        gbc.insets.left = 0;
        gbc.insets.right = 0;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        contentPane.add((Component)this.simpleErrorPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        contentPane.add((Component)this.tabPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weighty = 0.0;
        contentPane.add((Component)this.buttonPanel, gbc);
        this.fillInStackTrace();
        this.tabPanel.setVisible(false);
        this.pack();
        this.maxSizeComponent(this.simpleErrorView, 800, 600);
        this.maxSizeComponent(this.stackTraceView, 800, 400);
        if (this.theError.getStackLength() > 0) {
            this.maxSizeComponent(this.stackView, 800, 400);
        }
    }
}

