/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ButtonBar;
import fr.esrf.tangoatk.widget.util.ErrorPanel;
import fr.esrf.tangoatk.widget.util.IControlee;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;

public class ErrorHistory
extends JFrame
implements IErrorListener,
ISetErrorListener,
IControlee {
    ErrorPanel panel = new ErrorPanel();
    boolean errorPopupEnabled = true;

    public ErrorHistory() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.getContentPane().add((Component)this.panel, constraints);
        ButtonBar b = new ButtonBar();
        b.setControlee(this);
        constraints.weighty = 0.0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        this.getContentPane().add((Component)b, constraints);
        this.setTitle("Tango error manager");
        this.setErrorBufferSize(300);
        this.pack();
    }

    @Override
    public void ok() {
        this.setVisible(false);
    }

    public void errorChange(ErrorEvent evt) {
        this.panel.errorChange(evt);
    }

    public void setErrorOccured(ErrorEvent evt) {
        this.panel.setErrorOccured(evt);
    }

    public void setErrorPopupEnabled(boolean v) {
        this.errorPopupEnabled = v;
    }

    public void setErrorBufferSize(int nbErrors) {
        this.panel.setErrorBufferSize(nbErrors);
    }

    public static void main(String[] args) throws Exception {
        ErrorHistory hist = new ErrorHistory();
        AttributeList list = new AttributeList();
        list.addErrorListener((IErrorListener)hist);
        try {
            list.add("jlp/test/1/att_un");
            list.add("jlp/test/1/att_float");
        }
        catch (Exception exception) {
            // empty catch block
        }
        list.startRefresher();
        ATKGraphicsUtils.centerFrameOnScreen(hist);
        hist.setDefaultCloseOperation(3);
        hist.setVisible(true);
    }
}

