/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorAdapter;
import fr.esrf.tangoatk.widget.util.ErrorTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;

class ErrorPanel
extends JPanel
implements IErrorListener,
ISetErrorListener {
    private ErrorAdapter errorAdapter = new ErrorAdapter();
    private JPopupMenu popupMenu;
    private JMenuItem showItem;
    private JMenuItem stackItem;
    private JMenuItem stopItem;
    private JMenuItem startItem;
    private JPanel filterPanel;
    private JToggleButton stopButton;
    private JButton clearButton;
    private JCheckBox panicBox;
    private JCheckBox errorBox;
    private JCheckBox warningBox;
    private JComboBox sourceCombo;
    private JComboBox sortCombo;
    private JSplitPane errorSplitPane;
    private JScrollPane tableView;
    private JTable errorTable;
    private JScrollPane errorView;
    private ErrorTree errorTree;
    private JFrame stackFrame;
    private JTextArea stackText;
    private int selectedRow = -1;
    private String selectedSource = null;
    private boolean sourceComboUpdate = false;
    private boolean stopped = false;

    public ErrorPanel() {
        this.initComponents();
        this.errorAdapter.setTimeFormat(new SimpleDateFormat("dd/MMM HH:mm:ss"));
        this.errorAdapter.setErrorPanel(this);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.popupMenu = new JPopupMenu();
        this.showItem = new JMenuItem();
        this.showItem.setText("Show Error");
        this.showItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.showItemActionPerformed();
            }
        });
        this.popupMenu.add(this.showItem);
        this.stackItem = new JMenuItem();
        this.stackItem.setText("Show Java stack");
        this.stackItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.showJavaStackActionPerformed();
            }
        });
        this.popupMenu.add(this.stackItem);
        this.stopItem = new JMenuItem();
        this.stopItem.setText("Stop");
        this.stopItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.stopItemActionPerformed();
            }
        });
        this.popupMenu.add(this.stopItem);
        this.startItem = new JMenuItem();
        this.startItem.setText("Start");
        this.startItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.startItemActionPerformed();
            }
        });
        this.popupMenu.add(this.startItem);
        this.filterPanel = new JPanel();
        FlowLayout fl = new FlowLayout(0);
        this.filterPanel.setLayout(fl);
        this.filterPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Filters", 1, 0, ATKConstant.labelFont, Color.BLACK));
        this.stopButton = new JToggleButton();
        this.stopButton.setText("Stop");
        this.stopButton.setToolTipText("Stops updating");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.stopButtonActionPerformed();
            }
        });
        this.filterPanel.add(this.stopButton);
        this.clearButton = new JButton();
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("Clear errors");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.clearButtonActionPerformed();
            }
        });
        this.filterPanel.add(this.clearButton);
        this.panicBox = new JCheckBox();
        this.panicBox.setFont(ATKConstant.labelFont);
        this.panicBox.setSelected(true);
        this.panicBox.setText("View panic");
        this.panicBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.panicBoxActionPerformed();
            }
        });
        this.filterPanel.add(this.panicBox);
        this.errorBox = new JCheckBox();
        this.errorBox.setFont(ATKConstant.labelFont);
        this.errorBox.setSelected(true);
        this.errorBox.setText("View error");
        this.errorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.errorBoxActionPerformed();
            }
        });
        this.filterPanel.add(this.errorBox);
        this.warningBox = new JCheckBox();
        this.warningBox.setFont(ATKConstant.labelFont);
        this.warningBox.setSelected(true);
        this.warningBox.setText("View warning");
        this.warningBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.warningBoxActionPerformed();
            }
        });
        this.filterPanel.add(this.warningBox);
        JLabel l = new JLabel("  View source");
        l.setFont(ATKConstant.labelFont);
        this.filterPanel.add(l);
        this.sourceCombo = new JComboBox();
        this.sourceCombo.setFont(ATKConstant.labelFont);
        this.sourceCombo.addItem("All");
        this.filterPanel.add(this.sourceCombo);
        this.sourceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.sourceComboActionPerformed();
            }
        });
        l = new JLabel("  Sort by");
        l.setFont(ATKConstant.labelFont);
        this.filterPanel.add(l);
        this.sortCombo = new JComboBox();
        this.sortCombo.setFont(ATKConstant.labelFont);
        this.sortCombo.addItem("No sort");
        this.sortCombo.addItem("Time");
        this.sortCombo.addItem("Severity");
        this.sortCombo.addItem("Source");
        this.sortCombo.addItem("Description");
        this.filterPanel.add(this.sortCombo);
        this.sortCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.sortComboActionPerformed();
            }
        });
        this.add((Component)this.filterPanel, "South");
        this.errorTable = new JTable(this.errorAdapter);
        this.errorTable.setPreferredScrollableViewportSize(new Dimension(700, 300));
        this.errorTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ErrorPanel.this.errorTableMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ErrorPanel.this.errorTableMouseReleased(evt);
            }
        });
        this.errorTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                ErrorPanel.this.errorTableColumnClicked(e.getFromIndex());
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.tableView = new JScrollPane(this.errorTable);
        this.tableView.setVerticalScrollBarPolicy(22);
        this.errorTree = new ErrorTree();
        this.errorView = new JScrollPane(this.errorTree);
        this.errorView.setPreferredSize(new Dimension(230, 300));
        this.errorSplitPane = new JSplitPane(1);
        this.errorSplitPane.add(this.tableView);
        this.errorSplitPane.add(this.errorView);
        this.errorSplitPane.setDividerSize(4);
        this.add((Component)this.errorSplitPane, "Center");
        this.stackText = new JTextArea();
        JScrollPane jp = new JScrollPane(this.stackText);
        this.stackFrame = new JFrame("Java Stack View");
        this.stackFrame.setContentPane(jp);
        this.sizeColumns();
    }

    private void sortComboActionPerformed() {
        int s = this.sortCombo.getSelectedIndex();
        this.errorAdapter.setSortedColumn(s - 1);
    }

    private void sourceComboActionPerformed() {
        if (!this.sourceComboUpdate) {
            int s = this.sourceCombo.getSelectedIndex();
            this.selectedSource = s >= 1 ? this.sourceCombo.getSelectedItem().toString() : null;
            this.errorAdapter.setSourceFilter(this.selectedSource);
        }
    }

    private void panicBoxActionPerformed() {
        this.errorAdapter.showPanic(this.panicBox.isSelected());
    }

    private void errorBoxActionPerformed() {
        this.errorAdapter.showError(this.errorBox.isSelected());
    }

    private void warningBoxActionPerformed() {
        this.errorAdapter.showWarning(this.warningBox.isSelected());
    }

    private void clearButtonActionPerformed() {
        this.errorAdapter.clearError();
    }

    private void stopButtonActionPerformed() {
        this.stopped = this.stopButton.getText().equals("Stop");
        if (this.stopped) {
            this.stopButton.setText("Resume");
            this.stopButton.setToolTipText("Restarts updating");
        } else {
            this.stopButton.setText("Stop");
            this.stopButton.setToolTipText("Stops updating");
        }
    }

    private void showItemActionPerformed() {
        this.errorTree.addErrors(this.errorAdapter.getErrorNumber(this.selectedRow));
        this.selectedRow = -1;
    }

    private void showJavaStackActionPerformed() {
        Throwable theError = this.errorAdapter.getErrorAt(this.selectedRow);
        StackTraceElement[] st = theError.getStackTrace();
        StringBuffer str = new StringBuffer();
        str.append(theError.getClass() + "\n at\n");
        for (int i = 0; i < st.length; ++i) {
            str.append(st[i]);
            str.append('\n');
        }
        this.stackText.setText(str.toString());
        ATKGraphicsUtils.centerFrameOnScreen(this.stackFrame);
        this.stackFrame.setVisible(true);
    }

    private void stopItemActionPerformed() {
        this.stopped = true;
        this.stopButton.setText("Resume");
        this.stopButton.setToolTipText("Restarts updating");
    }

    private void startItemActionPerformed() {
        this.stopped = false;
        this.stopButton.setText("Stop");
        this.stopButton.setToolTipText("Stops updating");
    }

    private void errorTableColumnClicked(int column) {
        this.sortCombo.setSelectedIndex(column + 1);
    }

    private void errorTableMouseClicked(MouseEvent mouseevent) {
        this.selectedRow = this.errorTable.getSelectedRow();
        if (this.selectedRow != -1 && mouseevent.isPopupTrigger()) {
            this.popupMenu.show(mouseevent.getComponent(), mouseevent.getX(), mouseevent.getY());
        }
    }

    private void errorTableMouseReleased(MouseEvent evt) {
        this.errorTableMouseClicked(evt);
    }

    private void errorTableMousePressed(MouseEvent evt) {
        this.errorTableMouseClicked(evt);
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (this.stopped) {
            return;
        }
        this.errorAdapter.addError(errorEvent);
    }

    public void setErrorOccured(ErrorEvent errorEvent) {
        if (this.stopped) {
            return;
        }
        this.errorAdapter.addError(errorEvent);
    }

    public void setErrorBufferSize(int nbErrors) {
        this.errorAdapter.setErrorBufferSize(nbErrors);
    }

    public void sourceChange() {
        int idx = -1;
        this.sourceComboUpdate = true;
        Vector src = this.errorAdapter.getAllSource();
        this.sourceCombo.removeAllItems();
        this.sourceCombo.addItem("All");
        for (int i = 0; i < src.size(); ++i) {
            if (this.selectedSource != null && this.selectedSource.equalsIgnoreCase((String)src.get(i))) {
                idx = i;
            }
            this.sourceCombo.addItem(src.get(i));
        }
        if (idx == -1) {
            this.selectedSource = null;
            this.errorAdapter.setSourceFilter(this.selectedSource);
        }
        this.sourceCombo.setSelectedIndex(idx + 1);
        this.sourceComboUpdate = false;
    }

    private void sizeColumns() {
        this.errorTable.getColumnModel().getColumn(0).setMaxWidth(140);
        this.errorTable.getColumnModel().getColumn(0).setMinWidth(110);
        this.errorTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.errorTable.getColumnModel().getColumn(2).setMinWidth(150);
        this.errorTable.getColumnModel().getColumn(3).setMinWidth(200);
    }
}

