/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevError;
import fr.esrf.tangoatk.core.ATKException;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class ErrorTree
extends JPanel {
    DefaultMutableTreeNode top = new DefaultMutableTreeNode("Stack");
    private JTree errorTree;

    private void initComponents() {
        this.errorTree = new JTree(this.top);
        this.setLayout(new BorderLayout());
        this.add(this.errorTree);
    }

    void populateErrorNode(DefaultMutableTreeNode node, ErrorNode errornode) {
        DevError deverror = errornode.getError();
        node.add(new DefaultMutableTreeNode("Severity - " + ATKException.severity[deverror.severity.value()]));
        node.add(new DefaultMutableTreeNode("Origin - " + deverror.origin));
        node.add(new DefaultMutableTreeNode("Description - " + deverror.desc));
        node.add(new DefaultMutableTreeNode("Reason - " + deverror.reason));
    }

    public void addError(DevError deverror) {
        ErrorNode errornode = new ErrorNode(deverror);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(errornode);
        this.top.add(node);
        this.populateErrorNode(node, errornode);
    }

    public void addErrors(DevError[] adeverror) {
        this.remove(this.errorTree);
        this.top = new DefaultMutableTreeNode("Stack");
        this.initComponents();
        this.errorTree.setRootVisible(true);
        for (int i = 0; i < adeverror.length; ++i) {
            this.addError(adeverror[i]);
        }
        for (int j = 0; j < this.errorTree.getRowCount(); ++j) {
            this.errorTree.expandRow(j);
        }
    }

    public ErrorTree() {
        this.initComponents();
        this.errorTree.setRootVisible(false);
    }

    class ErrorNode {
        DevError error;

        public DevError getError() {
            return this.error;
        }

        public String toString() {
            return this.error.reason.trim();
        }

        ErrorNode(DevError deverror) {
            this.error = deverror;
        }
    }
}

