/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FileContentViewer
extends JPanel
implements PropertyChangeListener {
    private int width;
    private int height;
    private File theFile = null;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;

    public FileContentViewer(int w, int h) {
        this.width = w;
        this.height = h;
        this.initComponents();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private boolean useProbeContentType() {
        String typeStr;
        try {
            typeStr = Files.probeContentType(this.theFile.toPath());
            typeStr = typeStr == null ? "???" : typeStr.toLowerCase();
            if (this.theFile.getName().endsWith(".ts")) {
                typeStr = "text";
            }
        }
        catch (IOException ex) {
            return false;
        }
        if (typeStr.contains("text/plain")) {
            return true;
        }
        if (typeStr.contains("application/x-shellscript")) {
            return true;
        }
        if (typeStr.contains("text/vnd.trolltech.linguist")) {
            return true;
        }
        return typeStr.contains("text");
    }

    private boolean isTextFile() {
        if (this.theFile == null) {
            return false;
        }
        if (!this.theFile.isFile()) {
            return false;
        }
        boolean isText = this.useProbeContentType();
        return isText;
    }

    private void previewTextFile() {
        this.jTextArea1.setText(" ");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.theFile));
        }
        catch (FileNotFoundException ex) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            line = br.readLine();
            while (line != null) {
                if (line.length() > 6000) {
                    line = line.substring(0, 6000);
                }
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            this.jTextArea1.setText(sb.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void previewFile() {
        if (!this.isTextFile()) {
            this.jTextArea1.setText(" ");
            this.repaint();
            return;
        }
        this.previewTextFile();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.theFile = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.theFile = (File)e.getNewValue();
            update = true;
        }
        if (update && this.isShowing()) {
            this.previewFile();
            this.repaint();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jf = new JFrame();
                jf.setVisible(true);
                JFileChooser jfc = new JFileChooser("/users/poncet");
                FileContentViewer fcv = new FileContentViewer(500, 250);
                jfc.addPropertyChangeListener(fcv);
                jfc.setAccessory(fcv);
                jfc.showOpenDialog(jf.getContentPane());
            }
        });
    }
}

