/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Color;

public class Gradient {
    private Color[] colorVal = null;
    private double[] colorPos = null;

    public Gradient() {
        this.colorVal = new Color[2];
        this.colorPos = new double[2];
        this.colorVal[0] = new Color(0, 0, 0);
        this.colorVal[1] = new Color(255, 255, 255);
        this.colorPos[0] = 0.0;
        this.colorPos[1] = 1.0;
    }

    public Gradient(double[] pos, Color[] colors) {
        this.colorVal = colors;
        this.colorPos = pos;
    }

    public void buidColorGradient() {
        this.buildRainbowGradient();
    }

    public void buildRainbowGradient() {
        this.colorVal = new Color[5];
        this.colorPos = new double[5];
        this.colorVal[0] = new Color(200, 0, 250);
        this.colorVal[1] = new Color(40, 40, 255);
        this.colorVal[2] = new Color(40, 255, 40);
        this.colorVal[3] = new Color(250, 250, 0);
        this.colorVal[4] = new Color(255, 0, 0);
        this.colorPos[0] = 0.0;
        this.colorPos[1] = 0.25;
        this.colorPos[2] = 0.5;
        this.colorPos[3] = 0.75;
        this.colorPos[4] = 1.0;
    }

    public void invertGradient() {
        Color[] nColorVal = new Color[this.colorVal.length];
        for (int i = 0; i < this.colorVal.length; ++i) {
            nColorVal[i] = this.colorVal[this.colorVal.length - i - 1];
        }
        System.arraycopy(nColorVal, 0, this.colorVal, 0, this.colorVal.length);
    }

    public Gradient cloneMe() {
        Gradient nG = new Gradient();
        nG.colorPos = new double[this.getEntryNumber()];
        nG.colorVal = new Color[this.getEntryNumber()];
        for (int i = 0; i < this.getEntryNumber(); ++i) {
            nG.colorPos[i] = this.colorPos[i];
            nG.colorVal[i] = new Color(this.colorVal[i].getRGB());
        }
        return nG;
    }

    public int[] buildColorMap(int nb) {
        if (this.colorVal == null) {
            return null;
        }
        if (this.colorVal.length <= 1) {
            return null;
        }
        int colId = 0;
        int[] ret = new int[nb];
        for (int i = 0; i < nb; ++i) {
            double r = (double)i / (double)nb;
            if (colId < this.colorPos.length - 2 && r >= this.colorPos[colId + 1]) {
                ++colId;
            }
            double r1 = this.colorVal[colId].getRed();
            double g1 = this.colorVal[colId].getGreen();
            double b1 = this.colorVal[colId].getBlue();
            double r2 = this.colorVal[colId + 1].getRed();
            double g2 = this.colorVal[colId + 1].getGreen();
            double b2 = this.colorVal[colId + 1].getBlue();
            double rr = (r - this.colorPos[colId]) / (this.colorPos[colId + 1] - this.colorPos[colId]);
            if (rr < 0.0) {
                rr = 0.0;
            }
            if (rr > 1.0) {
                rr = 1.0;
            }
            ret[i] = (int)(r1 + (r2 - r1) * rr) * 65536 + (int)(g1 + (g2 - g1) * rr) * 256 + (int)(b1 + (b2 - b1) * rr);
        }
        return ret;
    }

    public int getEntryNumber() {
        return this.colorVal.length;
    }

    public Color getColorAt(int id) {
        return this.colorVal[id];
    }

    public double getPosAt(int id) {
        return this.colorPos[id];
    }

    public void setColorAt(int id, Color c) {
        if (id >= 0 && id < this.colorVal.length) {
            this.colorVal[id] = c;
        }
    }

    public void setPosAt(int id, double pos) {
        if (id > 0 && id < this.colorVal.length - 1 && pos >= 0.0 && pos <= 1.0) {
            if (id == 0) {
                if (pos < this.colorPos[id + 1]) {
                    this.colorPos[id] = pos;
                }
            } else if (id == this.colorVal.length - 1) {
                if (pos > this.colorPos[id - 1]) {
                    this.colorPos[id] = pos;
                }
            } else if (pos < this.colorPos[id + 1] && pos > this.colorPos[id - 1]) {
                this.colorPos[id] = pos;
            }
        }
    }

    public int addEntry(Color c, double pos) {
        if (pos <= 0.0 || pos >= 1.0) {
            return -1;
        }
        boolean found = false;
        int i = 0;
        while (i < this.colorPos.length && !found) {
            found = pos < this.colorPos[i];
            if (found) continue;
            ++i;
        }
        if (found) {
            if (Math.abs(this.colorPos[i] - pos) < 0.01) {
                return -1;
            }
            Color[] oldColor = this.colorVal;
            double[] oldPos = this.colorPos;
            this.colorVal = new Color[this.colorPos.length + 1];
            this.colorPos = new double[this.colorVal.length];
            System.arraycopy(oldColor, 0, this.colorVal, 0, i);
            System.arraycopy(oldPos, 0, this.colorPos, 0, i);
            this.colorVal[i] = c;
            this.colorPos[i] = pos;
            System.arraycopy(oldColor, i, this.colorVal, i + 1, oldColor.length - i);
            System.arraycopy(oldPos, i, this.colorPos, i + 1, oldColor.length - i);
            return i;
        }
        return -1;
    }

    public void removeEntry(int id) {
        if (id > 0 && id < this.colorVal.length - 1) {
            Color[] oldColor = this.colorVal;
            double[] oldPos = this.colorPos;
            this.colorVal = new Color[this.colorPos.length - 1];
            this.colorPos = new double[this.colorVal.length];
            System.arraycopy(oldColor, 0, this.colorVal, 0, id);
            System.arraycopy(oldColor, id + 1, this.colorVal, id, oldColor.length - id - 1);
            System.arraycopy(oldPos, 0, this.colorPos, 0, id);
            System.arraycopy(oldPos, id + 1, this.colorPos, id, oldPos.length - id - 1);
        }
    }
}

