/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ButtonBar;
import fr.esrf.tangoatk.widget.util.IControlee;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HelpWindow
extends JFrame
implements IControlee {
    protected static HelpWindow instance;
    JSplitPane mainSplit;
    JTree topics;
    JEditorPane htmlView;
    HelpNode top;
    Map nodes;
    JButton back;
    JButton forward;
    List views;
    JTextField location;
    boolean noHistory = false;
    int currentView = 0;
    ButtonBar bb;

    protected HelpWindow() {
        this.initComponents();
    }

    @Override
    public void ok() {
        this.setVisible(false);
    }

    public static HelpWindow getInstance() {
        if (instance == null) {
            instance = new HelpWindow();
        }
        return instance;
    }

    protected void initComponents() {
        this.bb = new ButtonBar();
        this.top = new HelpNode();
        this.nodes = new HashMap();
        this.views = new Vector();
        JLabel label = new JLabel("Location: ");
        this.back = new JButton();
        this.forward = new JButton();
        this.location = new JTextField();
        this.location.setEditable(false);
        this.location.setBackground(Color.white);
        this.htmlView = new JEditorPane();
        this.setTitle("Help");
        this.bb.setControlee(this);
        this.htmlView.setEditable(false);
        this.back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpWindow.this.goBack();
            }
        });
        this.forward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpWindow.this.goForward();
            }
        });
        this.back.setToolTipText("Back");
        this.back.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/Back16.gif")));
        this.forward.setToolTipText("Forward");
        this.forward.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/Forward16.gif")));
        this.htmlView.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                        HTMLDocument doc = (HTMLDocument)HelpWindow.this.htmlView.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(evt);
                    } else {
                        try {
                            HelpWindow.this.showUrl(e.getURL());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }
        });
        this.topics = new JTree(this.top);
        this.topics.getSelectionModel().setSelectionMode(1);
        this.topics.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)HelpWindow.this.topics.getLastSelectedPathComponent();
                if (n == null || !(n instanceof HelpNode)) {
                    return;
                }
                HelpNode node = (HelpNode)n;
                HelpWindow.this.showPage(node.getUrl());
                if (HelpWindow.this.noHistory) {
                    HelpWindow.this.noHistory = false;
                    return;
                }
                HelpWindow.this.views.add(node);
                ++HelpWindow.this.currentView;
            }
        });
        JScrollPane treeScroll = new JScrollPane(this.topics);
        JScrollPane htmlScroll = new JScrollPane(this.htmlView);
        this.mainSplit = new JSplitPane(1, treeScroll, htmlScroll);
        this.mainSplit.setDividerSize(9);
        this.mainSplit.setOneTouchExpandable(true);
        this.mainSplit.setDividerLocation(150);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        constraints.insets = new Insets(10, 10, 5, 0);
        this.getContentPane().add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(10, 0, 5, 0);
        this.getContentPane().add((Component)this.location, constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        constraints.insets = new Insets(10, 0, 5, 0);
        this.getContentPane().add((Component)this.back, constraints);
        constraints.gridx = 3;
        constraints.insets = new Insets(10, 0, 5, 10);
        this.getContentPane().add((Component)this.forward, constraints);
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 10, 0, 10);
        constraints.gridwidth = 0;
        treeScroll.setPreferredSize(new Dimension(150, 50));
        htmlScroll.setPreferredSize(new Dimension(400, 300));
        this.getContentPane().add((Component)this.mainSplit, constraints);
        constraints.weighty = 0.0;
        constraints.gridy = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.bb, constraints);
        this.pack();
    }

    public void showUrl(URL url) {
        HelpNode node;
        String urlName = url.toString();
        this.showPage(url);
        int index = urlName.indexOf(35);
        if (index != -1) {
            try {
                url = new URL(urlName.substring(0, index));
            }
            catch (MalformedURLException e) {
                System.out.println("Can't display url: " + e.getMessage());
            }
        }
        if ((node = (HelpNode)this.nodes.get(url)) == null) {
            return;
        }
        this.topics.setSelectionPath(new TreePath(node.getPath()));
        this.showHelpWindow();
    }

    public void goBack() {
        if (this.views.size() > 1 && this.currentView > 0) {
            this.noHistory = true;
            this.showNode((HelpNode)this.views.get(--this.currentView));
        }
    }

    public void goForward() {
        if (this.currentView < this.views.size() - 1) {
            this.noHistory = true;
            this.showNode((HelpNode)this.views.get(++this.currentView));
        }
    }

    protected void showPage(URL url) {
        try {
            this.htmlView.setPage(url);
            this.location.setText(url.toString());
        }
        catch (IOException e) {
            System.out.println("Can't display url: " + e.getMessage());
        }
    }

    public void showNode(HelpNode node) {
        this.topics.setSelectionPath(new TreePath(node.getPath()));
        this.showPage(node.getUrl());
    }

    public void addCategory(String category, String name, URL url) {
        CategoryNode node = null;
        Enumeration<TreeNode> i = this.top.children();
        boolean found = false;
        while (i.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)i.nextElement();
            if (n instanceof HelpNode || !(node = (CategoryNode)n).getCategory().equals(category)) continue;
            found = true;
            break;
        }
        if (!found) {
            node = new CategoryNode(category, name, url);
            this.top.add(node);
        } else {
            if (this.nodes.containsKey(url)) {
                return;
            }
            node.add(name, url);
        }
        this.pack();
    }

    public void setTop(String name, URL url) {
        this.top.setName(name);
        this.top.setUrl(url);
        this.nodes.put(url, this.top);
        this.views.add(this.top);
        this.showPage(url);
    }

    public void addTop(String name, URL url) {
        HelpNode node = null;
        node = new HelpNode(name, url);
        this.top.add(node);
        this.pack();
    }

    public void showHelpWindow() {
        this.topics.expandRow(0);
        super.setVisible(true);
    }

    public static void main(String[] args) throws Exception {
        HelpWindow.getInstance().setTop("Urk", new URL("http://www.dagbladet.no"));
        HelpWindow.getInstance().addTop("first", new URL("http://www.skiinfo.no"));
        HelpWindow.getInstance().addCategory("Skiinfo", "second", new URL("http://www.skiinfo.no"));
        HelpWindow.getInstance().showHelpWindow();
    }

    class HelpNode
    extends DefaultMutableTreeNode {
        String name;
        URL url;

        public HelpNode() {
        }

        public HelpNode(String name, URL url) {
            this.name = name;
            this.url = url;
            HelpWindow.this.nodes.put(url, this);
        }

        @Override
        public String toString() {
            return this.name;
        }

        public URL getUrl() {
            return this.url;
        }

        public void setUrl(URL url) {
            this.url = url;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    class CategoryNode
    extends DefaultMutableTreeNode {
        String category;

        public CategoryNode(String category, String name, URL url) {
            this.category = category;
            this.add(name, url);
        }

        public String getCategory() {
            return this.category;
        }

        @Override
        public String toString() {
            return this.category;
        }

        public void add(String name, URL url) {
            this.add(new HelpNode(name, url));
        }
    }
}

