/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.ScrollRun;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;

public class JAutoScrolledText
extends JTextField {
    public static int CENTER_ALIGNMENT = 1;
    public static int LEFT_ALIGNMENT = 2;
    public static int RIGHT_ALIGNMENT = 3;
    public static int CLASSIC_BEHAVIOR = 2;
    public static int MATRIX_BEHAVIOR = 1;
    public static final int SCROLL_TO_SEE_END = 0;
    public static final int SCROLL_LOOP = 1;
    private int maxPos = 0;
    private boolean scrollNeeded = false;
    private boolean lastScroll = false;
    private String text;
    private int off_x = 0;
    private int off_y = 0;
    private int align;
    private int sizingBehavior;
    private Insets margin;
    private int scrollingMode = 0;
    int sleepTime = 0;
    boolean endFlag;
    boolean stopDemand;
    int currentPos = 0;
    int waitTime = 2000;
    EventListenerList listenerList;

    public JAutoScrolledText() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.align = CENTER_ALIGNMENT;
        this.stopDemand = false;
        this.endFlag = false;
        this.text = "";
        this.margin = new Insets(2, 3, 2, 3);
        this.sizingBehavior = CLASSIC_BEHAVIOR;
        this.listenerList = new EventListenerList();
    }

    @Override
    public void setMargin(Insets i) {
        this.margin = i;
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    public void setWaitTime(int ms) {
        this.waitTime = ms;
    }

    public void setSizingBehavior(int s) {
        this.sizingBehavior = s;
    }

    public int getSizingBehavior() {
        return this.sizingBehavior;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.sizingBehavior == MATRIX_BEHAVIOR) {
            return super.getPreferredSize();
        }
        Dimension d = ATKGraphicsUtils.measureString(this.text, this.getFont());
        d.width += this.margin.right + this.margin.left;
        d.height += this.margin.top + this.margin.bottom;
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setAutoScroll(int time) {
        this.sleepTime = time;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    @Override
    public void setText(String txt) {
        this.text = txt == null ? "" : txt;
        this.currentPos = 0;
        this.repaint();
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setVerticalOffset(int y) {
        this.off_y = y;
        this.repaint();
    }

    public int getVerticalOffset() {
        return this.off_y;
    }

    public void setHorizontalOffset(int y) {
        this.off_x = y;
        this.repaint();
    }

    public int getHorizontalOffset() {
        return this.off_x;
    }

    public void setValueOffsets(int x, int y) {
        System.out.println("JAutoScrolledText.setValueOffsets() is deprecated and has no effects.");
    }

    @Override
    public void setHorizontalAlignment(int a) {
        this.align = a;
    }

    void scrollText() throws InterruptedException {
        if (this.scrollNeeded) {
            ++this.currentPos;
            if (this.currentPos > this.maxPos) {
                this.repaint();
                Thread.sleep(this.waitTime);
                this.currentPos = this.scrollingMode == 0 ? 0 : -this.getWidth();
                this.endFlag = true;
            }
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
        }
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D bounds = g.getFont().getStringBounds(this.text, frc);
        int tempMax = (int)(bounds.getWidth() - (double)(w - (this.margin.left + this.margin.right)));
        this.maxPos = this.scrollingMode == 0 ? tempMax : (int)bounds.getWidth();
        double a = this.getFont().getLineMetrics(this.text, frc).getAscent();
        int y = (int)(((double)h - bounds.getHeight()) / 2.0 + a);
        boolean bl = this.scrollNeeded = tempMax > 0;
        if (this.scrollNeeded) {
            this.fireExceedBounds();
        }
        if (this.lastScroll != this.scrollNeeded && this.sleepTime != 0) {
            if (this.scrollNeeded) {
                this.currentPos = 0;
                this.stopDemand = false;
                this.endFlag = true;
                ScrollRun p = new ScrollRun(this);
                new Thread(p).start();
            } else {
                this.stopDemand = true;
            }
        }
        this.lastScroll = this.scrollNeeded;
        if (this.scrollNeeded) {
            g.drawString(this.text, this.margin.left + this.off_x - this.currentPos, this.off_y + y);
        } else {
            int xpos = 0;
            switch (this.align) {
                case 1: {
                    xpos = (int)(((double)w - bounds.getWidth()) / 2.0);
                    break;
                }
                case 2: {
                    xpos = this.margin.left;
                    break;
                }
                case 3: {
                    xpos = (int)((double)w - bounds.getWidth() - (double)this.margin.right);
                }
            }
            g.drawString(this.text, xpos, this.off_y + y);
        }
        this.paintBorder(g);
    }

    public void addTextListener(JAutoScrolledTextListener l) {
        this.listenerList.add(JAutoScrolledTextListener.class, l);
    }

    public void removeTextListener(JAutoScrolledTextListener l) {
        this.listenerList.remove(JAutoScrolledTextListener.class, l);
    }

    private void fireExceedBounds() {
        if (this.listenerList.getListenerCount() > 0) {
            JAutoScrolledTextListener[] list = (JAutoScrolledTextListener[])this.listenerList.getListeners(JAutoScrolledTextListener.class);
            for (int i = 0; i < list.length; ++i) {
                list[i].textExceedBounds(this);
            }
        }
    }

    public int getScrollingMode() {
        return this.scrollingMode;
    }

    public void setScrollingMode(int scrollingMode) {
        this.scrollingMode = scrollingMode;
    }

    public static void main(String[] args) throws Exception {
        JFrame f = new JFrame();
        JAutoScrolledText txt = new JAutoScrolledText();
        txt.setText("Test JAutoScrolledText , with autoscrolling....");
        txt.setAutoScroll(30);
        txt.setFont(new Font("Dialog", 1, 30));
        f.setContentPane(txt);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

