/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class JGradientViewer
extends JComponent {
    private Gradient gradient;
    private int[] colorMap;
    private JLAxis axis;
    private int barWidth = 20;

    public JGradientViewer() {
        this.setLayout(null);
        this.setBorder(null);
        this.setOpaque(true);
        this.gradient = new Gradient();
        this.colorMap = this.gradient.buildColorMap(256);
        this.axis = new JLAxis(this, 5);
        this.axis.setAutoScale(false);
        this.axis.setAnnotation(2);
        this.axis.setMinimum(0.0);
        this.axis.setMaximum(100.0);
    }

    public Gradient getGradient() {
        return this.gradient;
    }

    public void setGradient(Gradient gradient) {
        this.gradient = gradient;
        this.colorMap = this.gradient.buildColorMap(256);
    }

    public JLAxis getAxis() {
        return this.axis;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(int barWidth) {
        this.barWidth = barWidth;
    }

    @Override
    public void paint(Graphics g) {
        int bw;
        Dimension d = this.getSize();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
        }
        int startX = 0;
        boolean axisVisible = false;
        if (d.height <= 20 || d.width <= 0) {
            return;
        }
        this.axis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), 0, d.height - 21);
        if (d.width < this.barWidth) {
            bw = d.width;
            startX = 0;
        } else {
            bw = this.barWidth;
            if (d.width < this.barWidth + this.axis.getThickness()) {
                startX = (d.width - this.barWidth) / 2;
            } else {
                startX = (d.width - (this.barWidth + this.axis.getThickness())) / 2;
                axisVisible = true;
            }
        }
        double r = 256.0 / (double)(d.height - 20);
        for (int i = 10; i < d.height - 10; ++i) {
            int id = (int)(r * (double)(i - 10));
            if (id <= 255) {
                g.setColor(new Color(this.colorMap[255 - id]));
            } else {
                g.setColor(new Color(this.colorMap[0]));
            }
            g.drawLine(startX, i, startX + bw, i);
        }
        if (axisVisible) {
            this.axis.paintAxisDirect(g, ATKGraphicsUtils.getDefaultRenderContext(), startX + bw, 10, Color.BLACK, 0, 0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        this.axis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), 0, this.getHeight() - 21);
        return new Dimension(this.axis.getThickness() + this.barWidth + 4, 20);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JGradientViewer gv = new JGradientViewer();
        gv.setPreferredSize(new Dimension(50, 200));
        gv.getAxis().setMinimum(1.0E-9);
        gv.getAxis().setMaximum(1.0E-6);
        gv.getAxis().setScale(1);
        f.setContentPane(gv);
        f.setDefaultCloseOperation(3);
        ATKGraphicsUtils.centerFrameOnScreen(f);
        f.setVisible(true);
    }
}

