/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IResultListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.ResultEvent;
import fr.esrf.tangoatk.core.command.ArrayVoidCommand;
import fr.esrf.tangoatk.core.command.ScalarScalarCommand;
import fr.esrf.tangoatk.core.command.StringVoidCommand;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.FilePreviewWindow;
import fr.esrf.tangoatk.widget.util.LoadSaveFileListener;
import fr.esrf.tangoatk.widget.util.PreviewFileChooser;
import fr.esrf.tangoatk.widget.util.SettingsManagerProxy;
import fr.esrf.tangoatk.widget.util.SmSaveFileChooser;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class LoadSaveFileHandler
implements IResultListener {
    private PreviewFileChooser pfc = null;
    private JFileChooser saveFileChooser = null;
    private FilePreviewWindow previewer = null;
    private String loadButtonText = "Load ...";
    private String saveButtonText = "Save ...";
    private String previewButtonText = "Preview ...";
    private String canonicalRootPath = null;
    private String fileAuthor = null;
    private String fileComments = null;
    private IStringScalar rootFolderModel = null;
    private ICommand saveFileCmd = null;
    private ICommand loadFileCmd = null;
    private ICommand readFileContentCmd = null;
    private boolean relativeFileName = true;
    private String fileContent = null;
    private LoadSaveFileListener listener = null;
    private SettingsManagerProxy parent = null;

    public LoadSaveFileHandler() {
        this.pfc = new PreviewFileChooser();
        this.pfc.setContentVisible(true);
        this.saveFileChooser = this.pfc;
        this.previewer = new FilePreviewWindow();
    }

    public LoadSaveFileHandler(boolean relFileName) {
        this();
        this.relativeFileName = relFileName;
    }

    public LoadSaveFileHandler(String rootDirPath) {
        this.pfc = new PreviewFileChooser(rootDirPath);
        this.pfc.setContentVisible(true);
        this.saveFileChooser = this.pfc;
        File sDir = new File(this.pfc.getRootDirectory());
        try {
            this.canonicalRootPath = sDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public LoadSaveFileHandler(String rootDirPath, boolean relFileName) {
        this(rootDirPath);
        this.relativeFileName = relFileName;
    }

    public void setParent(SettingsManagerProxy parent) {
        this.parent = parent;
    }

    public void clearModels() {
        if (this.readFileContentCmd != null) {
            this.readFileContentCmd.removeResultListener((IResultListener)this);
        }
        this.rootFolderModel = null;
        this.saveFileCmd = null;
        this.loadFileCmd = null;
        this.readFileContentCmd = null;
    }

    public void setLoadSaveListener(LoadSaveFileListener l) {
        this.listener = l;
    }

    public void setSaveJFileChooser(JFileChooser jfc) {
        if (jfc == null) {
            return;
        }
        this.saveFileChooser = jfc;
    }

    public void setLoadButtonText(String loadLabel) {
        this.loadButtonText = loadLabel;
    }

    public void setSaveButtonText(String saveLabel) {
        this.saveButtonText = saveLabel;
    }

    public String getFileAuthor() {
        return this.fileAuthor;
    }

    public void setFileAuthor(String fa) {
        if (fa == null) {
            return;
        }
        if (fa.length() < 1) {
            return;
        }
        this.fileAuthor = fa;
    }

    public String getFileComments() {
        return this.fileComments;
    }

    public void setFileComments(String fc) {
        if (fc == null) {
            return;
        }
        if (fc.length() < 1) {
            return;
        }
        this.fileComments = fc;
    }

    private void setRootDirectory(String dirPath) {
        if (this.rootFolderModel != null) {
            return;
        }
        this.pfc.setRootDirectory(dirPath);
        this.canonicalRootPath = null;
        File sDir = new File(this.pfc.getRootDirectory());
        try {
            this.canonicalRootPath = sDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setRootFolderModel(IStringScalar folderNameAtt) {
        if (folderNameAtt == null) {
            return;
        }
        this.rootFolderModel = null;
        folderNameAtt.refresh();
        String rootFolderName = folderNameAtt.getStringValue();
        this.setRootDirectory(rootFolderName);
        this.rootFolderModel = folderNameAtt;
    }

    public IStringScalar getRootFolderModel() {
        return this.rootFolderModel;
    }

    public void setLoadCmdModel(ICommand loadCmd) {
        if (loadCmd == null) {
            return;
        }
        if (!(loadCmd instanceof StringVoidCommand)) {
            return;
        }
        this.loadFileCmd = loadCmd;
    }

    public void setSaveCmdModel(ICommand saveCmd) {
        if (saveCmd == null) {
            return;
        }
        if (!(saveCmd instanceof StringVoidCommand) && !(saveCmd instanceof ArrayVoidCommand)) {
            return;
        }
        this.saveFileCmd = saveCmd;
    }

    public void setReadFileContentCmd(ICommand getFileContentCmd) {
        if (getFileContentCmd == null) {
            return;
        }
        if (!(getFileContentCmd instanceof ScalarScalarCommand)) {
            return;
        }
        this.readFileContentCmd = getFileContentCmd;
        this.readFileContentCmd.addResultListener((IResultListener)this);
    }

    private String getRelativeFileName(File file) {
        String selectedFilePath = null;
        int rootPathLength = 0;
        int filePathLength = 0;
        int increment = 1;
        if (this.canonicalRootPath == null || this.canonicalRootPath.length() <= 0) {
            if (this.pfc.getRootDirectory() == null) {
                JOptionPane.showMessageDialog(this.pfc.getRootPane(), "Root folder is not set.\n", "Error", 0);
            }
            return null;
        }
        try {
            selectedFilePath = file.getCanonicalPath();
        }
        catch (IOException ioex) {
            JOptionPane.showMessageDialog(this.pfc.getRootPane(), "Failed to get the canonical path of the selected file.\n" + ioex.getMessage(), "Error", 0);
            return null;
        }
        if (!selectedFilePath.startsWith(this.canonicalRootPath)) {
            JOptionPane.showMessageDialog(this.pfc.getRootPane(), "The selected file is not inside the authorized root directory.\n\nThe file should be located in  " + this.pfc.getRootDirectory() + "  directory tree.\n\n", "Error", 0);
            return null;
        }
        rootPathLength = this.canonicalRootPath.length();
        if (rootPathLength + (increment = this.canonicalRootPath.endsWith(File.separator) ? 0 : 1) >= (filePathLength = selectedFilePath.length())) {
            JOptionPane.showMessageDialog(this.pfc.getRootPane(), "Invalid file name :" + selectedFilePath + ".\n", "Error", 0);
            return null;
        }
        return selectedFilePath.substring(rootPathLength + increment);
    }

    private void loadFile(File file) {
        String filePath = null;
        filePath = this.relativeFileName ? this.getRelativeFileName(file) : file.getAbsolutePath();
        if (filePath == null) {
            return;
        }
        if (this.loadFileCmd == null) {
            return;
        }
        ArrayList<String> listArg = new ArrayList<String>();
        listArg.add(filePath);
        this.loadFileCmd.execute(listArg);
    }

    private void settingManagerSaveFile(String relativeFilePath) {
        ArrayList<CallSite> listArg = new ArrayList<CallSite>();
        int i = 0;
        listArg.add(i, (CallSite)((Object)("FILE:" + relativeFilePath)));
        ++i;
        if (this.fileAuthor != null) {
            listArg.add(i, (CallSite)((Object)("AUTHOR: " + this.fileAuthor)));
            ++i;
        }
        if (this.fileComments != null) {
            listArg.add(i, (CallSite)((Object)("COMMENTS: " + this.fileComments)));
            ++i;
        }
        this.saveFileCmd.execute(listArg);
    }

    private void saveFile(File file) {
        String filePath = null;
        filePath = this.relativeFileName ? this.getRelativeFileName(file) : file.getAbsolutePath();
        if (filePath == null) {
            return;
        }
        if (this.saveFileCmd == null) {
            return;
        }
        if (this.saveFileChooser instanceof SmSaveFileChooser) {
            SmSaveFileChooser ssfc = (SmSaveFileChooser)this.saveFileChooser;
            this.setFileAuthor(ssfc.getAuthorText());
            this.setFileComments(ssfc.getCommentsText());
        }
        if (this.saveFileCmd instanceof ArrayVoidCommand) {
            this.settingManagerSaveFile(filePath);
        } else {
            ArrayList<String> listArg = new ArrayList<String>();
            listArg.add(filePath);
            this.saveFileCmd.execute(listArg);
        }
    }

    private void readFile(File file) {
        if (this.readFileContentCmd == null) {
            return;
        }
        String filePath = null;
        filePath = this.relativeFileName ? this.getRelativeFileName(file) : file.getAbsolutePath();
        if (filePath == null) {
            return;
        }
        this.fileContent = null;
        this.previewer.setText(this.fileContent);
        ArrayList<String> listArg = new ArrayList<String>();
        listArg.add(filePath);
        this.readFileContentCmd.execute(listArg);
        ATKGraphicsUtils.centerFrameOnScreen(this.previewer);
        this.previewer.setVisible(true);
    }

    public void loadFile() {
        if (this.loadFileCmd == null) {
            return;
        }
        File selectedFile = null;
        this.pfc.sortByDate();
        int returnDial = this.pfc.showDialog(this.pfc.getRootPane(), this.loadButtonText);
        if (returnDial == 1) {
            return;
        }
        selectedFile = this.pfc.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        if (!selectedFile.exists()) {
            JOptionPane.showMessageDialog(this.pfc.getRootPane(), "The selected file does not exist.\n\n", this.loadButtonText + " aborted.\n", 0);
            return;
        }
        if (this.listener != null) {
            this.listener.beforeLoad(this.parent, selectedFile);
        }
        this.loadFile(selectedFile);
        if (this.listener != null) {
            this.listener.afterLoad(this.parent, selectedFile);
        }
    }

    public void saveFile() {
        int returnDial;
        if (this.saveFileCmd == null) {
            return;
        }
        File selectedFile = null;
        this.pfc.sortByDate();
        if (this.saveFileChooser instanceof SmSaveFileChooser) {
            SmSaveFileChooser ssfc = (SmSaveFileChooser)this.saveFileChooser;
            ssfc.setAuthorText(this.fileAuthor);
            ssfc.setCommentsText(this.fileComments);
            ssfc.sortByDate();
        }
        if ((returnDial = this.saveFileChooser.showDialog(this.saveFileChooser.getRootPane(), this.saveButtonText)) == 1) {
            return;
        }
        selectedFile = this.saveFileChooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        if (selectedFile.exists() && (returnDial = JOptionPane.showConfirmDialog(this.saveFileChooser.getRootPane(), "Do you want to overwrite the file?\n\n", "File already exists", 0)) != 0) {
            return;
        }
        if (this.listener != null) {
            this.listener.beforeSave(this.parent, selectedFile);
        }
        this.saveFile(selectedFile);
        if (this.listener != null) {
            this.listener.afterSave(this.parent, selectedFile);
        }
    }

    public void previewFile() {
        if (this.readFileContentCmd == null) {
            return;
        }
        File selectedFile = null;
        this.pfc.sortByDate();
        int returnDial = this.pfc.showDialog(this.pfc.getRootPane(), this.previewButtonText);
        if (returnDial == 1) {
            return;
        }
        selectedFile = this.pfc.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        if (!selectedFile.exists()) {
            JOptionPane.showMessageDialog(this.pfc.getRootPane(), "The selected file does not exist.\n\n", this.previewButtonText + " aborted.\n", 0);
            return;
        }
        this.readFile(selectedFile);
    }

    public void resultChange(ResultEvent resultEvent) {
        if (this.readFileContentCmd == null) {
            return;
        }
        if (resultEvent.getSource() != this.readFileContentCmd) {
            return;
        }
        List outArg = resultEvent.getResult();
        if (outArg == null) {
            return;
        }
        if (outArg.isEmpty()) {
            return;
        }
        Object outElem = outArg.get(0);
        if (!(outElem instanceof String)) {
            return;
        }
        this.fileContent = (String)outElem;
        this.previewer.setText(this.fileContent);
        if (this.previewer.isVisible()) {
            this.previewer.repaint();
        }
    }

    public void errorChange(ErrorEvent evt) {
        if (this.readFileContentCmd == null) {
            return;
        }
        if (evt.getSource() != this.readFileContentCmd) {
            return;
        }
        this.fileContent = null;
        this.previewer.setText(this.fileContent);
        if (this.previewer.isVisible()) {
            this.previewer.repaint();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                IEntity ie2;
                JFrame jf = new JFrame();
                jf.setVisible(true);
                IStringScalar rootPathAtt = null;
                ICommand loadCmd = null;
                ICommand saveCmd = null;
                ICommand fileContentCmd = null;
                ErrorHistory errh = new ErrorHistory();
                AttributeList attl = new AttributeList();
                CommandList cmdl = new CommandList();
                attl.addErrorListener((IErrorListener)errh);
                cmdl.addErrorListener((IErrorListener)errh);
                cmdl.addErrorListener((IErrorListener)ErrorPopup.getInstance());
                try {
                    ie2 = attl.add("//acudebian7:10000/sys/settings/syco/SettingsPath");
                    if (ie2 instanceof IStringScalar) {
                        rootPathAtt = (IStringScalar)ie2;
                    }
                }
                catch (Exception ie2) {
                    // empty catch block
                }
                try {
                    ie2 = cmdl.add("//acudebian7:10000/sys/settings/syco/ApplySettings");
                    if (ie2 instanceof ICommand) {
                        loadCmd = (ICommand)ie2;
                    }
                    if ((ie2 = cmdl.add("//acudebian7:10000/sys/settings/syco/GenerateSettingsFile")) instanceof ICommand) {
                        saveCmd = (ICommand)ie2;
                    }
                    if ((ie2 = cmdl.add("//acudebian7:10000/sys/settings/syco/GetSettingsFileContent")) instanceof ICommand) {
                        fileContentCmd = (ICommand)ie2;
                    }
                }
                catch (Exception ie3) {
                    // empty catch block
                }
                LoadSaveFileHandler loadSaveHandler = new LoadSaveFileHandler();
                loadSaveHandler.setFileAuthor("SYCO");
                loadSaveHandler.setFileComments("Testing ATK util widget LoadSaveFileHandler");
                loadSaveHandler.setLoadButtonText("Load Settings");
                loadSaveHandler.setSaveButtonText("Save Settings");
                loadSaveHandler.setRootFolderModel(rootPathAtt);
                loadSaveHandler.setLoadCmdModel(loadCmd);
                loadSaveHandler.setSaveCmdModel(saveCmd);
                loadSaveHandler.setReadFileContentCmd(fileContentCmd);
                String rootPath = null;
                if (loadSaveHandler.getRootFolderModel() != null) {
                    rootPath = loadSaveHandler.getRootFolderModel().getStringValue();
                }
                SmSaveFileChooser ssfc = new SmSaveFileChooser(rootPath);
                loadSaveHandler.setSaveJFileChooser(ssfc);
                loadSaveHandler.loadFile();
                loadSaveHandler.saveFile();
                loadSaveHandler.previewFile();
            }
        });
    }
}

