/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import ij.ImagePlus;
import ij.process.ImageProcessor;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class MaskUndoableEdit
extends AbstractUndoableEdit {
    private ImagePlus concernedImage;
    private ImageProcessor undoProcessor;
    private ImageProcessor redoProcessor;
    private String presentation = "Mask";

    public MaskUndoableEdit(ImagePlus concernedImage, ImageProcessor undoProcessor) {
        this(concernedImage, undoProcessor, null);
    }

    public MaskUndoableEdit(ImagePlus concernedImage, ImageProcessor undoProcessor, String presentation) {
        this.concernedImage = concernedImage;
        this.undoProcessor = undoProcessor;
        if (this.concernedImage != null) {
            this.redoProcessor = this.concernedImage.getProcessor();
        }
        if (presentation != null && !"".equals(presentation.trim())) {
            this.presentation = presentation;
        }
    }

    @Override
    public boolean canUndo() {
        return super.canUndo() && this.concernedImage != null && this.undoProcessor != null;
    }

    @Override
    public boolean canRedo() {
        return super.canRedo() && this.concernedImage != null && this.redoProcessor != null;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.redoProcessor = this.concernedImage.getProcessor();
        this.concernedImage.setProcessor(null, this.undoProcessor);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.concernedImage.setProcessor(null, this.redoProcessor);
    }

    @Override
    public String getPresentationName() {
        return this.presentation;
    }

    @Override
    public void die() {
        boolean canUndo = this.canUndo();
        boolean canRedo = this.canRedo();
        super.die();
        if (canUndo) {
            this.undoProcessor.setPixels(null);
        } else if (canRedo) {
            this.redoProcessor.setPixels(null);
        }
        this.undoProcessor = null;
        this.redoProcessor = null;
        this.concernedImage = null;
    }
}

