/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class MultiExtFileFilter
extends FileFilter {
    protected String prefix;
    protected List<String> extensions;
    protected String description;

    public MultiExtFileFilter(String filterDescription, String defaultExtension, String ... otherExtensions) {
        this.prefix = filterDescription;
        this.extensions = new ArrayList<String>(1 + otherExtensions.length);
        this.extensions.add(defaultExtension);
        for (String ext : otherExtensions) {
            this.extensions.add(ext);
        }
        this.computeDescription();
    }

    @Override
    public boolean accept(File f) {
        boolean result = false;
        if (f != null) {
            result |= f.isDirectory();
            String fileExtension = MultiExtFileFilter.getExtension(f);
            if (fileExtension != null) {
                result |= this.isAccepted(fileExtension);
            }
        }
        return result;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean isAccepted(String fileExtension) {
        boolean result = false;
        for (String extension : this.extensions) {
            result |= extension.equalsIgnoreCase(fileExtension);
        }
        return result;
    }

    public String getDefaultExtension() {
        return this.extensions.get(0);
    }

    protected void computeDescription() {
        StringBuilder sb = new StringBuilder(this.prefix);
        sb.append(" (");
        Iterator<String> iterator = this.extensions.iterator();
        do {
            String ext = iterator.next();
            sb.append("*.").append(ext);
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        } while (iterator.hasNext());
        sb.append(")");
        this.description = sb.toString();
    }

    public String toString() {
        return this.description;
    }

    public static String getExtension(File f) {
        String s;
        int i;
        String ext = null;
        if (f != null && (i = (s = f.getName()).lastIndexOf(46)) > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }
}

