/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.AdvancedImagePlus;
import ij.gui.Roi;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class RoiDefaultUndoableEdit
extends AbstractUndoableEdit {
    private AdvancedImagePlus concernedImage;
    private Vector<Roi> undoRoiVector;
    private Vector<Roi> undoSelectedRois;
    private Vector<Roi> undoInnerRois;
    private Vector<Roi> undoOuterRois;
    private Roi undoValidatedRoi;
    private Roi undoHandledRoi;
    private Vector<Roi> redoRoiVector;
    private Vector<Roi> redoSelectedRois;
    private Vector<Roi> redoInnerRois;
    private Vector<Roi> redoOuterRois;
    private Roi redoValidatedRoi;
    private Roi redoHandledRoi;
    private String presentation = "Roi operation";

    public RoiDefaultUndoableEdit(AdvancedImagePlus concernedImage, Vector<Roi> undoRoiVector, Vector<Roi> undoSelectedRois, Vector<Roi> undoInnerRois, Vector<Roi> undoOuterRois, Roi undoValidatedRoi, Roi undoHandledRoi) {
        this(concernedImage, undoRoiVector, undoSelectedRois, undoInnerRois, undoOuterRois, undoValidatedRoi, undoHandledRoi, null);
    }

    public RoiDefaultUndoableEdit(AdvancedImagePlus concernedImage, Vector<Roi> undoRoiVector, Vector<Roi> undoSelectedRois, Vector<Roi> undoInnerRois, Vector<Roi> undoOuterRois, Roi undoValidatedRoi, Roi undoHandledRoi, String presentation) {
        this.concernedImage = concernedImage;
        this.undoRoiVector = undoRoiVector;
        if (this.undoRoiVector == null) {
            this.undoRoiVector = new Vector();
        }
        this.undoSelectedRois = undoSelectedRois;
        if (this.undoSelectedRois == null) {
            this.undoSelectedRois = new Vector();
        }
        this.undoInnerRois = undoInnerRois;
        if (this.undoInnerRois == null) {
            this.undoInnerRois = new Vector();
        }
        this.undoOuterRois = undoOuterRois;
        if (this.undoOuterRois == null) {
            this.undoOuterRois = new Vector();
        }
        this.undoValidatedRoi = undoValidatedRoi;
        this.undoHandledRoi = undoHandledRoi;
        this.redoRoiVector = new Vector();
        this.redoSelectedRois = new Vector();
        this.redoInnerRois = new Vector();
        this.redoOuterRois = new Vector();
        if (this.concernedImage != null) {
            if (this.concernedImage.getAllRois() != null) {
                this.redoRoiVector.addAll(this.concernedImage.getAllRois());
            }
            if (this.concernedImage.getSelectedRois() != null) {
                this.redoSelectedRois.addAll(this.concernedImage.getSelectedRois());
            }
            if (this.concernedImage.getInnerRois() != null) {
                this.redoInnerRois.addAll(this.concernedImage.getInnerRois());
            }
            if (this.concernedImage.getOuterRois() != null) {
                this.redoOuterRois.addAll(this.concernedImage.getOuterRois());
            }
            this.redoValidatedRoi = this.concernedImage.getValidatedRoi();
            this.redoHandledRoi = this.concernedImage.getRoi();
        }
        if (presentation != null && !"".equals(presentation.trim())) {
            this.presentation = presentation;
        }
    }

    @Override
    public boolean canUndo() {
        return super.canUndo() && this.concernedImage != null && this.undoRoiVector != null && this.undoSelectedRois != null && this.undoInnerRois != null && this.undoOuterRois != null;
    }

    @Override
    public boolean canRedo() {
        return super.canRedo() && this.concernedImage != null && this.redoRoiVector != null && this.redoSelectedRois != null && this.redoInnerRois != null && this.redoOuterRois != null;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.redoRoiVector.clear();
        if (this.concernedImage.getAllRois() != null) {
            this.redoRoiVector.addAll(this.concernedImage.getAllRois());
            this.concernedImage.getAllRois().clear();
            this.concernedImage.getAllRois().addAll(this.undoRoiVector);
        }
        this.redoSelectedRois.clear();
        if (this.concernedImage.getSelectedRois() != null) {
            this.redoSelectedRois.addAll(this.concernedImage.getSelectedRois());
            this.concernedImage.getSelectedRois().clear();
            this.concernedImage.getSelectedRois().addAll(this.undoSelectedRois);
        }
        this.redoInnerRois.clear();
        if (this.concernedImage.getInnerRois() != null) {
            this.redoInnerRois.addAll(this.concernedImage.getInnerRois());
            this.concernedImage.getInnerRois().clear();
            this.concernedImage.getInnerRois().addAll(this.undoInnerRois);
        }
        this.redoOuterRois.clear();
        if (this.concernedImage.getOuterRois() != null) {
            this.redoOuterRois.addAll(this.concernedImage.getOuterRois());
            this.concernedImage.getOuterRois().clear();
            this.concernedImage.getOuterRois().addAll(this.undoOuterRois);
        }
        this.redoValidatedRoi = this.concernedImage.getValidatedRoi();
        this.concernedImage.setValidatedRoi(this.undoValidatedRoi);
        this.redoHandledRoi = this.concernedImage.getRoi();
        this.concernedImage.setHandledRoi(this.undoHandledRoi);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.concernedImage.getAllRois() != null) {
            this.concernedImage.getAllRois().clear();
            this.concernedImage.getAllRois().addAll(this.redoRoiVector);
        }
        if (this.concernedImage.getSelectedRois() != null) {
            this.concernedImage.getSelectedRois().clear();
            this.concernedImage.getSelectedRois().addAll(this.redoSelectedRois);
        }
        if (this.concernedImage.getInnerRois() != null) {
            this.concernedImage.getInnerRois().clear();
            this.concernedImage.getInnerRois().addAll(this.redoInnerRois);
        }
        this.redoOuterRois.clear();
        if (this.concernedImage.getOuterRois() != null) {
            this.concernedImage.getOuterRois().clear();
            this.concernedImage.getOuterRois().addAll(this.redoOuterRois);
        }
        this.concernedImage.setValidatedRoi(this.redoValidatedRoi);
        this.concernedImage.setHandledRoi(this.redoHandledRoi);
    }

    @Override
    public String getPresentationName() {
        return this.presentation;
    }

    @Override
    public void die() {
        super.die();
        this.undoRoiVector.clear();
        this.undoSelectedRois.clear();
        this.undoInnerRois.clear();
        this.undoOuterRois.clear();
        this.undoValidatedRoi = null;
        this.undoHandledRoi = null;
        this.undoRoiVector = null;
        this.undoSelectedRois = null;
        this.undoInnerRois = null;
        this.undoOuterRois = null;
        this.redoRoiVector.clear();
        this.redoSelectedRois.clear();
        this.redoInnerRois.clear();
        this.redoOuterRois.clear();
        this.redoValidatedRoi = null;
        this.redoHandledRoi = null;
        this.redoRoiVector = null;
        this.redoSelectedRois = null;
        this.redoInnerRois = null;
        this.redoOuterRois = null;
        this.concernedImage = null;
    }
}

