/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.command.ArrayVoidCommand;
import fr.esrf.tangoatk.core.command.ScalarScalarCommand;
import fr.esrf.tangoatk.core.command.StringVoidCommand;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.attribute.StatusViewer;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.LoadSaveFileHandler;
import fr.esrf.tangoatk.widget.util.LoadSaveFileListener;
import fr.esrf.tangoatk.widget.util.SmSaveFileChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class SettingsManagerProxy {
    public static final String ROOT_PATH_ATT_NAME = "SettingsPath";
    public static final String SETTINGS_FILE_ATT_NAME = "LastAppliedFile";
    public static final String LOAD_CMD_NAME = "ApplySettings";
    public static final String SAVE_CMD_NAME = "GenerateSettingsFile";
    public static final String READ_CONTENT_CMD_NAME = "GetSettingsFileContent";
    public static final String STATUS_BUTTON = "Status";
    public static final String LOAD_BUTTON = "Load";
    public static final String SAVE_BUTTON = "Save";
    public static final String PREVIEW_BUTTON = "Preview";
    public static final String FILE_LABEL = "FileLabel";
    public static final String FILE_NAME = "FileName";
    private String devName = null;
    private Device settingsManagerDevice = null;
    private AttributeList attl = new AttributeList();
    private CommandList cmdl = new CommandList();
    private IStringScalar rootPathAtt = null;
    private IStringScalar settingsFileAtt = null;
    private IStringScalar statusAtt = null;
    private ICommand loadCmd = null;
    private ICommand saveCmd = null;
    private ICommand readContentCmd = null;
    private ErrorHistory errh = new ErrorHistory();
    private LoadSaveFileHandler lsfh = null;
    private JPanel settingsPanel = null;
    private SimpleScalarViewer settingsFileSsv = null;
    private JFrame statusJFrame = null;
    private StatusViewer statusv = null;
    private JButton statusJButton = null;
    private JButton loadJButton = null;
    private JButton saveJButton = null;
    private JButton previewJButton = null;
    private JLabel fileLabel = null;

    public SettingsManagerProxy(String smName) {
        this.attl.addErrorListener((IErrorListener)this.errh);
        this.cmdl.addErrorListener((IErrorListener)this.errh);
        this.cmdl.addErrorListener((IErrorListener)ErrorPopup.getInstance());
        this.connectToSettingsManagerDevice(smName);
    }

    public SettingsManagerProxy(String smName, ErrorHistory errWindow) {
        if (errWindow != null) {
            this.errh = errWindow;
        }
        this.attl.addErrorListener((IErrorListener)this.errh);
        this.cmdl.addErrorListener((IErrorListener)this.errh);
        this.cmdl.addErrorListener((IErrorListener)ErrorPopup.getInstance());
        this.connectToSettingsManagerDevice(smName);
    }

    private void connectToSettingsManagerDevice(String smDeviceName) {
        if (smDeviceName != null) {
            try {
                this.settingsManagerDevice = DeviceFactory.getInstance().getDevice(smDeviceName);
                this.devName = smDeviceName;
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
        }
        if (this.devName == null) {
            JOptionPane.showMessageDialog(null, "Cannot connect to the device.\nCheck the setting manager device name you entered.", "Connection to device failed", 0);
        }
        String className = null;
        if (this.settingsManagerDevice != null) {
            try {
                className = this.settingsManagerDevice.get_class_name();
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            if (className == null) {
                JOptionPane.showMessageDialog(null, "Failed to get the class name of the device.\nCheck the setting manager device name you entered.", "Get class name failed", 0);
            } else if (!className.equalsIgnoreCase("SettingsManager")) {
                JOptionPane.showMessageDialog(null, "The device is not a SettingsManager.\nCheck the setting manager device name you entered.", "Bad class name", 0);
                className = null;
            }
        }
        if (className != null) {
            IEntity ie;
            String entityName = null;
            try {
                entityName = this.devName + "/Status";
                ie = this.attl.add(entityName);
                if (ie instanceof IStringScalar) {
                    this.statusAtt = (IStringScalar)ie;
                }
                if ((ie = this.attl.add(entityName = this.devName + "/SettingsPath")) instanceof IStringScalar) {
                    this.rootPathAtt = (IStringScalar)ie;
                }
                if ((ie = this.attl.add(entityName = this.devName + "/LastAppliedFile")) instanceof IStringScalar) {
                    this.settingsFileAtt = (IStringScalar)ie;
                }
            }
            catch (ConnectionException ex) {
                JOptionPane.showMessageDialog(null, "Cannot connect to the SettingsManager device.\nFailed to connect to the attribute : " + entityName, "Connection failed", 0);
            }
            try {
                entityName = this.devName + "/ApplySettings";
                ie = this.cmdl.add(entityName);
                if (ie instanceof StringVoidCommand) {
                    this.loadCmd = (ICommand)ie;
                }
                if ((ie = this.cmdl.add(entityName = this.devName + "/GenerateSettingsFile")) instanceof ArrayVoidCommand) {
                    this.saveCmd = (ICommand)ie;
                }
                if ((ie = this.cmdl.add(entityName = this.devName + "/GetSettingsFileContent")) instanceof ScalarScalarCommand) {
                    this.readContentCmd = (ICommand)ie;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.attl.startRefresher();
            this.createLoadSaveFileHandler();
            this.createSettingsPanel();
        }
    }

    private void createLoadSaveFileHandler() {
        this.lsfh = new LoadSaveFileHandler();
        this.lsfh.setFileAuthor("ATK SettingsManagerProxy class");
        this.lsfh.setLoadButtonText("Load Settings");
        this.lsfh.setSaveButtonText("Save Settings");
        this.lsfh.setRootFolderModel(this.rootPathAtt);
        this.lsfh.setLoadCmdModel(this.loadCmd);
        this.lsfh.setSaveCmdModel(this.saveCmd);
        this.lsfh.setReadFileContentCmd(this.readContentCmd);
        String rootPath = null;
        if (this.lsfh.getRootFolderModel() != null) {
            rootPath = this.lsfh.getRootFolderModel().getStringValue();
        }
        SmSaveFileChooser ssfc = new SmSaveFileChooser(rootPath);
        this.lsfh.setSaveJFileChooser(ssfc);
    }

    private void createSettingsPanel() {
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        this.fileLabel = new JLabel("Configuration file");
        this.fileLabel.setFont(new Font("Dialog", 1, 12));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.settingsPanel.add((Component)this.fileLabel, gbc);
        this.settingsFileSsv = new SimpleScalarViewer();
        this.settingsFileSsv.setBackgroundColor(Color.WHITE);
        this.settingsFileSsv.setMargin(new Insets(3, 2, 3, 2));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.settingsPanel.add((Component)this.settingsFileSsv, gbc);
        if (this.settingsFileAtt != null) {
            this.settingsFileSsv.setHasToolTip(true);
            this.settingsFileSsv.setModel(this.settingsFileAtt);
            this.settingsFileSsv.setFont(new Font("Dialog", 0, 12));
        }
        this.statusJButton = new JButton(STATUS_BUTTON);
        this.statusJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsManagerProxy.this.fileStatusButtonPerformed(e);
            }
        });
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.settingsPanel.add((Component)this.statusJButton, gbc);
        this.previewJButton = new JButton(PREVIEW_BUTTON);
        this.previewJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsManagerProxy.this.filePreviewButtonActionPerformed(e);
            }
        });
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.ipadx = 0;
        gbc.weightx = 0.0;
        this.settingsPanel.add((Component)this.previewJButton, gbc);
        this.loadJButton = new JButton(LOAD_BUTTON);
        this.loadJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsManagerProxy.this.fileLoadButtonActionPerformed(e);
            }
        });
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.settingsPanel.add((Component)this.loadJButton, gbc);
        this.saveJButton = new JButton(SAVE_BUTTON);
        this.saveJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsManagerProxy.this.fileSaveButtonActionPerformed(e);
            }
        });
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.settingsPanel.add((Component)this.saveJButton, gbc);
        this.statusJFrame = new JFrame();
        this.statusJFrame.setDefaultCloseOperation(1);
        this.statusJFrame.getContentPane().setLayout(new GridBagLayout());
        this.statusv = new StatusViewer();
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.statusJFrame.getContentPane().add((Component)this.statusv, gbc);
        this.statusJFrame.setPreferredSize(new Dimension(700, 400));
        if (this.statusAtt != null) {
            this.statusv.setModel(this.statusAtt);
        }
        this.statusJFrame.pack();
    }

    private void fileStatusButtonPerformed(ActionEvent evt) {
        if (this.statusJFrame == null) {
            return;
        }
        ATKGraphicsUtils.centerFrame(this.settingsPanel, this.statusJFrame);
        this.statusJFrame.setVisible(true);
    }

    private void filePreviewButtonActionPerformed(ActionEvent evt) {
        this.previewSettingsFile();
    }

    private void fileLoadButtonActionPerformed(ActionEvent evt) {
        this.loadSettingsFile();
    }

    private void fileSaveButtonActionPerformed(ActionEvent evt) {
        this.saveSettingsFile();
    }

    public JPanel getSettingsPanel() {
        return this.settingsPanel;
    }

    public ErrorHistory getErrorHistoryWindow() {
        return this.errh;
    }

    public void setErrorHistoryWindow(ErrorHistory errorWindow) {
        int i;
        if (errorWindow == null) {
            return;
        }
        if (errorWindow == this.errh) {
            return;
        }
        if (this.errh != null) {
            int i2;
            Object obj = null;
            for (i2 = 0; i2 < this.attl.size(); ++i2) {
                obj = this.attl.get(i2);
                if (!(obj instanceof IAttribute)) continue;
                IAttribute ia = (IAttribute)obj;
                ia.removeErrorListener((IErrorListener)this.errh);
            }
            for (i2 = 0; i2 < this.cmdl.size(); ++i2) {
                obj = this.cmdl.get(i2);
                if (!(obj instanceof ICommand)) continue;
                ICommand ic = (ICommand)obj;
                ic.removeErrorListener((IErrorListener)this.errh);
            }
            this.errh = null;
        }
        this.errh = errorWindow;
        AttributeList oldAttl = this.attl;
        CommandList oldCmdl = this.cmdl;
        this.attl = new AttributeList();
        this.cmdl = new CommandList();
        this.attl.addErrorListener((IErrorListener)this.errh);
        this.cmdl.addErrorListener((IErrorListener)this.errh);
        for (i = 0; i < oldAttl.size(); ++i) {
            IAttribute ia = (IAttribute)oldAttl.get(i);
            this.attl.add((IEntity)ia);
        }
        for (i = 0; i < oldCmdl.size(); ++i) {
            ICommand ic = (ICommand)oldCmdl.get(i);
            this.cmdl.add((IEntity)ic);
        }
        oldAttl.stopRefresher();
        oldAttl.clear();
        oldCmdl.clear();
        this.attl.startRefresher();
    }

    public void clearModels() {
        if (this.statusv != null) {
            this.statusv.clearModel();
        }
        if (this.settingsFileSsv != null) {
            this.settingsFileSsv.clearModel();
        }
        if (this.lsfh != null) {
            this.lsfh.clearModels();
        }
        this.attl.stopRefresher();
        this.attl.clear();
        this.cmdl.clear();
    }

    public Device getDevice() {
        return this.settingsManagerDevice;
    }

    public String getLastAppliedFile() {
        String fName;
        block3: {
            if (this.settingsManagerDevice == null) {
                return null;
            }
            fName = "-----";
            try {
                DeviceAttribute da = this.settingsManagerDevice.readAttributeFromDevice(SETTINGS_FILE_ATT_NAME);
                fName = da.extractString();
            }
            catch (DevFailed ex) {
                if (this.errh == null) break block3;
                ErrorEvent e = new ErrorEvent((Object)this.devName, (Throwable)new AttributeReadException(ex), System.currentTimeMillis());
                this.errh.setErrorOccured(e);
            }
        }
        return fName;
    }

    public void settingsPanelHideChild(String childName) {
        if (this.settingsManagerDevice == null) {
            return;
        }
        if (childName.equalsIgnoreCase(FILE_LABEL)) {
            if (this.fileLabel != null) {
                this.fileLabel.setVisible(false);
            }
            return;
        }
        if (childName.equalsIgnoreCase(STATUS_BUTTON)) {
            if (this.statusJButton != null) {
                this.statusJButton.setVisible(false);
            }
            return;
        }
        if (childName.equalsIgnoreCase(LOAD_BUTTON)) {
            if (this.loadJButton != null) {
                this.loadJButton.setVisible(false);
            }
            return;
        }
        if (childName.equalsIgnoreCase(SAVE_BUTTON)) {
            if (this.saveJButton != null) {
                this.saveJButton.setVisible(false);
            }
            return;
        }
        if (childName.equalsIgnoreCase(PREVIEW_BUTTON) && this.previewJButton != null) {
            this.previewJButton.setVisible(false);
        }
    }

    public void settingsPanelShowChild(String childName) {
        if (this.settingsManagerDevice == null) {
            return;
        }
        if (childName.equalsIgnoreCase(FILE_LABEL)) {
            if (this.fileLabel != null) {
                this.fileLabel.setVisible(true);
            }
            return;
        }
        if (childName.equalsIgnoreCase(STATUS_BUTTON)) {
            if (this.statusJButton != null) {
                this.statusJButton.setVisible(true);
            }
            return;
        }
        if (childName.equalsIgnoreCase(LOAD_BUTTON)) {
            if (this.loadJButton != null) {
                this.loadJButton.setVisible(true);
            }
            return;
        }
        if (childName.equalsIgnoreCase(SAVE_BUTTON)) {
            if (this.saveJButton != null) {
                this.saveJButton.setVisible(true);
            }
            return;
        }
        if (childName.equalsIgnoreCase(PREVIEW_BUTTON) && this.previewJButton != null) {
            this.previewJButton.setVisible(true);
        }
    }

    public JComponent getSettingsPanelChild(String childName) {
        if (this.settingsManagerDevice == null) {
            return null;
        }
        if (childName.equalsIgnoreCase(FILE_LABEL)) {
            return this.fileLabel;
        }
        if (childName.equalsIgnoreCase(FILE_NAME)) {
            return this.settingsFileSsv;
        }
        if (childName.equalsIgnoreCase(STATUS_BUTTON)) {
            return this.statusJButton;
        }
        if (childName.equalsIgnoreCase(LOAD_BUTTON)) {
            return this.loadJButton;
        }
        if (childName.equalsIgnoreCase(SAVE_BUTTON)) {
            return this.saveJButton;
        }
        if (childName.equalsIgnoreCase(PREVIEW_BUTTON)) {
            return this.previewJButton;
        }
        return null;
    }

    public void setLoadButtonText(String loadLabel) {
        if (this.lsfh == null) {
            return;
        }
        this.lsfh.setLoadButtonText(loadLabel);
    }

    public void setSaveButtonText(String saveLabel) {
        if (this.lsfh == null) {
            return;
        }
        this.lsfh.setSaveButtonText(saveLabel);
    }

    public String getFileAuthor() {
        if (this.lsfh == null) {
            return null;
        }
        return this.lsfh.getFileAuthor();
    }

    public void setFileAuthor(String fa) {
        if (this.lsfh == null) {
            return;
        }
        this.lsfh.setFileAuthor(fa);
    }

    public String getFileComments() {
        if (this.lsfh == null) {
            return null;
        }
        return this.lsfh.getFileComments();
    }

    public void setFileComments(String fc) {
        if (this.lsfh == null) {
            return;
        }
        this.lsfh.setFileComments(fc);
    }

    public void loadSettingsFile() {
        if (this.lsfh == null) {
            return;
        }
        this.lsfh.loadFile();
    }

    public void setLoadSaveListener(LoadSaveFileListener l) {
        if (this.lsfh == null) {
            return;
        }
        this.lsfh.setParent(this);
        this.lsfh.setLoadSaveListener(l);
    }

    public void saveSettingsFile() {
        if (this.lsfh == null) {
            return;
        }
        this.lsfh.saveFile();
    }

    public void previewSettingsFile() {
        if (this.lsfh == null) {
            return;
        }
        this.lsfh.previewFile();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                final ErrorHistory errorWindow = new ErrorHistory();
                final SettingsManagerProxy smp = new SettingsManagerProxy("sys/settings/test", errorWindow);
                smp.setFileAuthor("Test");
                smp.setFileComments("Encore test");
                smp.setLoadButtonText("Load it");
                smp.setSaveButtonText("Save it");
                smp.settingsPanelHideChild(SettingsManagerProxy.PREVIEW_BUTTON);
                JButton statusButton = (JButton)smp.getSettingsPanelChild(SettingsManagerProxy.STATUS_BUTTON);
                if (smp.getSettingsPanel() != null) {
                    GridBagLayout gbl = (GridBagLayout)smp.getSettingsPanel().getLayout();
                    GridBagConstraints gbc = gbl.getConstraints(smp.getSettingsPanelChild(SettingsManagerProxy.FILE_NAME));
                    smp.getSettingsPanel().remove(statusButton);
                    ++gbc.gridy;
                    gbc.fill = 0;
                    smp.getSettingsPanel().add((Component)statusButton, gbc);
                }
                JFrame jf = new JFrame();
                jf.setDefaultCloseOperation(3);
                jf.getContentPane().setLayout(new BorderLayout());
                jf.getContentPane().add((Component)new JPanel(), "Center");
                if (smp.getSettingsPanel() != null) {
                    jf.getContentPane().add((Component)smp.getSettingsPanel(), "South");
                }
                JMenuBar jMenuBar1 = new JMenuBar();
                JMenu fileJMenu = new JMenu();
                fileJMenu.setText("File");
                jMenuBar1.add(fileJMenu);
                JMenuItem fileLoadMenuItem = new JMenuItem("Load...");
                fileLoadMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        smp.loadSettingsFile();
                    }
                });
                fileJMenu.add(fileLoadMenuItem);
                JMenuItem filePreviewMenuItem = new JMenuItem("Preview...");
                filePreviewMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        smp.previewSettingsFile();
                    }
                });
                fileJMenu.add(filePreviewMenuItem);
                JMenuItem fileSaveMenuItem = new JMenuItem("Save...");
                fileSaveMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        smp.saveSettingsFile();
                    }
                });
                fileJMenu.add(fileSaveMenuItem);
                JMenuItem quitJMenuItem = new JMenuItem("Quit");
                quitJMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        System.exit(0);
                    }
                });
                fileJMenu.add(new JSeparator());
                fileJMenu.add(quitJMenuItem);
                JMenu viewMenu = new JMenu();
                viewMenu.setText("View");
                jMenuBar1.add(viewMenu);
                JMenuItem errorHistoryMenuItem = new JMenuItem("Error History...");
                errorHistoryMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ATKGraphicsUtils.centerFrameOnScreen(errorWindow);
                        errorWindow.setVisible(true);
                    }
                });
                viewMenu.add(errorHistoryMenuItem);
                JMenuItem atkDiagMenuItem = new JMenuItem("ATK Diagnostic...");
                atkDiagMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ATKDiagnostic.showDiagnostic();
                    }
                });
                viewMenu.add(atkDiagMenuItem);
                jf.setJMenuBar(jMenuBar1);
                jf.setPreferredSize(new Dimension(600, 300));
                jf.pack();
                jf.setVisible(true);
            }
        });
    }
}

