/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.SmSaveFileAccessoryPanel;
import fr.esrf.tangoatk.widget.util.SwingUtils;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class SmSaveFileChooser
extends JFileChooser {
    private String rootDirectory = null;
    private SmSaveFileAccessoryPanel saveAccessory = new SmSaveFileAccessoryPanel(400, 250);
    private JTable fileChoosertable = null;
    private Dimension increaseDimension = new Dimension(220, 70);

    public SmSaveFileChooser() {
        this.setAccessory(this.saveAccessory);
        ActionMap am = this.getActionMap();
        Action details = am.get("viewTypeDetails");
        details.actionPerformed(null);
        this.fileChoosertable = SwingUtils.getDescendantsOfType(JTable.class, this).get(0);
        this.sortByDate();
        this.validate();
        this.increaseSize();
    }

    public SmSaveFileChooser(String dirPath) {
        super(dirPath);
        this.rootDirectory = dirPath;
        this.setAccessory(this.saveAccessory);
        ActionMap am = this.getActionMap();
        Action details = am.get("viewTypeDetails");
        details.actionPerformed(null);
        this.fileChoosertable = SwingUtils.getDescendantsOfType(JTable.class, this).get(0);
        this.sortByDate();
        this.validate();
        this.increaseSize();
    }

    void sortByDate() {
        if (this.fileChoosertable == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SmSaveFileChooser.this.fileChoosertable.getRowSorter().toggleSortOrder(2);
                SmSaveFileChooser.this.fileChoosertable.getRowSorter().toggleSortOrder(2);
            }
        });
    }

    public void increaseDimension(int w, int h) {
        this.increaseDimension = new Dimension(w, h);
        this.increaseSize();
    }

    private void increaseSize() {
        if (this.increaseDimension == null) {
            return;
        }
        Dimension psize = this.getPreferredSize();
        psize.width += this.increaseDimension.width;
        psize.height += this.increaseDimension.height;
        this.setPreferredSize(psize);
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(String dirPath) {
        File dir = new File(dirPath);
        super.setCurrentDirectory(dir);
        this.rootDirectory = dirPath;
    }

    public String getAuthorText() {
        if (this.saveAccessory == null) {
            return null;
        }
        return this.saveAccessory.getAuthorText();
    }

    public void setAuthorText(String auth) {
        if (this.saveAccessory == null) {
            return;
        }
        this.saveAccessory.setAuthorText(auth);
    }

    public String getCommentsText() {
        if (this.saveAccessory == null) {
            return null;
        }
        return this.saveAccessory.getCommentsText();
    }

    public void setCommentsText(String com) {
        if (this.saveAccessory == null) {
            return;
        }
        this.saveAccessory.setCommentsText(com);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jf = new JFrame();
                jf.setVisible(true);
                SmSaveFileChooser saveFc = new SmSaveFileChooser("/users/poncet");
                int returnDial = saveFc.showDialog(jf.getRootPane(), "Save");
                if (returnDial == 1) {
                    return;
                }
                File selectedFile = saveFc.getSelectedFile();
                if (selectedFile == null) {
                    return;
                }
                if (!selectedFile.exists()) {
                    JOptionPane.showMessageDialog(jf.getRootPane(), "The selected file does not exist.\n\n", "Save file aborted.\n", 0);
                    return;
                }
                System.out.println("File to save : " + selectedFile.getName());
            }
        });
    }
}

