/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import fr.esrf.tangoatk.widget.util.SplashPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;

public final class SplashTimer
extends Splash {
    long timeDuration = 2000L;
    long timeStep = 200L;
    TimerTask progressTask = null;
    Timer progressTimer = null;

    public SplashTimer(long duration, long step) {
        this.initComponents(null, null, null);
        if (duration > 0L) {
            this.timeDuration = duration;
        }
        if (step > 0L) {
            this.timeStep = step;
        }
        if (this.timeDuration / this.timeStep < 1L) {
            this.timeDuration = 2000L;
            this.timeStep = 200L;
        }
        super.setMaxProgress((int)(this.timeDuration / this.timeStep));
        this.progressTask = new TimerTask(){

            @Override
            public void run() {
                SplashTimer.this.doOneStep();
            }
        };
        this.progressTimer = new Timer();
    }

    private void doOneStep() {
        int p = this.getProgressBar().getValue();
        super.progress(p + 1);
    }

    @Override
    protected void initComponents(ImageIcon icon, Color textColor, JSmoothProgressBar newBar) {
        this.setBackground(new Color(100, 110, 140));
        this.splashPanel = new SplashPanel(icon, textColor, newBar);
        this.setContentPane(this.splashPanel);
        this.pack();
        Dimension d = this.splashPanel.getPreferredSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - d.width) / 2, (screenSize.height - d.height) / 2, d.width, d.height);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            super.setMaxProgress((int)(this.timeDuration / this.timeStep));
            super.initProgress();
            this.progressTimer.purge();
            this.progressTimer.schedule(this.progressTask, 0L, this.timeStep);
        } else {
            this.progressTask.cancel();
            this.progressTimer.cancel();
            this.progressTimer.purge();
        }
        super.setVisible(b);
    }

    @Override
    public void initProgress() {
    }

    @Override
    public void setMaxProgress(int i) {
    }

    @Override
    public void progress(int i) {
    }

    public static void main(String[] args) {
        SplashTimer splt = new SplashTimer(6000L, 500L);
        splt.setTitle("SplashTimer Screen");
        splt.setCopyright("(c) ESRF 2014");
        splt.setMessage("This is the free message line");
        splt.setVisible(true);
        for (int i = 0; i <= 6; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        splt.setVisible(false);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }
}

