/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

class XORCaret
extends DefaultCaret {
    protected double lastPaintedWidth = 0.0;
    protected Font currentFont = null;
    protected float currentAscent = 0.0f;
    protected LineMetrics currentLineMetrics = null;
    protected Rectangle currentRectangle = null;
    protected FontRenderContext frc = null;

    public XORCaret() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                XORCaret.this.getComponent().repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isVisible()) {
            this.frc = ((Graphics2D)g).getFontRenderContext();
            JTextComponent c = this.getComponent();
            TextUI ui = c.getUI();
            Rectangle r = null;
            int dot = this.getDot();
            try {
                this.currentRectangle = r = ui.modelToView(c, dot);
            }
            catch (BadLocationException e) {
                return;
            }
            g.setColor(Color.red);
            this.lastPaintedWidth = this.currentWidth();
            g.fillRect(r.x, r.y, (int)this.lastPaintedWidth, r.height);
            g.setColor(c.getBackground());
            try {
                String s;
                if (dot < c.getDocument().getLength() && !Character.isISOControl((s = this.getComponent().getText(dot, 1)).charAt(0))) {
                    g.drawString(s, r.x, r.y + (int)this.currentAscent);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void damage(Rectangle r) {
    }

    protected double currentWidth() {
        Font f = this.getComponent().getFont();
        String current = null;
        try {
            current = this.getComponent().getText(this.getDot(), 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (f != this.currentFont) {
            this.currentLineMetrics = f.getLineMetrics(current, this.frc);
            this.currentAscent = this.currentLineMetrics.getAscent();
        }
        char currentChar = current != null && current.length() > 0 ? current.charAt(0) : (char)' ';
        return f.getStringBounds(Character.toString(currentChar), this.frc).getWidth();
    }
}

