/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class CfFileReader {
    protected Vector<Item> prop = new Vector();
    protected FileReader file = null;
    protected String cfStr = null;
    protected char currentChar;
    protected BufferedReader stream = null;

    protected char getCurrentChar() throws IOException {
        if (this.file != null) {
            return (char)this.file.read();
        }
        if (this.cfStr != null) {
            char c = this.cfStr.charAt(0);
            this.cfStr = this.cfStr.substring(1);
            return c;
        }
        if (this.stream != null) {
            return (char)this.stream.read();
        }
        return '\u0000';
    }

    protected boolean eof() throws IOException {
        if (this.file != null) {
            return !this.file.ready();
        }
        if (this.cfStr != null) {
            return this.cfStr.length() == 0;
        }
        if (this.stream != null) {
            return !this.stream.ready();
        }
        return true;
    }

    protected String readWord() throws IOException {
        boolean found = this.currentChar > ' ';
        Object ret = "";
        while (!this.eof() && !found) {
            this.currentChar = this.getCurrentChar();
            found = this.currentChar > ' ';
        }
        if (!found) {
            return null;
        }
        if (this.currentChar == '\'') {
            found = false;
            while (!this.eof() && !found) {
                this.currentChar = this.getCurrentChar();
                found = this.currentChar == '\'';
                if (found) continue;
                ret = (String)ret + this.currentChar;
            }
            if (!found) {
                System.out.println("CfFileReader.parse: ''' is missing");
                return null;
            }
            this.currentChar = this.getCurrentChar();
            return ret;
        }
        ret = (String)ret + this.currentChar;
        if (this.currentChar == ',' || this.currentChar == ':') {
            this.currentChar = this.getCurrentChar();
            return ret;
        }
        found = false;
        while (!this.eof() && !found) {
            this.currentChar = this.getCurrentChar();
            found = this.currentChar == ',' || this.currentChar == ':' || this.currentChar <= ' ';
            if (found) continue;
            ret = (String)ret + this.currentChar;
        }
        return ret;
    }

    protected boolean parse() throws IOException {
        this.prop.clear();
        this.currentChar = '\u0000';
        String word = this.readWord();
        while (word != null) {
            Item it = new Item(word);
            word = this.readWord();
            if (!word.equals(":")) {
                System.out.println("CfFileReader.parse: ':' expected instead of " + word);
                return false;
            }
            boolean sameItem = true;
            while (sameItem) {
                sameItem = false;
                word = this.readWord();
                if (word != null) {
                    it.addProp(word);
                }
                if ((word = this.readWord()) == null) continue;
                sameItem = word.equals(",");
            }
            this.prop.add(it);
        }
        return true;
    }

    public boolean parseText(String text) {
        boolean ok = false;
        try {
            this.cfStr = text;
            ok = this.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    public boolean readFile(String filename) {
        boolean ok = false;
        try {
            this.file = new FileReader(filename);
            ok = this.parse();
            this.file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    public boolean readFile(File file) {
        boolean ok = false;
        try {
            this.file = new FileReader(file);
            ok = this.parse();
            this.file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    public boolean readStream(BufferedReader stream) {
        boolean ok = false;
        try {
            this.stream = stream;
            ok = this.parse();
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    public Vector<String> getNames() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.prop.size(); ++i) {
            v.add(this.prop.get(i).toString());
        }
        return v;
    }

    public Vector<String> getParam(String name) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.prop.size()) {
            found = name.equals(this.prop.get(i).toString());
            if (found) continue;
            ++i;
        }
        if (found) {
            Item it = this.prop.get(i);
            return it.items;
        }
        return null;
    }

    public static void main(String[] args) {
        CfFileReader cf = new CfFileReader();
        if (cf.readFile("test.cfg")) {
            Vector<String> names = cf.getNames();
            System.out.println("Read " + names.size() + " params");
            for (int i = 0; i < names.size(); ++i) {
                System.out.println(names.get(i).toString());
                Vector<String> values = cf.getParam(names.get(i).toString());
                for (int j = 0; j < values.size(); ++j) {
                    System.out.println("   " + values.get(j).toString());
                }
            }
        } else {
            System.out.println("Error while reading config file");
        }
    }

    protected class Item {
        public Vector<String> items = new Vector();
        String name;

        public Item(String name) {
            this.name = name;
        }

        public void addProp(String value) {
            this.items.add(value);
        }

        public String toString() {
            return this.name;
        }
    }
}

