/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.LabelInfo;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.SearchInfo;
import fr.esrf.tangoatk.widget.util.chart.XYData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.invoke.StringConcatFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JComponent;

public class JLAxis
implements Serializable {
    public static final int HORIZONTAL_DOWN = 1;
    public static final int HORIZONTAL_UP = 2;
    public static final int HORIZONTAL_ORG1 = 3;
    public static final int HORIZONTAL_ORG2 = 4;
    public static final int VERTICAL_RIGHT = 5;
    public static final int VERTICAL_LEFT = 6;
    public static final int VERTICAL_ORG = 7;
    public static final int TIME_ANNO = 1;
    public static final int VALUE_ANNO = 2;
    public static final int LINEAR_SCALE = 0;
    public static final int LOG_SCALE = 1;
    public static final int AUTO_FORMAT = 0;
    public static final int SCIENTIFIC_FORMAT = 1;
    public static final int TIME_FORMAT = 2;
    public static final int DECINT_FORMAT = 3;
    public static final int HEXINT_FORMAT = 4;
    public static final int BININT_FORMAT = 5;
    public static final int SCIENTIFICINT_FORMAT = 6;
    public static final int DATE_FORMAT = 7;
    public static final String US_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FR_DATE_FORMAT = "dd-MM-yyyy HH:mm:ss.SSS";
    static final double YEAR = 3.1536E10;
    static final double MONTH = 2.592E9;
    static final double DAY = 8.64E7;
    static final double HOUR = 3600000.0;
    static final double MINU = 60000.0;
    static final double SECO = 1000.0;
    private boolean visible;
    private double min = 0.0;
    private double max = 100.0;
    private double minimum = 0.0;
    private double maximum = 100.0;
    private boolean autoScale = false;
    private int scale = 0;
    private Color labelColor;
    private Font labelFont;
    private int labelFormat;
    private Vector<LabelInfo> labels;
    private int orientation;
    private int dOrientation;
    private boolean subtickVisible;
    private Dimension csize = null;
    private String name = null;
    private int annotation = 2;
    private Vector<JLDataView> dataViews;
    private double ln10;
    private boolean gridVisible;
    private boolean subGridVisible;
    private int gridStyle;
    private Rectangle boundRect;
    private boolean lastAutoScale;
    private boolean isZoomed;
    private double percentScrollback;
    private double axisDuration = Double.POSITIVE_INFINITY;
    private String axeName;
    private SimpleDateFormat useFormat;
    private double desiredPrec;
    private boolean drawOpposite;
    private int tickLength;
    private int subtickLength;
    private int fontOverWidth;
    private boolean inverted = false;
    private double tickStep;
    private double minTickStep;
    private int subTickStep;
    private int subTickTimeAnno = 0;
    private boolean fitXAxisToDisplayDuration;
    private int vLabelWidth = 0;
    private boolean zeroAlwaysVisible = false;
    private boolean autoLabeling = true;
    private String[] userLabel = null;
    private double[] userLabelPos = null;
    private int labelOffsetX = 0;
    private int labelOffsetY = 0;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    private char decimalSeparator = (char)46;
    static final GregorianCalendar calendar = new GregorianCalendar();
    static final SimpleDateFormat genFormat = new SimpleDateFormat("dd/MM/yy HH:mm:ss.SSS");
    static final SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
    static final SimpleDateFormat monthFormat = new SimpleDateFormat("MMMMM yy");
    static final SimpleDateFormat weekFormat = new SimpleDateFormat("dd/MM/yy");
    static final SimpleDateFormat dayFormat = new SimpleDateFormat("EEE dd");
    static final SimpleDateFormat hour12Format = new SimpleDateFormat("EEE HH:mm");
    static final SimpleDateFormat hourFormat = new SimpleDateFormat("HH:mm");
    static final SimpleDateFormat secFormat = new SimpleDateFormat("HH:mm:ss");
    static final double[] timePrecs = new double[]{1000.0, 5000.0, 10000.0, 30000.0, 60000.0, 300000.0, 600000.0, 1800000.0, 3600000.0, 1.08E7, 2.16E7, 4.32E7, 8.64E7, 6.048E8, 2.592E9, 3.1536E10, 1.5768E11, 3.1536E11};
    static final SimpleDateFormat[] timeFormats = new SimpleDateFormat[]{secFormat, secFormat, secFormat, secFormat, secFormat, secFormat, secFormat, hourFormat, hourFormat, hourFormat, hourFormat, hour12Format, dayFormat, weekFormat, monthFormat, yearFormat, yearFormat, yearFormat};
    static final String[] labelFomats = new String[]{"%g", "", "%02d:%02d:%02d", "%d", "%X", "%b"};
    static final int[] triangleX = new int[]{0, 4, -4};
    static final int[] triangleY = new int[]{-3, 3, 3};
    static final Polygon triangleShape = new Polygon(triangleX, triangleY, 3);
    static final int[] diamondX = new int[]{0, 4, 0, -4};
    static final int[] diamondY = new int[]{4, 0, -4, 0};
    static final Polygon diamondShape = new Polygon(diamondX, diamondY, 4);
    static double[] logStep = new double[]{0.301, 0.477, 0.602, 0.699, 0.778, 0.845, 0.903, 0.954};

    public static String getHelpString() {
        return "-- Axis settings --\n  Parameter name is preceded by the axis name.\n\nvisible:true or false   Displays the axis\ngrid:true or false   Displays the grid\nsubgrid:true or false   Displays the sub grid\ngrid_style:style   (0 Solid,1 Dot, 2 Dash, 3 Long Dash)\nmin:value Axis minimum\nmax:value Axis maximum\nautoscale:true or false Axis autoscale\nscale:s   Axis scale (0 Linear ,1 Log)\nformat:format   Axis format (0 Auto,1 Sci,2 Time,3 Dec,4 Hex,5 Bin))\ntitle:'title'   Axis title ('null' to disable)\ncolor:r,g,b   Axis color\nlabel_font:name,style(0 Plain,1 Bold,2 italic),size\n";
    }

    public JLAxis(JComponent parent, int orientation) {
        this.labels = new Vector();
        this.labelFont = new Font("Dialog", 0, 11);
        this.labelColor = Color.black;
        this.orientation = orientation;
        this.dOrientation = orientation;
        this.inverted = !this.isHorizontal();
        this.dataViews = new Vector();
        this.ln10 = Math.log(10.0);
        this.gridVisible = false;
        this.subGridVisible = false;
        this.gridStyle = 1;
        this.labelFormat = 0;
        this.subtickVisible = true;
        this.boundRect = new Rectangle(0, 0, 0, 0);
        this.isZoomed = false;
        this.percentScrollback = 0.0;
        this.axeName = "";
        this.visible = true;
        this.drawOpposite = true;
        this.tickLength = 4;
        this.subtickLength = this.tickLength / 2;
        this.fontOverWidth = 0;
        this.minTickStep = 50.0;
        this.fitXAxisToDisplayDuration = true;
    }

    public void setPercentScrollback(double d) {
        this.percentScrollback = d / 100.0;
    }

    public double getPercentScrollback() {
        return this.percentScrollback * 100.0;
    }

    public void setAxisColor(Color c) {
        this.labelColor = c;
    }

    public Color getAxisColor() {
        return this.labelColor;
    }

    public void setLabelFormat(int l) {
        this.labelFormat = l;
    }

    public int getLabelFormat() {
        return this.labelFormat;
    }

    public void setGridVisible(boolean b) {
        this.gridVisible = b;
    }

    public void setFitXAxisToDisplayDuration(boolean b) {
        this.fitXAxisToDisplayDuration = b;
    }

    public boolean isFitXAxisToDisplayDuration() {
        return this.fitXAxisToDisplayDuration;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setDrawOpposite(boolean b) {
        this.drawOpposite = b;
    }

    public boolean isDrawOpposite() {
        return this.drawOpposite;
    }

    public void setSubGridVisible(boolean b) {
        this.subGridVisible = b;
    }

    public boolean isSubGridVisible() {
        return this.subGridVisible;
    }

    public void setGridStyle(int s) {
        this.gridStyle = s;
    }

    public int getGridStyle() {
        return this.gridStyle;
    }

    public void setFont(Font f) {
        this.labelFont = f;
    }

    public Font getFont() {
        return this.labelFont;
    }

    public void setAnnotation(int a) {
        this.annotation = a;
    }

    public int getAnnotation() {
        return this.annotation;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isZoomed() {
        return this.isZoomed;
    }

    public boolean isXY() {
        return this.dataViews.size() > 0;
    }

    public void setMinimum(double d) {
        this.minimum = d;
        if (!this.autoScale) {
            if (this.scale == 1) {
                if (d <= 0.0) {
                    d = 1.0;
                }
                this.min = Math.log(d) / this.ln10;
            } else {
                this.min = d;
            }
        }
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMaximum(double d) {
        this.maximum = d;
        if (!this.autoScale) {
            if (this.scale == 1) {
                if (this.max <= 0.0) {
                    this.max = this.min * 10.0;
                }
                this.max = Math.log(d) / this.ln10;
            } else {
                this.max = d;
            }
        }
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean b) {
        this.autoScale = b;
        this.lastAutoScale = b;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int s) {
        this.scale = s;
        if (this.scale == 1 && (this.minimum <= 0.0 || this.maximum <= 0.0)) {
            this.minimum = 1.0;
            this.maximum = 10.0;
        }
        if (this.scale == 1) {
            this.min = Math.log(this.minimum) / this.ln10;
            this.max = Math.log(this.maximum) / this.ln10;
        } else {
            this.min = this.minimum;
            this.max = this.maximum;
        }
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.dOrientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setTimeAnnoSubTickInterval(int nb) {
        this.subTickTimeAnno = nb;
    }

    public int getTimeAnnoSubTickInterval() {
        return this.subTickTimeAnno;
    }

    public boolean canApplyTimeSpan(int x1, int x2) {
        return !this.isZoomed && this.isHorizontal() && this.annotation == 1 && this.scale != 1 && x2 > this.boundRect.x + this.boundRect.width;
    }

    public void directZoom(double min, double max) {
        if (!this.isZoomed) {
            this.lastAutoScale = this.autoScale;
        }
        this.min = min;
        this.max = max;
        this.autoScale = false;
        this.isZoomed = true;
    }

    public void zoom(int x1, int x2) {
        if (!this.isZoomed) {
            this.lastAutoScale = this.autoScale;
        }
        if (this.isHorizontal()) {
            if (x1 < this.boundRect.x) {
                x1 = this.boundRect.x;
            }
            if (x2 > this.boundRect.x + this.boundRect.width) {
                x2 = this.boundRect.x + this.boundRect.width;
            }
            if (x2 - x1 < 10) {
                return;
            }
            double xr2 = (double)(x2 - this.boundRect.x) / (double)this.boundRect.width;
            double nmax = this.min + (this.max - this.min) * xr2;
            double xr1 = (double)(x1 - this.boundRect.x) / (double)this.boundRect.width;
            double nmin = this.min + (this.max - this.min) * xr1;
            double difference = nmax - nmin;
            if (difference < 1.0E-13) {
                return;
            }
            this.min = nmin;
            this.max = nmax;
        } else {
            if (x1 < this.boundRect.y) {
                x1 = this.boundRect.y;
            }
            if (x2 > this.boundRect.y + this.boundRect.height) {
                x2 = this.boundRect.y + this.boundRect.height;
            }
            if (x2 - x1 < 10) {
                return;
            }
            double yr2 = (double)(this.boundRect.y + this.boundRect.height - x1) / (double)this.boundRect.height;
            double nmax = this.min + (this.max - this.min) * yr2;
            double yr1 = (double)(this.boundRect.y + this.boundRect.height - x2) / (double)this.boundRect.height;
            double nmin = this.min + (this.max - this.min) * yr1;
            double difference = nmax - nmin;
            if (difference < 1.0E-13) {
                return;
            }
            this.min = nmin;
            this.max = nmax;
        }
        this.autoScale = false;
        this.isZoomed = true;
    }

    public void zoom(double r) {
        double nmin;
        double span;
        double middle;
        double nmax;
        double difference;
        if (!this.isZoomed) {
            this.lastAutoScale = this.autoScale;
        }
        if ((difference = (nmax = (middle = this.min + (span = (this.max - this.min) / 2.0)) + span * r) - (nmin = middle - span * r)) < 1.0E-13) {
            return;
        }
        this.min = nmin;
        this.max = nmax;
        this.autoScale = false;
        this.isZoomed = true;
    }

    public void translate(int x) {
        if (this.boundRect.width == 0 || this.boundRect.height == 0) {
            return;
        }
        if (!this.isZoomed) {
            this.lastAutoScale = this.autoScale;
        }
        if (this.isHorizontal()) {
            double t = (double)x / (double)this.boundRect.width * (this.max - this.min);
            this.min += t;
            this.max += t;
        } else {
            double t = (double)x / (double)this.boundRect.height * (this.max - this.min);
            this.min += t;
            this.max += t;
        }
        this.autoScale = false;
        this.isZoomed = true;
    }

    public void unzoom() {
        this.autoScale = this.lastAutoScale;
        if (!this.lastAutoScale) {
            this.setMinimum(this.getMinimum());
            this.setMaximum(this.getMaximum());
        }
        this.isZoomed = false;
    }

    public int getTick() {
        return (int)this.minTickStep;
    }

    public double getTickSpacing() {
        return this.minTickStep;
    }

    public void setTickSpacing(double spacing) {
        this.minTickStep = spacing;
    }

    public void setTick(int s) {
        this.minTickStep = s;
    }

    public void setTickLength(int lgth) {
        this.tickLength = lgth;
        this.subtickLength = this.tickLength / 2;
    }

    public int getTickLength() {
        return this.tickLength;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        int z = 0;
        if (s != null) {
            z = s.length();
        }
        this.name = z > 0 ? s : null;
    }

    public void setPosition(int o) {
        if (this.isHorizontal()) {
            if (o >= 1 && o <= 4) {
                this.orientation = o;
            }
        } else if (o >= 5 && o <= 7) {
            this.orientation = o;
        }
    }

    int getPosition() {
        return this.orientation;
    }

    public String getAxeName() {
        return this.axeName;
    }

    public void setAxeName(String s) {
        this.axeName = s;
    }

    public void addDataView(JLDataView v) {
        if (this.dataViews.contains(v)) {
            return;
        }
        if (!this.isHorizontal()) {
            this.dataViews.add(v);
            v.setAxis(this);
        } else {
            this.dataViews.clear();
            this.dataViews.add(v);
            v.setAxis(this);
            this.setAnnotation(2);
        }
    }

    public void addDataViewAt(int index, JLDataView v) {
        if (this.dataViews.contains(v)) {
            return;
        }
        if (!this.isHorizontal()) {
            this.dataViews.add(index, v);
            v.setAxis(this);
        } else {
            this.addDataView(v);
        }
    }

    public JLDataView getDataView(int index) {
        if (index < 0 || index >= this.dataViews.size()) {
            return null;
        }
        return this.dataViews.get(index);
    }

    public void removeDataView(JLDataView v) {
        this.dataViews.remove(v);
        v.setAxis(null);
        if (this.isHorizontal()) {
            this.setAnnotation(1);
            if (this.scale != 0) {
                this.setScale(0);
            }
        }
    }

    public boolean checkRemoveDataView(JLDataView v) {
        boolean contained = this.dataViews.remove(v);
        if (contained) {
            v.setAxis(null);
            if (this.isHorizontal()) {
                this.setAnnotation(1);
                if (this.scale != 0) {
                    this.setScale(0);
                }
            }
        }
        return contained;
    }

    public void clearDataView() {
        int sz = this.dataViews.size();
        for (int i = 0; i < sz; ++i) {
            JLDataView v = this.dataViews.get(i);
            v.setAxis(null);
        }
        this.dataViews.clear();
    }

    public Vector<JLDataView> getViews() {
        return this.dataViews;
    }

    public int getViewNumber() {
        return this.dataViews.size();
    }

    public void setInverted(boolean i) {
        this.inverted = i;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public Rectangle getBoundRect() {
        return this.boundRect;
    }

    public String toScientific(double d) {
        double a = Math.abs(d);
        int e = 0;
        String f = "%.2fe%d";
        if (a != 0.0) {
            if (a < 1.0) {
                while (a < 1.0) {
                    a *= 10.0;
                    --e;
                }
            } else {
                while (a >= 10.0) {
                    a /= 10.0;
                    ++e;
                }
            }
        }
        if (a >= 9.999999999) {
            a /= 10.0;
            ++e;
        }
        if (d < 0.0) {
            a = -a;
        }
        return String.format(f, a, e);
    }

    public String toScientificInt(double d) {
        double a = Math.abs(d);
        int e = 0;
        String f = "%de%d";
        if (a != 0.0) {
            if (a < 1.0) {
                while (a < 1.0) {
                    a *= 10.0;
                    --e;
                }
            } else {
                while (a >= 10.0) {
                    a /= 10.0;
                    ++e;
                }
            }
        }
        if (a >= 9.999999999) {
            a /= 10.0;
            ++e;
        }
        if (d < 0.0) {
            a = -a;
        }
        return String.format(f, (int)Math.rint(a), e);
    }

    public static String formatTimeValue(double vt) {
        calendar.setTimeInMillis((long)vt);
        Date date = calendar.getTime();
        return genFormat.format(date);
    }

    private void computeDateformat(int maxLab) {
        boolean found = false;
        int i = 0;
        while (i < timePrecs.length && !found) {
            int n = (int)((this.max - this.min) / timePrecs[i]);
            found = n <= maxLab;
            if (found) continue;
            ++i;
        }
        if (!found) {
            --i;
            this.desiredPrec = 3.1536E11;
            this.useFormat = yearFormat;
        } else {
            this.desiredPrec = timePrecs[i];
            this.useFormat = timeFormats[i];
        }
    }

    public void setLabelOffset(int x, int y) {
        this.labelOffsetX = x;
        this.labelOffsetY = y;
    }

    public void setLabels(String[] labels, double[] labelPos) {
        if (labels == null || labelPos == null) {
            this.userLabel = null;
            this.userLabelPos = null;
            this.autoLabeling = true;
            return;
        }
        if (labels.length != labelPos.length) {
            System.out.println("JLAxis.setLabels() : labels and labelPos must have the same size");
            return;
        }
        this.userLabel = labels;
        if (this.userLabel != null) {
            for (int i = 0; i < this.userLabel.length; ++i) {
                if (this.userLabel[i] != null) continue;
                this.userLabel[i] = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"null"});
            }
        }
        this.userLabelPos = labelPos;
        this.autoLabeling = false;
    }

    private String suppressZero(String n) {
        boolean hasExponent;
        boolean hasDecimal = n.indexOf(this.decimalSeparator) != -1;
        boolean bl = hasExponent = n.toLowerCase().indexOf("e") != -1;
        if (hasDecimal && !hasExponent) {
            StringBuffer str = new StringBuffer(n);
            int i = str.length() - 1;
            while (str.charAt(i) == '0') {
                str.deleteCharAt(i);
                --i;
            }
            if (str.charAt(i) == this.decimalSeparator) {
                str.deleteCharAt(i);
            }
            return str.toString();
        }
        return n;
    }

    public void setVLabelWidth(int width) {
        this.vLabelWidth = width;
    }

    public int getVLabelWidth() {
        return this.vLabelWidth;
    }

    public String formatValue(double vt, double prec) {
        if (Double.isNaN(vt)) {
            return "NaN";
        }
        if (prec != 0.0 && this.scale == 0) {
            boolean isNegative;
            boolean bl = isNegative = vt < 0.0;
            if (isNegative) {
                vt = -vt;
            }
            double i = Math.floor(vt / prec + 0.5);
            vt = i * prec;
            if (isNegative) {
                vt = -vt;
            }
        }
        switch (this.labelFormat) {
            case 1: {
                return this.toScientific(vt);
            }
            case 6: {
                return this.toScientificInt(vt);
            }
            case 3: 
            case 4: 
            case 5: {
                if (vt < 0.0) {
                    return "-" + String.format(labelFomats[this.labelFormat], (int)(Math.abs(vt) + 0.5));
                }
                return String.format(labelFomats[this.labelFormat], (int)(Math.abs(vt) + 0.5));
            }
            case 2: {
                int sec = (int)Math.abs(vt);
                int h = sec / 3600;
                int m = sec % 3600 / 60;
                int s = sec % 60;
                if (vt < 0.0) {
                    return "-" + String.format(labelFomats[this.labelFormat], h, m, s);
                }
                return String.format(labelFomats[this.labelFormat], h, m, s);
            }
            case 7: {
                SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
                long millisec = (long)(Math.abs(vt) * 1000.0);
                return format.format(new Date(millisec));
            }
        }
        if (vt == 0.0) {
            return "0";
        }
        if (Math.abs(vt) <= 1.0E-4) {
            return this.toScientific(vt);
        }
        int nbDigit = -((int)Math.floor(Math.log10(prec)));
        if (nbDigit <= 0) {
            return this.suppressZero(Double.toString(vt));
        }
        String dFormat = "%." + nbDigit + "f";
        return this.suppressZero(String.format(dFormat, vt));
    }

    private boolean isHorizontal() {
        return this.dOrientation == 1 || this.dOrientation == 2;
    }

    private double computeHighTen(double d) {
        int p = (int)Math.log10(d);
        return Math.pow(10.0, p + 1);
    }

    private double computeLowTen(double d) {
        int p = (int)Math.log10(d);
        return Math.pow(10.0, p);
    }

    public void computeAutoScale() {
        int i = 0;
        int sz = this.dataViews.size();
        double mi = 0.0;
        double ma = 0.0;
        if (this.autoScale && sz > 0) {
            this.min = Double.MAX_VALUE;
            this.max = -1.7976931348623157E308;
            for (i = 0; i < sz; ++i) {
                JLDataView v = this.dataViews.get(i);
                if (v.getDrawingMode() != 3) continue;
                if (v.hasTransform()) {
                    double[] mm = v.computeTransformedMinMax();
                    mi = mm[0];
                    ma = mm[1];
                } else {
                    mi = v.getMinimum();
                    ma = v.getMaximum();
                }
                if (this.scale == 1) {
                    if (mi <= 0.0) {
                        mi = v.computePositiveMin();
                    }
                    if (mi != Double.MAX_VALUE) {
                        mi = Math.log(mi) / this.ln10;
                    }
                    ma = ma <= 0.0 ? -1.7976931348623157E308 : Math.log(ma) / this.ln10;
                }
                if (ma > this.max) {
                    this.max = ma;
                }
                if (!(mi < this.min)) continue;
                this.min = mi;
            }
            if (this.min == Double.MAX_VALUE && this.max == -1.7976931348623157E308) {
                if (this.scale == 1) {
                    this.min = 0.0;
                    this.max = 1.0;
                } else {
                    this.min = 0.0;
                    this.max = 99.99;
                }
            } else if (this.zeroAlwaysVisible) {
                if (this.min < 0.0 && this.max < 0.0) {
                    this.max = 0.0;
                } else if (this.min > 0.0 && this.max > 0.0) {
                    this.min = 0.0;
                }
            }
            this.adjustMinMax();
            if (this.scale == 1) {
                double prec = this.computeLowTen(this.max - this.min);
                if (prec < 1.0) {
                    prec = 1.0;
                }
                this.min = this.min < 0.0 ? (double)((long)(this.min / prec) - 1L) * prec : (double)((long)(this.min / prec)) * prec;
                this.max = this.max < 0.0 ? (double)((long)(this.max / prec)) * prec : (double)((long)(this.max / prec) + 1L) * prec;
            } else {
                double prec = this.computeLowTen(this.max - this.min);
                double prec10 = prec / 10.0;
                this.min = this.min < 0.0 ? (double)((long)(this.min / prec10) - 1L) * prec10 : (double)((long)(this.min / prec10)) * prec10;
                this.max = this.max < 0.0 ? (double)((long)(this.max / prec10)) * prec10 : (double)((long)(this.max / prec10) + 1L) * prec10;
            }
        }
    }

    public void setAxisDuration(double d) {
        this.axisDuration = d;
    }

    public void computeXScale(Vector views) {
        int i = 0;
        int sz = views.size();
        if (this.isHorizontal() && this.autoScale && sz > 0) {
            if (!this.isXY()) {
                this.min = Double.MAX_VALUE;
                this.max = -1.7976931348623157E308;
                for (i = 0; i < sz; ++i) {
                    JLDataView v = (JLDataView)views.get(i);
                    if (v.getDrawingMode() != 3) continue;
                    double ma = v.getMaxXValue();
                    double mi = v.getMinXValue();
                    if (this.scale == 1) {
                        if (mi <= 0.0) {
                            mi = this.annotation == 2 ? v.getPositiveMinXValue() : v.getPositiveMinTime();
                        }
                        if (mi != Double.MAX_VALUE) {
                            mi = Math.log(mi) / this.ln10;
                        }
                        ma = ma <= 0.0 ? -1.7976931348623157E308 : Math.log(ma) / this.ln10;
                    }
                    if (ma > this.max) {
                        this.max = ma;
                    }
                    if (!(mi < this.min)) continue;
                    this.min = mi;
                }
                if (this.min == Double.MAX_VALUE && this.max == -1.7976931348623157E308) {
                    if (this.scale == 1) {
                        this.min = 0.0;
                        this.max = 1.0;
                    } else if (this.annotation == 1) {
                        this.min = (double)System.currentTimeMillis() - 3600000.0;
                        this.max = System.currentTimeMillis();
                    } else {
                        this.min = 0.0;
                        this.max = 99.99;
                    }
                }
                if (this.annotation == 1) {
                    if (this.axisDuration != Double.POSITIVE_INFINITY && this.fitXAxisToDisplayDuration) {
                        this.min = this.max - this.axisDuration;
                    }
                    this.max += (this.max - this.min) * this.percentScrollback;
                }
                this.adjustMinMax();
            } else {
                this.computeAutoScale();
            }
        }
    }

    private void adjustMinMax() {
        if (this.max - this.min < 1.0E-100) {
            this.max += 0.999;
            this.min -= 0.999;
        }
        if (this.max - this.min < 1.0E-100) {
            if (this.max < 0.0) {
                this.max /= 10.0;
                this.min *= 10.0;
            } else {
                this.max *= 10.0;
                this.min /= 10.0;
            }
        }
    }

    public int getFontHeight(Graphics g) {
        return this.getLabelFontDimension(null);
    }

    public int getLabelFontDimension(FontRenderContext frc) {
        if (!this.visible || frc == null) {
            return 5;
        }
        int hFont = (int)((double)this.labelFont.getLineMetrics("dummyStr0", frc).getHeight() + 0.5);
        if (this.isHorizontal()) {
            if (this.name != null) {
                if (this.orientation == 1 || this.orientation == 2) {
                    return 2 * hFont + 5;
                }
                return hFont + 5;
            }
            return hFont + 5;
        }
        if (this.name != null) {
            return hFont + 5;
        }
        return 5;
    }

    public int getFontOverWidth() {
        return this.fontOverWidth;
    }

    public int getThickness() {
        if (this.csize != null && this.visible) {
            if (!this.isHorizontal()) {
                return this.csize.width;
            }
            return this.csize.height;
        }
        return 0;
    }

    public int getLength() {
        if (this.csize != null) {
            if (this.isHorizontal()) {
                return this.csize.width;
            }
            return this.csize.height;
        }
        return 0;
    }

    public void measureAxis(FontRenderContext frc, int desiredWidth, int desiredHeight) {
        int max_width = 10;
        int max_height = 0;
        this.computeAutoScale();
        if (this.autoLabeling) {
            if (!this.isHorizontal()) {
                this.computeLabels(frc, desiredHeight);
            } else {
                this.computeLabels(frc, desiredWidth);
            }
        } else if (!this.isHorizontal()) {
            this.computeUserLabels(frc, desiredHeight);
        } else {
            this.computeUserLabels(frc, desiredWidth);
        }
        for (int i = 0; i < this.labels.size(); ++i) {
            LabelInfo li = this.labels.get(i);
            if (li.getWidth() > max_width) {
                max_width = li.getWidth();
            }
            if (li.getHeight() <= max_height) continue;
            max_height = li.getHeight();
        }
        this.fontOverWidth = max_width / 2 + 1;
        if (!this.isHorizontal()) {
            int w = max_width + this.getLabelFontDimension(frc);
            if (this.vLabelWidth > w) {
                w = this.vLabelWidth;
            }
            this.csize = new Dimension(w, desiredHeight);
        } else {
            this.csize = new Dimension(desiredWidth, max_height);
        }
    }

    public Point transform(double x, double y, JLAxis xAxis) {
        double vy;
        double vx;
        if (this.csize == null) {
            return new Point(-100, -100);
        }
        double xlength = xAxis.getMax() - xAxis.getMin();
        int xOrg = this.boundRect.x;
        int yOrg = this.boundRect.y + this.getLength();
        if (Double.isNaN(y) || Double.isNaN(x)) {
            return new Point(-100, -100);
        }
        if (xAxis.getScale() == 1) {
            if (x <= 0.0) {
                return new Point(-100, -100);
            }
            vx = Math.log(x) / this.ln10;
        } else {
            vx = x;
        }
        if (this.scale == 1) {
            if (y <= 0.0) {
                return new Point(-100, -100);
            }
            vy = Math.log(y) / this.ln10;
        } else {
            vy = y;
        }
        double xratio = (vx - xAxis.getMin()) / xlength * (double)xAxis.getLength();
        double yratio = -(vy - this.min) / (this.max - this.min) * (double)this.csize.height;
        if (xratio < -32000.0) {
            xratio = -32000.0;
        }
        if (xratio > 32000.0) {
            xratio = 32000.0;
        }
        if (yratio < -32000.0) {
            yratio = -32000.0;
        }
        if (yratio > 32000.0) {
            yratio = 32000.0;
        }
        return new Point((int)xratio + xOrg, (int)yratio + yOrg);
    }

    private int distance2(int x1, int y1, int x2, int y2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    public SearchInfo searchNearestNormal(int x, int y, JLAxis xAxis) {
        int sz = this.dataViews.size();
        int idx = 0;
        DataList minP = null;
        Point minPt = null;
        int minNorme = Integer.MAX_VALUE;
        JLDataView minDataView = null;
        int minPl = 0;
        int minIdx = -1;
        Rectangle boundRect2 = new Rectangle();
        boundRect2.setBounds(this.boundRect.x - 2, this.boundRect.y - 2, this.boundRect.width + 4, this.boundRect.height + 4);
        for (int i = 0; i < sz; ++i) {
            JLDataView v = this.dataViews.get(i);
            if (!v.isClickable()) continue;
            DataList e = v.getData();
            idx = 0;
            while (e != null) {
                int norme2;
                Point p = this.transform(e.x, v.getTransformedValue(e.y), xAxis);
                if (boundRect2.contains(p) && (norme2 = this.distance2(x, y, p.x, p.y)) < minNorme) {
                    minNorme = norme2;
                    minP = e;
                    minDataView = v;
                    minPt = p;
                    minIdx = idx;
                    minPl = p.x < this.boundRect.x + this.boundRect.width / 2 ? (p.y < this.boundRect.y + this.boundRect.height / 2 ? 3 : 1) : (p.y < this.boundRect.y + this.boundRect.height / 2 ? 2 : 0);
                }
                e = e.next;
                ++idx;
            }
        }
        if (minNorme == Integer.MAX_VALUE) {
            return new SearchInfo();
        }
        return new SearchInfo(minPt.x, minPt.y, minDataView, this, minP, minNorme, minPl, minIdx);
    }

    public SearchInfo searchNearestXY(int x, int y, JLAxis xAxis) {
        int sz = this.dataViews.size();
        DataList minP = null;
        DataList minXP = null;
        Point minPt = null;
        int minNorme = Integer.MAX_VALUE;
        JLDataView minDataView = null;
        int minPl = 0;
        JLDataView w = xAxis.getViews().get(0);
        Rectangle boundRect2 = new Rectangle();
        boundRect2.setBounds(this.boundRect.x - 2, this.boundRect.y - 2, this.boundRect.width + 4, this.boundRect.height + 4);
        for (int i = 0; i < sz; ++i) {
            JLDataView v = this.dataViews.get(i);
            if (!v.isClickable()) continue;
            XYData e = new XYData(v.getData(), w.getData());
            if (e.isValid()) {
                e.initFirstPoint();
            }
            while (e.isValid()) {
                int norme2;
                Point p = this.transform(w.getTransformedValue(e.d2.y), v.getTransformedValue(e.d1.y), xAxis);
                if (boundRect2.contains(p) && (norme2 = this.distance2(x, y, p.x, p.y)) < minNorme) {
                    minNorme = norme2;
                    minP = e.d1;
                    minXP = e.d2;
                    minDataView = v;
                    minPt = p;
                    minPl = p.x < this.boundRect.x + this.boundRect.width / 2 ? (p.y < this.boundRect.y + this.boundRect.height / 2 ? 3 : 1) : (p.y < this.boundRect.y + this.boundRect.height / 2 ? 2 : 0);
                }
                e.toNextXYPoint();
            }
        }
        if (minNorme == Integer.MAX_VALUE) {
            return new SearchInfo();
        }
        SearchInfo si = new SearchInfo(minPt.x, minPt.y, minDataView, this, minP, minNorme, minPl, -1);
        si.setXValue(minXP, w);
        return si;
    }

    public SearchInfo searchNearest(int x, int y, JLAxis xAxis) {
        if (x <= this.boundRect.x - 10 || x >= this.boundRect.x + this.boundRect.width + 10 || y <= this.boundRect.y - 10 || y >= this.boundRect.y + this.boundRect.height + 10) {
            return new SearchInfo();
        }
        if (xAxis.isXY()) {
            return this.searchNearestXY(x, y, xAxis);
        }
        return this.searchNearestNormal(x, y, xAxis);
    }

    private void computeUserLabels(FontRenderContext frc, double length) {
        double sz = this.max - this.min;
        double precDelta = sz / length;
        this.labels.clear();
        int offX = this.labelOffsetX;
        int offY = this.labelOffsetY;
        switch (this.dOrientation) {
            case 6: {
                offX += this.tickLength < 0 ? this.tickLength : 0;
                break;
            }
            case 5: {
                offX += this.tickLength < 0 ? -this.tickLength : 0;
                break;
            }
            default: {
                offY += this.tickLength < 0 ? -this.tickLength : 0;
            }
        }
        for (int i = 0; i < this.userLabel.length; ++i) {
            double upos = this.scale == 1 ? Math.log10(this.userLabelPos[i]) : this.userLabelPos[i];
            if (!(upos >= this.min - precDelta) || !(upos <= this.max + precDelta)) continue;
            int pos = this.inverted ? (int)Math.rint(length * (1.0 - (upos - this.min) / sz)) : (int)Math.rint(length * ((upos - this.min) / sz));
            Rectangle2D bounds = this.labelFont.getStringBounds(this.userLabel[i], frc);
            LabelInfo li = new LabelInfo(this.userLabel[i], (int)bounds.getWidth(), (int)bounds.getHeight(), pos);
            li.setOffset(offX, offY);
            this.labels.add(li);
        }
    }

    private void computeLabels(FontRenderContext frc, double length) {
        if (this.max < this.min) {
            double a = this.min;
            this.min = this.max;
            this.max = a;
        }
        if (Double.isInfinite(this.min) || Double.isInfinite(this.max) || Double.isNaN(this.min) || Double.isNaN(this.max)) {
            if (this.scale != 1) {
                this.min = 0.0;
                this.max = 100.0;
            } else {
                this.min = 0.0;
                this.max = 2.0;
            }
        }
        if (length <= 1.0) {
            length = 1.0;
        }
        double sz = this.max - this.min;
        int lgth = (int)length;
        double precDelta = sz / length;
        this.labels.clear();
        switch (this.annotation) {
            case 1: {
                double prec;
                this.computeDateformat(10);
                long round = (long)(this.min / this.desiredPrec);
                double startx = (double)(round + 1L) * this.desiredPrec;
                double pos = this.inverted ? length * (1.0 - (startx - this.min) / sz) : length * ((startx - this.min) / sz);
                calendar.setTimeInMillis((long)startx);
                Date date = calendar.getTime();
                String s = this.useFormat.format(date);
                Rectangle2D bounds = this.labelFont.getStringBounds(s, frc);
                int w = (int)bounds.getWidth();
                int h = (int)bounds.getHeight();
                this.labels.add(new LabelInfo(s, w, h, pos));
                double minStep = (double)w * 1.3;
                if (minStep < this.minTickStep) {
                    minStep = this.minTickStep;
                }
                double minPrec = minStep / length * sz;
                for (prec = this.desiredPrec; prec < minPrec; prec += this.desiredPrec) {
                }
                this.tickStep = length * prec / sz;
                startx += prec;
                if (this.inverted) {
                    this.tickStep = -this.tickStep;
                }
                this.subTickStep = this.subTickTimeAnno;
                while (startx <= this.max + precDelta) {
                    pos = this.inverted ? (double)((int)Math.rint(length * (1.0 - (startx - this.min) / sz))) : (double)((int)Math.rint(length * ((startx - this.min) / sz)));
                    calendar.setTimeInMillis((long)startx);
                    date = calendar.getTime();
                    s = this.useFormat.format(date);
                    bounds = this.labelFont.getStringBounds(s, frc);
                    if (pos > 0.0 && pos < (double)lgth) {
                        w = (int)bounds.getWidth();
                        h = (int)bounds.getHeight();
                        this.labels.add(new LabelInfo(s, w, h, pos));
                    }
                    startx += prec;
                }
                break;
            }
            case 2: {
                double startx;
                Rectangle2D bounds;
                String s;
                int nbMaxLab;
                double fontAscent = this.labelFont.getLineMetrics("0", frc).getAscent();
                double prec = this.computeLowTen(this.max - this.min);
                boolean extractLabel = false;
                if (!this.isHorizontal()) {
                    nbMaxLab = (int)(length / (2.0 * fontAscent));
                } else {
                    double maxT;
                    double minT;
                    if (this.scale == 1) {
                        minT = Math.pow(10.0, this.min);
                        maxT = Math.pow(10.0, this.max);
                    } else {
                        minT = this.min;
                        maxT = this.max;
                    }
                    s = this.formatValue(minT, prec);
                    bounds = this.labelFont.getStringBounds(s, frc);
                    double mW = bounds.getWidth();
                    s = this.formatValue(maxT, prec);
                    bounds = this.labelFont.getStringBounds(s, frc);
                    if (bounds.getWidth() > mW) {
                        mW = bounds.getWidth();
                    }
                    mW = 1.5 * mW;
                    nbMaxLab = (int)(length / mW);
                }
                int step = 0;
                int subStep = 0;
                int userMaxLab = (int)Math.rint(length / this.minTickStep);
                if (userMaxLab < nbMaxLab) {
                    nbMaxLab = userMaxLab;
                }
                if (nbMaxLab < 1) {
                    nbMaxLab = 1;
                }
                if (this.scale == 1) {
                    prec = 1.0;
                    step = -1;
                    startx = Math.rint(this.min);
                    n = (int)Math.rint((this.max - this.min) / prec);
                    while (n > nbMaxLab) {
                        step = 2;
                        n = (int)Math.rint((this.max - this.min) / (prec *= 2.0));
                        if (n <= nbMaxLab) continue;
                        step = 10;
                        n = (int)Math.rint((this.max - this.min) / (prec *= 5.0));
                    }
                    subStep = step;
                } else {
                    step = 10;
                    n = (int)Math.rint((this.max - this.min) / prec);
                    if (n <= nbMaxLab) {
                        n = (int)Math.rint((this.max - this.min) / (prec / 2.0));
                        while (n <= nbMaxLab) {
                            step = 5;
                            n = (int)Math.rint((this.max - this.min) / ((prec /= 2.0) / 5.0));
                            if (n > nbMaxLab) continue;
                            step = 10;
                            n = (int)Math.rint((this.max - this.min) / ((prec /= 5.0) / 2.0));
                        }
                    } else {
                        while (n > nbMaxLab) {
                            step = 5;
                            n = (int)Math.rint((this.max - this.min) / (prec *= 5.0));
                            if (n <= nbMaxLab) continue;
                            step = 10;
                            n = (int)Math.rint((this.max - this.min) / (prec *= 2.0));
                        }
                    }
                    long round = (long)Math.floor(this.min / prec);
                    int nbL = 0;
                    for (double sx = startx = (double)round * prec; sx <= this.max + precDelta; sx += prec) {
                        if (!(sx >= this.min - precDelta)) continue;
                        ++nbL;
                    }
                    if (nbL <= 2) {
                        if (step == 10) {
                            step = 5;
                            prec /= 2.0;
                        } else {
                            step = 10;
                            prec /= 5.0;
                        }
                        extractLabel = true;
                    }
                    double tickSpacing = Math.abs(prec / sz * length / (double)step);
                    subStep = step;
                    while (tickSpacing < 10.0 && subStep > 1) {
                        switch (subStep) {
                            case 10: {
                                subStep = 5;
                                tickSpacing *= 2.0;
                                break;
                            }
                            case 5: {
                                subStep = 2;
                                tickSpacing *= 2.5;
                                break;
                            }
                            case 2: {
                                subStep = 1;
                            }
                        }
                    }
                }
                this.tickStep = length * prec / sz;
                if (this.inverted) {
                    this.tickStep = -this.tickStep;
                }
                this.subTickStep = subStep;
                int offX = this.labelOffsetX;
                int offY = this.labelOffsetY;
                switch (this.dOrientation) {
                    case 6: {
                        offX += this.tickLength < 0 ? this.tickLength : 0;
                        break;
                    }
                    case 5: {
                        offX += this.tickLength < 0 ? -this.tickLength : 0;
                        break;
                    }
                    default: {
                        offY += this.tickLength < 0 ? -this.tickLength : 0;
                    }
                }
                String lastLabelText = "";
                double lastDiff = Double.MAX_VALUE;
                LabelInfo lastLabel = null;
                while (startx <= this.max + precDelta) {
                    double pos = this.inverted ? (double)((int)Math.rint(length * (1.0 - (startx - this.min) / sz))) : (double)((int)Math.rint(length * ((startx - this.min) / sz)));
                    double vt = this.scale == 1 ? Math.pow(10.0, startx) : startx;
                    String tempValue = this.formatValue(vt, prec);
                    double diff = 0.0;
                    if (this.labelFormat != 2 && this.labelFormat != 7) {
                        diff = Math.abs(Double.parseDouble(tempValue) - vt);
                    }
                    if (lastLabelText.equals(tempValue)) {
                        if (diff < lastDiff) {
                            s = new String(tempValue);
                            if (lastLabel != null) {
                                lastLabel.value = "";
                            }
                        } else {
                            s = "";
                        }
                    } else {
                        s = new String(tempValue);
                    }
                    lastDiff = diff;
                    lastLabelText = new String(tempValue);
                    bounds = this.labelFont.getStringBounds(s, frc);
                    if (startx >= this.min - precDelta) {
                        LabelInfo li = new LabelInfo(s, (int)bounds.getWidth(), (int)fontAscent, pos);
                        li.setOffset(offX, offY);
                        this.labels.add(li);
                        lastLabel = li;
                    }
                    startx += prec;
                }
                if (!extractLabel || this.labels.size() <= 2) break;
                Vector<LabelInfo> nLabels = new Vector<LabelInfo>();
                LabelInfo lis = this.labels.get(0);
                LabelInfo lie = this.labels.get(this.labels.size() - 1);
                nLabels.add(lis);
                nLabels.add(lie);
                this.tickStep = lie.pos - lis.pos;
                this.subTickStep = this.labels.size() - 1;
                this.labels = nLabels;
            }
        }
    }

    public void drawFast(Graphics g, Point lp, Point p, JLDataView v) {
        g.setClip(this.boundRect.x, this.boundRect.y, this.boundRect.width, this.boundRect.height);
        if (lp != null) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke old = g2.getStroke();
            BasicStroke bs = GraphicsUtils.createStrokeForLine(v.getLineWidth(), v.getStyle());
            if (bs != null) {
                g2.setStroke(bs);
            }
            g.setColor(v.getColor());
            g.drawLine(lp.x, lp.y, p.x, p.y);
            g2.setStroke(old);
        }
        Color oc = g.getColor();
        g.setColor(v.getMarkerColor());
        JLAxis.paintMarker(g, v.getMarker(), v.getMarkerSize(), p.x, p.y);
        g.setColor(oc);
    }

    public static void paintMarker(Graphics g, int mType, int mSize, int x, int y) {
        if (mSize == 0) {
            return;
        }
        if (mSize == 1) {
            g.drawLine(x, y, x, y);
            return;
        }
        int mSize2 = mSize / 2;
        int mSize21 = mSize / 2 + 1;
        switch (mType) {
            case 1: {
                g.fillOval(x - mSize2, y - mSize2, mSize, mSize);
                break;
            }
            case 2: {
                g.fillRect(x - mSize2, y - mSize2, mSize, mSize);
                break;
            }
            case 3: {
                triangleShape.translate(x, y);
                g.fillPolygon(triangleShape);
                triangleShape.translate(-x, -y);
                break;
            }
            case 4: {
                diamondShape.translate(x, y);
                g.fillPolygon(diamondShape);
                diamondShape.translate(-x, -y);
                break;
            }
            case 5: {
                g.drawLine(x - mSize2, y + mSize2, x + mSize21, y - mSize21);
                g.drawLine(x + mSize2, y + mSize2, x - mSize21, y - mSize21);
                g.drawLine(x, y - mSize2, x, y + mSize21);
                g.drawLine(x - mSize2, y, x + mSize21, y);
                break;
            }
            case 6: {
                g.drawLine(x, y - mSize2, x, y + mSize21);
                break;
            }
            case 7: {
                g.drawLine(x - mSize2, y, x + mSize21, y);
                break;
            }
            case 8: {
                g.drawLine(x, y - mSize2, x, y + mSize21);
                g.drawLine(x - mSize2, y, x + mSize21, y);
                break;
            }
            case 9: {
                g.drawOval(x - mSize2, y - mSize2, mSize + 1, mSize + 1);
                break;
            }
            case 10: {
                g.drawRect(x - mSize2, y - mSize2, mSize, mSize);
            }
        }
    }

    private void paintBarBorder(Graphics g, int barWidth, int y0, int x, int y) {
        g.drawLine(x - barWidth / 2, y, x + barWidth / 2, y);
        g.drawLine(x + barWidth / 2, y, x + barWidth / 2, y0);
        g.drawLine(x + barWidth / 2, y0, x - barWidth / 2, y0);
        g.drawLine(x - barWidth / 2, y0, x - barWidth / 2, y);
    }

    private void paintBar(Graphics g, Paint pattern, int barWidth, Color background, int fillStyle, int y0, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        if (fillStyle != 0) {
            if (pattern != null) {
                g2.setPaint(pattern);
            } else {
                g2.setColor(background);
            }
            if (y > y0) {
                if (y - y0 == 0) {
                    g.fillRect(x - barWidth / 2, y0, barWidth, 1);
                } else {
                    g.fillRect(x - barWidth / 2, y0, barWidth, y - y0);
                }
            } else if (y - y0 == 0) {
                g.fillRect(x - barWidth / 2, y, barWidth, 1);
            } else {
                g.fillRect(x - barWidth / 2, y, barWidth, y0 - y);
            }
        }
    }

    public static void drawSampleLine(Graphics g, int x, int y, JLDataView v) {
        Color oc = g.getColor();
        Graphics2D g2 = (Graphics2D)g;
        Stroke old = g2.getStroke();
        BasicStroke bs = GraphicsUtils.createStrokeForLine(v.getLineWidth(), v.getStyle());
        if (bs != null) {
            g2.setStroke(bs);
        }
        if (v.getViewType() == 0) {
            if (v.getLineWidth() > 0) {
                g.drawLine(x, y, x + 40, y);
            }
            g.setColor(v.getMarkerColor());
            JLAxis.paintMarker(g, v.getMarker(), v.getMarkerSize(), x + 20, y);
        } else if (v.getViewType() == 1) {
            if (v.getFillStyle() != 0) {
                g.setColor(v.getFillColor());
                g.fillRect(x + 16, y - 4, 8, 8);
            }
            g.setColor(v.getColor());
            if (bs != null) {
                g2.setStroke(bs);
            }
            if (v.getLineWidth() > 0) {
                g.drawLine(x + 16, y - 4, x + 24, y - 4);
                g.drawLine(x + 24, y - 4, x + 24, y + 4);
                g.drawLine(x + 24, y + 4, x + 16, y + 4);
                g.drawLine(x + 16, y + 4, x + 16, y - 4);
            }
        }
        g2.setStroke(old);
        g.setColor(oc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintDataViews(Graphics g, JLAxis xAxis, int xOrg, int yOrg) {
        int nbView = this.dataViews.size();
        boolean isXY = xAxis.isXY();
        JLDataView vx = null;
        int xClip = xOrg + 1;
        int yClip = yOrg - this.getLength() + 1;
        int wClip = xAxis.getLength() - 1;
        int hClip = this.getLength() - 1;
        if (wClip <= 1 || hClip <= 1) {
            return;
        }
        g.clipRect(xClip, yClip, wClip, hClip);
        if (isXY) {
            JLDataView jLDataView = vx = xAxis.getViews().get(0);
            synchronized (jLDataView) {
                for (int k = 0; k < nbView; ++k) {
                    JLDataView v;
                    JLDataView jLDataView2 = v = this.dataViews.get(k);
                    synchronized (jLDataView2) {
                        this.paintDataViewXY(g, v, vx, xAxis, xOrg, yOrg);
                        continue;
                    }
                }
            }
        } else {
            for (int k = 0; k < nbView; ++k) {
                JLDataView v;
                JLDataView jLDataView = v = this.dataViews.get(k);
                synchronized (jLDataView) {
                    this.paintDataViewNormal(g, v, xAxis, xOrg, yOrg);
                    continue;
                }
            }
        }
    }

    private int computeBarWidth(JLDataView v, JLAxis xAxis) {
        int defaultWidth = 20;
        double minx = xAxis.getMin();
        double maxx = xAxis.getMax();
        int bw = v.getBarWidth();
        double minI = Double.MAX_VALUE;
        if (bw > 0) {
            return bw;
        }
        if (xAxis.getScale() == 1) {
            return defaultWidth;
        }
        if (xAxis.isXY()) {
            JLDataView vx = xAxis.getViews().get(0);
            DataList d = vx.getData();
            if (d != null) {
                double x = d.y;
                d = d.next;
                while (d != null) {
                    double diff = Math.abs(d.y - x);
                    if (diff < minI) {
                        minI = diff;
                    }
                    x = d.y;
                    d = d.next;
                }
            }
        } else {
            DataList d = v.getData();
            if (d != null) {
                double x = d.x;
                d = d.next;
                while (d != null) {
                    double diff = Math.abs(d.x - x);
                    if (diff < minI) {
                        minI = diff;
                    }
                    x = d.x;
                    d = d.next;
                }
            }
        }
        if (minI == Double.MAX_VALUE) {
            return defaultWidth;
        }
        bw = (int)Math.floor(minI / (maxx - minx) * (double)xAxis.getLength()) - 2;
        bw /= 2;
        if ((bw *= 2) < 0) {
            bw = 0;
        }
        return bw;
    }

    private void paintSingleBar(Graphics2D g2, JLDataView v, int barWidth, BasicStroke bs, Paint fPattern, int y0, int x, int y, int idx) {
        if (idx >= 0) {
            Color fillColor = v.getBarFillColorAt(idx);
            if (fillColor == null) {
                this.paintBar(g2, fPattern, barWidth, v.getFillColor(), v.getFillStyle(), y0, x, y);
            } else {
                this.paintBar(g2, null, barWidth, fillColor, v.getFillStyle(), y0, x, y);
            }
        } else {
            this.paintBar(g2, fPattern, barWidth, v.getFillColor(), v.getFillStyle(), y0, x, y);
        }
        if (v.getLineWidth() > 0) {
            Stroke old = g2.getStroke();
            if (bs != null) {
                g2.setStroke(bs);
            }
            g2.setColor(v.getColor());
            this.paintBarBorder(g2, barWidth, y0, x, y);
            g2.setStroke(old);
        }
    }

    private void paintSegmentPolyline(Graphics2D g2, JLDataView v, BasicStroke bs, Paint fPattern, int nb, int yOrg, int[] pointX, int[] pointY) {
        if (nb > 1 && v.getViewType() == 0) {
            if (v.getFillStyle() != 0) {
                int[] Xs = new int[nb + 2];
                int[] Ys = new int[nb + 2];
                for (int i = 0; i < nb; ++i) {
                    Xs[i + 1] = pointX[i];
                    Ys[i + 1] = pointY[i];
                }
                Xs[0] = Xs[1];
                Ys[0] = yOrg;
                Xs[nb + 1] = Xs[nb];
                Ys[nb + 1] = yOrg;
                if (fPattern != null) {
                    g2.setPaint(fPattern);
                }
                g2.fillPolygon(Xs, Ys, nb + 2);
            }
            if (v.getLineWidth() > 0) {
                Stroke old = g2.getStroke();
                if (bs != null) {
                    g2.setStroke(bs);
                }
                g2.setColor(v.getColor());
                g2.drawPolyline(pointX, pointY, nb);
                g2.setStroke(old);
            }
        }
    }

    private void paintDataViewBar(Graphics2D g2, BasicStroke bs, Paint fPattern, JLDataView v, DataList l, int startOffset, JLAxis xAxis, int xOrg, int yOrg, int y0, int xMin, int xMax, int yMin, int yMax, double iX, double iY) {
        boolean end;
        int px = 0;
        int py = 0;
        double A0 = v.getA0();
        double A1 = v.getA1();
        double A2 = v.getA2();
        boolean showMarker = v.getMarker() > 0;
        boolean isXLogScale = xAxis.getScale() == 1;
        boolean isYLogScale = this.getScale() == 1;
        int nb = startOffset;
        double minx = xAxis.getMin();
        double miny = this.min;
        double ly = this.getLength();
        int barWidth = this.computeBarWidth(v, xAxis);
        boolean bl = end = l == null;
        while (!end) {
            boolean validY;
            double ly2 = l.y * l.y;
            double vt = A0 + A1 * l.y + A2 * ly2;
            boolean isNaN = Double.isNaN(vt);
            boolean validX = !isXLogScale || l.x > 1.0E-100;
            boolean bl2 = validY = !isNaN && (!isYLogScale || vt > 1.0E-100);
            if (validX) {
                double xratio = isXLogScale ? (Math.log(l.x) / this.ln10 - minx) * iX : (l.x - minx) * iX;
                px = (int)(xratio + (double)xOrg);
                if (validY) {
                    yratio = isYLogScale ? -(Math.log(vt) / this.ln10 - miny) * iY : -(vt - miny) * iY;
                    py = (int)(yratio + (double)yOrg);
                    if (px >= xMin && px <= xMax) {
                        this.paintSingleBar(g2, v, barWidth, bs, fPattern, y0, px, py, nb);
                        if (showMarker && py >= yMin && py <= yMax) {
                            g2.setColor(v.getMarkerColor());
                            JLAxis.paintMarker(g2, v.getMarker(), v.getMarkerSize(), px, py);
                        }
                    }
                } else if (isNaN && v.isDrawOnNaN()) {
                    yratio = -ly;
                    py = (int)(yratio + (double)yOrg);
                    if (px >= xMin && px <= xMax) {
                        this.paintSingleBar(g2, v, barWidth, bs, fPattern, y0, px, py, nb);
                    }
                }
                end = (l = l.next) == null || px > xMax;
            } else {
                l = l.next;
                end = l == null;
            }
            ++nb;
        }
    }

    private void PaintDataViewHighDensity(Graphics2D g2, BasicStroke bs, Paint fPattern, JLDataView v, DataList l, JLAxis xAxis, int xOrg, int yOrg, int y0, int xMin, int xMax, int yMin, int yMax, double iX, double iY) {
        double A0 = v.getA0();
        double A1 = v.getA1();
        double A2 = v.getA2();
        boolean isXLogScale = xAxis.getScale() == 1;
        boolean isYLogScale = this.getScale() == 1;
        double minx = xAxis.getMin();
        double miny = this.min;
        boolean showMarker = v.getMarker() > 0;
        int xDim = xMax - xMin + 1;
        int xin = Integer.MIN_VALUE;
        int yin = 0;
        int xout = Integer.MIN_VALUE;
        int yout = 0;
        int[] mins = new int[xDim];
        int[] maxs = new int[xDim];
        int[] hin = new int[xDim];
        int[] hout = new int[xDim];
        for (int i = 0; i < xDim; ++i) {
            mins[i] = Integer.MAX_VALUE;
            maxs[i] = Integer.MIN_VALUE;
            hin[i] = Integer.MIN_VALUE;
            hout[i] = Integer.MIN_VALUE;
        }
        boolean end = l == null;
        boolean valid = true;
        while (!end) {
            double ly2 = l.y * l.y;
            double vt = A0 + A1 * l.y + A2 * ly2;
            boolean isNaN = Double.isNaN(vt);
            boolean bl = valid = !isNaN && (!isYLogScale || vt > 1.0E-100);
            if (valid) {
                double xratio = isXLogScale ? (Math.log(l.x) / this.ln10 - minx) * iX : (l.x - minx) * iX;
                double yratio = isYLogScale ? -(Math.log(vt) / this.ln10 - miny) * iY : -(vt - miny) * iY;
                int px = (int)xratio;
                int py = (int)yratio;
                if (px < 0) {
                    xin = px;
                    yin = py;
                } else if (px >= xDim) {
                    xout = px;
                    yout = py;
                } else {
                    if (hin[px] == Integer.MIN_VALUE) {
                        hin[px] = py;
                    }
                    if (py >= maxs[px]) {
                        maxs[px] = py;
                    }
                    if (py <= mins[px]) {
                        mins[px] = py;
                    }
                    hout[px] = py;
                }
                l = l.next;
                end = l == null || px >= xDim;
                continue;
            }
            l = l.next;
            end = l == null;
        }
        int fxin = xin;
        int fyin = yin;
        if (v.getLineWidth() > 0) {
            Stroke old = g2.getStroke();
            if (bs != null) {
                g2.setStroke(bs);
            }
            g2.setColor(v.getColor());
            for (int i = 0; i < xDim; ++i) {
                if (mins[i] > maxs[i]) continue;
                if (xin != Integer.MIN_VALUE) {
                    g2.drawLine(xin + xOrg, yin + yOrg, i + xOrg, hin[i] + yOrg);
                }
                g2.drawLine(i + xOrg, maxs[i] + yOrg, i + xOrg, mins[i] + yOrg);
                xin = i;
                yin = hout[i];
            }
            if (xout != Integer.MIN_VALUE) {
                g2.drawLine(xin + xOrg, yin + yOrg, xout + xOrg, yout + yOrg);
            }
            g2.setStroke(old);
        }
        if (showMarker) {
            xin = fxin;
            yin = fyin;
            for (int i = 0; i < xDim; ++i) {
                if (mins[i] > maxs[i]) continue;
                if (xin != Integer.MIN_VALUE && yin + yOrg >= yMin && yin + yOrg <= yMax) {
                    g2.setColor(v.getMarkerColor());
                    JLAxis.paintMarker(g2, v.getMarker(), v.getMarkerSize(), xin + xOrg, yin + yOrg);
                }
                xin = i;
                yin = hout[i];
            }
        }
    }

    private void paintDataViewPolyline(Graphics2D g2, BasicStroke bs, Paint fPattern, JLDataView v, DataList list, JLAxis xAxis, int xOrg, int yOrg, int y0, int xMin, int xMax, int yMin, int yMax, double iX, double iY) {
        boolean end;
        double density;
        double xratio;
        int maxNbPoint;
        int px = 0;
        int py = 0;
        double A0 = v.getA0();
        double A1 = v.getA1();
        double A2 = v.getA2();
        boolean valid = true;
        boolean showMarker = v.getMarker() > 0;
        boolean isXLogScale = xAxis.getScale() == 1;
        boolean isYLogScale = this.getScale() == 1;
        int nb = 0;
        double minx = xAxis.getMin();
        double miny = this.min;
        boolean followX = (v.getDrawingMode() & 1) != 0;
        boolean followY = (v.getDrawingMode() & 2) != 0;
        DataList l = list;
        int n = maxNbPoint = followX ? 1 : v.getDataLength();
        if (followX) {
            boolean found = false;
            DataList f = l;
            while (f != null && !found) {
                xratio = isXLogScale ? (Math.log(f.x) / this.ln10 - minx) * iX : (f.x - minx) * iX;
                px = (int)(xratio + (double)xOrg);
                found = px > xMax;
                if (found) continue;
                ++maxNbPoint;
                f = f.next;
            }
        }
        if ((density = (double)maxNbPoint / (double)(xMax - xMin)) > 20.0 && v.getDrawingMode() == 3) {
            this.PaintDataViewHighDensity(g2, bs, fPattern, v, l, xAxis, xOrg, yOrg, y0, xMin, xMax, yMin, yMax, iX, iY);
            return;
        }
        int[] pointX = new int[maxNbPoint];
        int[] pointY = new int[maxNbPoint];
        boolean bl = end = l == null;
        while (!end) {
            double ly2 = l.y * l.y;
            while (valid && !end) {
                double vt = A0 + A1 * l.y + A2 * ly2;
                boolean isNaN = Double.isNaN(vt);
                boolean bl2 = valid = !isNaN && (!isYLogScale || vt > 1.0E-100);
                if (valid) {
                    xratio = isXLogScale ? (Math.log(l.x) / this.ln10 - minx) * iX : (l.x - minx) * iX;
                    double yratio = isYLogScale ? -(Math.log(vt) / this.ln10 - miny) * iY : -(vt - miny) * iY;
                    px = (int)(xratio + (double)xOrg);
                    py = (int)(yratio + (double)yOrg);
                    pointX[nb] = followX ? px : (int)(-minx * iX + (double)xOrg + l.x);
                    int n2 = pointY[nb] = followY ? py : (int)(miny * iY + (double)yOrg - l.y);
                    if (showMarker && py >= yMin && py <= yMax) {
                        g2.setColor(v.getMarkerColor());
                        JLAxis.paintMarker(g2, v.getMarker(), v.getMarkerSize(), pointX[nb], pointY[nb]);
                    }
                    ++nb;
                    l = l.next;
                    end = l == null || followX && px > xMax;
                    continue;
                }
                end = l == null;
            }
            this.paintSegmentPolyline(g2, v, bs, fPattern, nb, y0, pointX, pointY);
            nb = 0;
            if (end || valid) continue;
            l = l.next;
            end = l == null;
            valid = true;
        }
    }

    private void paintDataViewNormal(Graphics g, JLDataView v, JLAxis xAxis, int xOrg, int yOrg) {
        DataList l = v.getData();
        if (l == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        double minx = xAxis.getMin();
        double maxx = xAxis.getMax();
        double lx = xAxis.getLength();
        double miny = this.min;
        double maxy = this.max;
        double ly = this.getLength();
        boolean isXLogScale = xAxis.getScale() == 1;
        boolean isYLogScale = this.getScale() == 1;
        BasicStroke bs = GraphicsUtils.createStrokeForLine(v.getLineWidth(), v.getStyle());
        Paint fPattern = GraphicsUtils.createPatternForFilling(v.getFillStyle(), v.getFillColor(), v.getColor());
        int y0 = switch (v.getFillMethod()) {
            case 0 -> yOrg - (int)ly;
            case 1 -> {
                if (this.scale == 1) {
                    yield yOrg;
                }
                yield (int)(miny / (maxy - miny) * ly) + yOrg;
            }
            default -> yOrg;
        };
        int xMin = xOrg + 1;
        int xMax = xMin + xAxis.getLength() - 1;
        int yMin = yOrg - this.getLength() + 1;
        int yMax = yMin + this.getLength() - 1;
        double iX = 1.0 / (maxx - minx) * lx;
        double iY = 1.0 / (maxy - miny) * ly;
        int start = 0;
        boolean found = false;
        DataList prec = null;
        while (l != null && !found) {
            boolean validX;
            boolean bl = validX = !isXLogScale || l.x > 1.0E-100;
            if (validX) {
                double xratio = isXLogScale ? (Math.log(l.x) / this.ln10 - minx) * iX : (l.x - minx) * iX;
                int px = (int)(xratio + (double)xOrg);
                boolean bl2 = found = px > xMin;
            }
            if (found) continue;
            prec = l;
            l = l.next;
            ++start;
        }
        if (prec != null) {
            l = prec;
            --start;
        } else {
            start = 0;
        }
        if (l == null) {
            return;
        }
        if (v.getViewType() == 1) {
            this.paintDataViewBar(g2, bs, fPattern, v, l, start, xAxis, xOrg, yOrg, y0, xMin, xMax, yMin, yMax, iX, iY);
        } else {
            this.paintDataViewPolyline(g2, bs, fPattern, v, l, xAxis, xOrg, yOrg, y0, xMin, xMax, yMin, yMax, iX, iY);
        }
    }

    private void paintDataViewXY(Graphics g, JLDataView v, JLDataView w, JLAxis xAxis, int xOrg, int yOrg) {
        XYData l = new XYData(v.getData(), w.getData());
        if (l.isValid()) {
            boolean showBar;
            int nbPoint = v.getDataLength() + w.getDataLength();
            int[] pointX = new int[nbPoint];
            int[] pointY = new int[nbPoint];
            double A0y = v.getA0();
            double A1y = v.getA1();
            double A2y = v.getA2();
            double A0x = w.getA0();
            double A1x = w.getA1();
            double A2x = w.getA2();
            double minx = xAxis.getMin();
            double maxx = xAxis.getMax();
            double lx = xAxis.getLength();
            int sx = xAxis.getScale();
            double miny = this.min;
            double maxy = this.max;
            double ly = this.getLength();
            int j = 0;
            boolean valid = true;
            int y0 = switch (v.getFillMethod()) {
                case 0 -> yOrg - (int)ly;
                case 1 -> {
                    if (this.scale == 1) {
                        yield yOrg;
                    }
                    yield (int)(miny / (maxy - miny) * ly) + yOrg;
                }
                default -> yOrg;
            };
            Graphics2D g2 = (Graphics2D)g;
            BasicStroke bs = GraphicsUtils.createStrokeForLine(v.getLineWidth(), v.getStyle());
            Paint fPattern = GraphicsUtils.createPatternForFilling(v.getFillStyle(), v.getFillColor(), v.getColor());
            int barWidth = this.computeBarWidth(v, xAxis);
            boolean bl = showBar = v.getViewType() == 1;
            while (l.isValid()) {
                l.initFirstPoint();
                while (valid && l.isValid()) {
                    double vty = A0y + A1y * l.d1.y + A2y * l.d1.y * l.d1.y;
                    double vtx = A0x + A1x * l.d2.y + A2x * l.d2.y * l.d2.y;
                    valid = !Double.isNaN(vtx) && !Double.isNaN(vty) && (sx != 1 || vtx > 1.0E-100) && (this.scale != 1 || vty > 1.0E-100);
                    if (!valid) continue;
                    double xratio = sx == 1 ? (Math.log(vtx) / this.ln10 - minx) / (maxx - minx) * lx : (vtx - minx) / (maxx - minx) * lx;
                    double yratio = this.scale == 1 ? -(Math.log(vty) / this.ln10 - miny) / (maxy - miny) * ly : -(vty - miny) / (maxy - miny) * ly;
                    if (xratio < -32000.0) {
                        xratio = -32000.0;
                    }
                    if (xratio > 32000.0) {
                        xratio = 32000.0;
                    }
                    if (yratio < -32000.0) {
                        yratio = -32000.0;
                    }
                    if (yratio > 32000.0) {
                        yratio = 32000.0;
                    }
                    if (j < nbPoint) {
                        pointX[j] = (int)xratio + xOrg;
                        pointY[j] = (int)yratio + yOrg;
                        if (v.getMarker() > 0) {
                            g.setColor(v.getMarkerColor());
                            JLAxis.paintMarker(g, v.getMarker(), v.getMarkerSize(), pointX[j], pointY[j]);
                        }
                        if (showBar) {
                            this.paintSingleBar(g2, v, barWidth, bs, fPattern, y0, pointX[j], pointY[j], -1);
                        }
                        ++j;
                    }
                    l.toNextXYPoint();
                }
                this.paintSegmentPolyline(g2, v, bs, fPattern, j, y0, pointX, pointY);
                j = 0;
                if (valid) continue;
                l.toNextXYPoint();
                valid = true;
            }
        }
    }

    private void paintYOutTicks(Graphics g, int x0, double ys, int y0, int la, BasicStroke bs, int tr, int off, boolean grid) {
        block4: {
            Stroke old;
            Graphics2D g2;
            block5: {
                g2 = (Graphics2D)g;
                old = g2.getStroke();
                if (!this.subtickVisible) break block4;
                if (this.subTickStep != -1) break block5;
                for (int j = 0; j < logStep.length; ++j) {
                    int h = (int)Math.rint(ys + this.tickStep * logStep[j]);
                    if (h < y0 || h > y0 + this.csize.height) continue;
                    g.drawLine(x0 + tr + off, h, x0 + tr + off + this.subtickLength, h);
                    if (!this.gridVisible || !this.subGridVisible || !grid) continue;
                    if (bs != null) {
                        g2.setStroke(bs);
                    }
                    g.drawLine(x0, h, x0 + la, h);
                    g2.setStroke(old);
                }
                break block4;
            }
            if (this.subTickStep <= 0) break block4;
            double r = 1.0 / (double)this.subTickStep;
            for (int j = 0; j < this.subTickStep; ++j) {
                int h = (int)Math.rint(ys + this.tickStep * r * (double)j);
                if (h < y0 || h > y0 + this.csize.height) continue;
                g.drawLine(x0 + tr + off, h, x0 + tr + off + this.subtickLength, h);
                if (j <= 0 || !this.gridVisible || !this.subGridVisible || !grid) continue;
                if (bs != null) {
                    g2.setStroke(bs);
                }
                g.drawLine(x0, h, x0 + la, h);
                g2.setStroke(old);
            }
        }
    }

    private void paintXOutTicks(Graphics g, int y0, double xs, int x0, int la, BasicStroke bs, int tr, int off, boolean grid) {
        block4: {
            Stroke old;
            Graphics2D g2;
            block5: {
                g2 = (Graphics2D)g;
                old = g2.getStroke();
                if (!this.subtickVisible) break block4;
                if (this.subTickStep != -1) break block5;
                for (int j = 0; j < logStep.length; ++j) {
                    int w = (int)Math.rint(xs + this.tickStep * logStep[j]);
                    if (w < x0 || w > x0 + this.csize.width) continue;
                    g.drawLine(w, y0 + tr + off, w, y0 + tr + off + this.subtickLength);
                    if (!this.gridVisible || !this.subGridVisible || !grid) continue;
                    if (bs != null) {
                        g2.setStroke(bs);
                    }
                    g.drawLine(w, y0, w, y0 + la);
                    g2.setStroke(old);
                }
                break block4;
            }
            if (this.subTickStep <= 0) break block4;
            double r = 1.0 / (double)this.subTickStep;
            for (int j = 0; j < this.subTickStep; ++j) {
                int w = (int)Math.rint(xs + this.tickStep * r * (double)j);
                if (w < x0 || w > x0 + this.csize.width) continue;
                g.drawLine(w, y0 + tr + off, w, y0 + tr + off + this.subtickLength);
                if (j <= 0 || !this.gridVisible || !this.subGridVisible || !grid) continue;
                if (bs != null) {
                    g2.setStroke(bs);
                }
                g.drawLine(w, y0, w, y0 + la);
                g2.setStroke(old);
            }
        }
    }

    private int getTickShift(int width) {
        int off = 0;
        switch (this.dOrientation) {
            case 6: {
                if (this.orientation != 7) break;
                off = -width / 2;
                break;
            }
            case 5: {
                if (this.orientation == 7) {
                    off = -width / 2;
                    break;
                }
                off = -width;
                break;
            }
            case 1: 
            case 2: {
                off = this.orientation == 3 || this.orientation == 4 ? -width / 2 : (this.orientation == 2 ? 0 : -width);
            }
        }
        return off;
    }

    private int getTickShiftOpposite(int width) {
        int off = 0;
        switch (this.dOrientation) {
            case 5: {
                if (this.orientation != 7) break;
                off = -width / 2;
                break;
            }
            case 6: {
                if (this.orientation == 7) {
                    off = -width / 2;
                    break;
                }
                off = -width;
                break;
            }
            case 1: 
            case 2: {
                off = this.orientation == 3 || this.orientation == 4 ? -width / 2 : (this.orientation == 2 ? -width : 0);
            }
        }
        return off;
    }

    private void paintYTicks(Graphics g, int i, int x0, double y, int la, BasicStroke bs, int tr, int off, boolean grid) {
        block4: {
            Stroke old;
            Graphics2D g2;
            block5: {
                g2 = (Graphics2D)g;
                old = g2.getStroke();
                if (!this.subtickVisible || i >= this.labels.size() - 1) break block4;
                if (this.subTickStep != -1) break block5;
                for (int j = 0; j < logStep.length; ++j) {
                    int h = (int)Math.rint(y + this.tickStep * logStep[j]);
                    g.drawLine(x0 + tr + off, h, x0 + tr + off + this.subtickLength, h);
                    if (!this.gridVisible || !this.subGridVisible || !grid) continue;
                    if (bs != null) {
                        g2.setStroke(bs);
                    }
                    g.drawLine(x0, h, x0 + la, h);
                    g2.setStroke(old);
                }
                break block4;
            }
            if (this.subTickStep <= 0) break block4;
            double r = 1.0 / (double)this.subTickStep;
            for (int j = 0; j < this.subTickStep; ++j) {
                int h = (int)Math.rint(y + this.tickStep * r * (double)j);
                g.drawLine(x0 + tr + off, h, x0 + tr + off + this.subtickLength, h);
                if (j <= 0 || !this.gridVisible || !this.subGridVisible || !grid) continue;
                if (bs != null) {
                    g2.setStroke(bs);
                }
                g.drawLine(x0, h, x0 + la, h);
                g2.setStroke(old);
            }
        }
    }

    private void paintXTicks(Graphics g, int i, int y0, double x, int la, BasicStroke bs, int tr, int off, boolean grid) {
        block4: {
            Stroke old;
            Graphics2D g2;
            block5: {
                g2 = (Graphics2D)g;
                old = g2.getStroke();
                if (!this.subtickVisible || i >= this.labels.size() - 1) break block4;
                if (this.subTickStep != -1) break block5;
                for (int j = 0; j < logStep.length; ++j) {
                    int w = (int)Math.rint(x + this.tickStep * logStep[j]);
                    g.drawLine(w, y0 + tr + off, w, y0 + tr + off + this.subtickLength);
                    if (!this.gridVisible || !this.subGridVisible || !grid) continue;
                    if (bs != null) {
                        g2.setStroke(bs);
                    }
                    g.drawLine(w, y0, w, y0 + la);
                    g2.setStroke(old);
                }
                break block4;
            }
            if (this.subTickStep <= 0) break block4;
            double r = 1.0 / (double)this.subTickStep;
            for (int j = 0; j < this.subTickStep; ++j) {
                int w = (int)Math.rint(x + this.tickStep * r * (double)j);
                g.drawLine(w, y0 + tr + off, w, y0 + tr + off + this.subtickLength);
                if (j <= 0 || !this.gridVisible || !this.subGridVisible || !grid) continue;
                if (bs != null) {
                    g2.setStroke(bs);
                }
                g.drawLine(w, y0, w, y0 + la);
                g2.setStroke(old);
            }
        }
    }

    public Color computeMediumColor(Color c1, Color c2) {
        return new Color((c1.getRed() + 3 * c2.getRed()) / 4, (c1.getGreen() + 3 * c2.getGreen()) / 4, (c1.getBlue() + 3 * c2.getBlue()) / 4);
    }

    void paintAxis(Graphics g, FontRenderContext frc, int x0, int y0, JLAxis xAxis, int xOrg, int yOrg, Color back, boolean oppositeVisible, boolean forcePaint) {
        int la = 0;
        int tr = 0;
        Point p0 = null;
        if (!forcePaint && !this.isHorizontal() && this.dataViews.size() == 0) {
            return;
        }
        if (this.getLength() <= 1) {
            this.boundRect.setRect(0.0, 0.0, 0.0, 0.0);
            return;
        }
        la = xAxis.getLength();
        if (la <= 0) {
            this.boundRect.setRect(0.0, 0.0, 0.0, 0.0);
            return;
        }
        switch (this.dOrientation) {
            case 6: {
                this.boundRect.setRect(x0 + this.getThickness(), y0, la, this.csize.height);
                if (this.orientation != 7) break;
                p0 = this.transform(0.0, 1.0, xAxis);
                if (p0.x >= x0 + this.csize.width && p0.x <= x0 + this.csize.width + la) {
                    tr = p0.x - (x0 + this.csize.width);
                    break;
                }
                return;
            }
            case 5: {
                this.boundRect.setRect(x0 - la - 1, y0, la, this.csize.height);
                if (this.orientation != 7) break;
                p0 = this.transform(0.0, 1.0, xAxis);
                if (p0.x >= x0 - la - 1 && p0.x <= x0) {
                    tr = p0.x - x0;
                    break;
                }
                return;
            }
            case 1: 
            case 2: {
                this.boundRect.setRect(x0, y0 - la, this.csize.width, la);
                if (this.orientation != 3 && this.orientation != 4) break;
                p0 = xAxis.transform(1.0, 0.0, this);
                if (p0.y >= y0 - la && p0.y <= y0) {
                    tr = p0.y - y0;
                    break;
                }
                return;
            }
            default: {
                System.out.println("JLChart warning: Wrong axis position");
            }
        }
        if (!this.visible) {
            return;
        }
        this.paintAxisDirect(g, frc, x0, y0, back, tr, xAxis.getLength());
        if (this.drawOpposite && oppositeVisible) {
            if (this.orientation == 7 || this.orientation == 3 || this.orientation == 4) {
                this.paintAxisOppositeDouble(g, frc, x0, y0, back, tr, xAxis.getLength());
            } else {
                this.paintAxisOpposite(g, frc, x0, y0, back, tr, xAxis.getLength());
            }
        }
    }

    public void paintAxisDirect(Graphics g, FontRenderContext frc, int x0, int y0, Color back, int tr, int la) {
        BasicStroke bs = null;
        Graphics2D g2 = (Graphics2D)g;
        Color subgridColor = this.computeMediumColor(this.labelColor, back);
        if (this.gridVisible) {
            bs = GraphicsUtils.createStrokeForLine(1, this.gridStyle);
        }
        g.setFont(this.labelFont);
        int tickOff = this.getTickShift(this.tickLength);
        int subTickOff = this.getTickShift(this.subtickLength);
        switch (this.dOrientation) {
            case 6: {
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintYOutTicks(g, x0 + this.csize.width, (double)y0 + lis.pos - this.tickStep, y0, la, bs, tr, subTickOff, true);
                    this.paintYOutTicks(g, x0 + this.csize.width, (double)y0 + lie.pos, y0, la, bs, tr, subTickOff, true);
                }
                for (int i = 0; i < this.labels.size(); ++i) {
                    g.setColor(this.labelColor);
                    LabelInfo li = this.labels.get(i);
                    int x = x0 + (this.csize.width - 4) - li.size.width;
                    int y = (int)Math.rint(li.pos) + y0;
                    g.drawString(li.value, x + tr + li.offset.x, y + li.offset.y + li.size.height / 3);
                    if (this.gridVisible) {
                        Stroke old = g2.getStroke();
                        if (bs != null) {
                            g2.setStroke(bs);
                        }
                        g.drawLine(x0 + (this.csize.width + 1), y, x0 + (this.csize.width + 1) + la, y);
                        g2.setStroke(old);
                    }
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintYTicks(g, i, x0 + this.csize.width, li.pos + (double)y0, la, bs, tr, subTickOff, true);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(x0 + tr + this.csize.width + tickOff, y, x0 + tr + this.csize.width + tickOff + this.tickLength, y);
                }
                g.setColor(this.labelColor);
                g.drawLine(x0 + tr + this.csize.width, y0, x0 + tr + this.csize.width, y0 + this.csize.height);
                if (this.name == null) break;
                g2.rotate(-1.5707963267948966);
                Rectangle2D bounds = this.labelFont.getStringBounds(this.name, frc);
                int fontAscent = (int)(this.labelFont.getLineMetrics("0", frc).getAscent() + 0.5f);
                g.drawString(this.name, -y0 - (this.csize.height + (int)bounds.getWidth()) / 2, x0 + fontAscent - 2);
                g2.rotate(1.5707963267948966);
                break;
            }
            case 5: {
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintYOutTicks(g, x0, (double)y0 + lis.pos - this.tickStep, y0, -la, bs, tr, subTickOff, true);
                    this.paintYOutTicks(g, x0, (double)y0 + lie.pos, y0, -la, bs, tr, subTickOff, true);
                }
                for (int i = 0; i < this.labels.size(); ++i) {
                    g.setColor(this.labelColor);
                    LabelInfo li = this.labels.get(i);
                    int y = (int)Math.rint(li.pos) + y0;
                    g.drawString(li.value, x0 + tr + li.offset.x + 6, y + li.offset.y + li.size.height / 3);
                    if (this.gridVisible) {
                        Stroke old = g2.getStroke();
                        if (bs != null) {
                            g2.setStroke(bs);
                        }
                        g.drawLine(x0, y, x0 - la, y);
                        g2.setStroke(old);
                    }
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintYTicks(g, i, x0, li.pos + (double)y0, -la, bs, tr, subTickOff, true);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(x0 + tr + tickOff, y, x0 + tr + tickOff + this.tickLength, y);
                }
                g.setColor(this.labelColor);
                g.drawLine(x0 + tr, y0, x0 + tr, y0 + this.csize.height);
                if (this.name == null) break;
                g2.rotate(-1.5707963267948966);
                Rectangle2D bounds = this.labelFont.getStringBounds(this.name, frc);
                g.drawString(this.name, -y0 - (this.csize.height + (int)bounds.getWidth()) / 2, x0 + tr + this.csize.width - 2);
                g2.rotate(1.5707963267948966);
                break;
            }
            case 1: 
            case 2: {
                int labelShift;
                if (this.orientation == 2) {
                    tr = -la;
                    labelShift = 1;
                } else {
                    labelShift = this.orientation == 3 || this.orientation == 4 ? 1 : 2;
                }
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintXOutTicks(g, y0, (double)x0 + lis.pos - this.tickStep, x0, -la, bs, tr, subTickOff, true);
                    this.paintXOutTicks(g, y0, (double)x0 + lie.pos, x0, -la, bs, tr, subTickOff, true);
                }
                for (int i = 0; i < this.labels.size(); ++i) {
                    g.setColor(this.labelColor);
                    LabelInfo li = this.labels.get(i);
                    int x = (int)Math.rint(li.pos) + x0;
                    int y = y0;
                    if (this.orientation == 2) {
                        g.drawString(li.value, x + li.offset.x - li.size.width / 2, y + tr - 2);
                    } else {
                        g.drawString(li.value, x + li.offset.x - li.size.width / 2, y + tr + li.offset.y + li.size.height + 2);
                    }
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintXTicks(g, i, y, li.pos + (double)x0, -la, bs, tr, subTickOff, true);
                    }
                    g.setColor(this.labelColor);
                    if (this.gridVisible) {
                        Stroke old = g2.getStroke();
                        if (bs != null) {
                            g2.setStroke(bs);
                        }
                        g.drawLine(x, y0, x, y0 - la);
                        g2.setStroke(old);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(x, y0 + tr + tickOff, x, y0 + tr + tickOff + this.tickLength);
                }
                g.setColor(this.labelColor);
                g.drawLine(x0, y0 + tr, x0 + this.csize.width, y0 + tr);
                if (this.name == null) break;
                Rectangle2D bounds = this.labelFont.getStringBounds(this.name, frc);
                g.drawString(this.name, x0 + (this.csize.width - (int)bounds.getWidth()) / 2, y0 + labelShift * (int)bounds.getHeight());
            }
        }
    }

    public void paintAxisOpposite(Graphics g, FontRenderContext frc, int x0, int y0, Color back, int tr, int la) {
        BasicStroke bs = null;
        Color subgridColor = this.computeMediumColor(this.labelColor, back);
        int tickOff = this.getTickShiftOpposite(this.tickLength);
        int subTickOff = this.getTickShiftOpposite(this.subtickLength);
        switch (this.dOrientation) {
            case 5: {
                int nX0 = x0 - la - this.csize.width;
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintYOutTicks(g, nX0 + this.csize.width, (double)y0 + lis.pos - this.tickStep, y0, la, bs, tr, subTickOff, false);
                    this.paintYOutTicks(g, nX0 + this.csize.width, (double)y0 + lie.pos, y0, la, bs, tr, subTickOff, false);
                }
                for (int i = 0; i < this.labels.size(); ++i) {
                    LabelInfo li = this.labels.get(i);
                    int x = nX0 + (this.csize.width - 4) - li.size.width;
                    int y = (int)Math.rint(li.pos) + y0;
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintYTicks(g, i, nX0 + this.csize.width, li.pos + (double)y0, la, bs, tr, subTickOff, false);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(nX0 + tr + this.csize.width + tickOff, y, nX0 + tr + this.csize.width + tickOff + this.tickLength, y);
                }
                g.setColor(this.labelColor);
                g.drawLine(nX0 + tr + this.csize.width, y0, nX0 + tr + this.csize.width, y0 + this.csize.height);
                break;
            }
            case 6: {
                int x = x0 + la + this.csize.width;
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintYOutTicks(g, x, (double)y0 + lis.pos - this.tickStep, y0, -la, bs, tr, subTickOff, false);
                    this.paintYOutTicks(g, x, (double)y0 + lie.pos, y0, -la, bs, tr, subTickOff, false);
                }
                for (int i = 0; i < this.labels.size(); ++i) {
                    LabelInfo li = this.labels.get(i);
                    int y = (int)Math.rint(li.pos) + y0;
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintYTicks(g, i, x, li.pos + (double)y0, -la, bs, tr, subTickOff, false);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(x + tr + tickOff, y, x + tr + tickOff + this.tickLength, y);
                }
                g.setColor(this.labelColor);
                g.drawLine(x + tr, y0, x + tr, y0 + this.csize.height);
                break;
            }
            case 1: 
            case 2: {
                if (this.orientation == 1) {
                    tr = -la;
                }
                if (this.labels.size() > 0 && this.autoLabeling) {
                    LabelInfo lis = this.labels.get(0);
                    LabelInfo lie = this.labels.get(this.labels.size() - 1);
                    g.setColor(subgridColor);
                    this.paintXOutTicks(g, y0, (double)x0 + lis.pos - this.tickStep, x0, -la, bs, tr, subTickOff, false);
                    this.paintXOutTicks(g, y0, (double)x0 + lie.pos, x0, -la, bs, tr, subTickOff, false);
                }
                for (int i = 0; i < this.labels.size(); ++i) {
                    LabelInfo li = this.labels.get(i);
                    int x = (int)Math.rint(li.pos) + x0;
                    int y = y0;
                    if (this.autoLabeling) {
                        g.setColor(subgridColor);
                        this.paintXTicks(g, i, y, li.pos + (double)x0, -la, bs, tr, subTickOff, false);
                    }
                    g.setColor(this.labelColor);
                    g.drawLine(x, y0 + tr + tickOff, x, y0 + tr + tickOff + this.tickLength);
                }
                g.setColor(this.labelColor);
                g.drawLine(x0, y0 + tr, x0 + this.csize.width, y0 + tr);
            }
        }
    }

    public void paintAxisOppositeDouble(Graphics g, FontRenderContext frc, int x0, int y0, Color back, int tr, int la) {
        switch (this.dOrientation) {
            case 5: {
                int nX0 = x0 - la;
                g.setColor(this.labelColor);
                g.drawLine(nX0, y0, nX0, y0 + this.csize.height);
                g.drawLine(nX0 + la, y0, nX0 + la, y0 + this.csize.height);
                break;
            }
            case 6: {
                int nX0 = x0 + this.csize.width;
                g.setColor(this.labelColor);
                g.drawLine(nX0, y0, nX0, y0 + this.csize.height);
                g.drawLine(nX0 + la, y0, nX0 + la, y0 + this.csize.height);
                break;
            }
            case 1: 
            case 2: {
                g.setColor(this.labelColor);
                g.drawLine(x0, y0 - la, x0 + this.csize.width, y0 - la);
                g.drawLine(x0, y0, x0 + this.csize.width, y0);
            }
        }
    }

    public void applyConfiguration(String prefix, CfFileReader f) {
        Vector<String> p = f.getParam(prefix + "visible");
        if (p != null) {
            this.setVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "grid")) != null) {
            this.setGridVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "subgrid")) != null) {
            this.setSubGridVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "timeannosubtick")) != null) {
            this.setTimeAnnoSubTickInterval(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "grid_style")) != null) {
            this.setGridStyle(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "min")) != null) {
            this.setMinimum(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "max")) != null) {
            this.setMaximum(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "autoscale")) != null) {
            this.setAutoScale(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "scale")) != null) {
            this.setScale(OFormat.getInt(p.get(0).toString()));
        } else {
            p = f.getParam(prefix + "cale");
            if (p != null) {
                this.setScale(OFormat.getInt(p.get(0).toString()));
            }
        }
        p = f.getParam(prefix + "format");
        if (p != null) {
            this.setLabelFormat(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "title")) != null) {
            this.setName(OFormat.getName(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "color")) != null) {
            this.setAxisColor(OFormat.getColor(p));
        }
        if ((p = f.getParam(prefix + "label_font")) != null) {
            this.setFont(OFormat.getFont(p));
        }
        if ((p = f.getParam(prefix + "fit_display_duration")) != null) {
            this.setFitXAxisToDisplayDuration(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "percentscrollback")) != null) {
            this.setPercentScrollback(OFormat.getDouble(p.get(0).toString()));
        }
    }

    public String getConfiguration(String prefix) {
        Object to_write = "";
        to_write = (String)to_write + prefix + "visible:" + this.isVisible() + "\n";
        to_write = (String)to_write + prefix + "grid:" + this.isGridVisible() + "\n";
        to_write = (String)to_write + prefix + "subgrid:" + this.isSubGridVisible() + "\n";
        to_write = (String)to_write + prefix + "timeannosubtick:" + this.getTimeAnnoSubTickInterval() + "\n";
        to_write = (String)to_write + prefix + "grid_style:" + this.getGridStyle() + "\n";
        to_write = (String)to_write + prefix + "min:" + this.getMinimum() + "\n";
        to_write = (String)to_write + prefix + "max:" + this.getMaximum() + "\n";
        to_write = (String)to_write + prefix + "autoscale:" + this.isAutoScale() + "\n";
        to_write = (String)to_write + prefix + "scale:" + this.getScale() + "\n";
        to_write = (String)to_write + prefix + "format:" + this.getLabelFormat() + "\n";
        to_write = (String)to_write + prefix + "title:'" + this.getName() + "'\n";
        to_write = (String)to_write + prefix + "color:" + OFormat.color(this.getAxisColor()) + "\n";
        to_write = (String)to_write + prefix + "label_font:" + OFormat.font(this.getFont()) + "\n";
        to_write = (String)to_write + prefix + "fit_display_duration:" + this.isFitXAxisToDisplayDuration() + "\n";
        to_write = (String)to_write + prefix + "percentscrollback:" + this.getPercentScrollback() + "\n";
        return to_write;
    }

    public boolean isZeroAlwaysVisible() {
        return this.zeroAlwaysVisible;
    }

    public void setZeroAlwaysVisible(boolean zeroAlwaysVisible) {
        this.zeroAlwaysVisible = zeroAlwaysVisible;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

