/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.chart.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JLDataViewOption
extends JDialog
implements ActionListener,
MouseListener,
ChangeListener,
KeyListener {
    private JLDataView dataView;
    protected JLChart chart;
    protected JLabel nameLabel;
    private JTabbedPane tabPane;
    protected JButton closeBtn;
    private JPanel linePanel;
    private JLabel viewTypeLabel;
    private JComboBox viewTypeCombo;
    private JLabel lineColorView;
    private JButton lineColorBtn;
    private JLabel lineColorLabel;
    private JLabel fillColorView;
    private JButton fillColorBtn;
    private JLabel fillColorLabel;
    private JLabel fillStyleLabel;
    private JComboBox fillStyleCombo;
    private JLabel lineWidthLabel;
    private JSpinner lineWidthSpinner;
    private JLabel lineDashLabel;
    private JComboBox lineDashCombo;
    private JLabel lineNameLabel;
    private JTextField lineNameText;
    private JPanel barPanel;
    private JLabel barWidthLabel;
    private JSpinner barWidthSpinner;
    private JLabel fillMethodLabel;
    private JComboBox fillMethodCombo;
    private JPanel markerPanel;
    private JLabel markerColorView;
    private JButton markerColorBtn;
    private JLabel markerColorLabel;
    private JLabel markerSizeLabel;
    private JSpinner markerSizeSpinner;
    private JLabel markerStyleLabel;
    private JComboBox markerStyleCombo;
    private JCheckBox labelVisibleCheck;
    private JPanel transformPanel;
    private JTextArea transformHelpLabel;
    private JLabel transformA0Label;
    private JTextField transformA0Text;
    private JLabel transformA1Label;
    private JTextField transformA1Text;
    private JLabel transformA2Label;
    private JTextField transformA2Text;
    private JPanel interpPanel;
    private ButtonGroup methodIntBtnGrp;
    private JRadioButton noInterpBtn;
    private JRadioButton linearBtn;
    private JRadioButton cosineBtn;
    private JRadioButton cubicBtn;
    private JRadioButton hermiteBtn;
    private JSpinner stepSpinner;
    private JTextField tensionText;
    private JTextField biasText;
    private JPanel smoothPanel;
    private ButtonGroup methodSmBtnGrp;
    private JRadioButton noSmoothBtn;
    private JRadioButton flatSmoothBtn;
    private JRadioButton triangularSmoothBtn;
    private JRadioButton gaussianSmoothBtn;
    private JSpinner neighborSpinner;
    private JTextField sigmaText;
    private ButtonGroup methodExtBtnGrp;
    private JRadioButton noExtBtn;
    private JRadioButton flatExtBtn;
    private JRadioButton linearExtBtn;
    private JPanel mathPanel;
    private ButtonGroup mathBtnGrp;
    private JRadioButton noMathBtn;
    private JRadioButton derivativeBtn;
    private JRadioButton integralBtn;
    private JRadioButton fftModBtn;
    private JRadioButton fftPhaseBtn;
    private JCheckBox removeAvgBtn;

    public JLDataViewOption(JDialog parent, JLChart chart, JLDataView v) {
        super((Dialog)parent, true);
        this.dataView = v;
        this.chart = chart;
        this.initComponents();
    }

    public JLDataViewOption(JFrame parent, JLChart chart, JLDataView v) {
        super((Frame)parent, true);
        this.dataView = v;
        this.chart = chart;
        this.initComponents();
    }

    private void initComponents() {
        JPanel innerPane = new JPanel();
        innerPane.setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JLDataViewOption.this.setVisible(false);
                JLDataViewOption.this.dispose();
            }
        });
        this.setTitle("Data view options");
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(GraphicsUtils.labelFont);
        this.linePanel = new JPanel();
        this.linePanel.setLayout(null);
        this.viewTypeLabel = new JLabel("View type");
        this.viewTypeLabel.setFont(GraphicsUtils.labelFont);
        this.viewTypeLabel.setForeground(GraphicsUtils.fColor);
        this.viewTypeCombo = new JComboBox();
        this.viewTypeCombo.setFont(GraphicsUtils.labelFont);
        this.viewTypeCombo.addItem("Line");
        this.viewTypeCombo.addItem("Bar graph");
        this.viewTypeCombo.setSelectedIndex(this.dataView.getViewType());
        this.viewTypeCombo.addActionListener(this);
        this.lineColorView = new JLabel("");
        this.lineColorView.setBackground(this.dataView.getColor());
        this.lineColorView.setOpaque(true);
        this.lineColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.lineColorBtn = new JButton("...");
        this.lineColorBtn.addMouseListener(this);
        this.lineColorLabel = new JLabel("Line Color");
        this.lineColorLabel.setFont(GraphicsUtils.labelFont);
        this.lineColorLabel.setForeground(GraphicsUtils.fColor);
        this.fillColorView = new JLabel("");
        this.fillColorView.setBackground(this.dataView.getFillColor());
        this.fillColorView.setOpaque(true);
        this.fillColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.fillColorBtn = new JButton("...");
        this.fillColorBtn.addMouseListener(this);
        this.fillColorLabel = new JLabel("Fill Color");
        this.fillColorLabel.setFont(GraphicsUtils.labelFont);
        this.fillColorLabel.setForeground(GraphicsUtils.fColor);
        this.lineWidthLabel = new JLabel("Line Width");
        this.lineWidthLabel.setFont(GraphicsUtils.labelFont);
        this.lineWidthLabel.setForeground(GraphicsUtils.fColor);
        this.lineWidthSpinner = new JSpinner();
        Integer value = new Integer(this.dataView.getLineWidth());
        Integer min = new Integer(0);
        Integer max = new Integer(10);
        Integer step = new Integer(1);
        SpinnerNumberModel spModel = new SpinnerNumberModel(value, min, max, step);
        this.lineWidthSpinner.setModel(spModel);
        this.lineWidthSpinner.addChangeListener(this);
        this.lineDashLabel = new JLabel("Line style");
        this.lineDashLabel.setFont(GraphicsUtils.labelFont);
        this.lineDashLabel.setForeground(GraphicsUtils.fColor);
        this.lineDashCombo = new JComboBox();
        this.lineDashCombo.setFont(GraphicsUtils.labelFont);
        this.lineDashCombo.addItem("Solid");
        this.lineDashCombo.addItem("Point dash");
        this.lineDashCombo.addItem("Short dash");
        this.lineDashCombo.addItem("Long dash");
        this.lineDashCombo.addItem("Dot dash");
        this.lineDashCombo.setSelectedIndex(this.dataView.getStyle());
        this.lineDashCombo.addActionListener(this);
        this.fillStyleLabel = new JLabel("Fill style");
        this.fillStyleLabel.setFont(GraphicsUtils.labelFont);
        this.fillStyleLabel.setForeground(GraphicsUtils.fColor);
        this.fillStyleCombo = new JComboBox();
        this.fillStyleCombo.setFont(GraphicsUtils.labelFont);
        this.fillStyleCombo.addItem("No fill");
        this.fillStyleCombo.addItem("Solid");
        this.fillStyleCombo.addItem("Large leff hatch");
        this.fillStyleCombo.addItem("Large right hatch");
        this.fillStyleCombo.addItem("Large cross hatch");
        this.fillStyleCombo.addItem("Small leff hatch");
        this.fillStyleCombo.addItem("Small right hatch");
        this.fillStyleCombo.addItem("Small cross hatch");
        this.fillStyleCombo.addItem("Dot pattern 1");
        this.fillStyleCombo.addItem("Dot pattern 2");
        this.fillStyleCombo.addItem("Dot pattern 3");
        this.fillStyleCombo.setSelectedIndex(this.dataView.getFillStyle());
        this.fillStyleCombo.addActionListener(this);
        this.lineNameLabel = new JLabel("Name");
        this.lineNameLabel.setFont(GraphicsUtils.labelFont);
        this.lineNameLabel.setForeground(GraphicsUtils.fColor);
        this.lineNameText = new JTextField();
        this.lineNameText.setEditable(true);
        this.lineNameText.setText(this.dataView.getName());
        this.lineNameText.setMargin(GraphicsUtils.zInset);
        this.lineNameText.addKeyListener(this);
        this.linePanel.add(this.viewTypeLabel);
        this.linePanel.add(this.viewTypeCombo);
        this.linePanel.add(this.lineColorLabel);
        this.linePanel.add(this.lineColorView);
        this.linePanel.add(this.lineColorBtn);
        this.linePanel.add(this.fillColorLabel);
        this.linePanel.add(this.fillColorView);
        this.linePanel.add(this.fillColorBtn);
        this.linePanel.add(this.lineWidthLabel);
        this.linePanel.add(this.lineWidthSpinner);
        this.linePanel.add(this.lineDashLabel);
        this.linePanel.add(this.lineDashCombo);
        this.linePanel.add(this.fillStyleLabel);
        this.linePanel.add(this.fillStyleCombo);
        this.linePanel.add(this.lineNameLabel);
        this.linePanel.add(this.lineNameText);
        this.viewTypeLabel.setBounds(10, 10, 100, 25);
        this.viewTypeCombo.setBounds(115, 10, 125, 25);
        this.lineColorLabel.setBounds(10, 40, 100, 25);
        this.lineColorView.setBounds(115, 40, 80, 25);
        this.lineColorBtn.setBounds(200, 40, 40, 27);
        this.fillColorLabel.setBounds(10, 70, 100, 25);
        this.fillColorView.setBounds(115, 70, 80, 25);
        this.fillColorBtn.setBounds(200, 70, 40, 27);
        this.fillStyleLabel.setBounds(10, 100, 100, 25);
        this.fillStyleCombo.setBounds(115, 100, 125, 25);
        this.lineWidthLabel.setBounds(10, 130, 100, 25);
        this.lineWidthSpinner.setBounds(115, 130, 125, 25);
        this.lineDashLabel.setBounds(10, 160, 100, 25);
        this.lineDashCombo.setBounds(115, 160, 125, 25);
        this.lineNameLabel.setBounds(10, 190, 100, 25);
        this.lineNameText.setBounds(115, 190, 125, 25);
        this.barPanel = new JPanel();
        this.barPanel.setLayout(null);
        this.barWidthLabel = new JLabel("Bar Width");
        this.barWidthLabel.setFont(GraphicsUtils.labelFont);
        this.barWidthLabel.setForeground(GraphicsUtils.fColor);
        this.barWidthSpinner = new JSpinner();
        value = new Integer(this.dataView.getBarWidth());
        min = new Integer(0);
        max = new Integer(100);
        step = new Integer(1);
        spModel = new SpinnerNumberModel(value, min, max, step);
        this.barWidthSpinner.setModel(spModel);
        this.barWidthSpinner.addChangeListener(this);
        this.fillMethodLabel = new JLabel("Filling method");
        this.fillMethodLabel.setFont(GraphicsUtils.labelFont);
        this.fillMethodLabel.setForeground(GraphicsUtils.fColor);
        this.fillMethodCombo = new JComboBox();
        this.fillMethodCombo.setFont(GraphicsUtils.labelFont);
        this.fillMethodCombo.addItem("From Up");
        this.fillMethodCombo.addItem("From Zero");
        this.fillMethodCombo.addItem("From Bottom");
        this.fillMethodCombo.setSelectedIndex(this.dataView.getFillMethod());
        this.fillMethodCombo.addActionListener(this);
        this.barPanel.add(this.barWidthLabel);
        this.barPanel.add(this.barWidthSpinner);
        this.barPanel.add(this.fillMethodLabel);
        this.barPanel.add(this.fillMethodCombo);
        this.barWidthLabel.setBounds(10, 10, 100, 25);
        this.barWidthSpinner.setBounds(115, 10, 125, 25);
        this.fillMethodLabel.setBounds(10, 40, 100, 25);
        this.fillMethodCombo.setBounds(115, 40, 125, 25);
        this.markerPanel = new JPanel();
        this.markerPanel.setLayout(null);
        this.markerColorView = new JLabel("");
        this.markerColorView.setBackground(this.dataView.getMarkerColor());
        this.markerColorView.setOpaque(true);
        this.markerColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.markerColorBtn = new JButton("...");
        this.markerColorBtn.addMouseListener(this);
        this.markerColorLabel = new JLabel("Color");
        this.markerColorLabel.setFont(GraphicsUtils.labelFont);
        this.markerColorLabel.setForeground(GraphicsUtils.fColor);
        this.markerSizeLabel = new JLabel("Size");
        this.markerSizeLabel.setFont(GraphicsUtils.labelFont);
        this.markerSizeLabel.setForeground(GraphicsUtils.fColor);
        this.markerSizeSpinner = new JSpinner();
        value = new Integer(this.dataView.getMarkerSize());
        spModel = new SpinnerNumberModel(value, min, max, step);
        this.markerSizeSpinner.setModel(spModel);
        this.markerSizeSpinner.addChangeListener(this);
        this.markerStyleLabel = new JLabel("Marker style");
        this.markerStyleLabel.setFont(GraphicsUtils.labelFont);
        this.markerStyleLabel.setForeground(GraphicsUtils.fColor);
        this.markerStyleCombo = new JComboBox();
        this.markerStyleCombo.addItem("None");
        this.markerStyleCombo.addItem("Dot");
        this.markerStyleCombo.addItem("Box");
        this.markerStyleCombo.addItem("triangle");
        this.markerStyleCombo.addItem("Diamond");
        this.markerStyleCombo.addItem("Star");
        this.markerStyleCombo.addItem("Vert. line");
        this.markerStyleCombo.addItem("Horz. line");
        this.markerStyleCombo.addItem("Cross");
        this.markerStyleCombo.addItem("Circle");
        this.markerStyleCombo.addItem("Square");
        this.markerStyleCombo.setSelectedIndex(this.dataView.getMarker());
        this.markerStyleCombo.addActionListener(this);
        this.labelVisibleCheck = new JCheckBox();
        this.labelVisibleCheck.setFont(GraphicsUtils.labelFont);
        this.labelVisibleCheck.setForeground(GraphicsUtils.fColor);
        this.labelVisibleCheck.setText("Legend visible");
        this.labelVisibleCheck.setSelected(this.dataView.isLabelVisible());
        this.labelVisibleCheck.addActionListener(this);
        this.markerPanel.add(this.markerColorLabel);
        this.markerPanel.add(this.markerColorView);
        this.markerPanel.add(this.markerColorBtn);
        this.markerPanel.add(this.markerSizeLabel);
        this.markerPanel.add(this.markerSizeSpinner);
        this.markerPanel.add(this.markerStyleLabel);
        this.markerPanel.add(this.markerStyleCombo);
        this.markerPanel.add(this.labelVisibleCheck);
        this.markerColorLabel.setBounds(10, 10, 100, 25);
        this.markerColorView.setBounds(115, 10, 80, 25);
        this.markerColorBtn.setBounds(200, 10, 40, 27);
        this.markerSizeLabel.setBounds(10, 40, 100, 25);
        this.markerSizeSpinner.setBounds(115, 40, 125, 25);
        this.markerStyleLabel.setBounds(10, 70, 100, 25);
        this.markerStyleCombo.setBounds(115, 70, 125, 25);
        this.labelVisibleCheck.setBounds(10, 100, 225, 25);
        this.transformPanel = new JPanel();
        this.transformPanel.setLayout(null);
        this.transformHelpLabel = new JTextArea("This apply a polynomial transform\nto the data view:\n y' = A0 + A1*y + A2*y^2");
        this.transformHelpLabel.setFont(GraphicsUtils.labelFont);
        this.transformHelpLabel.setForeground(GraphicsUtils.fColor);
        this.transformHelpLabel.setFont(this.markerStyleLabel.getFont());
        this.transformHelpLabel.setEditable(false);
        this.transformHelpLabel.setBackground(this.markerStyleLabel.getBackground());
        this.transformA0Label = new JLabel("A0");
        this.transformA0Label.setFont(GraphicsUtils.labelFont);
        this.transformA0Label.setForeground(GraphicsUtils.fColor);
        this.transformA0Text = new JTextField();
        this.transformA0Text.setEditable(true);
        this.transformA0Text.setText(Double.toString(this.dataView.getA0()));
        this.transformA0Text.setMargin(GraphicsUtils.zInset);
        this.transformA0Text.addKeyListener(this);
        this.transformA1Label = new JLabel("A1");
        this.transformA1Label.setFont(GraphicsUtils.labelFont);
        this.transformA1Label.setForeground(GraphicsUtils.fColor);
        this.transformA1Text = new JTextField();
        this.transformA1Text.setEditable(true);
        this.transformA1Text.setText(Double.toString(this.dataView.getA1()));
        this.transformA1Text.setMargin(GraphicsUtils.zInset);
        this.transformA1Text.addKeyListener(this);
        this.transformA2Label = new JLabel("A2");
        this.transformA2Label.setFont(GraphicsUtils.labelFont);
        this.transformA2Label.setForeground(GraphicsUtils.fColor);
        this.transformA2Text = new JTextField();
        this.transformA2Text.setEditable(true);
        this.transformA2Text.setText(Double.toString(this.dataView.getA2()));
        this.transformA2Text.setMargin(GraphicsUtils.zInset);
        this.transformA2Text.addKeyListener(this);
        this.transformPanel.add(this.transformHelpLabel);
        this.transformPanel.add(this.transformA0Label);
        this.transformPanel.add(this.transformA0Text);
        this.transformPanel.add(this.transformA1Label);
        this.transformPanel.add(this.transformA1Text);
        this.transformPanel.add(this.transformA2Label);
        this.transformPanel.add(this.transformA2Text);
        this.transformHelpLabel.setBounds(10, 100, 240, 100);
        this.transformA0Label.setBounds(60, 10, 30, 25);
        this.transformA0Text.setBounds(95, 10, 100, 25);
        this.transformA1Label.setBounds(60, 40, 30, 25);
        this.transformA1Text.setBounds(95, 40, 100, 25);
        this.transformA2Label.setBounds(60, 70, 30, 25);
        this.transformA2Text.setBounds(95, 70, 100, 25);
        this.interpPanel = new JPanel();
        this.interpPanel.setLayout(null);
        this.methodIntBtnGrp = new ButtonGroup();
        this.noInterpBtn = new JRadioButton("None");
        this.noInterpBtn.setForeground(GraphicsUtils.fColor);
        this.noInterpBtn.setFont(GraphicsUtils.labelFont);
        this.noInterpBtn.setBounds(5, 10, 90, 25);
        this.interpPanel.add(this.noInterpBtn);
        this.methodIntBtnGrp.add(this.noInterpBtn);
        this.linearBtn = new JRadioButton("Linear");
        this.linearBtn.setForeground(GraphicsUtils.fColor);
        this.linearBtn.setFont(GraphicsUtils.labelFont);
        this.linearBtn.setBounds(5, 35, 90, 25);
        this.interpPanel.add(this.linearBtn);
        this.methodIntBtnGrp.add(this.linearBtn);
        this.cosineBtn = new JRadioButton("Cosine");
        this.cosineBtn.setForeground(GraphicsUtils.fColor);
        this.cosineBtn.setFont(GraphicsUtils.labelFont);
        this.cosineBtn.setBounds(5, 60, 90, 25);
        this.interpPanel.add(this.cosineBtn);
        this.methodIntBtnGrp.add(this.cosineBtn);
        this.cubicBtn = new JRadioButton("Cubic");
        this.cubicBtn.setForeground(GraphicsUtils.fColor);
        this.cubicBtn.setFont(GraphicsUtils.labelFont);
        this.cubicBtn.setBounds(5, 85, 90, 25);
        this.interpPanel.add(this.cubicBtn);
        this.methodIntBtnGrp.add(this.cubicBtn);
        this.hermiteBtn = new JRadioButton("Hermite");
        this.hermiteBtn.setForeground(GraphicsUtils.fColor);
        this.hermiteBtn.setFont(GraphicsUtils.labelFont);
        this.hermiteBtn.setBounds(5, 110, 90, 25);
        this.interpPanel.add(this.hermiteBtn);
        this.methodIntBtnGrp.add(this.hermiteBtn);
        JLabel stepLabel = new JLabel("Step");
        stepLabel.setFont(GraphicsUtils.labelFont);
        stepLabel.setForeground(GraphicsUtils.fColor);
        stepLabel.setHorizontalAlignment(4);
        stepLabel.setBounds(100, 10, 85, 25);
        this.interpPanel.add(stepLabel);
        this.stepSpinner = new JSpinner();
        value = new Integer(this.dataView.getInterpolationStep());
        min = new Integer(2);
        max = new Integer(100);
        spModel = new SpinnerNumberModel(value, min, max, step);
        this.stepSpinner.setModel(spModel);
        this.stepSpinner.addChangeListener(this);
        this.stepSpinner.setBounds(195, 10, 50, 25);
        this.interpPanel.add(this.stepSpinner);
        JLabel tensionLabel = new JLabel("Tension");
        tensionLabel.setFont(GraphicsUtils.labelFont);
        tensionLabel.setForeground(GraphicsUtils.fColor);
        tensionLabel.setHorizontalAlignment(4);
        tensionLabel.setBounds(100, 40, 85, 25);
        this.interpPanel.add(tensionLabel);
        this.tensionText = new JTextField();
        this.tensionText.setFont(GraphicsUtils.labelFont);
        this.tensionText.setEditable(true);
        this.tensionText.setBounds(195, 40, 50, 25);
        this.tensionText.setEnabled(false);
        this.tensionText.addKeyListener(this);
        this.interpPanel.add(this.tensionText);
        JLabel biasLabel = new JLabel("Bias");
        biasLabel.setFont(GraphicsUtils.labelFont);
        biasLabel.setForeground(GraphicsUtils.fColor);
        biasLabel.setHorizontalAlignment(4);
        biasLabel.setBounds(100, 70, 85, 25);
        this.interpPanel.add(biasLabel);
        this.biasText = new JTextField();
        this.biasText.setFont(GraphicsUtils.labelFont);
        this.biasText.setEditable(true);
        this.biasText.setBounds(195, 70, 50, 25);
        this.biasText.setEnabled(false);
        this.biasText.addKeyListener(this);
        this.interpPanel.add(this.biasText);
        switch (this.dataView.getInterpolationMethod()) {
            case 0: {
                this.noInterpBtn.setSelected(true);
                break;
            }
            case 1: {
                this.linearBtn.setSelected(true);
                break;
            }
            case 3: {
                this.cubicBtn.setSelected(true);
                break;
            }
            case 2: {
                this.cosineBtn.setSelected(true);
                break;
            }
            case 4: {
                this.hermiteBtn.setSelected(true);
            }
        }
        this.noInterpBtn.addChangeListener(this);
        this.linearBtn.addChangeListener(this);
        this.cosineBtn.addChangeListener(this);
        this.cubicBtn.addChangeListener(this);
        this.hermiteBtn.addChangeListener(this);
        this.tensionText.setText(Double.toString(this.dataView.getHermiteTension()));
        this.biasText.setText(Double.toString(this.dataView.getHermiteBias()));
        this.smoothPanel = new JPanel();
        this.smoothPanel.setLayout(null);
        this.methodSmBtnGrp = new ButtonGroup();
        this.noSmoothBtn = new JRadioButton("None");
        this.noSmoothBtn.setForeground(GraphicsUtils.fColor);
        this.noSmoothBtn.setFont(GraphicsUtils.labelFont);
        this.noSmoothBtn.setBounds(5, 10, 90, 25);
        this.smoothPanel.add(this.noSmoothBtn);
        this.methodSmBtnGrp.add(this.noSmoothBtn);
        this.flatSmoothBtn = new JRadioButton("Flat");
        this.flatSmoothBtn.setForeground(GraphicsUtils.fColor);
        this.flatSmoothBtn.setFont(GraphicsUtils.labelFont);
        this.flatSmoothBtn.setBounds(5, 35, 90, 25);
        this.smoothPanel.add(this.flatSmoothBtn);
        this.methodSmBtnGrp.add(this.flatSmoothBtn);
        this.triangularSmoothBtn = new JRadioButton("Linear");
        this.triangularSmoothBtn.setForeground(GraphicsUtils.fColor);
        this.triangularSmoothBtn.setFont(GraphicsUtils.labelFont);
        this.triangularSmoothBtn.setBounds(5, 60, 90, 25);
        this.smoothPanel.add(this.triangularSmoothBtn);
        this.methodSmBtnGrp.add(this.triangularSmoothBtn);
        this.gaussianSmoothBtn = new JRadioButton("Gaussian");
        this.gaussianSmoothBtn.setForeground(GraphicsUtils.fColor);
        this.gaussianSmoothBtn.setFont(GraphicsUtils.labelFont);
        this.gaussianSmoothBtn.setBounds(5, 85, 90, 25);
        this.smoothPanel.add(this.gaussianSmoothBtn);
        this.methodSmBtnGrp.add(this.gaussianSmoothBtn);
        JLabel neighborLabel = new JLabel("Neighbors");
        neighborLabel.setFont(GraphicsUtils.labelFont);
        neighborLabel.setForeground(GraphicsUtils.fColor);
        neighborLabel.setHorizontalAlignment(4);
        neighborLabel.setBounds(100, 10, 90, 25);
        this.smoothPanel.add(neighborLabel);
        this.neighborSpinner = new JSpinner();
        value = new Integer(this.dataView.getSmoothingNeighbors());
        min = new Integer(2);
        max = new Integer(99);
        step = new Integer(2);
        spModel = new SpinnerNumberModel(value, min, max, step);
        this.neighborSpinner.setModel(spModel);
        this.neighborSpinner.addChangeListener(this);
        this.neighborSpinner.setBounds(195, 10, 50, 25);
        this.smoothPanel.add(this.neighborSpinner);
        JLabel sigmaLabel = new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/chart/sigma_small.gif")));
        sigmaLabel.setForeground(GraphicsUtils.fColor);
        sigmaLabel.setHorizontalAlignment(4);
        sigmaLabel.setBounds(100, 40, 85, 25);
        this.smoothPanel.add(sigmaLabel);
        this.sigmaText = new JTextField(Double.toString(this.dataView.getSmoothingGaussSigma()));
        this.sigmaText.setFont(GraphicsUtils.labelFont);
        this.sigmaText.setEditable(true);
        this.sigmaText.setBounds(195, 40, 50, 25);
        this.sigmaText.setEnabled(false);
        this.sigmaText.addKeyListener(this);
        this.smoothPanel.add(this.sigmaText);
        JPanel bPanel = new JPanel();
        bPanel.setLayout(null);
        bPanel.setBorder(GraphicsUtils.createTitleBorder("Boundary extrapolation"));
        this.methodExtBtnGrp = new ButtonGroup();
        this.noExtBtn = new JRadioButton("None");
        this.noExtBtn.setForeground(GraphicsUtils.fColor);
        this.noExtBtn.setFont(GraphicsUtils.labelFont);
        this.noExtBtn.setBounds(5, 20, 90, 25);
        bPanel.add(this.noExtBtn);
        this.methodExtBtnGrp.add(this.noExtBtn);
        this.flatExtBtn = new JRadioButton("Flat");
        this.flatExtBtn.setForeground(GraphicsUtils.fColor);
        this.flatExtBtn.setFont(GraphicsUtils.labelFont);
        this.flatExtBtn.setBounds(5, 45, 90, 25);
        bPanel.add(this.flatExtBtn);
        this.methodExtBtnGrp.add(this.flatExtBtn);
        this.linearExtBtn = new JRadioButton("Linear");
        this.linearExtBtn.setForeground(GraphicsUtils.fColor);
        this.linearExtBtn.setFont(GraphicsUtils.labelFont);
        this.linearExtBtn.setBounds(5, 70, 90, 25);
        bPanel.add(this.linearExtBtn);
        this.methodExtBtnGrp.add(this.linearExtBtn);
        bPanel.setBounds(5, 120, 245, 100);
        this.smoothPanel.add(bPanel);
        switch (this.dataView.getSmoothingExtrapolation()) {
            case 0: {
                this.noExtBtn.setSelected(true);
                break;
            }
            case 1: {
                this.flatExtBtn.setSelected(true);
                break;
            }
            case 2: {
                this.linearExtBtn.setSelected(true);
            }
        }
        switch (this.dataView.getSmoothingMethod()) {
            case 0: {
                this.noSmoothBtn.setSelected(true);
                break;
            }
            case 1: {
                this.flatSmoothBtn.setSelected(true);
                break;
            }
            case 2: {
                this.triangularSmoothBtn.setSelected(true);
                break;
            }
            case 3: {
                this.gaussianSmoothBtn.setSelected(true);
            }
        }
        this.noExtBtn.addChangeListener(this);
        this.flatExtBtn.addChangeListener(this);
        this.linearExtBtn.addChangeListener(this);
        this.noSmoothBtn.addChangeListener(this);
        this.flatSmoothBtn.addChangeListener(this);
        this.triangularSmoothBtn.addChangeListener(this);
        this.gaussianSmoothBtn.addChangeListener(this);
        this.mathPanel = new JPanel();
        this.mathPanel.setLayout(null);
        this.mathBtnGrp = new ButtonGroup();
        this.noMathBtn = new JRadioButton("No operation");
        this.noMathBtn.setForeground(GraphicsUtils.fColor);
        this.noMathBtn.setFont(GraphicsUtils.labelFont);
        this.noMathBtn.setBounds(5, 10, 160, 25);
        this.mathPanel.add(this.noMathBtn);
        this.mathBtnGrp.add(this.noMathBtn);
        this.derivativeBtn = new JRadioButton("Derivative");
        this.derivativeBtn.setForeground(GraphicsUtils.fColor);
        this.derivativeBtn.setFont(GraphicsUtils.labelFont);
        this.derivativeBtn.setBounds(5, 35, 160, 25);
        this.mathPanel.add(this.derivativeBtn);
        this.mathBtnGrp.add(this.derivativeBtn);
        this.integralBtn = new JRadioButton("Integral");
        this.integralBtn.setForeground(GraphicsUtils.fColor);
        this.integralBtn.setFont(GraphicsUtils.labelFont);
        this.integralBtn.setBounds(5, 60, 160, 25);
        this.mathPanel.add(this.integralBtn);
        this.mathBtnGrp.add(this.integralBtn);
        this.fftModBtn = new JRadioButton("FFT (modulus)");
        this.fftModBtn.setForeground(GraphicsUtils.fColor);
        this.fftModBtn.setFont(GraphicsUtils.labelFont);
        this.fftModBtn.setBounds(5, 85, 160, 25);
        this.mathPanel.add(this.fftModBtn);
        this.mathBtnGrp.add(this.fftModBtn);
        this.fftPhaseBtn = new JRadioButton("FFT (phase radians)");
        this.fftPhaseBtn.setForeground(GraphicsUtils.fColor);
        this.fftPhaseBtn.setFont(GraphicsUtils.labelFont);
        this.fftPhaseBtn.setBounds(5, 110, 160, 25);
        this.mathPanel.add(this.fftPhaseBtn);
        this.mathBtnGrp.add(this.fftPhaseBtn);
        this.removeAvgBtn = new JCheckBox("Remove Average (FFT)");
        this.removeAvgBtn.setForeground(GraphicsUtils.fColor);
        this.removeAvgBtn.setFont(GraphicsUtils.labelFont);
        this.removeAvgBtn.setBounds(5, 135, 160, 25);
        this.mathPanel.add(this.removeAvgBtn);
        switch (this.dataView.getMathFunction()) {
            case 0: {
                this.noMathBtn.setSelected(true);
                break;
            }
            case 1: {
                this.derivativeBtn.setSelected(true);
                break;
            }
            case 2: {
                this.integralBtn.setSelected(true);
                break;
            }
            case 3: {
                this.fftModBtn.setSelected(true);
                break;
            }
            case 4: {
                this.fftPhaseBtn.setSelected(true);
            }
        }
        this.removeAvgBtn.setSelected(this.dataView.getRemoveAverage());
        this.noMathBtn.addChangeListener(this);
        this.derivativeBtn.addChangeListener(this);
        this.integralBtn.addChangeListener(this);
        this.fftModBtn.addChangeListener(this);
        this.fftPhaseBtn.addChangeListener(this);
        this.removeAvgBtn.addChangeListener(this);
        this.nameLabel = new JLabel();
        this.nameLabel.setText(this.dataView.getName());
        this.tabPane.add("Curve", this.linePanel);
        this.tabPane.add("Bar", this.barPanel);
        this.tabPane.add("Marker", this.markerPanel);
        this.tabPane.add("Transform", this.transformPanel);
        this.tabPane.add("Interpolation", this.interpPanel);
        this.tabPane.add("Smoothing", this.smoothPanel);
        this.tabPane.add("Math", this.mathPanel);
        innerPane.add(this.tabPane);
        innerPane.add(this.nameLabel);
        this.closeBtn = new JButton();
        this.closeBtn.setText("Close");
        innerPane.add(this.closeBtn);
        this.tabPane.setBounds(5, 5, 260, 270);
        this.closeBtn.setBounds(185, 280, 80, 25);
        this.nameLabel.setBounds(10, 280, 170, 25);
        this.closeBtn.addMouseListener(this);
        this.updateControls();
        innerPane.setPreferredSize(new Dimension(270, 310));
        this.setContentPane(innerPane);
        this.setResizable(false);
    }

    private void updateControls() {
        this.biasText.setEnabled(false);
        this.tensionText.setEnabled(false);
        this.sigmaText.setEnabled(false);
        switch (this.dataView.getInterpolationMethod()) {
            case 4: {
                this.biasText.setEnabled(true);
                this.tensionText.setEnabled(true);
            }
        }
        switch (this.dataView.getSmoothingMethod()) {
            case 3: {
                this.sigmaText.setEnabled(true);
            }
        }
    }

    public void Commit() {
        if (this.chart != null) {
            this.chart.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Color c;
        if (e.getSource() == this.closeBtn) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.lineColorBtn) {
            Color c2 = JColorChooser.showDialog(this, "Choose Line Color", this.dataView.getColor());
            if (c2 != null) {
                this.dataView.setColor(c2);
                this.lineColorView.setBackground(c2);
                this.Commit();
            }
        } else if (e.getSource() == this.fillColorBtn) {
            Color c3 = JColorChooser.showDialog(this, "Choose Fill Color", this.dataView.getFillColor());
            if (c3 != null) {
                this.dataView.setFillColor(c3);
                this.fillColorView.setBackground(c3);
                this.Commit();
            }
        } else if (e.getSource() == this.markerColorBtn && (c = JColorChooser.showDialog(this, "Choose marker Color", this.dataView.getMarkerColor())) != null) {
            this.dataView.setMarkerColor(c);
            this.markerColorView.setBackground(c);
            this.Commit();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.lineDashCombo) {
            this.dataView.setStyle(this.lineDashCombo.getSelectedIndex());
            this.Commit();
        } else if (e.getSource() == this.fillStyleCombo) {
            this.dataView.setFillStyle(this.fillStyleCombo.getSelectedIndex());
            this.Commit();
        } else if (e.getSource() == this.fillMethodCombo) {
            this.dataView.setFillMethod(this.fillMethodCombo.getSelectedIndex());
            this.Commit();
        } else if (e.getSource() == this.viewTypeCombo) {
            this.dataView.setViewType(this.viewTypeCombo.getSelectedIndex());
            this.Commit();
        } else if (e.getSource() == this.markerStyleCombo) {
            this.dataView.setMarker(this.markerStyleCombo.getSelectedIndex());
            this.Commit();
        } else if (e.getSource() == this.labelVisibleCheck) {
            this.dataView.setLabelVisible(this.labelVisibleCheck.isSelected());
            this.Commit();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.lineWidthSpinner) {
            Integer v = (Integer)this.lineWidthSpinner.getValue();
            this.dataView.setLineWidth(v);
        } else if (src == this.barWidthSpinner) {
            Integer v = (Integer)this.barWidthSpinner.getValue();
            this.dataView.setBarWidth(v);
        } else if (src == this.markerSizeSpinner) {
            Integer v = (Integer)this.markerSizeSpinner.getValue();
            this.dataView.setMarkerSize(v);
        } else if (src == this.stepSpinner) {
            Integer v = (Integer)this.stepSpinner.getValue();
            this.dataView.setInterpolationStep(v);
        } else if (src == this.neighborSpinner) {
            Integer v = (Integer)this.neighborSpinner.getValue();
            this.dataView.setSmoothingNeighbors(v);
        } else if (src == this.noInterpBtn) {
            if (this.noInterpBtn.isSelected()) {
                this.dataView.setInterpolationMethod(0);
            }
        } else if (src == this.linearBtn) {
            if (this.linearBtn.isSelected()) {
                this.dataView.setInterpolationMethod(1);
            }
        } else if (src == this.cosineBtn) {
            if (this.cosineBtn.isSelected()) {
                this.dataView.setInterpolationMethod(2);
            }
        } else if (src == this.cubicBtn) {
            if (this.cubicBtn.isSelected()) {
                this.dataView.setInterpolationMethod(3);
            }
        } else if (src == this.hermiteBtn) {
            if (this.hermiteBtn.isSelected()) {
                this.dataView.setInterpolationMethod(4);
            }
        } else if (src == this.noSmoothBtn) {
            if (this.noSmoothBtn.isSelected()) {
                this.dataView.setSmoothingMethod(0);
            }
        } else if (src == this.flatSmoothBtn) {
            if (this.flatSmoothBtn.isSelected()) {
                this.dataView.setSmoothingMethod(1);
            }
        } else if (src == this.triangularSmoothBtn) {
            if (this.triangularSmoothBtn.isSelected()) {
                this.dataView.setSmoothingMethod(2);
            }
        } else if (src == this.gaussianSmoothBtn) {
            if (this.gaussianSmoothBtn.isSelected()) {
                this.dataView.setSmoothingMethod(3);
            }
        } else if (src == this.noExtBtn) {
            if (this.noExtBtn.isSelected()) {
                this.dataView.setSmoothingExtrapolation(0);
            }
        } else if (src == this.flatExtBtn) {
            if (this.flatExtBtn.isSelected()) {
                this.dataView.setSmoothingExtrapolation(1);
            }
        } else if (src == this.linearExtBtn) {
            if (this.linearExtBtn.isSelected()) {
                this.dataView.setSmoothingExtrapolation(2);
            }
        } else if (src == this.noMathBtn) {
            if (this.noMathBtn.isSelected()) {
                this.dataView.setMathFunction(0);
            }
        } else if (src == this.derivativeBtn) {
            if (this.derivativeBtn.isSelected()) {
                this.dataView.setMathFunction(1);
            }
        } else if (src == this.integralBtn) {
            if (this.integralBtn.isSelected()) {
                this.dataView.setMathFunction(2);
            }
        } else if (src == this.fftModBtn) {
            if (this.fftModBtn.isSelected()) {
                this.dataView.setMathFunction(3);
            }
        } else if (src == this.fftPhaseBtn) {
            if (this.fftPhaseBtn.isSelected()) {
                this.dataView.setMathFunction(4);
            }
        } else if (src == this.removeAvgBtn) {
            this.dataView.setRemoveAverage(this.removeAvgBtn.isSelected());
        }
        this.updateControls();
        this.Commit();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.transformA0Text) {
            if (e.getKeyCode() == 10) {
                String s = this.transformA0Text.getText();
                try {
                    double d = Double.parseDouble(s);
                    this.dataView.setA0(d);
                    this.Commit();
                }
                catch (NumberFormatException err) {
                    this.transformA0Text.setText(Double.toString(this.dataView.getA0()));
                }
            }
            if (e.getKeyCode() == 27) {
                this.transformA0Text.setText(Double.toString(this.dataView.getA0()));
            }
        } else if (e.getSource() == this.transformA1Text) {
            if (e.getKeyCode() == 10) {
                String s = this.transformA1Text.getText();
                try {
                    double d = Double.parseDouble(s);
                    this.dataView.setA1(d);
                    this.Commit();
                }
                catch (NumberFormatException err) {
                    this.transformA1Text.setText(Double.toString(this.dataView.getA1()));
                }
            }
            if (e.getKeyCode() == 27) {
                this.transformA1Text.setText(Double.toString(this.dataView.getA1()));
            }
        } else if (e.getSource() == this.transformA2Text) {
            if (e.getKeyCode() == 10) {
                String s = this.transformA2Text.getText();
                try {
                    double d = Double.parseDouble(s);
                    this.dataView.setA2(d);
                    this.Commit();
                }
                catch (NumberFormatException err) {
                    this.transformA2Text.setText(Double.toString(this.dataView.getA2()));
                }
            }
            if (e.getKeyCode() == 27) {
                this.transformA2Text.setText(Double.toString(this.dataView.getA2()));
            }
        } else if (e.getSource() == this.lineNameText) {
            this.dataView.setName(this.lineNameText.getText());
            this.Commit();
        } else if (e.getSource() == this.tensionText) {
            if (e.getKeyCode() == 10) {
                String s = this.tensionText.getText();
                try {
                    double d = Double.parseDouble(s);
                    this.dataView.setHermiteTension(d);
                    this.Commit();
                }
                catch (NumberFormatException err) {
                    this.tensionText.setText(Double.toString(this.dataView.getHermiteTension()));
                }
            }
            if (e.getKeyCode() == 27) {
                this.tensionText.setText(Double.toString(this.dataView.getHermiteTension()));
            }
        } else if (e.getSource() == this.biasText) {
            if (e.getKeyCode() == 10) {
                String s = this.biasText.getText();
                try {
                    double d = Double.parseDouble(s);
                    this.dataView.setHermiteBias(d);
                    this.Commit();
                }
                catch (NumberFormatException err) {
                    this.tensionText.setText(Double.toString(this.dataView.getHermiteBias()));
                }
            }
            if (e.getKeyCode() == 27) {
                this.biasText.setText(Double.toString(this.dataView.getHermiteBias()));
            }
        } else if (e.getSource() == this.sigmaText) {
            if (e.getKeyCode() == 10) {
                String s = this.sigmaText.getText();
                try {
                    double d = Double.parseDouble(s);
                    this.dataView.setSmoothingGaussSigma(d);
                    this.Commit();
                }
                catch (NumberFormatException err) {
                    this.sigmaText.setText(Double.toString(this.dataView.getSmoothingGaussSigma()));
                }
            }
            if (e.getKeyCode() == 27) {
                this.sigmaText.setText(Double.toString(this.dataView.getSmoothingGaussSigma()));
            }
        }
    }
}

