/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StatFrame
extends JFrame {
    private JPanel innerPanel;
    private JPanel btnPanel;
    private Vector<JLDataView> views;
    private JLChart parent;
    private JLabel atLabel;
    private JLabel avgLabel;
    private JTextField avgText;
    private JPanel dummyPanel0;
    private JPanel dummyPanel1;
    private JPanel dummyPanel2;
    private JPanel dummyPanel3;
    private JPanel dummyPanel4;
    private JPanel dummyPanel5;
    private JPanel dummyPanel6;
    private JTextField maxAtText;
    private JLabel maxLabel;
    private JTextField maxText;
    private JTextField minAtText;
    private JLabel minLabel;
    private JTextField minText;
    private JLabel rangeLabel;
    private JTextField rangeText;
    private JLabel rmsLabel;
    private JTextField rmsText;
    private JPanel statPanel;
    private JLabel stdLabel;
    private JTextField stdText;
    private JLabel valueLabel;

    public StatFrame(JLChart parent, Vector<JLDataView> views) {
        this.views = views;
        this.parent = parent;
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BorderLayout());
        this.statPanel = new JPanel();
        this.minLabel = new JLabel();
        this.maxLabel = new JLabel();
        this.rangeLabel = new JLabel();
        this.avgLabel = new JLabel();
        this.stdLabel = new JLabel();
        this.rmsLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.atLabel = new JLabel();
        this.minText = new JTextField();
        this.maxText = new JTextField();
        this.rangeText = new JTextField();
        this.minAtText = new JTextField();
        this.maxAtText = new JTextField();
        this.avgText = new JTextField();
        this.stdText = new JTextField();
        this.rmsText = new JTextField();
        this.dummyPanel0 = new JPanel();
        this.dummyPanel1 = new JPanel();
        this.dummyPanel2 = new JPanel();
        this.dummyPanel3 = new JPanel();
        this.dummyPanel4 = new JPanel();
        this.dummyPanel5 = new JPanel();
        this.dummyPanel6 = new JPanel();
        this.setDefaultCloseOperation(3);
        Font textFont = new Font("Dialog", 0, 14);
        this.statPanel.setBackground(new Color(0, 0, 0));
        GridBagLayout statPanelLayout = new GridBagLayout();
        this.statPanel.setLayout(statPanelLayout);
        this.minLabel.setBackground(new Color(204, 204, 204));
        this.minLabel.setFont(new Font("Dialog", 0, 12));
        this.minLabel.setText("Minimum");
        this.minLabel.setToolTipText("");
        this.minLabel.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.minLabel, gridBagConstraints);
        this.maxLabel.setBackground(new Color(204, 204, 204));
        this.maxLabel.setFont(new Font("Dialog", 0, 12));
        this.maxLabel.setText("Maximum");
        this.maxLabel.setToolTipText("");
        this.maxLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.maxLabel, gridBagConstraints);
        this.rangeLabel.setBackground(new Color(204, 204, 204));
        this.rangeLabel.setFont(new Font("Dialog", 0, 12));
        this.rangeLabel.setText("Range");
        this.rangeLabel.setToolTipText("");
        this.rangeLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.rangeLabel, gridBagConstraints);
        this.avgLabel.setBackground(new Color(204, 204, 204));
        this.avgLabel.setFont(new Font("Dialog", 0, 12));
        this.avgLabel.setText("Average");
        this.avgLabel.setToolTipText("");
        this.avgLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.avgLabel, gridBagConstraints);
        this.stdLabel.setBackground(new Color(204, 204, 204));
        this.stdLabel.setFont(new Font("Dialog", 0, 12));
        this.stdLabel.setText("Standard Deviation");
        this.stdLabel.setToolTipText("");
        this.stdLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.stdLabel, gridBagConstraints);
        this.rmsLabel.setBackground(new Color(204, 204, 204));
        this.rmsLabel.setFont(new Font("Dialog", 0, 12));
        this.rmsLabel.setText("RMS");
        this.rmsLabel.setToolTipText("");
        this.rmsLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.rmsLabel, gridBagConstraints);
        this.valueLabel.setBackground(new Color(204, 204, 204));
        this.valueLabel.setFont(new Font("Dialog", 0, 12));
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setText("Value");
        this.valueLabel.setToolTipText("");
        this.valueLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.statPanel.add((Component)this.valueLabel, gridBagConstraints);
        this.atLabel.setBackground(new Color(204, 204, 204));
        this.atLabel.setFont(new Font("Dialog", 0, 12));
        this.atLabel.setHorizontalAlignment(0);
        this.atLabel.setText("At (X=)");
        this.atLabel.setToolTipText("");
        this.atLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.atLabel, gridBagConstraints);
        this.minText.setEditable(false);
        this.minText.setBackground(new Color(255, 255, 255));
        this.minText.setFont(textFont);
        this.minText.setText("-----");
        this.minText.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.statPanel.add((Component)this.minText, gridBagConstraints);
        this.maxText.setEditable(false);
        this.maxText.setBackground(new Color(255, 255, 255));
        this.maxText.setFont(textFont);
        this.maxText.setText("-----");
        this.maxText.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.statPanel.add((Component)this.maxText, gridBagConstraints);
        this.rangeText.setEditable(false);
        this.rangeText.setBackground(new Color(255, 255, 255));
        this.rangeText.setFont(textFont);
        this.rangeText.setText("-----");
        this.rangeText.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.statPanel.add((Component)this.rangeText, gridBagConstraints);
        this.minAtText.setEditable(false);
        this.minAtText.setBackground(new Color(255, 255, 255));
        this.minAtText.setFont(textFont);
        this.minAtText.setText("-----");
        this.minAtText.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.minAtText, gridBagConstraints);
        this.maxAtText.setEditable(false);
        this.maxAtText.setBackground(new Color(255, 255, 255));
        this.maxAtText.setFont(textFont);
        this.maxAtText.setText("-----");
        this.maxAtText.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.maxAtText, gridBagConstraints);
        this.avgText.setEditable(false);
        this.avgText.setBackground(new Color(255, 255, 255));
        this.avgText.setFont(textFont);
        this.avgText.setText("-----");
        this.avgText.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.statPanel.add((Component)this.avgText, gridBagConstraints);
        this.stdText.setEditable(false);
        this.stdText.setBackground(new Color(255, 255, 255));
        this.stdText.setFont(textFont);
        this.stdText.setText("-----");
        this.stdText.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.statPanel.add((Component)this.stdText, gridBagConstraints);
        this.rmsText.setEditable(false);
        this.rmsText.setBackground(new Color(255, 255, 255));
        this.rmsText.setFont(textFont);
        this.rmsText.setText("-----");
        this.rmsText.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.statPanel.add((Component)this.rmsText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.dummyPanel0, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.dummyPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.dummyPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.dummyPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        this.statPanel.add((Component)this.dummyPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.statPanel.add((Component)this.dummyPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        this.statPanel.add((Component)this.dummyPanel6, gridBagConstraints);
        this.innerPanel.add((Component)this.statPanel, "Center");
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout(2));
        this.innerPanel.add((Component)this.btnPanel, "South");
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatFrame.this.refreshStat();
            }
        });
        this.btnPanel.add(refreshButton);
        JButton dismissButton = new JButton("Dismiss");
        dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatFrame.this.setVisible(false);
            }
        });
        this.btnPanel.add(dismissButton);
        this.setContentPane(this.innerPanel);
        Object vTitle = "[All]";
        if (views.size() == 1) {
            vTitle = "[" + views.get(0).getName() + "]";
        }
        this.refreshStat();
        this.setTitle("Statistics " + (String)vTitle);
        ATKGraphicsUtils.centerFrame(parent, this);
        this.setVisible(true);
    }

    private String formatX(double x) {
        if (this.parent.getXAxis().getAnnotation() == 1) {
            return JLAxis.formatTimeValue(x);
        }
        return Double.toString(x);
    }

    private void refreshStat() {
        int nbData = 0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double minX = 0.0;
        double maxX = 0.0;
        double avg = 0.0;
        double sum = 0.0;
        double sum2 = 0.0;
        double rms = 0.0;
        double std = 0.0;
        for (int i = 0; i < this.views.size(); ++i) {
            DataList l = this.views.get(i).getData();
            while (l != null) {
                if (!Double.isNaN(l.x) && !Double.isNaN(l.y)) {
                    ++nbData;
                    if (l.y < min) {
                        min = l.y;
                        minX = l.x;
                    }
                    if (l.y > max) {
                        max = l.y;
                        maxX = l.x;
                    }
                    sum += l.y;
                    sum2 += l.y * l.y;
                }
                l = l.next;
            }
        }
        if (nbData > 0) {
            double N = nbData;
            avg = sum / N;
            rms = Math.sqrt(sum2 / N);
            sum2 = 0.0;
            for (int i = 0; i < this.views.size(); ++i) {
                DataList l = this.views.get(i).getData();
                while (l != null) {
                    if (!Double.isNaN(l.x) && !Double.isNaN(l.y)) {
                        sum2 += (l.y - avg) * (l.y - avg);
                    }
                    l = l.next;
                }
            }
            std = Math.sqrt(sum2 / N);
            this.minText.setText(Double.toString(min));
            this.minAtText.setText(this.formatX(minX));
            this.maxText.setText(Double.toString(max));
            this.maxAtText.setText(this.formatX(maxX));
            this.rangeText.setText(Double.toString(max - min));
            this.avgText.setText(Double.toString(avg));
            this.stdText.setText(Double.toString(std));
            this.rmsText.setText(Double.toString(rms));
        } else {
            this.minText.setText("-----");
            this.minAtText.setText("");
            this.maxText.setText("-----");
            this.maxAtText.setText("");
            this.rangeText.setText("-----");
            this.avgText.setText("-----");
            this.stdText.setText("-----");
            this.rmsText.setText("-----");
        }
    }
}

