/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;

class TabbedLine {
    JLDataView[] dv;
    DataList[] dl;
    double[] lastValue;
    int anno;
    int sIndex;
    int precision = 0;
    String noValueString = "";
    boolean correlated;

    TabbedLine(int nb) {
        this.dv = new JLDataView[nb];
        this.dl = new DataList[nb];
        this.lastValue = new double[nb];
    }

    void setCorrelated(boolean correlated) {
        this.correlated = correlated;
    }

    void setPrecision(int milliseconds) {
        this.precision = milliseconds;
    }

    void setNoValueString(String noValueString) {
        this.noValueString = noValueString;
    }

    void add(int id, JLDataView v) {
        this.dv[id] = v;
        this.dl[id] = v.getData();
        this.lastValue[id] = v.getData() != null ? v.getData().y : Double.NaN;
    }

    double getMinTime() {
        double r = Double.MAX_VALUE;
        for (int i = 0; i < this.dl.length; ++i) {
            if (this.dl[i] == null || !(this.dl[i].x < r)) continue;
            r = this.dl[i].x;
        }
        return r;
    }

    String getFirstLine(int annotation) {
        StringBuffer ret = new StringBuffer();
        this.anno = annotation;
        if (annotation == 1) {
            ret.append("Time (s)\t");
        } else {
            ret.append("Index\t");
        }
        for (int i = 0; i < this.dv.length; ++i) {
            ret.append(this.dv[i].getName() + "\t");
        }
        ret.append("\n");
        return ret.toString();
    }

    String getNextLine() {
        double t0 = this.getMinTime();
        if (t0 == Double.MAX_VALUE) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        if (this.anno == 1) {
            long t = (long)t0;
            long ts = t / 1000L;
            long ms = t % 1000L;
            if (ms == 0L) {
                ret.append(ts + "\t");
            } else if (ms < 10L) {
                ret.append(ts + ".00" + ms + "\t");
            } else if (ms < 100L) {
                ret.append(ts + ".0" + ms + "\t");
            } else {
                ret.append(ts + "." + ms + "\t");
            }
        } else {
            ret.append(Double.toString(t0) + "\t");
        }
        if (this.correlated) {
            for (int i = 0; i < this.dl.length; ++i) {
                if (this.dl[i] != null) {
                    if (this.dl[i].x == t0) {
                        ret.append(Double.toString(this.dl[i].y) + "\t");
                        this.lastValue[i] = this.dl[i].y;
                        this.dl[i] = this.dl[i].next;
                        continue;
                    }
                    ret.append(Double.toString(this.lastValue[i]) + "\t");
                    continue;
                }
                ret.append(Double.toString(this.lastValue[i]) + "\t");
            }
        } else {
            for (int i = 0; i < this.dl.length; ++i) {
                if (this.dl[i] != null) {
                    if (this.dl[i].x >= t0 - (double)this.precision && this.dl[i].x <= t0 + (double)this.precision) {
                        ret.append(Double.toString(this.dl[i].y) + "\t");
                        this.dl[i] = this.dl[i].next;
                        continue;
                    }
                    ret.append(this.noValueString + "\t");
                    continue;
                }
                ret.append(this.noValueString + "\t");
            }
        }
        ret.append("\n");
        return ret.toString();
    }

    String[] getFirstFields(int annotation, boolean showIndex) {
        this.anno = annotation;
        this.sIndex = showIndex ? 1 : 0;
        String[] ret = new String[this.dv.length + this.sIndex];
        if (this.sIndex > 0) {
            ret[0] = annotation == 1 ? "Time (s)" : "Index";
        }
        for (int i = 0; i < this.dv.length; ++i) {
            ret[i + this.sIndex] = this.dv[i].getName();
        }
        return ret;
    }

    String[] getNextFields() {
        double t0 = this.getMinTime();
        if (t0 == Double.MAX_VALUE) {
            return null;
        }
        String[] ret = new String[this.dv.length + this.sIndex];
        if (this.sIndex > 0) {
            ret[0] = this.anno == 1 ? JLAxis.formatTimeValue(t0) : Double.toString(t0);
        }
        for (int i = 0; i < this.dl.length; ++i) {
            if (this.dl[i] != null) {
                if (this.dl[i].x >= t0 - (double)this.precision && this.dl[i].x <= t0 + (double)this.precision) {
                    ret[i + this.sIndex] = this.dv[i].formatValue(this.dl[i].y);
                    this.dl[i] = this.dl[i].next;
                    continue;
                }
                ret[i + this.sIndex] = "";
                continue;
            }
            ret[i + this.sIndex] = "";
        }
        return ret;
    }
}

