/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.examples;

import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ChartExample2
extends JFrame {
    public ChartExample2() {
        final JLChart chart = new JLChart();
        chart.setHeaderFont(new Font("Times", 1, 18));
        chart.setHeader("Real Time Monitoring");
        chart.setDisplayDuration(3600000.0);
        chart.getY1Axis().setName("deg C");
        chart.getY1Axis().setAutoScale(false);
        chart.getY1Axis().setMinimum(0.0);
        chart.getY1Axis().setMaximum(40.0);
        chart.getY2Axis().setName("%");
        chart.getY2Axis().setAutoScale(false);
        chart.getY2Axis().setMinimum(0.0);
        chart.getY2Axis().setMaximum(100.0);
        chart.getXAxis().setAutoScale(true);
        chart.getXAxis().setName("Time");
        final JLDataView temperature = new JLDataView();
        temperature.setName("Temperature");
        temperature.setUnit("deg C");
        temperature.setColor(new Color(200, 0, 0));
        temperature.setLineWidth(2);
        chart.getY1Axis().addDataView(temperature);
        final JLDataView humidity = new JLDataView();
        humidity.setName("Humidity");
        humidity.setUnit("%");
        humidity.setColor(Color.blue);
        humidity.setLineWidth(2);
        chart.getY2Axis().addDataView(humidity);
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    double time = System.currentTimeMillis();
                    double t = Math.random() * 1.0 + 24.0;
                    double h = Math.random() * 5.0 + 50.0;
                    chart.addData(temperature, time, t);
                    chart.addData(humidity, time, h);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
        JPanel bot = new JPanel();
        bot.setLayout(new FlowLayout());
        JButton b = new JButton("Exit");
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }
        });
        bot.add(b);
        JButton c = new JButton("Graph options");
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                chart.showOptionDialog();
            }
        });
        bot.add(c);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)chart, "Center");
        this.getContentPane().add((Component)bot, "South");
        this.setSize(640, 480);
        this.setTitle("Chart Example 2");
        this.setVisible(true);
    }

    public static void main(String[] args) {
        ChartExample2 f = new ChartExample2();
    }
}

