/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.examples;

import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ChartExample3
extends JFrame {
    public ChartExample3() {
        final JLChart chart = new JLChart();
        chart.setHeaderFont(new Font("Times", 1, 18));
        chart.setHeader("Real time XY Monitoring");
        chart.setDisplayDuration(60000.0);
        chart.getY1Axis().setName("X value");
        chart.getY1Axis().setAutoScale(true);
        chart.getXAxis().setAutoScale(true);
        chart.getXAxis().setName("Y value");
        final JLDataView yData1 = new JLDataView();
        yData1.setName("XY plot1");
        yData1.setColor(new Color(200, 0, 0));
        yData1.setMarkerColor(new Color(100, 0, 0));
        yData1.setLineWidth(1);
        yData1.setMarker(1);
        yData1.setMarkerSize(4);
        chart.getY1Axis().addDataView(yData1);
        final JLDataView xData = new JLDataView();
        xData.setName("X view");
        chart.getXAxis().addDataView(xData);
        final double startTime = (double)System.currentTimeMillis() / 1000.0;
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    double now = (double)System.currentTimeMillis() / 1000.0;
                    double t1 = Math.PI * 2 * ((now - startTime) / 30.0);
                    double t2 = Math.PI * 2 * ((now - startTime) / 300.0);
                    chart.addData(xData, now * 1000.0, Math.sin(t1) * Math.sin(t2));
                    chart.addData(yData1, now * 1000.0, Math.sin(t1 + 2.0) * Math.sin(t2));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
        JPanel bot = new JPanel();
        bot.setLayout(new FlowLayout());
        JButton b = new JButton("Exit");
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }
        });
        bot.add(b);
        JButton c = new JButton("Graph options");
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                chart.showOptionDialog();
            }
        });
        bot.add(c);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)chart, "Center");
        this.getContentPane().add((Component)bot, "South");
        this.setSize(640, 480);
        this.setTitle("Chart Example 3");
        this.setVisible(true);
    }

    public static void main(String[] args) {
        ChartExample3 f = new ChartExample3();
    }
}

