/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.math;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.AdvancedJLChart;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.math.ExpressionParser;
import fr.esrf.tangoatk.widget.util.chart.math.ParserOptionDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class StaticChartMathExpression
extends AdvancedJLChart
implements IJLChartActionListener {
    protected static final String EVALUATE_EXPRESSION = "Evaluate an expression";
    public static final int Y1_AXIS = 0;
    public static final int Y2_AXIS = 1;
    public static final int X_AXIS = 2;
    private boolean useXViewsWithExpressions = true;
    private boolean canPutExpressionOnX = true;
    protected HashMap<JLDataView, Object[]> expressionMap = new HashMap();

    public StaticChartMathExpression() {
        this.addUserAction(EVALUATE_EXPRESSION);
        this.addJLChartActionListener(this);
    }

    public void showExpressionDialog() {
        JLDataView expressionDataView = new JLDataView();
        Container dlgParent = this.getRootPane().getParent();
        ParserOptionDialog optionDlg = dlgParent instanceof JDialog ? new ParserOptionDialog((JDialog)dlgParent, (JLChart)this, expressionDataView) : (dlgParent instanceof JFrame ? new ParserOptionDialog((JFrame)dlgParent, (JLChart)this, expressionDataView) : new ParserOptionDialog((JFrame)null, (JLChart)this, expressionDataView));
        ATKGraphicsUtils.centerDialog(optionDlg);
        optionDlg.setVisible(true);
        boolean ok = optionDlg.isValidated;
        int selectedAxis = optionDlg.selectedAxis;
        if (ok) {
            this.applyExpressionToChart(optionDlg.expressionField.getText().trim(), expressionDataView, selectedAxis, optionDlg.getVariables(), optionDlg.isX());
        }
        optionDlg.dispose();
        optionDlg = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JLDataView applyExpressionToChart(String expression, JLDataView expressionDataView, int selectedAxis, String[] variables, boolean x) {
        JLDataView resultView;
        if (selectedAxis == 2 && !this.isCanPutExpressionOnX()) {
            return null;
        }
        HashMap<JLDataView, Object[]> hashMap = this.expressionMap;
        synchronized (hashMap) {
            Object[] parameters;
            if (expressionDataView != null && this.expressionMap.containsKey(expressionDataView)) {
                parameters = this.expressionMap.get(expressionDataView);
                Integer axis = (Integer)parameters[0];
                switch (axis) {
                    case 2: {
                        this.getXAxis().removeDataView(expressionDataView);
                        break;
                    }
                    case 0: {
                        this.getY1Axis().removeDataView(expressionDataView);
                        break;
                    }
                    case 1: {
                        this.getY2Axis().removeDataView(expressionDataView);
                    }
                }
                this.expressionMap.remove(expressionDataView);
                expressionDataView.reset();
            }
            resultView = this.applyExpression(expression, expressionDataView, variables, x);
            parameters = new Object[variables.length + 3];
            parameters[0] = new Integer(selectedAxis);
            parameters[1] = expression;
            parameters[2] = new Boolean(x);
            for (int i = 0; i < variables.length; ++i) {
                parameters[i + 3] = variables[i];
            }
            this.expressionMap.put(resultView, parameters);
        }
        switch (selectedAxis) {
            case 2: {
                this.getXAxis().addDataView(resultView);
                if (this.getXAxis().isVisible()) break;
                this.getXAxis().setVisible(true);
                this.getXAxis().setAutoScale(true);
                break;
            }
            case 0: {
                this.getY1Axis().addDataView(resultView);
                if (this.getY1Axis().isVisible()) break;
                this.getY1Axis().setVisible(true);
                this.getY1Axis().setAutoScale(true);
                break;
            }
            case 1: {
                this.getY2Axis().addDataView(resultView);
                if (this.getY2Axis().isVisible()) break;
                this.getY2Axis().setVisible(true);
                this.getY2Axis().setAutoScale(true);
            }
        }
        this.repaint();
        return resultView;
    }

    protected JLDataView applyExpression(String expression, JLDataView expressionDataView, String[] variables, boolean x) {
        JLDataView resultView = null;
        Vector<JLDataView> views = this.prepareViews();
        ExpressionParser parser = new ExpressionParser(variables.length, expression);
        parser.setX(x);
        parser.setPrecision(this.getTimePrecision());
        block0: for (int i = 0; i < variables.length; ++i) {
            for (int v = 0; v < views.size(); ++v) {
                if (!variables[i].equals(views.get(v).getName())) continue;
                parser.add(i, views.get(v));
                continue block0;
            }
        }
        views.clear();
        views = null;
        resultView = parser.buildDataView(expressionDataView);
        parser.clean();
        parser = null;
        return resultView;
    }

    public Vector<JLDataView> prepareViews() {
        Vector<JLDataView> views = new Vector<JLDataView>();
        if (this.getXAxis().isXY() && this.isUseXViewsWithExpressions()) {
            views.addAll(this.getXAxis().getViews());
        }
        views.addAll(this.getY1Axis().getViews());
        views.addAll(this.getY2Axis().getViews());
        return views;
    }

    public synchronized void clearExpressions() {
        Set<JLDataView> keySet = this.expressionMap.keySet();
        for (JLDataView data : keySet) {
            Object[] parameters = this.expressionMap.get(data);
            Integer axis = (Integer)parameters[0];
            switch (axis) {
                case 2: {
                    this.getXAxis().removeDataView(data);
                    break;
                }
                case 0: {
                    this.getY1Axis().removeDataView(data);
                    break;
                }
                case 1: {
                    this.getY2Axis().removeDataView(data);
                }
            }
        }
        this.expressionMap.clear();
    }

    protected synchronized void updateExpressions(JLDataView view) {
        Vector<JLDataView> expressions = new Vector<JLDataView>();
        expressions.addAll(this.expressionMap.keySet());
        block0: for (int i = 0; i < expressions.size(); ++i) {
            JLDataView expressionView = (JLDataView)expressions.get(i);
            Object[] parameters = this.expressionMap.get(expressionView);
            if (parameters == null) continue;
            for (int j = 3; j < parameters.length; ++j) {
                if (!parameters[j].equals(view.getName())) continue;
                String expression = (String)parameters[1];
                Boolean x = (Boolean)parameters[2];
                String[] variables = new String[parameters.length - 3];
                for (int k = 0; k < variables.length; ++k) {
                    variables[k] = (String)parameters[k + 3];
                }
                expressionView.reset();
                this.applyExpression(expression, expressionView, variables, x);
                this.updateExpressions(expressionView);
                continue block0;
            }
        }
    }

    @Override
    public void actionPerformed(JLChartActionEvent evt) {
        if (EVALUATE_EXPRESSION.equals(evt.getName())) {
            this.showExpressionDialog();
        }
    }

    @Override
    public boolean getActionState(JLChartActionEvent evt) {
        return false;
    }

    @Override
    public String getConfiguration() {
        Object to_write = super.getConfiguration();
        to_write = (String)to_write + "expressions:" + this.expressionMap.size() + "\n";
        Set<JLDataView> keySet = this.expressionMap.keySet();
        Iterator<JLDataView> keyIterator = keySet.iterator();
        int i = 0;
        while (keyIterator.hasNext()) {
            JLDataView keyView = keyIterator.next();
            Object[] expressionData = this.expressionMap.get(keyView);
            to_write = (String)to_write + "expression_" + i + "_name:'" + keyView.getName() + "'\n";
            to_write = (String)to_write + "expression_" + i + "_axis:" + (Integer)expressionData[0] + "\n";
            to_write = (String)to_write + "expression_" + i + "_expression:'" + (String)expressionData[1] + "'\n";
            to_write = (String)to_write + "expression_" + i + "_isX:" + (Boolean)expressionData[2] + "\n";
            to_write = (String)to_write + "expression_" + i + "_variables:" + (expressionData.length - 3) + "\n";
            for (int j = 0; j < expressionData.length - 3; ++j) {
                to_write = (String)to_write + "expression_" + i + "_variable_" + j + ":'" + (String)expressionData[j + 3] + "'\n";
            }
            to_write = (String)to_write + keyView.getConfiguration("expression_" + i);
            ++i;
        }
        return to_write;
    }

    @Override
    public void applyConfiguration(CfFileReader f) {
        super.applyConfiguration(f);
        Vector<String> p = f.getParam("expressions");
        int expressionSize = 0;
        if (p != null) {
            expressionSize = OFormat.getInt(p.get(0).toString());
        }
        for (int i = 0; i < expressionSize; ++i) {
            JLDataView expressionView = new JLDataView();
            expressionView.applyConfiguration("expression_" + i, f);
            p = f.getParam("expression_" + i + "_name");
            if (p != null) {
                expressionView.setName(p.get(0).toString());
            }
            int axis = -1;
            p = f.getParam("expression_" + i + "_axis");
            if (p != null) {
                axis = OFormat.getInt(p.get(0).toString());
            }
            String expression = "";
            p = f.getParam("expression_" + i + "_expression");
            if (p != null) {
                expression = p.get(0).toString();
            }
            boolean x = false;
            p = f.getParam("expression_" + i + "_isX");
            if (p != null) {
                x = OFormat.getBoolean(p.get(0).toString());
            }
            int variablesCount = 0;
            p = f.getParam("expression_" + i + "_variables");
            if (p != null) {
                variablesCount = OFormat.getInt(p.get(0).toString());
            }
            String[] variables = new String[variablesCount];
            for (int j = 0; j < variablesCount; ++j) {
                String variable = "";
                p = f.getParam("expression_" + i + "_variable_" + j);
                if (p != null) {
                    variable = p.get(0).toString();
                }
                variables[j] = new String(variable);
                variable = null;
            }
            if (axis == -1) continue;
            this.applyExpressionToChart(expression, expressionView, axis, variables, x);
        }
    }

    @Override
    public void reset(boolean showConfirmDialog) {
        super.reset(showConfirmDialog);
        this.expressionMap.clear();
    }

    public static void main(String[] args) {
        String fileName;
        JFrame f = new JFrame();
        final StaticChartMathExpression chart = new StaticChartMathExpression();
        chart.setHeaderFont(new Font("Times", 1, 18));
        chart.setLabelFont(new Font("Times", 1, 12));
        chart.setHeader("Test DataView");
        chart.getXAxis().setAutoScale(true);
        chart.getXAxis().setGridVisible(true);
        chart.getXAxis().setSubGridVisible(true);
        chart.getXAxis().setAnnotation(2);
        chart.getY1Axis().setAutoScale(true);
        chart.getY1Axis().setGridVisible(true);
        chart.getY1Axis().setSubGridVisible(true);
        chart.getY2Axis().setVisible(false);
        chart.setUseXViewsWithExpressions(false);
        chart.setCanPutExpressionOnX(false);
        if (args.length > 0) {
            fileName = args[0];
        } else {
            JFileChooser chooser = new JFileChooser(".");
            chooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = null;
                    String s = f.getName();
                    int i = s.lastIndexOf(46);
                    if (i > 0 && i < s.length() - 1) {
                        extension = s.substring(i + 1).toLowerCase();
                    }
                    return extension != null && extension.equals("txt");
                }

                @Override
                public String getDescription() {
                    return "text files ";
                }
            });
            chooser.setDialogTitle("Load Graph Data (Text file with TAB separated fields)");
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                fileName = file.getAbsolutePath();
            } else {
                fileName = "";
                System.exit(0);
            }
        }
        chart.reset(false);
        chart.loadDataFile(fileName);
        JPanel bot = new JPanel();
        bot.setLayout(new FlowLayout());
        JButton b = new JButton("Exit");
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }
        });
        bot.add(b);
        JButton c = new JButton("Options");
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                chart.showOptionDialog();
            }
        });
        bot.add(c);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)chart, "Center");
        f.getContentPane().add((Component)bot, "South");
        f.setSize(400, 300);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public boolean isUseXViewsWithExpressions() {
        return this.useXViewsWithExpressions;
    }

    public void setUseXViewsWithExpressions(boolean useXViewsWithExpressions) {
        this.useXViewsWithExpressions = useXViewsWithExpressions;
    }

    public boolean isCanPutExpressionOnX() {
        return this.canPutExpressionOnX;
    }

    public void setCanPutExpressionOnX(boolean canSetExpressionOnX) {
        this.canPutExpressionOnX = canSetExpressionOnX;
    }

    @Override
    public void removeDataView(JLDataView view) {
        if (view != null) {
            super.removeDataView(view);
            if (this.expressionMap.containsKey(view)) {
                this.expressionMap.remove(view);
                view.reset();
                this.updateExpressions(view);
            }
        }
    }
}

