/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.math;

import fr.esrf.tangoatk.widget.util.chart.math.PossibleNamesLister;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

class VariablePanel
extends JPanel
implements MouseListener {
    protected String expression = null;
    protected JLabel[] variableTitles = null;
    protected JLabel[] variableNames = null;
    protected JLabel lastSelected = null;
    protected boolean x = false;
    protected JDialog parent;
    protected static final Border textBorder = new EtchedBorder();
    protected PossibleNamesLister lister = null;

    public VariablePanel(String[] names, JDialog parent) {
        this.setLayout(null);
        this.parent = parent;
        this.lister = new PossibleNamesLister(names, parent);
    }

    public void generateVariables() {
        this.removeAll();
        int width = 250;
        int height = 0;
        if (this.expression.indexOf("x1") != -1) {
            this.x = false;
            int count = 0;
            while (this.expression.indexOf("x" + (count + 1)) != -1) {
                ++count;
            }
            this.variableTitles = new JLabel[count];
            this.variableNames = new JLabel[count];
            for (int i = 0; i < count; ++i) {
                this.variableTitles[i] = new JLabel("x" + (i + 1) + ":");
                this.variableTitles[i].setBounds(0, i * 25, 30, 25);
                this.variableTitles[i].setMaximumSize(this.variableTitles[i].getPreferredSize());
                this.add(this.variableTitles[i]);
                this.variableNames[i] = new JLabel("");
                this.variableNames[i].setBounds(40, i * 25, 210, 25);
                this.variableNames[i].setBackground(Color.WHITE);
                this.variableNames[i].setBorder(textBorder);
                this.variableNames[i].setOpaque(true);
                this.variableNames[i].addMouseListener(this);
                this.variableNames[i].setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
                this.add(this.variableNames[i]);
                height += 25;
            }
        } else if (this.expression.replaceAll("x", "_x_").replaceAll("e_x_p", "exp").indexOf("_x_") != -1) {
            this.x = true;
            this.variableTitles = new JLabel[1];
            this.variableNames = new JLabel[1];
            this.variableTitles[0] = new JLabel("x:");
            this.variableTitles[0].setBounds(0, 0, 30, 25);
            this.variableTitles[0].setMaximumSize(this.variableTitles[0].getPreferredSize());
            this.add(this.variableTitles[0]);
            this.variableNames[0] = new JLabel("");
            this.variableNames[0].setBounds(40, 0, 210, 25);
            this.variableNames[0].setBackground(Color.WHITE);
            this.variableNames[0].setBorder(textBorder);
            this.variableNames[0].setOpaque(true);
            this.variableNames[0].addMouseListener(this);
            this.variableNames[0].setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
            this.add(this.variableNames[0]);
            height += 25;
        } else {
            this.x = false;
            this.variableTitles = new JLabel[0];
            this.variableNames = new JLabel[0];
        }
        this.setPreferredSize(new Dimension(width, height));
        this.revalidate();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lister.setDestination((JLabel)e.getSource());
        this.lister.initBounds();
        this.lister.setVisible(true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void dispose() {
        this.expression = null;
        if (this.variableNames != null) {
            for (int i = 0; i < this.variableNames.length; ++i) {
                this.variableNames[i] = null;
                this.variableTitles[i] = null;
            }
            this.variableNames = null;
            this.variableTitles = null;
        }
        this.lastSelected = null;
        this.parent = null;
    }

    public boolean isX() {
        return this.x;
    }

    public String[] getVariables() {
        String[] variables;
        if (this.variableNames == null) {
            variables = new String[]{};
        } else {
            variables = new String[this.variableNames.length];
            for (int i = 0; i < this.variableNames.length; ++i) {
                variables[i] = new String(this.variableNames[i].getText());
            }
        }
        return variables;
    }
}

