/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetEditorDlg;
import fr.esrf.tangoatk.widget.util.interlock.NetEditorListener;
import fr.esrf.tangoatk.widget.util.interlock.NetFileFilter;
import fr.esrf.tangoatk.widget.util.interlock.NetFileLoader;
import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import fr.esrf.tangoatk.widget.util.interlock.NetObjectDlg;
import fr.esrf.tangoatk.widget.util.interlock.NetUtils;
import fr.esrf.tangoatk.widget.util.interlock.UndoBuffer;
import fr.esrf.tangoatk.widget.util.interlock.XpssFileLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class NetEditor
extends JComponent
implements MouseListener,
MouseMotionListener {
    static final int DRAG_NONE = 0;
    static final int DRAG_OBJECT = 1;
    static final int DRAG_SELECTION = 2;
    static final int DRAG_LABEL = 3;
    static final int DRAG_LINK = 4;
    static final int DRAG_LINKMOVE = 5;
    public static final int CREATE_NONE = 0;
    public static final int CREATE_BUBBLE = 1;
    public static final int CREATE_TEXT = 3;
    public static final int CREATE_LINK = 4;
    Font smallFont = defaultSmallFont;
    Font labelFont = defaultLabelFont;
    boolean useAAFont = false;
    boolean showArrow = true;
    boolean isEditable = true;
    String defaultExtension = "net";
    int XGRID_SIZE = 20;
    int YGRID_SIZE = 16;
    private Vector objects;
    private Vector clipboard;
    private Vector undo;
    private JFrame pFrame;
    private boolean needToSave;
    private boolean moveBubble;
    private int dragMode;
    private int createMode;
    private Point dragStart;
    private Rectangle selDrag;
    private boolean onlyTextSelected;
    private NetObject selObject;
    private NetObject lnkObject;
    private NetObjectDlg dlgProp;
    private NetEditorDlg dlgOpt;
    private static final int undoLength = 15;
    private int undoPos;
    private Vector listeners;
    private String currentFileName;
    private static final float[] dashPattern = new float[]{2.0f};
    private static final BasicStroke dashStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f);
    static final Font defaultSmallFont = new Font("Dialog", 0, 9);
    static final Font defaultLabelFont = new Font("Dialog", 0, 11);

    public NetEditor() {
        this.pFrame = null;
        this.initComponents();
    }

    public NetEditor(JFrame parent) {
        this.pFrame = parent;
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(new Color(220, 220, 220));
        this.setLayout(null);
        this.objects = new Vector();
        this.clipboard = new Vector();
        this.dragMode = 0;
        this.dragStart = new Point();
        this.selDrag = new Rectangle();
        this.selObject = null;
        this.createMode = 0;
        this.dlgProp = new NetObjectDlg(this.pFrame, this);
        this.dlgOpt = new NetEditorDlg(this.pFrame, this);
        this.useAAFont = false;
        this.undo = new Vector();
        this.resetUndo();
        this.needToSave = false;
        this.listeners = new Vector();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.currentFileName = "";
        this.moveBubble = false;
        this.setPreferredSize(new Dimension(640, 480));
    }

    public void setEditable(boolean b) {
        this.unselectAll();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.dragMode = 0;
        if (this.createMode != 0) {
            this.createMode = 0;
            this.fireCancelCreate();
        }
        this.isEditable = b;
        this.repaint();
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setFileExtension(String ext) {
        this.defaultExtension = ext;
    }

    public String getFileExtension() {
        return this.defaultExtension;
    }

    public void loadFile(String fileName) throws IOException {
        char[] header_buff = new char[5];
        FileReader f = new FileReader(fileName);
        f.read(header_buff, 0, 5);
        f.close();
        f = new FileReader(fileName);
        String header = new String(header_buff);
        Vector objs = null;
        if (header.equalsIgnoreCase("Begin")) {
            fl = new XpssFileLoader(f);
            objs = ((XpssFileLoader)fl).parseXpssFile(new Dimension(this.XGRID_SIZE, this.YGRID_SIZE));
        } else {
            fl = new NetFileLoader(f, fileName);
            objs = ((NetFileLoader)fl).parseNetFile();
            this.smallFont = ((NetFileLoader)fl).getSmallFont();
            this.labelFont = ((NetFileLoader)fl).getLabelFont();
            this.useAAFont = ((NetFileLoader)fl).getUseAAFont();
            this.showArrow = ((NetFileLoader)fl).getDrawArrow();
        }
        f.close();
        this.clearObjects();
        this.currentFileName = fileName;
        for (int i = 0; i < objs.size(); ++i) {
            this.addObject((NetObject)objs.get(i));
        }
        this.resetUndo();
        this.computePreferredSize();
        this.setNeedToSave(false, "Load");
        this.repaint();
    }

    public void showOpenFileDialog(String defaultDir, NetFileFilter filter) {
        File f;
        boolean ok = false;
        JFileChooser chooser = new JFileChooser(defaultDir);
        if (this.currentFileName.length() > 0) {
            chooser.setSelectedFile(new File(this.currentFileName));
        }
        if (filter != null) {
            chooser.addChoosableFileFilter(filter);
        } else {
            String[] ext = new String[]{this.defaultExtension};
            String[] extPss = new String[]{"xpss", "pss"};
            chooser.addChoosableFileFilter(new NetFileFilter("PSS Network description file", extPss));
            chooser.addChoosableFileFilter(new NetFileFilter("Network description file", ext));
        }
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (f = chooser.getSelectedFile()) != null && !ok) {
            String fileName = f.getAbsolutePath();
            try {
                this.loadFile(fileName);
            }
            catch (IOException ex) {
                this.error("Error during reading file:" + fileName + "\n" + ex.getMessage());
                this.fireValueChanged();
            }
        }
    }

    public void saveNetFile(String fileName) throws IOException {
        int i;
        int sz = this.objects.size();
        if (sz == 0) {
            return;
        }
        if (!fileName.endsWith(this.defaultExtension) && JOptionPane.showConfirmDialog(this, "Do you really want to save " + fileName + "\nwith an extension different from the standard (." + this.defaultExtension + ") ?", "Confirm", 0) == 1) {
            return;
        }
        FileWriter f = new FileWriter(fileName);
        f.write("NetFile v10 {\n");
        f.write("  GlobalParam {\n");
        if (!NetUtils.fontEquals(this.labelFont, defaultLabelFont)) {
            f.write("    label_font:\"" + this.labelFont.getName() + "\"," + this.labelFont.getStyle() + "," + this.labelFont.getSize() + "\n");
        }
        if (!NetUtils.fontEquals(this.smallFont, defaultSmallFont)) {
            f.write("    small_font:\"" + this.smallFont.getName() + "\"," + this.smallFont.getStyle() + "," + this.smallFont.getSize() + "\n");
        }
        if (this.useAAFont) {
            f.write("    use_aa_font:1\n");
        }
        if (!this.showArrow) {
            f.write("    draw_arrow:0\n");
        }
        f.write("  }\n");
        for (i = 0; i < sz; ++i) {
            ((NetObject)this.objects.get(i)).setIndex(i);
        }
        for (i = 0; i < this.objects.size(); ++i) {
            ((NetObject)this.objects.get(i)).saveObject(f);
        }
        f.write("}\n");
        f.close();
        this.currentFileName = fileName;
        this.setNeedToSave(false, "Save");
    }

    public void showSaveFileDialog(String defaultDir, NetFileFilter filter) {
        File f;
        int ok = 0;
        JFileChooser chooser = new JFileChooser(defaultDir);
        if (this.currentFileName.length() > 0) {
            chooser.setSelectedFile(new File(this.currentFileName));
        }
        if (filter != null) {
            chooser.addChoosableFileFilter(filter);
        } else {
            String[] ext = new String[]{this.defaultExtension};
            chooser.addChoosableFileFilter(new NetFileFilter("Network description file", ext));
        }
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
            if (f.exists()) {
                ok = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + f.getName() + " ?", "Confirm overwrite", 0);
            }
            if (ok == 0) {
                String fileName = f.getAbsolutePath();
                try {
                    this.saveNetFile(fileName);
                }
                catch (IOException ex) {
                    this.error("Error during saving file:" + fileName + "\n" + ex.getMessage());
                }
            }
        }
    }

    public void saveCurrent(String defaultDir) {
        if (this.currentFileName.length() == 0) {
            this.showSaveFileDialog(defaultDir, null);
        } else {
            try {
                this.saveNetFile(this.currentFileName);
            }
            catch (IOException ex) {
                this.error("Error during saving file:" + this.currentFileName + "\n" + ex.getMessage());
            }
        }
    }

    public void setAntialiasFont(boolean b) {
        this.useAAFont = b;
        this.repaint();
    }

    public boolean getAntialiasFont() {
        return this.useAAFont;
    }

    public void unselectAll() {
        int sz = this.objects.size();
        for (int i = 0; i < sz; ++i) {
            ((NetObject)this.objects.get(i)).setSelected(false);
        }
        this.selObject = null;
        this.onlyTextSelected = false;
    }

    public void selectAll() {
        int sz = this.objects.size();
        this.onlyTextSelected = true;
        for (int i = 0; i < sz; ++i) {
            NetObject o = (NetObject)this.objects.get(i);
            o.setSelected(true);
            this.onlyTextSelected |= o.type == 2;
        }
        this.selObject = null;
    }

    public void newAll() {
        int ok = 0;
        if (this.objects.size() > 0 && (ok = JOptionPane.showConfirmDialog(this.pFrame, "Do you want to clear all objects. ?", "Confirm new", 0)) == 0) {
            this.clearObjects();
            this.setNeedToSave(true, "New all");
            this.repaint();
        }
    }

    public void setShowArrow(boolean b) {
        this.showArrow = b;
        this.repaint();
    }

    public boolean isShowingArrow() {
        return this.showArrow;
    }

    public void setCreateMode(int type) {
        if (!this.isEditable) {
            return;
        }
        this.createMode = type;
        switch (type) {
            case 1: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                break;
            }
            case 4: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                this.unselectAll();
                this.repaint();
            }
        }
    }

    public NetObject createBubbleObject(int x, int y) {
        return new NetObject(1, 0, 10, 10, x, y);
    }

    public void cutSelection() {
        this.copySelection();
        this.deleteSelection();
    }

    public void copySelection() {
        NetObject no;
        NetObject o;
        int i;
        int[] nIdx = new int[this.objects.size()];
        int[] oIdx = new int[this.objects.size()];
        if (!this.isEditable) {
            return;
        }
        this.clipboard.clear();
        for (i = 0; i < this.objects.size(); ++i) {
            nIdx[i] = -1;
            oIdx[i] = -1;
        }
        int j = 0;
        for (i = 0; i < this.objects.size(); ++i) {
            o = (NetObject)this.objects.get(i);
            if (!o.getSelected()) continue;
            no = o.type == 2 ? o.getCopyAt(o.org.x + 2 * this.XGRID_SIZE, o.org.y + 2 * this.YGRID_SIZE) : o.getCopyAt(o.org.x + 2, o.org.y + 2);
            this.clipboard.add(no);
            nIdx[i] = j;
            oIdx[j] = i;
            ++j;
        }
        if (this.clipboard.size() == 0) {
            this.error("Nothing to copy, empty selection.");
            return;
        }
        for (i = 0; i < this.clipboard.size(); ++i) {
            no = (NetObject)this.clipboard.get(i);
            o = (NetObject)this.objects.get(oIdx[i]);
            for (j = 0; j < o.getChildrenNumber(); ++j) {
                int childIdx = nIdx[this.objects.indexOf(o.getChildAt(j))];
                if (childIdx == -1) continue;
                no.addChild((NetObject)this.clipboard.get(childIdx));
            }
        }
    }

    public void pasteSelection() {
        if (!this.isEditable) {
            return;
        }
        if (this.clipboard.size() == 0) {
            this.error("Nothing to paste, clipboard empty.");
            return;
        }
        this.unselectAll();
        for (int i = 0; i < this.clipboard.size(); ++i) {
            NetObject o = (NetObject)this.clipboard.get(i);
            if (!this.addObject(o)) continue;
            o.setSelected(true);
        }
        this.copySelection();
        this.setNeedToSave(true, "Paste");
        this.repaint();
    }

    public void deleteSelection() {
        int i;
        Vector<NetObject> sel = new Vector<NetObject>();
        if (!this.isEditable) {
            return;
        }
        if (this.selObject != null && this.selObject.selSet >= 10) {
            int toDel = this.selObject.selSet - 10;
            this.selObject.removeChild(toDel);
            this.unselectAll();
            this.setNeedToSave(true, "Delete link");
            this.repaint();
            return;
        }
        for (i = 0; i < this.objects.size(); ++i) {
            NetObject o = (NetObject)this.objects.get(i);
            if (!o.getSelected()) continue;
            sel.add(o);
        }
        if (sel.size() == 0) {
            this.error("Nothing to delete, empty selection.");
            return;
        }
        for (i = 0; i < sel.size(); ++i) {
            this.removeObject((NetObject)sel.get(i));
        }
        sel.clear();
        this.unselectAll();
        this.setNeedToSave(true, "Cut/Delete");
        this.repaint();
    }

    public boolean canUndo() {
        return this.isEditable && this.undoPos >= 2;
    }

    public String getUndoActionName() {
        if (this.canUndo()) {
            return ((UndoBuffer)this.undo.get(this.undoPos - 1)).getName();
        }
        return "";
    }

    public String getRedoActionName() {
        if (this.canRedo()) {
            return ((UndoBuffer)this.undo.get(this.undoPos)).getName();
        }
        return "";
    }

    public boolean canRedo() {
        return this.isEditable && this.undoPos < this.undo.size();
    }

    public void undo() {
        if (this.canUndo()) {
            --this.undoPos;
            this.rebuildBackup(this.undoPos - 1);
        }
    }

    public void redo() {
        if (this.canRedo()) {
            ++this.undoPos;
            this.rebuildBackup(this.undoPos - 1);
        }
    }

    public void addEditorListener(NetEditorListener l) {
        this.listeners.add(l);
    }

    public void removeEditorListener(NetEditorListener l) {
        this.listeners.remove(l);
    }

    public void clearEditorListener() {
        this.listeners.clear();
    }

    public boolean getNeedToSaveState() {
        return this.needToSave;
    }

    public void computePreferredSize() {
        int maxx = 320;
        int maxy = 200;
        for (int i = 0; i < this.objects.size(); ++i) {
            ((NetObject)this.objects.get(i)).updateRepaintRect();
            Rectangle r = ((NetObject)this.objects.get(i)).getRepaintRect();
            if (r.x + r.width > maxx) {
                maxx = r.x + r.width;
            }
            if (r.y + r.height <= maxy) continue;
            maxy = r.y + r.height;
        }
        Dimension d = new Dimension(maxx += 10, maxy += 10);
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.invalidate();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((NetEditorListener)this.listeners.get(i)).sizeChanged(this, d);
        }
    }

    public String getFileName() {
        return this.currentFileName;
    }

    public NetObject getNetObjectAt(int i) {
        return (NetObject)this.objects.get(i);
    }

    public void removeObject(NetObject obj) {
        int sz = this.objects.size();
        obj.clearChildren();
        for (int i = 0; i < sz; ++i) {
            NetObject o = (NetObject)this.objects.get(i);
            if (!o.isParentOf(obj)) continue;
            o.removeChild(obj);
        }
        this.objects.remove(obj);
        obj.setParent(null);
    }

    public boolean addObject(NetObject obj) {
        if (obj == null) {
            return false;
        }
        obj.setParent(this);
        this.objects.add(obj);
        return true;
    }

    public void clearObjects() {
        this.unselectAll();
        this.objects.clear();
    }

    public int getNetObjectNumber() {
        return this.objects.size();
    }

    public void showOptionDialog() {
        this.dlgOpt.showOption();
    }

    public void setNetEditorDialog(NetEditorDlg dlg) {
        this.dlgOpt = dlg;
    }

    public void setNetObjectDialog(NetObjectDlg dlg) {
        this.dlgProp = dlg;
    }

    public void setMoveableBubble(boolean b) {
        this.moveBubble = b;
    }

    public JFrame getParentFrame() {
        return this.pFrame;
    }

    public void setGridSize(Dimension d) {
        this.XGRID_SIZE = d.width;
        this.YGRID_SIZE = d.height;
        this.repaint();
    }

    public Dimension getGridSize() {
        return new Dimension(this.XGRID_SIZE, this.YGRID_SIZE);
    }

    private NetObject findObject(MouseEvent e) {
        boolean found = false;
        int foundC = -1;
        NetObject o = null;
        int sz = this.objects.size();
        int ex = e.getX();
        int ey = e.getY();
        int i = 0;
        while (i < sz && !found) {
            o = (NetObject)this.objects.get(i);
            found = o.labelContains(ex, ey);
            if (found) continue;
            ++i;
        }
        if (found) {
            o.selSet = 2;
            return o;
        }
        i = 0;
        while (i < sz && !found) {
            o = (NetObject)this.objects.get(i);
            found = o.contains(ex, ey);
            if (found) continue;
            ++i;
        }
        if (found) {
            o.selSet = 1;
            return o;
        }
        i = 0;
        while (i < sz && foundC == -1) {
            o = (NetObject)this.objects.get(i);
            foundC = o.childContains(ex, ey);
            if (foundC != -1) continue;
            ++i;
        }
        if (foundC != -1) {
            o.selSet = 10 + foundC;
            return o;
        }
        return null;
    }

    private void initDragObject(MouseEvent e) {
        int sz = this.objects.size();
        this.dragMode = 1;
        this.onlyTextSelected = true;
        for (int i = 0; i < sz; ++i) {
            NetObject o = (NetObject)this.objects.get(i);
            if (!o.getSelected()) continue;
            o.resetDrag();
            this.onlyTextSelected = this.onlyTextSelected && o.type == 2;
        }
        this.dragStart.x = e.getX();
        this.dragStart.y = e.getY();
        this.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void initDragSelection(MouseEvent e) {
        this.dragMode = 2;
        this.dragStart.x = e.getX();
        this.dragStart.y = e.getY();
        this.selDrag.setRect(e.getX(), e.getY(), 0.0, 0.0);
    }

    private void initDragLabel(MouseEvent e, NetObject o) {
        this.dragMode = 3;
        this.dragStart.x = e.getX();
        this.dragStart.y = e.getY();
        this.selObject = o;
        this.selObject.dragStart.x = o.labelOffset.x;
        this.selObject.dragStart.y = o.labelOffset.y;
        this.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void initDragLink(MouseEvent e, NetObject o) {
        this.dragStart.x = o.org.x * this.XGRID_SIZE;
        this.dragStart.y = o.org.y * this.YGRID_SIZE;
        this.selDrag.setRect(e.getX(), e.getY(), e.getX(), e.getY());
        this.lnkObject = o;
        this.dragMode = 4;
    }

    private void initDragMoveLink(MouseEvent e, NetObject o) {
        this.unselectAll();
        this.dragStart.x = e.getX();
        this.dragStart.y = e.getY();
        this.selObject = o;
        this.lnkObject = o.getChildAt(o.selSet - 10);
        this.selObject.resetDrag();
        this.lnkObject.resetDrag();
        this.dragMode = 5;
        this.setCursor(Cursor.getPredefinedCursor(13));
    }

    private void createObject(MouseEvent e) {
        int x = 0;
        int y = 0;
        NetObject o = null;
        switch (this.createMode) {
            case 1: {
                x = (e.getX() + this.XGRID_SIZE / 2) / this.XGRID_SIZE;
                y = (e.getY() + this.YGRID_SIZE / 2) / this.YGRID_SIZE;
                o = this.createBubbleObject(x, y);
                break;
            }
            case 3: {
                o = new NetObject(2, 0, 0, 0, e.getX(), e.getY());
                o.setLabel("label");
            }
        }
        if (this.addObject(o)) {
            this.setNeedToSave(true, "Create " + o.getName());
        }
        o = null;
        this.repaint();
    }

    private void buildSelRect(int x1, int y1, int x2, int y2) {
        if (x1 < x2) {
            if (y1 < y2) {
                this.selDrag.setRect(x1, y1, x2 - x1, y2 - y1);
            } else {
                this.selDrag.setRect(x1, y2, x2 - x1, y1 - y2);
            }
        } else if (y1 < y2) {
            this.selDrag.setRect(x2, y1, x1 - x2, y2 - y1);
        } else {
            this.selDrag.setRect(x2, y2, x1 - x2, y1 - y2);
        }
    }

    private void dragObjects(MouseEvent e) {
        int tx = 0;
        int ty = 0;
        int sz = this.objects.size();
        for (int i = 0; i < sz; ++i) {
            NetObject o = (NetObject)this.objects.get(i);
            if (!o.getSelected()) continue;
            if (this.onlyTextSelected) {
                tx = e.getX() - this.dragStart.x;
                ty = e.getY() - this.dragStart.y;
            } else {
                tx = e.getX() - this.dragStart.x;
                tx = tx < 0 ? (o.type == 2 ? (e.getX() - this.dragStart.x - this.XGRID_SIZE / 2) / this.XGRID_SIZE * this.XGRID_SIZE : (e.getX() - this.dragStart.x - this.XGRID_SIZE / 2) / this.XGRID_SIZE) : (o.type == 2 ? (e.getX() - this.dragStart.x + this.XGRID_SIZE / 2) / this.XGRID_SIZE * this.XGRID_SIZE : (e.getX() - this.dragStart.x + this.XGRID_SIZE / 2) / this.XGRID_SIZE);
                ty = e.getY() - this.dragStart.y;
                ty = ty < 0 ? (o.type == 2 ? (e.getY() - this.dragStart.y - this.YGRID_SIZE / 2) / this.YGRID_SIZE * this.YGRID_SIZE : (e.getY() - this.dragStart.y - this.YGRID_SIZE / 2) / this.YGRID_SIZE) : (o.type == 2 ? (e.getY() - this.dragStart.y + this.YGRID_SIZE / 2) / this.YGRID_SIZE * this.YGRID_SIZE : (e.getY() - this.dragStart.y + this.YGRID_SIZE / 2) / this.YGRID_SIZE);
            }
            if (o.type == 2) {
                switch (o.justify) {
                    case 2: {
                        o.org.x = this.saturateLow(o.dragStart.x + tx, o.getBoundRect().width / 2);
                        o.org.y = this.saturateLow(o.dragStart.y + ty, o.labelAscent);
                        break;
                    }
                    case 1: {
                        o.org.x = this.saturateLow(o.dragStart.x + tx, o.getBoundRect().width);
                        o.org.y = this.saturateLow(o.dragStart.y + ty, o.labelAscent);
                        break;
                    }
                    case 0: {
                        o.org.x = this.saturateLow(o.dragStart.x + tx, 0);
                        o.org.y = this.saturateLow(o.dragStart.y + ty, o.labelAscent);
                    }
                }
                continue;
            }
            o.org.x = this.saturateLow(o.dragStart.x + tx, 1);
            o.org.y = this.saturateLow(o.dragStart.y + ty, 1);
        }
    }

    private void dragLink(MouseEvent e) {
        int tx = 0;
        int ty = 0;
        tx = e.getX() - this.dragStart.x;
        tx = tx < 0 ? (e.getX() - this.dragStart.x - this.XGRID_SIZE / 2) / this.XGRID_SIZE : (e.getX() - this.dragStart.x + this.XGRID_SIZE / 2) / this.XGRID_SIZE;
        ty = e.getY() - this.dragStart.y;
        ty = ty < 0 ? (e.getY() - this.dragStart.y - this.YGRID_SIZE / 2) / this.YGRID_SIZE : (e.getY() - this.dragStart.y + this.YGRID_SIZE / 2) / this.YGRID_SIZE;
        this.selObject.org.x = this.saturateLow(this.selObject.dragStart.x + tx, 1);
        this.selObject.org.y = this.saturateLow(this.selObject.dragStart.y + ty, 1);
        this.lnkObject.org.x = this.saturateLow(this.lnkObject.dragStart.x + tx, 1);
        this.lnkObject.org.y = this.saturateLow(this.lnkObject.dragStart.y + ty, 1);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        switch (this.dragMode) {
            case 1: {
                this.dragObjects(e);
                this.repaint();
                break;
            }
            case 5: {
                this.dragLink(e);
                this.repaint();
                break;
            }
            case 2: {
                this.buildSelRect(this.dragStart.x, this.dragStart.y, e.getX(), e.getY());
                this.repaint();
                break;
            }
            case 4: {
                this.selDrag.setRect(this.dragStart.x, this.dragStart.y, e.getX(), e.getY());
                this.repaint();
                break;
            }
            case 3: {
                this.selObject.labelOffset.x = this.selObject.dragStart.x + (e.getX() - this.dragStart.x);
                this.selObject.labelOffset.y = this.selObject.dragStart.y + (e.getY() - this.dragStart.y);
                this.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void mouseClickedB3(MouseEvent e) {
    }

    public void mouseClickedB1(MouseEvent e) {
        NetObject o;
        if (e.getClickCount() == 2 && (o = this.findObject(e)) != null && (o.selSet == 1 || o.selSet == 2) && o.hasProperties()) {
            this.dlgProp.editObject(o);
            if (this.dlgProp.getModified()) {
                this.setNeedToSave(true, "Change properties");
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isEditable) {
            if (e.getButton() == 1) {
                this.mouseClickedB1(e);
            }
            if (e.getButton() == 3) {
                this.mouseClickedB3(e);
            }
        } else {
            NetObject o = this.findObject(e);
            if (o != null) {
                if (o.selSet == 1) {
                    this.fireObjectClicked(o, e);
                } else if (o.selSet >= 10) {
                    this.fireLinkClicked(o, o.selSet - 10, e);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int i = 0;
        int sz = this.objects.size();
        switch (this.dragMode) {
            case 1: 
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                if (this.dragStart.x != e.getX() || this.dragStart.y != e.getY()) {
                    this.setNeedToSave(true, "Move object");
                }
                this.dragMode = 0;
                break;
            }
            case 5: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                if (this.dragStart.x != e.getX() || this.dragStart.y != e.getY()) {
                    this.setNeedToSave(true, "Move link");
                }
                this.dragMode = 0;
                break;
            }
            case 2: {
                this.dragMode = 0;
                for (i = 0; i < sz; ++i) {
                    NetObject o = (NetObject)this.objects.get(i);
                    this.onlyTextSelected = true;
                    if (!o.inside(this.selDrag)) continue;
                    o.setSelected(true);
                    this.onlyTextSelected |= o.type == 2;
                }
                this.repaint();
                break;
            }
            case 4: {
                NetObject o = this.findObject(e);
                if (o != null) {
                    if (o != this.lnkObject) {
                        if (o.acceptInput()) {
                            if (!this.lnkObject.isParentOf(o)) {
                                this.lnkObject.addChild(o);
                                this.setNeedToSave(true, "Create link");
                            } else {
                                this.error("Link already exists.");
                            }
                        } else {
                            this.error("This object does not accept more incoming link.");
                        }
                    } else {
                        this.error("Cannot link to itself.\nHint: to return to selection mode, right click");
                    }
                }
                this.dragMode = 0;
                this.repaint();
                break;
            }
            default: {
                this.dragMode = 0;
            }
        }
    }

    public void mousePressedB1(MouseEvent e) {
        if (this.createMode != 0 && this.createMode != 4) {
            this.createObject(e);
            return;
        }
        NetObject o = this.findObject(e);
        if (o != null) {
            if (this.isEditable) {
                if (this.createMode == 4) {
                    if (o.acceptOutput()) {
                        this.unselectAll();
                        o.setSelected(true);
                        this.initDragLink(e, o);
                        this.repaint();
                    } else {
                        this.error("This object does not accept more outgoing link.");
                    }
                    return;
                }
                if (o.selSet >= 10) {
                    this.initDragMoveLink(e, o);
                } else {
                    if (e.isControlDown()) {
                        o.setSelected(!o.getSelected());
                    } else if (!o.getSelected()) {
                        this.unselectAll();
                        o.setSelected(true);
                    }
                    if (!e.isControlDown()) {
                        switch (o.selSet) {
                            case 1: {
                                this.initDragObject(e);
                                break;
                            }
                            case 2: {
                                this.initDragLabel(e, o);
                            }
                        }
                    }
                }
                this.repaint();
            } else if (o.selSet == 1 && this.moveBubble && o.type == 1) {
                this.unselectAll();
                o.setSelected(true);
                this.initDragObject(e);
            }
        } else if (!e.isControlDown() && this.isEditable && this.createMode == 0) {
            this.unselectAll();
            this.initDragSelection(e);
            this.repaint();
        }
    }

    public void mousePressedB3(MouseEvent e) {
        if (this.createMode != 0) {
            this.createMode = 0;
            this.fireCancelCreate();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.grabFocus();
        if (e.getButton() == 1) {
            this.mousePressedB1(e);
        }
        if (e.getButton() == 3) {
            this.mousePressedB3(e);
        }
    }

    public void paintLinks(Graphics2D g2) {
        for (int i = 0; i < this.objects.size(); ++i) {
            NetObject o = (NetObject)this.objects.get(i);
            o.paintLinks(g2, this.showArrow, this.isEditable ? this.selObject == o : false);
        }
    }

    public void paintObjects(Graphics2D g2) {
        int sz = this.objects.size();
        for (int i = 0; i < sz; ++i) {
            ((NetObject)this.objects.get(i)).paint(g2);
        }
    }

    @Override
    public void paint(Graphics g) {
        Stroke old;
        Dimension d = this.getSize();
        Graphics2D g2 = (Graphics2D)g;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        this.paintGrid(g2);
        this.paintLinks(g2);
        if (this.useAAFont) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.paintObjects(g2);
        if (this.dragMode == 2) {
            old = g2.getStroke();
            g2.setStroke(dashStroke);
            g2.setColor(Color.DARK_GRAY);
            g2.drawRect(this.selDrag.x, this.selDrag.y, this.selDrag.width, this.selDrag.height);
            g2.setStroke(old);
        }
        if (this.dragMode == 4) {
            old = g2.getStroke();
            g2.setStroke(dashStroke);
            g2.setColor(Color.DARK_GRAY);
            g2.drawLine(this.selDrag.x, this.selDrag.y, this.selDrag.width, this.selDrag.height);
            g2.setStroke(old);
        }
    }

    private void paintGrid(Graphics2D g) {
        Dimension d = this.getSize();
        if (this.isEditable) {
            g.setColor(Color.BLACK);
            for (int i = 0; i < d.width; i += this.XGRID_SIZE) {
                for (int j = 0; j < d.height; j += this.YGRID_SIZE) {
                    g.drawLine(i, j, i, j);
                }
            }
        }
    }

    void error(String m) {
        JOptionPane.showMessageDialog(this.pFrame, m, "Error", 0);
    }

    void fireValueChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((NetEditorListener)this.listeners.get(i)).valueChanged(this);
        }
    }

    private void fireCancelCreate() {
        if (this.isEditable) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((NetEditorListener)this.listeners.get(i)).cancelCreate(this);
            }
        }
    }

    private void fireObjectClicked(NetObject o, MouseEvent e) {
        if (!this.isEditable) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((NetEditorListener)this.listeners.get(i)).objectClicked(this, o, e);
            }
        }
    }

    private void fireLinkClicked(NetObject o, int id, MouseEvent e) {
        if (!this.isEditable) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((NetEditorListener)this.listeners.get(i)).linkClicked(this, o, id, e);
            }
        }
    }

    private int saturateLow(int x, int min) {
        if (x <= min) {
            return min;
        }
        return x;
    }

    private void setNeedToSave(boolean b, String s) {
        this.needToSave = b;
        if (this.needToSave && this.isEditable) {
            for (int i = this.undo.size() - 1; i >= this.undoPos; --i) {
                this.undo.removeElementAt(i);
            }
            this.undo.add(new UndoBuffer(this.objects, s));
            if (this.undo.size() >= 15) {
                this.undo.removeElementAt(0);
            }
            this.undoPos = this.undo.size();
        }
        this.fireValueChanged();
    }

    private void resetUndo() {
        this.undo.clear();
        this.undo.add(new UndoBuffer(this.objects, "Init"));
        this.undoPos = 1;
    }

    private void rebuildBackup(int pos) {
        this.clearObjects();
        NetObject[] objs = ((UndoBuffer)this.undo.get(pos)).rebuild();
        for (int i = 0; i < objs.length; ++i) {
            this.addObject(objs[i]);
        }
        this.fireValueChanged();
        this.repaint();
    }
}

