/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetEditor;
import fr.esrf.tangoatk.widget.util.interlock.NetEditorListener;
import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import fr.esrf.tangoatk.widget.util.interlock.NetUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

public class NetEditorFrame
extends JFrame
implements NetEditorListener,
ActionListener {
    public static final int FILE_NEW = 1;
    public static final int FILE_LOAD = 2;
    public static final int FILE_SAVE = 3;
    public static final int FILE_SAVEAS = 4;
    public static final int FILE_EXIT = 5;
    public static final int EDIT_UNDO = 1;
    public static final int EDIT_REDO = 2;
    public static final int EDIT_CUT = 3;
    public static final int EDIT_COPY = 4;
    public static final int EDIT_PASTE = 5;
    public static final int EDIT_DELETE = 6;
    public static final int EDIT_SELECT_ALL = 7;
    public static final int EDIT_SELECT_NONE = 8;
    public static final int OPTION_FIT = 1;
    public static final int OPTION_PREF = 2;
    public static final int TOOL_BUBBLE = 1;
    public static final int TOOL_LABEL = 2;
    public static final int TOOL_LINK = 3;
    public static final int TOOL_UNDO = 4;
    public static final int TOOL_REDO = 5;
    private String appRelease = "Network editor";
    private JScrollPane netView;
    private NetEditor netEditor;
    private JMenu jMenuFile;
    private JMenuItem jMenuItemNew;
    private JMenuItem jMenuItemLoad;
    private JMenuItem jMenuItemSave;
    private JMenuItem jMenuItemSaveAs;
    private JMenuItem jMenuItemExit;
    private JMenu jMenuEdit;
    private JMenuItem jMenuItemUndo;
    private JMenuItem jMenuItemRedo;
    private JMenuItem jMenuItemCut;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemPaste;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemSelectAll;
    private JMenuItem jMenuItemSelectNone;
    private JMenu jMenuOptions;
    private JMenuItem jMenuItemFit;
    private JMenuItem jMenuItemPref;
    private JToolBar toolBar;
    private JButton bubbleBtn;
    private JButton labelBtn;
    private JButton linkBtn;
    private JButton undoBtn;
    private JButton redoBtn;
    private JLabel helpLabel;
    static final Insets bMargin = new Insets(3, 3, 3, 3);

    public NetEditorFrame() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(this.appRelease);
        this.netEditor = null;
        this.netView = null;
        this.jMenuFile = new JMenu();
        this.jMenuFile.setText("File");
        this.jMenuFile.setMnemonic('F');
        this.jMenuItemNew = NetUtils.createMenuItem("New", 0, 0, this);
        this.jMenuItemLoad = NetUtils.createMenuItem("Load file...", 0, 0, this);
        this.jMenuItemSave = NetUtils.createMenuItem("Save", 83, 2, this);
        this.jMenuItemSaveAs = NetUtils.createMenuItem("Save as...", 0, 0, this);
        this.jMenuItemExit = NetUtils.createMenuItem("Exit", 0, 0, this);
        this.jMenuFile.add(this.jMenuItemNew);
        this.jMenuFile.add(this.jMenuItemLoad);
        this.jMenuFile.add(this.jMenuItemSave);
        this.jMenuFile.add(this.jMenuItemSaveAs);
        this.jMenuFile.add(new JSeparator());
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuEdit = new JMenu();
        this.jMenuEdit.setText("Edit");
        this.jMenuEdit.setMnemonic('E');
        this.jMenuItemUndo = NetUtils.createMenuItem("Undo", 90, 2, this);
        this.jMenuItemRedo = NetUtils.createMenuItem("Redo", 90, 3, this);
        this.jMenuItemCut = NetUtils.createMenuItem("Cut", 88, 2, this);
        this.jMenuItemCopy = NetUtils.createMenuItem("Copy", 67, 2, this);
        this.jMenuItemPaste = NetUtils.createMenuItem("Paste", 86, 2, this);
        this.jMenuItemDelete = NetUtils.createMenuItem("Delete", 127, 0, this);
        this.jMenuItemSelectAll = NetUtils.createMenuItem("Select All", 65, 2, this);
        this.jMenuItemSelectNone = NetUtils.createMenuItem("Clear selection", 78, 2, this);
        this.jMenuEdit.add(this.jMenuItemUndo);
        this.jMenuEdit.add(this.jMenuItemRedo);
        this.jMenuEdit.add(new JSeparator());
        this.jMenuEdit.add(this.jMenuItemCut);
        this.jMenuEdit.add(this.jMenuItemCopy);
        this.jMenuEdit.add(this.jMenuItemPaste);
        this.jMenuEdit.add(this.jMenuItemDelete);
        this.jMenuEdit.add(new JSeparator());
        this.jMenuEdit.add(this.jMenuItemSelectAll);
        this.jMenuEdit.add(this.jMenuItemSelectNone);
        this.jMenuOptions = new JMenu();
        this.jMenuOptions.setText("Options");
        this.jMenuOptions.setMnemonic('O');
        this.jMenuItemFit = NetUtils.createMenuItem("Fit drawing area to scheme", 0, 0, this);
        this.jMenuItemPref = NetUtils.createMenuItem("Edit preferences ...", 0, 0, this);
        this.jMenuOptions.add(this.jMenuItemFit);
        this.jMenuOptions.add(this.jMenuItemPref);
        this.toolBar = new JToolBar();
        String rPth = "/fr/esrf/tangoatk/widget/util/interlock/gif/";
        this.bubbleBtn = this.createIconButton(rPth, "bubble", "Create a bubble object", this);
        this.toolBar.add(this.bubbleBtn);
        this.labelBtn = this.createIconButton(rPth, "label", "Create a label object", this);
        this.toolBar.add(this.labelBtn);
        this.toolBar.add(new JToolBar.Separator());
        this.linkBtn = this.createIconButton(rPth, "link", "Link an object to an other", this);
        this.toolBar.add(this.linkBtn);
        this.toolBar.add(new JToolBar.Separator());
        this.undoBtn = this.createIconButton(rPth, "undo", "Undo last action", this);
        this.toolBar.add(this.undoBtn);
        this.redoBtn = this.createIconButton(rPth, "redo", "Redo last action", this);
        this.toolBar.add(this.redoBtn);
        this.toolBar.setOrientation(1);
        this.helpLabel = new JLabel();
        this.helpLabel.setFont(new Font("Dialog", 0, 12));
        this.helpLabel.setText("");
        this.helpLabel.setPreferredSize(new Dimension(0, 16));
        JMenuBar mainMenu = new JMenuBar();
        mainMenu.add(this.jMenuFile);
        mainMenu.add(this.jMenuEdit);
        mainMenu.add(this.jMenuOptions);
        this.setJMenuBar(mainMenu);
        this.getContentPane().add((Component)this.toolBar, "West");
        this.getContentPane().add((Component)this.helpLabel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NetEditorFrame.this.exitApp();
            }
        });
    }

    public void setEditor(NetEditor editor) {
        this.netEditor = editor;
        this.netEditor.addEditorListener(this);
        this.netView = new JScrollPane(this.netEditor);
        this.netView.setPreferredSize(new Dimension(800, 600));
        this.getContentPane().add((Component)this.netView, "Center");
        this.valueChanged(this.netEditor);
    }

    public void setAppTitle(String appName) {
        this.appRelease = appName;
    }

    public JMenu getFileMenu() {
        return this.jMenuFile;
    }

    public JMenuItem getFileMenuItem(int which) {
        switch (which) {
            case 1: {
                return this.jMenuItemNew;
            }
            case 2: {
                return this.jMenuItemLoad;
            }
            case 3: {
                return this.jMenuItemSave;
            }
            case 4: {
                return this.jMenuItemSaveAs;
            }
            case 5: {
                return this.jMenuItemExit;
            }
        }
        return null;
    }

    public JMenu getEditMenu() {
        return this.jMenuEdit;
    }

    public JMenuItem getEditMenuItem(int which) {
        switch (which) {
            case 1: {
                return this.jMenuItemUndo;
            }
            case 2: {
                return this.jMenuItemRedo;
            }
            case 3: {
                return this.jMenuItemCut;
            }
            case 4: {
                return this.jMenuItemCopy;
            }
            case 5: {
                return this.jMenuItemPaste;
            }
            case 6: {
                return this.jMenuItemDelete;
            }
            case 7: {
                return this.jMenuItemSelectAll;
            }
            case 8: {
                return this.jMenuItemSelectNone;
            }
        }
        return null;
    }

    public JMenu getOptionMenu() {
        return this.jMenuOptions;
    }

    public JMenuItem getOptionMenuItem(int which) {
        switch (which) {
            case 1: {
                return this.jMenuItemFit;
            }
            case 2: {
                return this.jMenuItemPref;
            }
        }
        return null;
    }

    public JToolBar getToolbar() {
        return this.toolBar;
    }

    public JButton getToobarButton(int which) {
        switch (which) {
            case 1: {
                return this.bubbleBtn;
            }
            case 2: {
                return this.labelBtn;
            }
            case 3: {
                return this.linkBtn;
            }
            case 4: {
                return this.undoBtn;
            }
            case 5: {
                return this.redoBtn;
            }
        }
        return null;
    }

    public void loadFile(String fileName) {
        try {
            this.netEditor.loadFile(fileName);
        }
        catch (IOException ex) {
            this.netEditor.error("Error during reading file:" + fileName + "\n" + ex.getMessage());
            this.netEditor.fireValueChanged();
        }
    }

    public JLabel getHelpLabel() {
        return this.helpLabel;
    }

    public JScrollPane getScrollPane() {
        return this.netView;
    }

    public void exitApp() {
        if (this.netEditor.getNeedToSaveState() && JOptionPane.showConfirmDialog(this, "Save before closing ?", "Exiting", 0) == 0) {
            this.netEditor.saveCurrent(".");
        }
        System.exit(0);
    }

    public JButton createIconButton(String resPath, String preffix, String toolTip, ActionListener l) {
        JButton b = new JButton();
        b.setIcon(new ImageIcon(this.getClass().getResource(resPath + preffix + "_btn_up.gif")));
        b.setPressedIcon(new ImageIcon(this.getClass().getResource(resPath + preffix + "_btn_down.gif")));
        b.setDisabledIcon(new ImageIcon(this.getClass().getResource(resPath + preffix + "_btn_dis.gif")));
        b.setMargin(bMargin);
        b.setBorder(null);
        b.setToolTipText(toolTip);
        b.addActionListener(l);
        return b;
    }

    @Override
    public void valueChanged(NetEditor src) {
        Object title = this.appRelease;
        if (src.getFileName().length() > 0) {
            title = (String)title + " [" + src.getFileName() + "]";
        }
        if (src.getNeedToSaveState()) {
            this.setTitle((String)title + "*");
        } else {
            this.setTitle((String)title);
        }
        this.jMenuItemUndo.setEnabled(src.canUndo());
        this.undoBtn.setEnabled(src.canUndo());
        this.jMenuItemUndo.setText("Undo " + src.getUndoActionName());
        this.jMenuItemRedo.setEnabled(src.canRedo());
        this.redoBtn.setEnabled(src.canRedo());
        this.jMenuItemRedo.setText("Redo " + src.getRedoActionName());
    }

    @Override
    public void objectClicked(NetEditor src, NetObject obj, MouseEvent e) {
    }

    @Override
    public void linkClicked(NetEditor src, NetObject obj, int childIdx, MouseEvent e) {
    }

    @Override
    public void sizeChanged(NetEditor src, Dimension d) {
        this.netView.revalidate();
        this.repaint();
    }

    @Override
    public void cancelCreate(NetEditor src) {
        this.helpLabel.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.jMenuItemNew) {
            this.netEditor.newAll();
        } else if (src == this.jMenuItemLoad) {
            this.netEditor.showOpenFileDialog(".", null);
        } else if (src == this.jMenuItemSave) {
            this.netEditor.saveCurrent(".");
        } else if (src == this.jMenuItemSaveAs) {
            this.netEditor.showSaveFileDialog(".", null);
        } else if (src == this.bubbleBtn) {
            this.netEditor.setCreateMode(1);
            this.helpLabel.setText("Bubble creation: Left click to create a bubble object, right click to cancel.");
        } else if (src == this.labelBtn) {
            this.netEditor.setCreateMode(3);
            this.helpLabel.setText("Label creation: Left click to create a label object, right click to cancel.");
        } else if (src == this.linkBtn) {
            this.netEditor.setCreateMode(4);
            this.helpLabel.setText("Link creation: Left click on fisrt object and drag the cursor up to the second object, right click to cancel.");
        } else if (src == this.jMenuItemDelete) {
            this.netEditor.deleteSelection();
        } else if (src == this.jMenuItemCopy) {
            this.netEditor.copySelection();
        } else if (src == this.jMenuItemPaste) {
            this.netEditor.pasteSelection();
        } else if (src == this.jMenuItemCut) {
            this.netEditor.cutSelection();
        } else if (src == this.jMenuItemSelectAll) {
            this.netEditor.selectAll();
            this.netEditor.repaint();
        } else if (src == this.jMenuItemSelectNone) {
            this.netEditor.unselectAll();
            this.netEditor.repaint();
        } else if (src == this.jMenuItemUndo || src == this.undoBtn) {
            this.netEditor.undo();
        } else if (src == this.jMenuItemRedo || src == this.redoBtn) {
            this.netEditor.redo();
        } else if (src == this.jMenuItemFit) {
            this.netEditor.computePreferredSize();
        } else if (src == this.jMenuItemPref) {
            this.netEditor.showOptionDialog();
        } else if (src == this.jMenuItemExit) {
            this.exitApp();
        }
    }

    public static void main(String[] args) {
        NetEditorFrame frame = new NetEditorFrame();
        NetEditor netEditor = new NetEditor(frame);
        frame.setEditor(netEditor);
        NetUtils.centerFrameOnScreen(frame);
        frame.setVisible(true);
    }
}

