/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetEditor;
import fr.esrf.tangoatk.widget.util.interlock.NetShape;
import fr.esrf.tangoatk.widget.util.interlock.NetUtils;
import fr.esrf.tangoatk.widget.util.interlock.UndoPattern;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class NetObject {
    public static final int OBJECT_BUBBLE = 1;
    public static final int OBJECT_TEXT = 2;
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_RIGHT = 1;
    public static final int JUSTIFY_CENTER = 2;
    int type;
    int userType;
    int bSize;
    int maxInput;
    int maxOutput;
    int shape;
    boolean editableShape;
    Point org;
    private String[] labels;
    Point labelOffset;
    int justify;
    String smallCenterLabel;
    String smallBottomLabel;
    Color backColor;
    String[] extParamValue;
    String[] extParamName;
    Point dragStart;
    int selSet;
    int labelAscent;
    static final int SEL_NONE = 0;
    static final int SEL_OBJECT = 1;
    static final int SEL_LABEL = 2;
    static final int SEL_LINK = 10;
    private Vector children;
    private Vector parents;
    private int[] childrenIds;
    private int idx;
    private boolean selected;
    private Rectangle repaintRect;
    private Rectangle boundRect;
    private Rectangle labelRect;
    private int[] labelWidth;
    private int labelHeight;
    private int maxLabelWidth;
    private Font textFont;
    private Object userValue;
    private int[] ashx;
    private int[] ashy;
    private StringBuffer to_write;
    private NetEditor parentEditor;
    private static float[] dashPattern = new float[]{3.0f};
    private static BasicStroke dashStroke = new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f);
    private static BufferedImage fntImg = null;
    private static FontRenderContext frc;
    private static Point pt0;

    public NetObject(int type, int userType, int maxInput, int maxOutput, int x, int y) {
        this.type = type;
        this.userType = userType;
        if (type == 1) {
            this.maxInput = maxInput;
            this.maxOutput = maxOutput;
        } else {
            this.maxInput = 0;
            this.maxOutput = 0;
        }
        this.shape = 0;
        this.org = new Point(x, y);
        this.labelOffset = new Point(0, 0);
        this.boundRect = new Rectangle();
        this.labelRect = new Rectangle();
        this.repaintRect = new Rectangle();
        this.children = new Vector();
        this.parents = new Vector();
        this.childrenIds = null;
        this.idx = 0;
        this.selected = false;
        this.ashx = new int[4];
        this.ashy = new int[4];
        this.labels = new String[0];
        this.labelWidth = new int[0];
        this.smallCenterLabel = "";
        this.smallBottomLabel = "";
        this.justify = 2;
        this.dragStart = new Point();
        this.parentEditor = null;
        this.userValue = null;
        this.extParamValue = null;
        this.extParamName = null;
        this.bSize = 10;
        this.backColor = Color.black;
        this.editableShape = true;
        this.textFont = type == 2 ? NetEditor.defaultLabelFont : null;
        if (fntImg == null) {
            fntImg = new BufferedImage(10, 10, 1);
            Graphics2D g = (Graphics2D)fntImg.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            frc = g.getFontRenderContext();
        }
    }

    NetObject(UndoPattern e) {
        this.type = e.type;
        this.userType = e.userType;
        this.org = new Point(e.x, e.y);
        this.shape = e.shape;
        this.editableShape = e.eshape;
        this.labelOffset = new Point(e.lx, e.ly);
        this.boundRect = new Rectangle();
        this.labelRect = new Rectangle();
        this.repaintRect = new Rectangle();
        this.children = new Vector();
        this.parents = new Vector();
        this.childrenIds = null;
        this.idx = e.idx;
        this.selected = false;
        this.ashx = new int[4];
        this.ashy = new int[4];
        this.setLabel(e.label);
        this.smallCenterLabel = "";
        this.smallBottomLabel = "";
        this.justify = e.justify;
        this.dragStart = new Point();
        this.parentEditor = null;
        this.userValue = null;
        this.maxInput = e.maxi;
        this.maxOutput = e.maxo;
        this.bSize = e.size;
        this.textFont = e.textFnt;
        this.extParamName = null;
        this.extParamValue = null;
        if (this.type == 1) {
            this.extParamName = e.extsN;
            if (e.extsN != null) {
                this.extParamValue = new String[e.extsN.length];
                for (int i = 0; i < e.extsN.length; ++i) {
                    this.extParamValue[i] = new String(e.extsV[i]);
                }
            }
        }
    }

    public void addChild(NetObject o) {
        this.children.add(o);
        o.parents.add(this);
    }

    public void removeChild(NetObject o) {
        this.children.remove(o);
        o.parents.remove(this);
    }

    public void removeChild(int i) {
        this.getChildAt((int)i).parents.remove(this);
        this.children.remove(i);
    }

    public int getChildrenNumber() {
        return this.children.size();
    }

    public NetObject getChildAt(int idx) {
        return (NetObject)this.children.get(idx);
    }

    public void clearChildren() {
        int sz = this.getChildrenNumber();
        for (int i = 0; i < sz; ++i) {
            this.getChildAt((int)i).parents.remove(this);
        }
        this.children.clear();
    }

    public int getParentNumber() {
        return this.parents.size();
    }

    public NetObject getParentAt(int idx) {
        return (NetObject)this.parents.get(idx);
    }

    public boolean isParentOf(NetObject o) {
        return this.children.contains(o);
    }

    public boolean isChildOf(NetObject o) {
        return this.parents.contains(o);
    }

    void setChildrenIdList(int[] lst) {
        this.childrenIds = lst;
    }

    int[] getChildrenIdList() {
        return this.childrenIds;
    }

    int getIndex() {
        return this.idx;
    }

    void setIndex(int i) {
        this.idx = i;
    }

    void setParent(NetEditor iE) {
        this.parentEditor = iE;
    }

    public String getLabel() {
        StringBuffer tmpStr = new StringBuffer();
        int sz = this.labels.length;
        for (int i = 0; i < sz; ++i) {
            tmpStr.append(this.labels[i]);
            if (i >= sz - 1) continue;
            tmpStr.append('\n');
        }
        return tmpStr.toString();
    }

    public void setLabel(String value) {
        if (value == null) {
            this.labels = new String[0];
            this.labelWidth = new int[this.labels.length];
            return;
        }
        while (value.endsWith("\n")) {
            value = value.substring(0, value.length() - 1);
        }
        StringBuffer newValue = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                newValue.append('\'');
                continue;
            }
            newValue.append(c);
        }
        this.labels = newValue.length() == 0 ? new String[0] : newValue.toString().split("\n");
        this.labelWidth = new int[this.labels.length];
    }

    public void setLabel(String[] value) {
        this.labels = value;
        this.labelWidth = new int[this.labels.length];
    }

    public String getName() {
        switch (this.type) {
            case 1: {
                return "Bubble";
            }
            case 2: {
                return "Text";
            }
        }
        return "Unknown";
    }

    public int getType() {
        return this.type;
    }

    public int getUserType() {
        return this.userType;
    }

    public void setShape(int s) {
        this.shape = s;
    }

    public int getShape() {
        return this.shape;
    }

    public void setEditableShape(boolean b) {
        this.editableShape = b;
    }

    public void setJustify(int i) {
        this.justify = i;
    }

    public int getJustify() {
        return this.justify;
    }

    public int getMaxInput() {
        return this.maxInput;
    }

    public int getMaxOutput() {
        return this.maxOutput;
    }

    public void setCenterLabel(String s) {
        this.smallCenterLabel = s;
    }

    public void setBottomLabel(String s) {
        this.smallBottomLabel = s;
    }

    public void setColor(Color c) {
        this.backColor = c;
    }

    public Color getColor() {
        return this.backColor;
    }

    public void setSize(int size) {
        this.bSize = size;
    }

    public int getSize() {
        return this.bSize;
    }

    public void setUserValue(Object v) {
        this.userValue = v;
    }

    public Object getUserValue() {
        return this.userValue;
    }

    public void setExtensionList(String[] names) {
        if (this.type != 1) {
            System.out.println("NetObject.setExtensionList() : Only bubble object accept extensions.");
            return;
        }
        this.extParamName = names;
        this.extParamValue = new String[names.length];
        for (int i = 0; i < this.extParamValue.length; ++i) {
            this.extParamValue[i] = "";
        }
    }

    public void setExtendedParam(String name, String value) {
        int i = this.getExtendedParamIndex(name);
        if (i != -1) {
            this.extParamValue[i] = name;
        } else {
            System.out.println("NetObject.setExtendedParam() : " + name + " does not exist.");
        }
    }

    public void setExtendedParam(int extIdx, String value) {
        int n = this.getExtendedParamNumber();
        if (extIdx < 0 || extIdx >= n) {
            System.out.println("NetObject.setExtendedParam() : index of of bounds.");
            return;
        }
        this.extParamValue[extIdx] = value;
    }

    public String getExtendedParam(String name) {
        int i = this.getExtendedParamIndex(name);
        if (i != -1) {
            return this.extParamValue[i];
        }
        System.out.println("NetObject.getExtendedParam() : " + name + " does not exist.");
        return "";
    }

    public String getExtendedParam(int extIdx) {
        int n = this.getExtendedParamNumber();
        if (extIdx < 0 || extIdx >= n) {
            System.out.println("NetObject.getExtendedParam() : index of of bounds.");
            return "";
        }
        return this.extParamValue[extIdx];
    }

    public int getExtendedParamNumber() {
        if (this.extParamValue == null) {
            return 0;
        }
        return this.extParamValue.length;
    }

    public int getExtendedParamIndex(String name) {
        if (this.extParamName == null) {
            return -1;
        }
        boolean found = false;
        int i = 0;
        while (i < this.extParamName.length && !found) {
            found = name.equalsIgnoreCase(this.extParamName[i]);
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public void setTextFont(Font f) {
        if (this.type == 2) {
            this.textFont = f;
        }
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public int getXOrigin() {
        if (this.type == 2) {
            return this.org.x;
        }
        return this.org.x * this.parentEditor.XGRID_SIZE;
    }

    public int getYOrigin() {
        if (this.type == 2) {
            return this.org.y;
        }
        return this.org.y * this.parentEditor.YGRID_SIZE;
    }

    boolean acceptInput() {
        switch (this.type) {
            case 1: {
                return this.getParentNumber() < this.maxInput;
            }
        }
        return false;
    }

    boolean acceptOutput() {
        switch (this.type) {
            case 1: {
                return this.getChildrenNumber() < this.maxOutput;
            }
        }
        return false;
    }

    public void setSelected(boolean s) {
        this.selected = s;
    }

    public boolean getSelected() {
        return this.selected;
    }

    boolean contains(int x, int y) {
        return this.boundRect.contains(x, y);
    }

    boolean labelContains(int x, int y) {
        return this.labelRect.contains(x, y);
    }

    private Point getLinkTranslation(int x1, int y1, int x2, int y2, NetObject child) {
        if (this.isChildOf(child)) {
            double nx = y2 - y1;
            double ny = x1 - x2;
            double n = Math.sqrt(nx * nx + ny * ny);
            int tx = (int)(nx / n * 3.0 + 0.5);
            int ty = (int)(ny / n * 3.0 + 0.5);
            return new Point(tx, ty);
        }
        return pt0;
    }

    int childContains(int x, int y) {
        int sz = this.children.size();
        int i = 0;
        boolean found = false;
        Line2D.Double l = new Line2D.Double();
        Rectangle2D.Double r = new Rectangle2D.Double(x - 4, y - 4, 8.0, 8.0);
        int x1 = this.org.x * this.parentEditor.XGRID_SIZE;
        int y1 = this.org.y * this.parentEditor.YGRID_SIZE;
        while (i < sz && !found) {
            NetObject child = this.getChildAt(i);
            int x2 = child.org.x * this.parentEditor.XGRID_SIZE;
            int y2 = child.org.y * this.parentEditor.YGRID_SIZE;
            Point t = this.getLinkTranslation(x1, y1, x2, y2, child);
            ((Line2D)l).setLine(x1 + t.x, y1 + t.y, x2 + t.x, y2 + t.y);
            found = l.intersects(r);
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    boolean inside(Rectangle r) {
        return r.contains(this.boundRect);
    }

    boolean hasProperties() {
        switch (this.type) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    void resetDrag() {
        this.dragStart.x = this.org.x;
        this.dragStart.y = this.org.y;
    }

    Rectangle getBoundRect() {
        return this.boundRect;
    }

    Rectangle getRepaintRect() {
        return this.repaintRect;
    }

    NetObject getCopyAt(int newX, int newY) {
        int i;
        NetObject n = new NetObject(this.type, this.userType, this.maxInput, this.maxOutput, newX, newY);
        n.shape = this.shape;
        n.editableShape = this.editableShape;
        n.bSize = this.bSize;
        n.labels = new String[this.labels.length];
        n.labelWidth = new int[this.labels.length];
        for (i = 0; i < this.labels.length; ++i) {
            n.labels[i] = new String(this.labels[i]);
        }
        n.justify = this.justify;
        n.textFont = this.textFont;
        n.labelOffset.x = this.labelOffset.x;
        n.labelOffset.y = this.labelOffset.y;
        n.extParamName = this.extParamName;
        if (this.extParamName != null) {
            n.extParamValue = new String[this.extParamValue.length];
            for (i = 0; i < this.extParamValue.length; ++i) {
                n.extParamValue[i] = new String(this.extParamValue[i]);
            }
        } else {
            n.extParamValue = null;
        }
        return n;
    }

    UndoPattern getUndoPattern() {
        return new UndoPattern(this);
    }

    private void paintArrows(Graphics2D g, int x1, int y1, int x2, int y2, boolean doubleLink) {
        double nx = -(y2 - y1);
        double ny = x2 - x1;
        double n = Math.sqrt(nx * nx + ny * ny);
        double aw = 5.0;
        if (n >= 1.0) {
            double yc;
            double xc;
            double dx = (double)(x2 - x1) * aw * 1.3 / n;
            double dy = (double)(y2 - y1) * aw * 1.3 / n;
            if (doubleLink) {
                xc = (double)x1 + (double)(x2 - x1) * 0.51;
                yc = (double)y1 + (double)(y2 - y1) * 0.51;
            } else {
                xc = (double)x1 + (double)(x2 - x1) * 0.5;
                yc = (double)y1 + (double)(y2 - y1) * 0.5;
            }
            this.ashx[0] = (int)Math.round(xc + -nx / n * aw);
            this.ashy[0] = (int)Math.round(yc + -ny / n * aw);
            this.ashx[1] = (int)Math.round(xc + nx / n * aw);
            this.ashy[1] = (int)Math.round(yc + ny / n * aw);
            this.ashx[2] = (int)Math.round(xc + dx);
            this.ashy[2] = (int)Math.round(yc + dy);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fillPolygon(this.ashx, this.ashy, 3);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    void paintLinks(Graphics2D g, boolean drawArrow, boolean isSelected) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (isSelected && i == this.selSet - 10) {
                g.setColor(NetShape.selColor);
            } else {
                g.setColor(Color.black);
            }
            this.paintLink(g, this.getChildAt(i), drawArrow);
        }
    }

    private void paintLabels(Graphics2D g) {
        int y = this.labelRect.y + this.labelAscent;
        switch (this.justify) {
            case 0: {
                for (int i = 0; i < this.labels.length; ++i) {
                    g.drawString(this.labels[i], this.labelRect.x, y);
                    y += this.labelHeight;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.labels.length; ++i) {
                    g.drawString(this.labels[i], this.labelRect.x + (this.maxLabelWidth - this.labelWidth[i]), y);
                    y += this.labelHeight;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.labels.length; ++i) {
                    g.drawString(this.labels[i], this.labelRect.x + (this.maxLabelWidth - this.labelWidth[i]) / 2, y);
                    y += this.labelHeight;
                }
                break;
            }
        }
        if (this.selected && this.parentEditor.isEditable() && this.labelRect.width > 0) {
            g.setColor(Color.black);
            Stroke old = g.getStroke();
            g.setStroke(dashStroke);
            g.drawRect(this.labelRect.x, this.labelRect.y, this.labelRect.width, this.labelRect.height);
            g.setStroke(old);
        }
    }

    private void paintSmallCenterLabel(Graphics2D g) {
        if (this.smallCenterLabel.length() > 0) {
            g.setFont(this.parentEditor.smallFont);
            g.setColor(Color.black);
            Rectangle2D bounds = this.parentEditor.smallFont.getStringBounds(this.smallCenterLabel, frc);
            g.drawString(this.smallCenterLabel, this.org.x * this.parentEditor.XGRID_SIZE - (int)(bounds.getWidth() / 2.0), this.org.y * this.parentEditor.YGRID_SIZE + 4);
        }
    }

    private void paintSmallBottomLabel(Graphics2D g) {
        if (this.smallBottomLabel.length() > 0) {
            g.setFont(this.parentEditor.smallFont);
            Rectangle2D bounds = this.parentEditor.smallFont.getStringBounds(this.smallBottomLabel, frc);
            g.drawString(this.smallBottomLabel, this.org.x * this.parentEditor.XGRID_SIZE - (this.bSize + (int)bounds.getWidth() + 2), this.org.y * this.parentEditor.YGRID_SIZE + 15);
        }
    }

    void paintBubble(Graphics2D g) {
        Color bckColor = this.parentEditor.isEditable() ? Color.yellow : this.backColor;
        boolean sel = this.parentEditor.isEditable() ? this.selected : false;
        NetShape.paintShape(g, this.shape, sel, bckColor, this.org.x * this.parentEditor.XGRID_SIZE, this.org.y * this.parentEditor.YGRID_SIZE, this.bSize);
        g.setFont(this.parentEditor.labelFont);
        g.setColor(Color.black);
        this.paintLabels(g);
        this.paintSmallBottomLabel(g);
        this.paintSmallCenterLabel(g);
    }

    void paintJoin(Graphics2D g) {
        if (this.parentEditor.isEditable()) {
            if (this.selected) {
                g.setColor(NetShape.selColor);
            } else {
                g.setColor(Color.BLACK);
            }
            g.fillRect(this.org.x * this.parentEditor.XGRID_SIZE - 3, this.org.y * this.parentEditor.YGRID_SIZE - 3, 6, 6);
        } else {
            if (this.bSize == 0) {
                return;
            }
            g.setColor(Color.BLACK);
            g.fillRect(this.org.x * this.parentEditor.XGRID_SIZE - 2, this.org.y * this.parentEditor.YGRID_SIZE - 2, 4, 4);
        }
    }

    void paintText(Graphics2D g) {
        g.setColor(this.backColor);
        g.setFont(this.textFont);
        this.paintLabels(g);
    }

    public void paintLink(Graphics2D g, NetObject child, boolean drawArrow) {
        int x1 = this.org.x * this.parentEditor.XGRID_SIZE;
        int y1 = this.org.y * this.parentEditor.YGRID_SIZE;
        int x2 = child.org.x * this.parentEditor.XGRID_SIZE;
        int y2 = child.org.y * this.parentEditor.YGRID_SIZE;
        Point t = this.getLinkTranslation(x1, y1, x2, y2, child);
        g.drawLine(x1 + t.x, y1 + t.y, x2 + t.x, y2 + t.y);
        if (drawArrow) {
            this.paintArrows(g, x1 + t.x, y1 + t.y, x2 + t.x, y2 + t.y, t != pt0);
        }
    }

    public void paint(Graphics2D g) {
        if (this.parentEditor == null) {
            return;
        }
        this.updateBoundRect();
        switch (this.type) {
            case 1: {
                this.paintBubble(g);
                break;
            }
            case 2: {
                this.paintText(g);
            }
        }
    }

    private void updateLabelBoundRect() {
        Font font;
        int yOrg;
        int xOrg;
        if (this.type == 2) {
            xOrg = this.org.x;
            yOrg = this.org.y;
            font = this.textFont;
        } else {
            xOrg = this.org.x * this.parentEditor.XGRID_SIZE;
            yOrg = this.org.y * this.parentEditor.YGRID_SIZE - 15;
            font = this.parentEditor.labelFont;
        }
        if (this.labels.length == 0) {
            this.labelRect.setRect(0.0, 0.0, 0.0, 0.0);
            return;
        }
        this.maxLabelWidth = 0;
        for (int i = 0; i < this.labels.length; ++i) {
            Rectangle2D bounds = font.getStringBounds(this.labels[i], frc);
            this.labelHeight = (int)bounds.getHeight();
            this.labelWidth[i] = (int)bounds.getWidth();
            if (this.labelWidth[i] <= this.maxLabelWidth) continue;
            this.maxLabelWidth = this.labelWidth[i];
        }
        this.labelAscent = (int)((double)this.labelHeight * 0.8);
        switch (this.justify) {
            case 0: {
                this.labelRect.setRect(xOrg + this.labelOffset.x, yOrg + this.labelOffset.y - this.labelAscent, this.maxLabelWidth, this.labelHeight * this.labels.length);
                break;
            }
            case 1: {
                this.labelRect.setRect(xOrg - this.maxLabelWidth + this.labelOffset.x, yOrg + this.labelOffset.y - this.labelAscent, this.maxLabelWidth, this.labelHeight * this.labels.length);
                break;
            }
            case 2: {
                this.labelRect.setRect(xOrg - this.maxLabelWidth / 2 + this.labelOffset.x, yOrg + this.labelOffset.y - this.labelAscent, this.maxLabelWidth, this.labelHeight * this.labels.length);
            }
        }
    }

    private void updateBoundRect() {
        switch (this.type) {
            case 1: {
                this.updateLabelBoundRect();
                NetShape.setBoundRect(this.shape, this.org.x * this.parentEditor.XGRID_SIZE, this.org.y * this.parentEditor.YGRID_SIZE, this.bSize, this.boundRect);
                break;
            }
            case 2: {
                this.updateLabelBoundRect();
                this.boundRect.setRect(this.labelRect.x, this.labelRect.y, this.labelRect.width, this.labelRect.height);
            }
        }
    }

    void updateRepaintRect() {
        if (this.parentEditor != null) {
            this.updateBoundRect();
            this.repaintRect = this.labelRect.width > 0 ? this.boundRect.union(this.labelRect) : new Rectangle(this.boundRect);
        }
    }

    private void saveLabels() {
        if (this.labels.length > 0) {
            this.to_write.append("    label:");
            for (int i = 0; i < this.labels.length; ++i) {
                this.to_write.append('\"');
                this.to_write.append(this.labels[i]);
                this.to_write.append('\"');
                if (i >= this.labels.length - 1) continue;
                this.to_write.append(",\n          ");
            }
            this.to_write.append('\n');
        }
        if (this.labelOffset.x != 0 || this.labelOffset.y != 0) {
            this.to_write.append("    label_offset:");
            this.to_write.append(Integer.toString(this.labelOffset.x));
            this.to_write.append(',');
            this.to_write.append(Integer.toString(this.labelOffset.y));
            this.to_write.append('\n');
        }
        if (this.justify != 2) {
            this.to_write.append("    justify:");
            this.to_write.append(Integer.toString(this.justify));
            this.to_write.append('\n');
        }
    }

    private void saveHeader() {
        this.to_write.append("  ");
        this.to_write.append(this.getName());
        this.to_write.append(' ');
        this.to_write.append(Integer.toString(this.userType));
        this.to_write.append(" (");
        this.to_write.append(Integer.toString(this.org.x));
        this.to_write.append(',');
        this.to_write.append(Integer.toString(this.org.y));
        this.to_write.append(") ");
        if (this.type == 1) {
            this.to_write.append(Integer.toString(this.maxInput));
            this.to_write.append(',');
            this.to_write.append(Integer.toString(this.maxOutput));
            this.to_write.append(' ');
        }
        this.to_write.append("{\n");
    }

    private void saveChildrenList() {
        int sz = this.children.size();
        if (sz > 0) {
            this.to_write.append("    children:");
            for (int i = 0; i < sz; ++i) {
                NetObject child = (NetObject)this.children.get(i);
                this.to_write.append(Integer.toString(child.idx));
                if (i >= sz - 1) continue;
                this.to_write.append(',');
            }
            this.to_write.append('\n');
        }
    }

    private void saveExtensions() {
        int sz = this.getExtendedParamNumber();
        if (sz > 0) {
            this.to_write.append("    extensions {\n");
            for (int i = 0; i < sz; ++i) {
                this.to_write.append("      ");
                if (this.extParamName[i].indexOf(32) > 0) {
                    this.to_write.append('\"');
                    this.to_write.append(this.extParamName[i]);
                    this.to_write.append('\"');
                } else {
                    this.to_write.append(this.extParamName[i]);
                }
                this.to_write.append(":\"");
                this.to_write.append(this.extParamValue[i]);
                this.to_write.append("\"\n");
            }
            this.to_write.append("    }\n");
        }
    }

    private void saveShape() {
        if (this.shape != 0) {
            this.to_write.append("    shape:");
            this.to_write.append(Integer.toString(this.shape));
            this.to_write.append("\n");
        }
        if (!this.editableShape) {
            this.to_write.append("    editable_shape:0\n");
        }
    }

    private void saveSize() {
        if (this.bSize != 10) {
            this.to_write.append("    size:");
            this.to_write.append(Integer.toString(this.bSize));
            this.to_write.append("\n");
        }
    }

    private void saveFont() {
        if (!NetUtils.fontEquals(this.textFont, NetEditor.defaultLabelFont)) {
            this.to_write.append("    font:\"");
            this.to_write.append(this.textFont.getName());
            this.to_write.append("\",");
            this.to_write.append(Integer.toString(this.textFont.getStyle()));
            this.to_write.append(',');
            this.to_write.append(Integer.toString(this.textFont.getSize()));
            this.to_write.append("\n");
        }
    }

    void saveObject(FileWriter f) throws IOException {
        this.to_write = new StringBuffer();
        switch (this.type) {
            case 1: {
                this.saveHeader();
                this.saveShape();
                this.saveSize();
                this.saveLabels();
                this.saveChildrenList();
                this.saveExtensions();
                this.to_write.append("  }\n");
                break;
            }
            case 2: {
                this.saveHeader();
                this.saveLabels();
                this.saveFont();
                this.saveChildrenList();
                this.to_write.append("  }\n");
            }
        }
        f.write(this.to_write.toString());
    }

    static {
        pt0 = new Point(0, 0);
    }
}

