/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class NetUtils {
    static final String[] fntList = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"};
    static final Color fColor = new Color(99, 97, 156);
    static final Font labelFont = new Font("Dialog", 0, 12);
    static final Font labelbFont = new Font("Dialog", 1, 12);
    static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public static JMenuItem createMenuItem(String name, int key, int modifier, ActionListener a) {
        JMenuItem m = new JMenuItem();
        m.setText(name);
        if (key != 0) {
            m.setAccelerator(KeyStroke.getKeyStroke(key, modifier));
        }
        m.addActionListener(a);
        return m;
    }

    public static Border createTitleBorder(String name) {
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), name, 1, 0, labelbFont, fColor);
    }

    public static void centerDialog(Dialog dlg, int dlgWidth, int dlgHeight) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        if (dlg.getParent() != null) {
            r = dlg.getParent().getBounds();
        }
        if (r.width == 0 || r.height == 0) {
            r.x = 0;
            r.y = 0;
            r.width = NetUtils.screenSize.width;
            r.height = NetUtils.screenSize.height;
        }
        dlg.pack();
        Insets insets = dlg.getInsets();
        int wx = dlgWidth + (insets.right + insets.left);
        int wy = dlgHeight + (insets.bottom + insets.top);
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        if (xe < 0) {
            xe = 0;
        }
        if (ye < 0) {
            ye = 0;
        }
        if (xe + wx > NetUtils.screenSize.width) {
            xe = NetUtils.screenSize.width - wx;
        }
        if (ye + wy > NetUtils.screenSize.height) {
            ye = NetUtils.screenSize.height - wy;
        }
        dlg.setBounds(xe, ye, wx, wy);
    }

    public static void centerFrameOnScreen(Frame fr) {
        Rectangle r = new Rectangle(0, 0, NetUtils.screenSize.width, NetUtils.screenSize.height);
        fr.pack();
        int wx = fr.getPreferredSize().width;
        int wy = fr.getPreferredSize().height;
        int xe = r.x + (r.width - wx) / 2;
        int ye = r.y + (r.height - wy) / 2;
        fr.setBounds(xe, ye, wx, wy);
    }

    static JLabel createLabel(String msg) {
        JLabel label = new JLabel(msg);
        label.setFont(labelFont);
        label.setForeground(fColor);
        return label;
    }

    static boolean fontEquals(Font f1, Font f2) {
        return f1.getName().equalsIgnoreCase(f2.getName()) && f1.getSize() == f2.getSize() && f1.getStyle() == f2.getStyle();
    }

    static JComboBox createFontCombo() {
        JComboBox<String> ret = new JComboBox<String>();
        ret.setEditable(false);
        ret.setFont(labelFont);
        for (int i = 0; i < fntList.length; ++i) {
            ret.addItem(fntList[i]);
        }
        return ret;
    }

    static int getIdx(String fntName) {
        int i = 0;
        boolean found = false;
        while (i < fntList.length && !found) {
            found = fntName.equalsIgnoreCase(fntList[i]);
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }
}

