/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import fr.esrf.tangoatk.widget.util.interlock.XpssLink;
import fr.esrf.tangoatk.widget.util.interlock.XpssObject;
import java.awt.Dimension;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

class XpssFileLoader {
    private static final int NUMBER = 1;
    private static final int STRING = 2;
    private static final int SLASH = 3;
    private static final int BEGIN_KW = 4;
    private static final int END_KW = 5;
    private static final int LINK_KW = 6;
    private static final int OBJECT_KW = 7;
    private final String[] lexical_word = new String[]{"NULL", "NUMBER", "STRING", "SLASH", "Begin", "End", "Link", "Object"};
    private int CrtLine;
    private int StartLine;
    private char CurrentChar;
    private String word;
    FileReader f;

    public XpssFileLoader(FileReader file) throws IOException {
        this.f = file;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
    }

    private void read_char(FileReader f) throws IOException {
        this.CurrentChar = f.ready() ? (char)f.read() : (char)'\u0000';
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    private void jump_space(FileReader f) throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char(f);
        }
    }

    private String read_word(FileReader f) throws IOException {
        Object ret_word = "";
        this.jump_space(f);
        if (this.CurrentChar == '/') {
            ret_word = (String)ret_word + this.CurrentChar;
            this.read_char(f);
            return ret_word;
        }
        this.StartLine = this.CrtLine;
        while (this.CurrentChar > ' ' && this.CurrentChar != '/') {
            ret_word = (String)ret_word + this.CurrentChar;
            this.read_char(f);
        }
        if (((String)ret_word).length() == 0) {
            return null;
        }
        return ret_word;
    }

    private String read_full_line(FileReader f) throws IOException {
        Object ret_word = "";
        this.StartLine = this.CrtLine;
        while (this.CurrentChar != '\n' && this.CurrentChar != '\u0000') {
            this.read_char(f);
        }
        if (this.CurrentChar != '\u0000') {
            this.read_char(f);
        }
        while (this.CurrentChar >= ' ') {
            ret_word = (String)ret_word + this.CurrentChar;
            this.read_char(f);
        }
        return ret_word;
    }

    private boolean isNumber(String s) {
        char c;
        boolean ok = true;
        for (int i = 0; i < s.length() && ok; ok &= (c = s.charAt(i)) >= '0' && c <= '9' || c == '.' || c == 'e' || c == 'E' || c == '-', ++i) {
        }
        return ok;
    }

    private int class_lex(String word) {
        if (word == null) {
            return 0;
        }
        if (word.length() == 0) {
            return 2;
        }
        if (word.equals("/")) {
            return 3;
        }
        if (word.equalsIgnoreCase("begin")) {
            return 4;
        }
        if (word.equalsIgnoreCase("end")) {
            return 5;
        }
        if (word.equalsIgnoreCase("link")) {
            return 6;
        }
        if (word.equalsIgnoreCase("object")) {
            return 7;
        }
        if (this.isNumber(word)) {
            return 1;
        }
        return 2;
    }

    private void CHECK_LEX(int lt, int le) throws IOException {
        if (lt != le) {
            throw new IOException("Invalid syntyax at line " + this.StartLine + ", " + this.lexical_word[le] + " expected");
        }
    }

    public int getCurrentLine() {
        return this.StartLine;
    }

    public void startBlock() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 4);
        this.word = this.read_word(this.f);
        this.CHECK_LEX(this.class_lex(this.word), 7);
        this.word = this.read_word(this.f);
    }

    public void endBlock() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 5);
        this.word = this.read_word(this.f);
        this.CHECK_LEX(this.class_lex(this.word), 7);
        this.word = this.read_word(this.f);
    }

    public boolean isEndBlock() {
        return this.class_lex(this.word) == 5;
    }

    public XpssLink parseLink() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 6);
        this.word = this.read_word(this.f);
        int t = this.parseInteger();
        int x = this.parseInteger();
        int y = this.parseInteger();
        this.parseInteger();
        return new XpssLink(t, x, y);
    }

    public XpssLink parseLastLink() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 6);
        this.word = this.read_word(this.f);
        int t = this.parseInteger();
        int x = this.parseInteger();
        int y = this.parseInteger();
        return new XpssLink(t, x, y);
    }

    int parseInteger() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 1);
        int ret = 0;
        try {
            ret = Integer.parseInt(this.word);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid number at line " + this.StartLine);
        }
        this.word = this.read_word(this.f);
        return ret;
    }

    public String parseString() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 2);
        String s = this.word;
        this.word = this.read_word(this.f);
        return s;
    }

    public XpssObject parseObject() throws IOException {
        XpssObject o = new XpssObject();
        o.type = this.parseInteger();
        o.org.x = this.parseInteger();
        o.org.y = this.parseInteger();
        o.addLink(this.parseLink());
        o.addLink(this.parseLink());
        o.addLink(this.parseLastLink());
        switch (o.type) {
            case 1: {
                o.label1 = this.read_full_line(this.f);
                o.label2 = this.read_full_line(this.f);
                o.typeStr = this.read_full_line(this.f);
                this.word = this.read_word(this.f);
                o.idHigh = this.parseInteger();
                this.CHECK_LEX(this.class_lex(this.word), 3);
                this.word = this.read_word(this.f);
                o.idLow = this.parseInteger();
                o.idDev = this.parseInteger();
                break;
            }
            case 7: {
                o.label1 = this.read_full_line(this.f);
                this.word = this.read_word(this.f);
                break;
            }
            case 8: {
                o.label1 = this.read_full_line(this.f);
                o.label2 = this.read_full_line(this.f);
                o.typeStr = this.read_full_line(this.f);
                o.permitFileName = this.read_full_line(this.f);
                this.word = this.read_word(this.f);
                break;
            }
            case 4: {
                o.label1 = "24V";
                this.word = this.read_word(this.f);
                break;
            }
            default: {
                this.word = this.read_word(this.f);
            }
        }
        return o;
    }

    private int findWithCoord(Vector objects, int x, int y) {
        int i = 0;
        boolean found = false;
        XpssObject o = null;
        int sz = objects.size();
        while (i < sz && !found) {
            o = (XpssObject)objects.get(i);
            found = o.org.x == x && o.org.y == y;
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public Vector parseXpssFile(Dimension gridSize) throws IOException {
        NetObject no;
        boolean eof = false;
        Vector<XpssObject> objects = new Vector<XpssObject>();
        Vector<NetObject> iobjects = new Vector<NetObject>();
        this.word = this.read_word(this.f);
        if (this.word == null) {
            throw new IOException("File empty !");
        }
        int lex = this.class_lex(this.word);
        while (!eof) {
            switch (lex) {
                case 4: {
                    this.startBlock();
                    XpssObject p = this.parseObject();
                    if (p != null) {
                        if (p.org.x < 0 || p.org.x * gridSize.width >= 1800 || p.org.y < 0 || p.org.y * gridSize.height >= 1600) {
                            System.out.println("Warning:Out of bounds object detected. Ignoring...");
                        } else {
                            objects.add(p);
                            no = p.convert(gridSize);
                            if (no != null) {
                                iobjects.add(no);
                            }
                        }
                    }
                    this.endBlock();
                    break;
                }
                default: {
                    throw new IOException("Invalid syntyax at line " + this.StartLine + ": 'Begin' expected.");
                }
            }
            lex = this.class_lex(this.word);
            eof = this.word == null;
        }
        for (int i = 0; i < objects.size(); ++i) {
            XpssObject o = (XpssObject)objects.get(i);
            no = (NetObject)iobjects.get(i);
            for (int j = 0; j < o.links.size(); ++j) {
                XpssLink l = (XpssLink)o.links.get(j);
                int idx = this.findWithCoord(objects, l.pos.x, l.pos.y);
                if (idx != -1) {
                    no.addChild((NetObject)iobjects.get(idx));
                    continue;
                }
                System.out.println("Warning: Not ended link detected. Ignoring...");
            }
        }
        objects.clear();
        return iobjects;
    }
}

