/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import fr.esrf.tangoatk.widget.util.interlock.XpssLink;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Vector;

class XpssObject {
    public static final int OBJECT_NONE = 0;
    public static final int OBJECT_BUBBLE = 1;
    public static final int OBJECT_SPLIT = 2;
    public static final int OBJECT_JOIN = 3;
    public static final int OBJECT_STARTPOINT = 4;
    public static final int OBJECT_ENDPOINT = 5;
    public static final int OBJECT_CORNER = 6;
    public static final int OBJECT_TEXT = 7;
    public static final int OBJECT_PERMIT = 8;
    public int type = 0;
    public Point org = new Point();
    String label1 = "";
    String label2 = "";
    String typeStr = "";
    String permitFileName = "";
    public int id = 0;
    public int idHigh;
    public int idLow;
    public int idDev;
    Vector links = new Vector();
    String retLabel;
    int lx;
    int ly;
    static String[] xpssDevices = new String[]{"ELIN/ELIN/ELIN", "ELIN/SA-CR1/SL0", "ELIN/SA-CR2/SL0", "ELIN/SA-CR3/SL0", "ELIN/INTLK/0", "SY/SA-CR5/SL0", "SY/SA-CR6/SL0", "SY/SA-CR7/SL0", "SY/SA-CR8/SL0", "SR/SA-CR9/SL0", "ELIN/ELIN/ELIN", "SR/SA-CR11/SL0", "ELIN/ELIN/ELIN", "SR/SA-CR13/SL0"};
    static String[] bubbleExts = new String[]{"Device", "Board", "Relay", "Type", "Net Name"};
    static String[] permitExts = new String[]{"Type", "Net Name"};

    XpssObject() {
    }

    void addLink(XpssLink l) {
        if (l.type == 2) {
            this.links.add(l);
        }
    }

    void convertLabels() {
        this.retLabel = "";
        if (this.label1.length() == 0) {
            if (this.label2.length() != 0) {
                this.retLabel = this.retLabel + this.label2;
            }
        } else if (this.label2.length() == 0) {
            this.retLabel = this.retLabel + this.label1;
            switch (this.type) {
                case 8: {
                    this.lx = 17;
                    this.ly = 13;
                    break;
                }
                case 1: {
                    this.lx = 0;
                    this.ly = -12;
                    break;
                }
                case 4: {
                    this.lx = 0;
                    this.ly = 8;
                }
            }
        } else {
            this.retLabel = this.retLabel + this.label1 + "\n" + this.label2;
            if (this.type != 8) {
                this.lx = 0;
                this.ly = -12;
            } else {
                this.lx = 17;
                this.ly = 13;
            }
        }
    }

    NetObject convert(Dimension gridSize) {
        NetObject no = null;
        switch (this.type) {
            case 1: {
                no = new NetObject(1, 1, 1, 1, this.org.x, this.org.y);
                this.convertLabels();
                no.setLabel(this.retLabel);
                no.labelOffset.x = this.lx;
                no.labelOffset.y = this.ly;
                no.setExtensionList(bubbleExts);
                no.setExtendedParam(0, xpssDevices[this.idDev]);
                no.setExtendedParam(1, Integer.toString(this.idHigh));
                no.setExtendedParam(2, Integer.toString(this.idLow));
                no.setExtendedParam(3, this.typeStr);
                no.setExtendedParam(4, this.permitFileName);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                no = new NetObject(1, 5, 1000, 1000, this.org.x, this.org.y);
                no.setShape(5);
                break;
            }
            case 4: {
                no = new NetObject(1, 3, 0, 1, this.org.x, this.org.y);
                this.convertLabels();
                no.setLabel(this.retLabel);
                no.labelOffset.x = this.lx;
                no.labelOffset.y = this.ly;
                no.setShape(3);
                break;
            }
            case 5: {
                no = new NetObject(1, 4, 1, 0, this.org.x, this.org.y);
                no.setShape(4);
                break;
            }
            case 7: {
                no = new NetObject(2, 0, 0, 0, this.org.x * gridSize.width, this.org.y * gridSize.height - 3);
                this.convertLabels();
                no.setLabel(this.retLabel);
                no.labelOffset.x = this.lx;
                no.labelOffset.y = this.ly - 2;
                no.justify = 0;
                break;
            }
            case 8: {
                no = new NetObject(1, 2, 1, 1, this.org.x, this.org.y);
                this.convertLabels();
                no.setLabel(this.retLabel);
                no.labelOffset.x = this.lx;
                no.labelOffset.y = this.ly;
                no.setExtensionList(permitExts);
                no.setExtendedParam(0, this.typeStr);
                no.setExtendedParam(1, this.permitFileName);
                no.justify = 0;
                no.setShape(1);
                no.setSize(9);
                break;
            }
            default: {
                System.out.println("Warning: Unknown object detected. Ignoring...");
                return null;
            }
        }
        return no;
    }
}

