/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock.examples;

import fr.esrf.tangoatk.widget.util.interlock.NetEditor;
import fr.esrf.tangoatk.widget.util.interlock.NetEditorListener;
import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;

public class DjNetViewer
extends NetEditor
implements NetEditorListener {
    NetObject[] bubbles;
    int nbBubble;
    NetObject theSource = null;
    NetObject theDest = null;

    DjNetViewer(JFrame parent) {
        super(parent);
        this.setEditable(false);
        this.setMoveableBubble(true);
        this.addEditorListener(this);
    }

    @Override
    public void loadFile(String fileName) throws IOException {
        super.loadFile(fileName);
        this.bubbles = new NetObject[this.getNetObjectNumber()];
        this.nbBubble = 0;
        for (int i = 0; i < this.getNetObjectNumber(); ++i) {
            if (this.getNetObjectAt(i).getType() != 1) continue;
            this.bubbles[this.nbBubble] = this.getNetObjectAt(i);
            this.bubbles[this.nbBubble].setUserValue(new DijkstraInfo());
            ++this.nbBubble;
        }
        this.theSource = this.bubbles[0];
        this.theDest = this.bubbles[this.nbBubble - 1];
        this.computeDijkstra();
    }

    @Override
    public void paintLinks(Graphics2D g2) {
        super.paintLinks(g2);
        if (this.theDest != null) {
            NetObject dst = this.theDest;
            g2.setColor(Color.ORANGE);
            while (this.getDI((NetObject)dst).pred != null) {
                this.getDI((NetObject)dst).pred.paintLink(g2, dst, true);
                dst = this.getDI((NetObject)dst).pred;
            }
        }
    }

    private double distance(NetObject n1, NetObject n2) {
        double x = n2.getXOrigin() - n1.getXOrigin();
        double y = n2.getYOrigin() - n1.getYOrigin();
        return Math.sqrt(x * x + y * y);
    }

    private DijkstraInfo getDI(NetObject o) {
        return (DijkstraInfo)o.getUserValue();
    }

    private Vector initDijkstra() {
        Vector<NetObject> S = new Vector<NetObject>();
        for (int i = 0; i < this.nbBubble; ++i) {
            if (this.theSource.isParentOf(this.bubbles[i])) {
                this.getDI((NetObject)this.bubbles[i]).dist = this.distance(this.theSource, this.bubbles[i]);
                this.getDI((NetObject)this.bubbles[i]).pred = this.theSource;
            } else {
                this.getDI((NetObject)this.bubbles[i]).dist = Double.POSITIVE_INFINITY;
                this.getDI((NetObject)this.bubbles[i]).pred = null;
            }
            S.add(this.bubbles[i]);
        }
        this.getDI((NetObject)this.theSource).dist = 0.0;
        S.remove(this.theSource);
        return S;
    }

    private void computeDijkstra() {
        NetObject s;
        Vector S = this.initDijkstra();
        do {
            int i;
            double minDist = Double.POSITIVE_INFINITY;
            s = null;
            for (i = 0; i < S.size(); ++i) {
                NetObject toDo = (NetObject)S.get(i);
                if (!(this.getDI((NetObject)toDo).dist < minDist)) continue;
                s = toDo;
                minDist = this.getDI((NetObject)toDo).dist;
            }
            if (s == null) continue;
            S.remove(s);
            for (i = 0; i < s.getChildrenNumber(); ++i) {
                NetObject t = s.getChildAt(i);
                double d = this.distance(s, t);
                if (!(this.getDI((NetObject)s).dist + d < this.getDI((NetObject)t).dist)) continue;
                this.getDI((NetObject)t).dist = this.getDI((NetObject)s).dist + d;
                this.getDI((NetObject)t).pred = s;
            }
        } while (s != null);
        this.updateBubble();
    }

    private void updateBubble() {
        for (int i = 0; i < this.nbBubble; ++i) {
            if (this.bubbles[i].equals(this.theSource)) {
                this.bubbles[i].setColor(Color.BLUE);
            } else if (this.bubbles[i].equals(this.theDest)) {
                this.bubbles[i].setColor(Color.CYAN);
            } else {
                this.bubbles[i].setColor(Color.GRAY);
            }
            double d = this.getDI((NetObject)this.bubbles[i]).dist;
            if (d == Double.POSITIVE_INFINITY) {
                this.bubbles[i].setColor(Color.RED);
                this.bubbles[i].setCenterLabel("No");
                continue;
            }
            this.bubbles[i].setCenterLabel(Integer.toString((int)d));
        }
        this.repaint();
    }

    @Override
    public void valueChanged(NetEditor src) {
        if (this.nbBubble > 0) {
            this.computeDijkstra();
        }
    }

    @Override
    public void objectClicked(NetEditor src, NetObject obj, MouseEvent e) {
        if (obj.getType() != 1) {
            return;
        }
        if (e.getButton() == 1) {
            this.theSource = obj;
            this.computeDijkstra();
        }
        if (e.getButton() == 3) {
            this.theDest = obj;
            this.computeDijkstra();
        }
    }

    @Override
    public void linkClicked(NetEditor src, NetObject obj, int childIdx, MouseEvent e) {
    }

    @Override
    public void sizeChanged(NetEditor src, Dimension d) {
    }

    @Override
    public void cancelCreate(NetEditor src) {
    }

    class DijkstraInfo {
        double dist;
        NetObject pred;

        DijkstraInfo() {
        }
    }
}

