/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock.examples;

import fr.esrf.tangoatk.widget.util.interlock.NetEditor;
import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ItlkNetEditor
extends NetEditor {
    static final int ITLK_BUBBLE = 1;
    static final int SENSOR_BUBBLE = 2;
    static final int VCC_BUBBLE = 3;
    static final int GROUND_BUBBLE = 4;
    static final int JOIN_BUBBLE = 5;
    private int createMode = 0;
    private NetObject theRoot = null;
    static final String[] bubbleExt = new String[]{"Type", "Address"};

    public ItlkNetEditor(JFrame parent) {
        super(parent);
    }

    @Override
    public void loadFile(String fileName) throws IOException {
        super.loadFile(fileName);
        if (!this.isEditable()) {
            this.prepareObjects();
        }
    }

    @Override
    public void setEditable(boolean b) {
        if (!b) {
            this.prepareObjects();
        }
        super.setEditable(b);
    }

    public NetObject getRoot() {
        return this.theRoot;
    }

    public void prepareObjects() {
        for (int i = 0; i < this.getNetObjectNumber(); ++i) {
            NetObject o = this.getNetObjectAt(i);
            if (o.getType() == 2) continue;
            o.setUserValue(new ItlkInfo());
            this.getII((NetObject)o).state = true;
            o.setColor(Color.GREEN);
        }
    }

    private void resetLogic() {
        for (int i = 0; i < this.getNetObjectNumber(); ++i) {
            NetObject o = this.getNetObjectAt(i);
            if (o.getType() == 2) continue;
            this.getII((NetObject)o).nbHit = o.getParentNumber();
            this.getII((NetObject)o).storedResult = false;
        }
    }

    private void computeState(Graphics2D g, NetObject o, boolean curState) {
        if (this.getII((NetObject)o).nbHit > 1) {
            this.getII((NetObject)o).storedResult = this.getII((NetObject)o).storedResult || curState;
            --this.getII((NetObject)o).nbHit;
        } else {
            switch (o.getUserType()) {
                case 1: {
                    if (this.getII((NetObject)o).state) {
                        this.propagateState(g, o, curState);
                        break;
                    }
                    this.propagateState(g, o, false);
                    break;
                }
                case 3: {
                    this.propagateState(g, o, curState);
                    break;
                }
                case 2: {
                    if (!curState) {
                        o.setColor(Color.RED);
                    } else {
                        o.setColor(Color.GREEN);
                    }
                    this.propagateState(g, o, curState);
                    break;
                }
                case 5: {
                    if (o.getParentNumber() > 1) {
                        this.getII((NetObject)o).storedResult |= curState;
                        this.propagateState(g, o, this.getII((NetObject)o).storedResult);
                        break;
                    }
                    this.propagateState(g, o, curState);
                }
            }
        }
    }

    private void propagateState(Graphics2D g, NetObject o, boolean curState) {
        for (int i = 0; i < o.getChildrenNumber(); ++i) {
            NetObject c = o.getChildAt(i);
            if (curState) {
                g.setColor(Color.GREEN);
            } else {
                g.setColor(Color.RED);
            }
            o.paintLink(g, c, false);
            this.computeState(g, c, curState);
        }
    }

    public void swapItlkState(NetObject o) {
        boolean bl = this.getII((NetObject)o).state = !this.getII((NetObject)o).state;
        if (this.getII((NetObject)o).state) {
            o.setColor(Color.GREEN);
        } else {
            o.setColor(Color.RED);
        }
        this.repaint();
    }

    private ItlkInfo getII(NetObject o) {
        return (ItlkInfo)o.getUserValue();
    }

    public void setCreateMode(int type, int userType) {
        this.createMode = userType;
        this.setCreateMode(type);
    }

    @Override
    public NetObject createBubbleObject(int x, int y) {
        NetObject ret = null;
        switch (this.createMode) {
            case 1: {
                ret = new NetObject(1, 1, 1, 1, x, y);
                ret.setShape(0);
                ret.setExtensionList(bubbleExt);
                ret.setEditableShape(false);
                break;
            }
            case 2: {
                ret = new NetObject(1, 2, 1, 1, x, y);
                ret.setShape(1);
                ret.setEditableShape(false);
                ret.setSize(9);
                break;
            }
            case 3: {
                ret = new NetObject(1, 3, 0, 1, x, y);
                ret.setShape(3);
                ret.setEditableShape(false);
                ret.setLabel("Vcc");
                break;
            }
            case 4: {
                ret = new NetObject(1, 4, 1, 0, x, y);
                ret.setShape(4);
                ret.setEditableShape(false);
                break;
            }
            case 5: {
                ret = new NetObject(1, 5, 10, 10, x, y);
                ret.setShape(5);
                ret.setEditableShape(false);
            }
        }
        return ret;
    }

    @Override
    public boolean addObject(NetObject o) {
        if (o == null) {
            return false;
        }
        if (o.getUserType() == 3) {
            if (this.theRoot != null) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Cannot add a new VCC object. Only 1 accepted", "Error", 0);
                return false;
            }
            this.theRoot = o;
        }
        return super.addObject(o);
    }

    @Override
    public void removeObject(NetObject o) {
        if (this.theRoot == o) {
            this.theRoot = null;
        }
        super.removeObject(o);
    }

    @Override
    public void clearObjects() {
        this.theRoot = null;
        super.clearObjects();
    }

    @Override
    public void paintLinks(Graphics2D g2) {
        if (!this.isEditable()) {
            this.resetLogic();
            if (this.theRoot != null) {
                this.computeState(g2, this.theRoot, true);
            }
        } else {
            super.paintLinks(g2);
        }
    }

    @Override
    public void paintObjects(Graphics2D g2) {
        for (int i = 0; i < this.getNetObjectNumber(); ++i) {
            NetObject o = this.getNetObjectAt(i);
            if (o.getUserType() != 1) continue;
            o.setCenterLabel(o.getExtendedParam(0));
            o.setBottomLabel(o.getExtendedParam(1));
        }
        super.paintObjects(g2);
    }

    class ItlkInfo {
        boolean state;
        int nbHit;
        boolean storedResult;

        ItlkInfo() {
        }
    }
}

