/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JDBar
extends JDRectangular {
    public static final int BAR_HORIZONTAL_LEFT = 0;
    public static final int BAR_HORIZONTAL_RIGHT = 1;
    public static final int BAR_VERTICAL_TOP = 2;
    public static final int BAR_VERTICAL_BOTTOM = 3;
    static final double minDefault = 0.0;
    static final double maxDefault = 1.0;
    static final double valueDefault = 1.0;
    static final boolean outLineVisibleDefault = true;
    static final int orientationDefault = 3;
    double min;
    double max;
    double value;
    boolean outLineVisible;
    int orientation;

    public JDBar(String objectName, int x, int y, int w, int h) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(x, y));
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.createSummit();
        this.computeSummitCoordinates(x, y, w, h);
        this.updateShape();
    }

    JDBar(JDBar e, int x, int y) {
        this.cloneObject(e, x, y);
        this.min = e.min;
        this.max = e.max;
        this.value = e.value;
        this.outLineVisible = e.outLineVisible;
        this.orientation = e.orientation;
        this.updateShape();
    }

    JDBar(JDFileLoader f) throws IOException {
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("minBar")) {
                this.min = f.parseDouble();
                continue;
            }
            if (propName.equals("maxBar")) {
                this.max = f.parseDouble();
                continue;
            }
            if (propName.equals("valueBar")) {
                this.value = f.parseDouble();
                continue;
            }
            if (propName.equals("outLineVisible")) {
                this.outLineVisible = f.parseBoolean();
                continue;
            }
            if (propName.equals("orientation")) {
                this.orientation = (int)f.parseDouble();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.updateShape();
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDBar(this, x, y);
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.fillStyle = 1;
        this.min = 0.0;
        this.max = 1.0;
        this.value = 1.0;
        this.outLineVisible = true;
        this.orientation = 3;
    }

    @Override
    public boolean isInsideObject(int x, int y) {
        if (!super.isInsideObject(x, y)) {
            return false;
        }
        if (this.fillStyle != 0) {
            return this.boundRect.contains(x, y);
        }
        int x1 = this.boundRect.x;
        int x2 = this.boundRect.x + this.boundRect.width;
        int y1 = this.boundRect.y;
        int y2 = this.boundRect.y + this.boundRect.height;
        return this.isPointOnLine(x, y, x1, y1, x2, y1) || this.isPointOnLine(x, y, x2, y1, x2, y2) || this.isPointOnLine(x, y, x2, y2, x1, y2) || this.isPointOnLine(x, y, x1, y2, x1, y1);
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        if (!Double.isNaN(this.value)) {
            double ratio = 0.0;
            if (this.min != this.max) {
                ratio = (this.value - this.min) / (this.max - this.min);
            }
            if (ratio < 0.0) {
                ratio = 0.0;
            }
            if (ratio > 1.0) {
                ratio = 1.0;
            }
            switch (this.orientation) {
                case 0: {
                    int nWidth = (int)((double)(this.boundRect.width - 1) * ratio + 0.5);
                    if (nWidth < 0) {
                        nWidth = 0;
                    }
                    this.ptsx[0] = this.boundRect.x;
                    this.ptsy[0] = this.boundRect.y;
                    this.ptsx[1] = this.boundRect.x + nWidth;
                    this.ptsy[1] = this.boundRect.y;
                    this.ptsx[2] = this.boundRect.x + nWidth;
                    this.ptsy[2] = this.boundRect.y + this.boundRect.height - 1;
                    this.ptsx[3] = this.boundRect.x;
                    this.ptsy[3] = this.boundRect.y + this.boundRect.height - 1;
                    break;
                }
                case 1: {
                    int nWidth = (int)((double)(this.boundRect.width - 1) * (1.0 - ratio) + 0.5);
                    if (nWidth < 0) {
                        nWidth = 0;
                    }
                    this.ptsx[0] = this.boundRect.x + nWidth;
                    this.ptsy[0] = this.boundRect.y;
                    this.ptsx[1] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[1] = this.boundRect.y;
                    this.ptsx[2] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[2] = this.boundRect.y + this.boundRect.height - 1;
                    this.ptsx[3] = this.boundRect.x + nWidth;
                    this.ptsy[3] = this.boundRect.y + this.boundRect.height - 1;
                    break;
                }
                case 2: {
                    int nHeight = (int)((double)(this.boundRect.height - 1) * ratio + 0.5);
                    if (nHeight < 0) {
                        nHeight = 0;
                    }
                    this.ptsx[0] = this.boundRect.x;
                    this.ptsy[0] = this.boundRect.y;
                    this.ptsx[1] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[1] = this.boundRect.y;
                    this.ptsx[2] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[2] = this.boundRect.y + nHeight;
                    this.ptsx[3] = this.boundRect.x;
                    this.ptsy[3] = this.boundRect.y + nHeight;
                    break;
                }
                case 3: {
                    int nHeight = (int)((double)(this.boundRect.height - 1) * (1.0 - ratio) + 0.5);
                    if (nHeight < 0) {
                        nHeight = 0;
                    }
                    this.ptsx[0] = this.boundRect.x;
                    this.ptsy[0] = this.boundRect.y + nHeight;
                    this.ptsx[1] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[1] = this.boundRect.y + nHeight;
                    this.ptsx[2] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[2] = this.boundRect.y + this.boundRect.height - 1;
                    this.ptsx[3] = this.boundRect.x;
                    this.ptsy[3] = this.boundRect.y + this.boundRect.height - 1;
                }
            }
            if (this.hasShadow()) {
                this.computeShadow(true);
                this.computeShadowColors();
            }
        }
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (Double.isNaN(this.value)) {
            return;
        }
        this.prepareRendering((Graphics2D)g);
        super.paint(parent, g);
        if (this.outLineVisible) {
            g.setColor(this.foreground);
            int x1 = (int)(this.summit[0].x + 0.5);
            int y1 = (int)(this.summit[0].y + 0.5);
            int x2 = (int)(this.summit[4].x + 0.5);
            int y2 = (int)(this.summit[4].y + 0.5);
            g.drawLine(x1, y1, x2, y1);
            g.drawLine(x2, y1, x2, y2);
            g.drawLine(x2, y2, x1, y2);
            g.drawLine(x1, y2, x1, y1);
        }
    }

    public void setMaximum(double m) {
        this.max = m;
        this.updateShape();
    }

    public double getMaximum() {
        return this.max;
    }

    public void setMinimum(double m) {
        this.min = m;
        this.updateShape();
    }

    public double getMinimum() {
        return this.min;
    }

    public void setBarValue(double v) {
        this.value = v;
        this.updateShape();
    }

    public double getBarValue() {
        return this.value;
    }

    public void setOutLineVisible(boolean visible) {
        this.outLineVisible = visible;
    }

    public boolean isOutLineVisible() {
        return this.outLineVisible;
    }

    public void setOrientation(int o) {
        this.orientation = o;
        this.updateShape();
    }

    public int getOrientation() {
        return this.orientation;
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        if (this.min != 0.0) {
            to_write.append(decal).append("minBar:").append(this.min).append("\n");
        }
        if (this.max != 1.0) {
            to_write.append(decal).append("maxBar:").append(this.max).append("\n");
        }
        if (this.value != 1.0) {
            to_write.append(decal).append("valueBar:").append(this.value).append("\n");
        }
        if (this.orientation != 3) {
            to_write.append(decal).append("orientation:").append(this.orientation).append("\n");
        }
        if (!this.outLineVisible) {
            to_write.append(decal).append("outLineVisible:").append(this.outLineVisible).append("\n");
        }
        this.closeObjectHeader(to_write, level);
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(12);
        this.fillUndoPattern(u);
        u.min = this.min;
        u.max = this.max;
        u.value = this.value;
        u.isClosed = this.outLineVisible;
        u.textOrientation = this.orientation;
        return u;
    }

    JDBar(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.min = e.min;
        this.max = e.max;
        this.value = e.value;
        this.outLineVisible = e.isClosed;
        this.orientation = e.textOrientation;
        this.updateShape();
    }

    private void computeSummitCoordinates(int x, int y, int width, int height) {
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[2].x = x + width;
        this.summit[2].y = y;
        this.summit[4].x = x + width;
        this.summit[4].y = y + height;
        this.summit[6].x = x;
        this.summit[6].y = y + height;
        this.centerSummit();
    }
}

