/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDAxisPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDBarPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipsePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDExtensionPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDImagePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabelPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDLinePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDObjectPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolylinePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDRotatableLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDRotatableLabelPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectanglePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDTitledRect;
import fr.esrf.tangoatk.widget.util.jdraw.JDTitledRectPanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDTreeNode;
import fr.esrf.tangoatk.widget.util.jdraw.JDTreeNodeRenderer;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDValuePanel;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class JDBrowserPanel
extends JPanel
implements TreeSelectionListener,
ActionListener {
    private JDObject[] allObjects;
    private JDrawEditor invoker;
    private JTree theTree;
    private JScrollPane treeView;
    private JDTreeNode rootNode;
    private DefaultTreeModel mainTreeModel;
    private JDTreeNodeRenderer treeRenderer;
    private JDTreeNode selectedNode;
    private JPanel btnPanel;
    private JButton dismissBtn;
    private JTabbedPane tabbedPane;
    private JDObjectPanel objectPanel;
    private JDValuePanel valuePanel;
    private JDExtensionPanel extensionPanel;
    private JDLabelPanel labelPanel;
    private JDRotatableLabelPanel rotatableLabelPanel;
    private JDLinePanel linePanel;
    private JDPolylinePanel polylinePanel;
    private JDEllipsePanel ellipsePanel;
    private JDRoundRectanglePanel roundRectanglePanel;
    private JDImagePanel imagePanel;
    private JDSwingPanel swingPanel;
    private JDAxisPanel axisPanel;
    private JDBarPanel barPanel;
    private JDTitledRectPanel titledRectPanel;
    private Component lastSelectedPanel = null;
    private boolean updatingProp = false;

    public JDBrowserPanel(JDObject[] obj, JDrawEditor jc) {
        this.setLayout(new BorderLayout());
        this.allObjects = obj;
        this.invoker = jc;
        this.rootNode = new JDTreeNode();
        this.selectedNode = null;
        for (int i = 0; i < this.allObjects.length; ++i) {
            this.rootNode.add(new JDTreeNode(this.allObjects[i]));
        }
        this.mainTreeModel = new DefaultTreeModel(this.rootNode);
        this.treeRenderer = new JDTreeNodeRenderer();
        this.theTree = new JTree(this.mainTreeModel);
        this.theTree.setCellRenderer(this.treeRenderer);
        this.theTree.setEditable(false);
        this.theTree.getSelectionModel().setSelectionMode(1);
        this.theTree.setShowsRootHandles(false);
        this.theTree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.theTree);
        this.treeView.setMinimumSize(new Dimension(20, 290));
        this.add((Component)this.treeView, "Center");
        this.tabbedPane = new JTabbedPane();
        this.objectPanel = new JDObjectPanel(null, this.invoker, this);
        this.valuePanel = new JDValuePanel(null, this.invoker, this);
        this.extensionPanel = new JDExtensionPanel(null, this.invoker);
        this.labelPanel = new JDLabelPanel(null, this.invoker);
        this.rotatableLabelPanel = new JDRotatableLabelPanel(null, this.invoker);
        this.linePanel = new JDLinePanel(null, this.invoker);
        this.polylinePanel = new JDPolylinePanel(null, this.invoker);
        this.ellipsePanel = new JDEllipsePanel(null, this.invoker);
        this.roundRectanglePanel = new JDRoundRectanglePanel(null, this.invoker);
        this.imagePanel = new JDImagePanel(null, this.invoker);
        this.swingPanel = new JDSwingPanel(null, this.invoker);
        this.axisPanel = new JDAxisPanel(null, this.invoker);
        this.barPanel = new JDBarPanel(null, this.invoker);
        this.titledRectPanel = new JDTitledRectPanel(null, this.invoker);
        this.tabbedPane.add((Component)this.objectPanel, "Graphics");
        this.tabbedPane.add((Component)this.valuePanel, "Value");
        this.tabbedPane.add((Component)this.extensionPanel, "Extensions");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (JDBrowserPanel.this.tabbedPane.getSelectedComponent() != null && !JDBrowserPanel.this.updatingProp) {
                    JDBrowserPanel.this.lastSelectedPanel = JDBrowserPanel.this.tabbedPane.getSelectedComponent();
                }
            }
        });
        this.add((Component)this.tabbedPane, "East");
        this.btnPanel = new JPanel();
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(2);
        this.btnPanel.setLayout(fl);
        this.dismissBtn = new JButton("Dismiss");
        this.dismissBtn.setFont(JDUtils.labelFont);
        this.dismissBtn.addActionListener(this);
        this.btnPanel.add(this.dismissBtn);
        this.add((Component)this.btnPanel, "South");
    }

    public void postInit() {
        this.theTree.addTreeSelectionListener(this);
        this.theTree.setSelectionRow(1);
    }

    public void updateNode() {
        if (this.selectedNode != null) {
            this.mainTreeModel.nodeChanged(this.selectedNode);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.dismissBtn) {
            if (this.objectPanel.nameHasChanged()) {
                if (JOptionPane.showConfirmDialog(this, "Object name has changed but has not been applied\nDo you want to apply ?", "Confirmation", 0) == 0) {
                    this.objectPanel.applyName();
                } else {
                    this.objectPanel.cancelNameChanged();
                }
            }
            ATKGraphicsUtils.getWindowForComponent(this).setVisible(false);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath selPath = e.getPath();
        if (selPath != null) {
            this.updatingProp = true;
            JDTreeNode n = (JDTreeNode)selPath.getLastPathComponent();
            this.invoker.unselectAll();
            this.invoker.selectObject(n.getObject());
            JDObject jObj = n.getObject();
            if (jObj != null) {
                JDObject[] objs2;
                this.tabbedPane.removeAll();
                this.tabbedPane.add((Component)this.objectPanel, "Graphics");
                JDObject[] objs = new JDObject[]{jObj};
                this.objectPanel.updatePanel(objs);
                this.valuePanel.updatePanel(objs);
                this.extensionPanel.updatePanel(objs);
                if (jObj instanceof JDLabel) {
                    objs2 = new JDLabel[]{(JDLabel)jObj};
                    this.labelPanel.updatePanel((JDLabel[])objs2);
                    this.tabbedPane.add((Component)this.labelPanel, "Text");
                }
                if (jObj instanceof JDRotatableLabel) {
                    objs2 = new JDRotatableLabel[]{(JDRotatableLabel)jObj};
                    this.rotatableLabelPanel.updatePanel((JDRotatableLabel[])objs2);
                    this.tabbedPane.add((Component)this.rotatableLabelPanel, "Text");
                }
                if (jObj instanceof JDLine) {
                    objs2 = new JDLine[]{(JDLine)jObj};
                    this.linePanel.updatePanel((JDLine[])objs2);
                    this.tabbedPane.add((Component)this.linePanel, "Line");
                }
                if (jObj instanceof JDPolyline) {
                    objs2 = new JDPolyline[]{(JDPolyline)jObj};
                    this.polylinePanel.updatePanel((JDPolyline[])objs2);
                    this.tabbedPane.add((Component)this.polylinePanel, "Polyline");
                }
                if (jObj instanceof JDEllipse) {
                    objs2 = new JDEllipse[]{(JDEllipse)jObj};
                    this.ellipsePanel.updatePanel((JDEllipse[])objs2);
                    this.tabbedPane.add((Component)this.ellipsePanel, "Ellipse");
                }
                if (jObj instanceof JDRoundRectangle) {
                    objs2 = new JDRoundRectangle[]{(JDRoundRectangle)jObj};
                    this.roundRectanglePanel.updatePanel((JDRoundRectangle[])objs2);
                    this.tabbedPane.add((Component)this.roundRectanglePanel, "Corner");
                }
                if (jObj instanceof JDImage) {
                    objs2 = new JDImage[]{(JDImage)jObj};
                    this.imagePanel.updatePanel((JDImage[])objs2);
                    this.tabbedPane.add((Component)this.imagePanel, "Image");
                }
                if (jObj instanceof JDSwingObject) {
                    objs2 = new JDSwingObject[]{(JDSwingObject)jObj};
                    this.swingPanel.updatePanel((JDSwingObject[])objs2);
                    this.tabbedPane.add((Component)this.swingPanel, "Swing");
                }
                if (jObj instanceof JDAxis) {
                    objs2 = new JDAxis[]{(JDAxis)jObj};
                    this.axisPanel.updatePanel((JDAxis[])objs2);
                    this.tabbedPane.add((Component)this.axisPanel, "Axis");
                }
                if (jObj instanceof JDBar) {
                    objs2 = new JDBar[]{(JDBar)jObj};
                    this.barPanel.updatePanel((JDBar[])objs2);
                    this.tabbedPane.add((Component)this.barPanel, "Bar");
                }
                if (jObj instanceof JDTitledRect) {
                    objs2 = new JDTitledRect[]{(JDTitledRect)jObj};
                    this.titledRectPanel.updatePanel((JDTitledRect[])objs2);
                    this.tabbedPane.add((Component)this.titledRectPanel, "TitledRect");
                }
                this.tabbedPane.add((Component)this.valuePanel, "Value");
                this.tabbedPane.add((Component)this.extensionPanel, "Extensions");
                this.selectedNode = n;
                String t = "Selection browser [" + jObj + " " + jObj.getName() + " selected]";
                ((JDialog)ATKGraphicsUtils.getWindowForComponent(this)).setTitle(t);
                try {
                    this.tabbedPane.setSelectedComponent(this.lastSelectedPanel);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                this.objectPanel.updatePanel(null);
                this.valuePanel.updatePanel(null);
                this.extensionPanel.updatePanel(null);
                this.labelPanel.updatePanel(null);
                this.rotatableLabelPanel.updatePanel(null);
                this.linePanel.updatePanel(null);
                this.polylinePanel.updatePanel(null);
                this.ellipsePanel.updatePanel(null);
                this.roundRectanglePanel.updatePanel(null);
                this.imagePanel.updatePanel(null);
                this.swingPanel.updatePanel(null);
                this.axisPanel.updatePanel(null);
                this.selectedNode = null;
                String t = "Selection browser [none selected]";
                ((JDialog)ATKGraphicsUtils.getWindowForComponent(this)).setTitle(t);
            }
            this.tabbedPane.getSelectedComponent().setVisible(true);
            this.updatingProp = false;
        }
    }
}

